/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen.unit.gen.java;

import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.junit.jupiter.api.BeforeAll;
import org.web3j.codegen.unit.gen.java.JavaParser;
import org.web3j.codegen.unit.gen.java.MethodSpecGenerator;
import org.web3j.codegen.unit.gen.utils.JavaMappingHelper;
import org.web3j.codegen.unit.gen.utils.NameUtils;
import org.web3j.protocol.Web3j;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class MethodParser {
    private final Method method;
    private final Class theContract;

    public MethodParser(Method method, Class theContract) {
        this.method = method;
        this.theContract = theContract;
    }

    public MethodSpec getMethodSpec() {
        return this.methodNeedsInjection() ? new MethodSpecGenerator(this.method.getName(), BeforeAll.class, Modifier.STATIC, this.defaultParameterSpecsForEachUnitTest(), this.generateStatementBody()).generate() : new MethodSpecGenerator(this.method.getName(), this.generateStatementBody()).generate();
    }

    private boolean methodNeedsInjection() {
        return Arrays.asList(this.method.getParameterTypes()).containsAll(Arrays.asList(Web3j.class, TransactionManager.class, ContractGasProvider.class));
    }

    private List<ParameterSpec> defaultParameterSpecsForEachUnitTest() {
        return Stream.of(ParameterSpec.builder(Web3j.class, (String)NameUtils.toCamelCase(Web3j.class), (Modifier[])new Modifier[0]).build(), ParameterSpec.builder(TransactionManager.class, (String)NameUtils.toCamelCase(TransactionManager.class), (Modifier[])new Modifier[0]).build(), ParameterSpec.builder(ContractGasProvider.class, (String)NameUtils.toCamelCase(ContractGasProvider.class), (Modifier[])new Modifier[0]).build()).collect(Collectors.toList());
    }

    private Map<String, Object[]> generateStatementBody() {
        LinkedHashMap<String, Object[]> methodBodySpecification = new LinkedHashMap<String, Object[]>();
        JavaParser parser = new JavaParser(this.theContract, this.method, new JavaMappingHelper());
        String javaPoetStringTypes = parser.generatePoetStringTypes();
        Object[] genericParameters = parser.generatePlaceholderValues();
        methodBodySpecification.put(javaPoetStringTypes, genericParameters);
        if (this.methodNeedsAssertion()) {
            String assertionJavaPoet = parser.generateAssertionJavaPoetStringTypes();
            Object[] assertionParams = parser.generateAssertionPlaceholderValues();
            methodBodySpecification.put(assertionJavaPoet, assertionParams);
        }
        return methodBodySpecification;
    }

    private boolean methodNeedsAssertion() {
        return !this.methodNeedsInjection();
    }
}

