/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen.unit.gen;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.web3j.codegen.unit.gen.CompilerClassLoader;

public class ClassProvider {
    private final File pathToJavaFiles;
    private final ClassLoader classLoader;

    public ClassProvider(File pathToJavaFiles) throws IOException {
        this.pathToJavaFiles = pathToJavaFiles;
        URL[] classPathURL = new URL[]{pathToJavaFiles.toURI().toURL()};
        Path outputDirectory = Files.createTempDirectory("tmp", new FileAttribute[0]);
        this.classLoader = new CompilerClassLoader(outputDirectory.toFile(), classPathURL);
    }

    public final List<Class<?>> getClasses() throws IOException {
        return Files.walk(Paths.get(this.pathToJavaFiles.toURI()), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toString).map(this::toClassName).map(this::loadClass).collect(Collectors.toList());
    }

    private String toClassName(String sourceFile) {
        try {
            return sourceFile.substring(this.pathToJavaFiles.getCanonicalPath().length() + 1, sourceFile.lastIndexOf(".java")).replace(File.separator, ".");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Class<?> loadClass(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }
}

