/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen.unit.gen;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.web3j.codegen.unit.gen.utils.MappingHelper;
import org.web3j.codegen.unit.gen.utils.NameUtils;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public abstract class Parser {
    protected final MappingHelper mappingHelper;
    protected final Class<?> theContract;
    protected final Method method;

    public Parser(Class<?> theContract, Method method, MappingHelper mappingHelper) {
        this.theContract = theContract;
        this.method = method;
        this.mappingHelper = mappingHelper;
    }

    protected abstract Object getDefaultValueForType(Class<?> var1);

    protected abstract String generatePoetStringTypes();

    protected abstract String getPoetFormatSpecifier();

    protected final Object[] replaceTypeWithDefaultValue() {
        return Arrays.stream(this.method.getParameterTypes()).map(this::getDefaultValueForType).toArray();
    }

    public final Type getMethodReturnType() {
        Type genericType = this.method.getGenericReturnType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            return parameterizedType.getActualTypeArguments()[0];
        }
        return genericType;
    }

    protected final Type[] getTypeArray(Type type) {
        ParameterizedType parameterizedType = (ParameterizedType)type;
        return parameterizedType.getActualTypeArguments();
    }

    public final Object[] generateAssertionPlaceholderValues() {
        Type returnType = this.getMethodReturnType();
        Object[] body = this.generatePlaceholderValues();
        ArrayList<Object> placeHolder = new ArrayList<Object>();
        placeHolder.add(Assertions.class);
        if (!body[0].equals(TransactionReceipt.class)) {
            if (returnType.getTypeName().contains("Tuple")) {
                placeHolder.add(((ParameterizedType)returnType).getRawType());
                for (Type t : this.getTypeArray(returnType)) {
                    placeHolder.add(this.mappingHelper.getDefaultValueMap().get(t));
                }
            } else {
                placeHolder.add(this.mappingHelper.getDefaultValueMap().get(body[0]));
            }
        }
        placeHolder.add(NameUtils.toCamelCase(NameUtils.returnTypeAsLiteral(returnType, true)));
        return placeHolder.toArray();
    }

    public final Object[] generatePlaceholderValues() {
        return this.mergePlaceholderValues(this.concludeMethodReturnType(), this.replaceTypeWithDefaultValue());
    }

    protected final Object[] mergePlaceholderValues(Object[] source1, Object[] source2) {
        Object[] destination = new Object[source1.length + source2.length];
        System.arraycopy(source1, 0, destination, 0, source1.length);
        System.arraycopy(source2, 0, destination, source1.length, source2.length);
        return destination;
    }

    protected final Object[] concludeMethodReturnType() {
        Type returnType = this.getMethodReturnType();
        if (returnType.equals(this.theContract)) {
            return new Object[]{NameUtils.toCamelCase(NameUtils.returnTypeAsLiteral(returnType, false)), returnType};
        }
        return new Object[]{returnType, NameUtils.toCamelCase(NameUtils.returnTypeAsLiteral(returnType, true)), NameUtils.toCamelCase(this.theContract)};
    }
}

