/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.rx;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.DefaultBlockParameterNumber;
import org.web3j.protocol.core.filters.BlockFilter;
import org.web3j.protocol.core.filters.Filter;
import org.web3j.protocol.core.filters.LogFilter;
import org.web3j.protocol.core.filters.PendingTransactionFilter;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.utils.Observables;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.schedulers.Schedulers;
import rx.subscriptions.Subscriptions;

public class JsonRpc2_0Rx {
    private final Web3j web3j;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Scheduler scheduler;

    public JsonRpc2_0Rx(Web3j web3j, ScheduledExecutorService scheduledExecutorService) {
        this.web3j = web3j;
        this.scheduledExecutorService = scheduledExecutorService;
        this.scheduler = Schedulers.from((Executor)scheduledExecutorService);
    }

    public Observable<String> ethBlockHashObservable(long pollingInterval) {
        return Observable.create(subscriber -> {
            BlockFilter blockFilter = new BlockFilter(this.web3j, arg_0 -> ((Subscriber)subscriber).onNext(arg_0));
            this.run(blockFilter, (Subscriber)subscriber, pollingInterval);
        });
    }

    public Observable<String> ethPendingTransactionHashObservable(long pollingInterval) {
        return Observable.create(subscriber -> {
            PendingTransactionFilter pendingTransactionFilter = new PendingTransactionFilter(this.web3j, arg_0 -> ((Subscriber)subscriber).onNext(arg_0));
            this.run(pendingTransactionFilter, (Subscriber)subscriber, pollingInterval);
        });
    }

    public Observable<Log> ethLogObservable(EthFilter ethFilter, long pollingInterval) {
        return Observable.create(subscriber -> {
            LogFilter logFilter = new LogFilter(this.web3j, arg_0 -> ((Subscriber)subscriber).onNext(arg_0), ethFilter);
            this.run(logFilter, (Subscriber)subscriber, pollingInterval);
        });
    }

    private <T> void run(Filter<T> filter, Subscriber<? super T> subscriber, long pollingInterval) {
        filter.run(this.scheduledExecutorService, pollingInterval);
        subscriber.add(Subscriptions.create(filter::cancel));
    }

    public Observable<Transaction> transactionObservable(long pollingInterval) {
        return this.blockObservable(true, pollingInterval).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    public Observable<Transaction> pendingTransactionObservable(long pollingInterval) {
        return this.ethPendingTransactionHashObservable(pollingInterval).flatMap(transactionHash -> this.web3j.ethGetTransactionByHash((String)transactionHash).observable()).filter(ethTransaction -> ethTransaction.getTransaction().isPresent()).map(ethTransaction -> ethTransaction.getTransaction().get());
    }

    public Observable<EthBlock> blockObservable(boolean fullTransactionObjects, long pollingInterval) {
        return this.ethBlockHashObservable(pollingInterval).flatMap(blockHash -> this.web3j.ethGetBlockByHash((String)blockHash, fullTransactionObjects).observable());
    }

    public Observable<EthBlock> replayBlocksObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects) {
        return this.replayBlocksObservable(startBlock, endBlock, fullTransactionObjects, true);
    }

    public Observable<EthBlock> replayBlocksObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects, boolean ascending) {
        return this.replayBlocksObservableSync(startBlock, endBlock, fullTransactionObjects, ascending).subscribeOn(this.scheduler);
    }

    private Observable<EthBlock> replayBlocksObservableSync(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects) {
        return this.replayBlocksObservableSync(startBlock, endBlock, fullTransactionObjects, true);
    }

    private Observable<EthBlock> replayBlocksObservableSync(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects, boolean ascending) {
        BigInteger startBlockNumber = null;
        BigInteger endBlockNumber = null;
        try {
            startBlockNumber = this.getBlockNumber(startBlock);
            endBlockNumber = this.getBlockNumber(endBlock);
        }
        catch (IOException e) {
            Observable.error((Throwable)e);
        }
        if (ascending) {
            return Observables.range(startBlockNumber, endBlockNumber).flatMap(i -> this.web3j.ethGetBlockByNumber(new DefaultBlockParameterNumber((BigInteger)i), fullTransactionObjects).observable());
        }
        return Observables.range(startBlockNumber, endBlockNumber, false).flatMap(i -> this.web3j.ethGetBlockByNumber(new DefaultBlockParameterNumber((BigInteger)i), fullTransactionObjects).observable());
    }

    public Observable<Transaction> replayTransactionsObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        return this.replayBlocksObservable(startBlock, endBlock, true).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    public Observable<EthBlock> catchUpToLatestBlockObservable(DefaultBlockParameter startBlock, boolean fullTransactionObjects, Observable<EthBlock> onCompleteObservable) {
        return this.catchUpToLatestBlockObservableSync(startBlock, fullTransactionObjects, onCompleteObservable).subscribeOn(this.scheduler);
    }

    public Observable<EthBlock> catchUpToLatestBlockObservable(DefaultBlockParameter startBlock, boolean fullTransactionObjects) {
        return this.catchUpToLatestBlockObservable(startBlock, fullTransactionObjects, (Observable<EthBlock>)Observable.empty());
    }

    private Observable<EthBlock> catchUpToLatestBlockObservableSync(DefaultBlockParameter startBlock, boolean fullTransactionObjects, Observable<EthBlock> onCompleteObservable) {
        BigInteger latestBlockNumber;
        BigInteger startBlockNumber;
        try {
            startBlockNumber = this.getBlockNumber(startBlock);
            latestBlockNumber = this.getLatestBlockNumber();
        }
        catch (IOException e) {
            return Observable.error((Throwable)e);
        }
        if (startBlockNumber.compareTo(latestBlockNumber) > -1) {
            return onCompleteObservable;
        }
        return Observable.concat(this.replayBlocksObservableSync(new DefaultBlockParameterNumber(startBlockNumber), new DefaultBlockParameterNumber(latestBlockNumber), fullTransactionObjects), (Observable)Observable.defer(() -> this.catchUpToLatestBlockObservableSync(new DefaultBlockParameterNumber(latestBlockNumber.add(BigInteger.ONE)), fullTransactionObjects, onCompleteObservable)));
    }

    public Observable<Transaction> catchUpToLatestTransactionObservable(DefaultBlockParameter startBlock) {
        return this.catchUpToLatestBlockObservable(startBlock, true, (Observable<EthBlock>)Observable.empty()).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    public Observable<EthBlock> catchUpToLatestAndSubscribeToNewBlocksObservable(DefaultBlockParameter startBlock, boolean fullTransactionObjects, long pollingInterval) {
        return this.catchUpToLatestBlockObservable(startBlock, fullTransactionObjects, this.blockObservable(fullTransactionObjects, pollingInterval));
    }

    public Observable<Transaction> catchUpToLatestAndSubscribeToNewTransactionsObservable(DefaultBlockParameter startBlock, long pollingInterval) {
        return this.catchUpToLatestAndSubscribeToNewBlocksObservable(startBlock, true, pollingInterval).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    private BigInteger getLatestBlockNumber() throws IOException {
        return this.getBlockNumber(DefaultBlockParameterName.LATEST);
    }

    private BigInteger getBlockNumber(DefaultBlockParameter defaultBlockParameter) throws IOException {
        if (defaultBlockParameter instanceof DefaultBlockParameterNumber) {
            return ((DefaultBlockParameterNumber)defaultBlockParameter).getBlockNumber();
        }
        EthBlock latestEthBlock = this.web3j.ethGetBlockByNumber(defaultBlockParameter, false).send();
        return latestEthBlock.getBlock().getNumber();
    }

    private static List<Transaction> toTransactions(EthBlock ethBlock) {
        return ethBlock.getBlock().getTransactions().stream().map(transactionResult -> (Transaction)transactionResult.get()).collect(Collectors.toList());
    }
}

