/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.filters;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.filters.Callback;
import org.web3j.protocol.core.filters.Filter;
import org.web3j.protocol.core.filters.FilterException;
import org.web3j.protocol.core.methods.response.EthFilter;
import org.web3j.protocol.core.methods.response.EthLog;

public class PendingTransactionsFilter
extends Filter<List<String>> {
    public PendingTransactionsFilter(Web3j web3j, Callback<List<String>> callback) {
        super(web3j, callback);
    }

    @Override
    EthFilter sendRequest() throws IOException {
        return this.web3j.ethNewPendingTransactionFilter().send();
    }

    @Override
    void process(List<EthLog.LogResult> logResults) {
        ArrayList<String> logs = new ArrayList<String>(logResults.size());
        for (EthLog.LogResult logResult : logResults) {
            if (!(logResult instanceof EthLog.Hash)) {
                throw new FilterException("Unexpected result type: " + logResult.get() + ", required Hash");
            }
            logs.add(((EthLog.Hash)logResult).get());
        }
        this.callback.onEvent(logs);
    }

    @Override
    protected Optional<Request<?, EthLog>> getFilterLogs(BigInteger filterId) {
        return Optional.empty();
    }
}

