/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.ens.contracts.generated;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.abi.datatypes.generated.Bytes4;
import org.web3j.abi.datatypes.generated.Uint64;
import org.web3j.crypto.Credentials;
import org.web3j.ens.contracts.generated.PublicResolver;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.utils.Numeric;

public class OffchainResolverContract
extends PublicResolver {
    public static final String BINARY = "Bin file was not provided";
    public static final String FUNC_MAKESIGNATUREHASH = "makeSignatureHash";
    public static final String FUNC_RESOLVE = "resolve";
    public static final String FUNC_RESOLVEWITHPROOF = "resolveWithProof";
    public static final String FUNC_SIGNERS = "signers";
    public static final String FUNC_SUPPORTSINTERFACE = "supportsInterface";
    public static final String FUNC_URL = "url";
    public static final String FUNC_VERIFY = "verify";
    public static final Event NEWSIGNERS_EVENT = new Event("NewSigners", Arrays.asList(new TypeReference<DynamicArray<Address>>(){}));

    public OffchainResolverContract(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    public OffchainResolverContract(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(contractAddress, web3j, credentials, contractGasProvider);
    }

    public OffchainResolverContract(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public OffchainResolverContract(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public List<NewSignersEventResponse> getNewSignersEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(NEWSIGNERS_EVENT, transactionReceipt);
        ArrayList<NewSignersEventResponse> responses = new ArrayList<NewSignersEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            NewSignersEventResponse typedResponse = new NewSignersEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.signers = (List)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<NewSignersEventResponse> newSignersEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, NewSignersEventResponse>(){

            public NewSignersEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = OffchainResolverContract.this.extractEventParametersWithLog(NEWSIGNERS_EVENT, log);
                NewSignersEventResponse typedResponse = new NewSignersEventResponse();
                typedResponse.log = log;
                typedResponse.signers = (List)eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<NewSignersEventResponse> newSignersEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)NEWSIGNERS_EVENT));
        return this.newSignersEventFlowable(filter);
    }

    public RemoteFunctionCall<byte[]> makeSignatureHash(String target, BigInteger expires, byte[] request, byte[] result) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_MAKESIGNATUREHASH, Arrays.asList(new Address(160, target), new Uint64(expires), new DynamicBytes(request), new DynamicBytes(result)), Arrays.asList(new TypeReference<Bytes32>(){}));
        return this.executeRemoteCallSingleValueReturn(function, byte[].class);
    }

    public RemoteFunctionCall<String> resolve(byte[] name, byte[] data) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_RESOLVE, Arrays.asList(new DynamicBytes(name), new DynamicBytes(data)), Arrays.asList(new TypeReference<DynamicBytes>(){}));
        return new RemoteFunctionCall<String>(function, () -> Numeric.removeDoubleQuotes((String)this.executeCallWithoutDecoding(function)));
    }

    public String executeCallWithoutDecoding(String encodedFunction) throws IOException {
        return this.call(this.contractAddress, encodedFunction, this.defaultBlockParameter);
    }

    public RemoteFunctionCall<String> resolveWithProof(byte[] response, byte[] extraData) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_RESOLVEWITHPROOF, Arrays.asList(new DynamicBytes(response), new DynamicBytes(extraData)), Arrays.asList(new TypeReference<DynamicBytes>(){}));
        return new RemoteFunctionCall<String>(function, () -> Numeric.removeDoubleQuotes((String)this.executeCallWithoutDecoding(function)));
    }

    public RemoteFunctionCall<Boolean> signers(String param0) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SIGNERS, Arrays.asList(new Address(160, param0)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    @Override
    public RemoteFunctionCall<Boolean> supportsInterface(byte[] interfaceID) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SUPPORTSINTERFACE, Arrays.asList(new Bytes4(interfaceID)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<String> url() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_URL, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<byte[]> verify(byte[] request, byte[] response) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_VERIFY, Arrays.asList(new DynamicBytes(request), new DynamicBytes(response)), Arrays.asList(new TypeReference<DynamicBytes>(){}));
        return this.executeRemoteCallSingleValueReturn(function, byte[].class);
    }

    @Deprecated
    public static OffchainResolverContract load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new OffchainResolverContract(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static OffchainResolverContract load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new OffchainResolverContract(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static OffchainResolverContract load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new OffchainResolverContract(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static OffchainResolverContract load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new OffchainResolverContract(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static class NewSignersEventResponse
    extends BaseEventResponse {
        public List<String> signers;
    }
}

