/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.ens;

import org.web3j.ens.EnsResolutionException;

public class NameWrapperUrl {
    public static final String BASE_URL = "https://ens-metadata-service.appspot.com/";
    public static final String MAINNET_URL = "https://ens-metadata-service.appspot.com/mainnet/0xD4416b13d2b3a9aBae7AcD5D6C2BbDBE25686401/";
    public static final String SEPOLIA_URL = "https://ens-metadata-service.appspot.com/sepolia/0x0635513f179D50A207757E05759CbD106d7dFcE8/";
    public static final String HOLESKY_URL = "https://ens-metadata-service.appspot.com/holesky/0xab50971078225D365994dc1Edcb9b7FD72Bb4862/";

    private NameWrapperUrl() {
    }

    public static String getEnsMetadataApi(String chainId) {
        Long chainIdLong = Long.parseLong(chainId);
        if (chainIdLong.equals(1L)) {
            return MAINNET_URL;
        }
        if (chainIdLong.equals(11155111L)) {
            return SEPOLIA_URL;
        }
        if (chainIdLong.equals(17000L)) {
            return HOLESKY_URL;
        }
        throw new EnsResolutionException("Unable to get ENS metadata API for network id: " + chainId);
    }
}

