/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.ens;

import org.web3j.ens.EnsResolutionException;

public class ReverseRegistrarContracts {
    public static final String MAINNET = "0xa58E81fe9b61B5c3fE2AFD33CF304c454AbFc7Cb";
    public static final String SEPOLIA = "0xA0a1AbcDAe1a2a4A2EF8e9113Ff0e02DD81DC0C6";
    public static final String HOLESKY = "0x132AC0B116a73add4225029D1951A9A707Ef673f";
    public static final String LINEA = "0x08D3fF6E65f680844fd2465393ff6f0d742b67D5";
    public static final String LINEA_SEPOLIA = "0x4aAA964D8EB65508ca3DA3b0A3C060c16059E613";

    private ReverseRegistrarContracts() {
    }

    public static String resolveReverseRegistrarContract(String chainId) {
        Long chainIdLong = Long.parseLong(chainId);
        if (chainIdLong.equals(1L)) {
            return MAINNET;
        }
        if (chainIdLong.equals(11155111L)) {
            return SEPOLIA;
        }
        if (chainIdLong.equals(17000L)) {
            return HOLESKY;
        }
        if (chainIdLong.equals(59144L)) {
            return LINEA;
        }
        if (chainIdLong.equals(59141L)) {
            return LINEA_SEPOLIA;
        }
        throw new EnsResolutionException("Unable to resolve ENS reverse registrar contract for network id: " + chainId);
    }
}

