/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.ens.contracts.generated;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.abi.datatypes.generated.Uint64;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class ENSRegistryWithFallbackContract
extends Contract {
    public static final String BINARY = "Bin file was not provided";
    public static final String FUNC_ISAPPROVEDFORALL = "isApprovedForAll";
    public static final String FUNC_OLD = "old";
    public static final String FUNC_OWNER = "owner";
    public static final String FUNC_RECORDEXISTS = "recordExists";
    public static final String FUNC_RESOLVER = "resolver";
    public static final String FUNC_SETAPPROVALFORALL = "setApprovalForAll";
    public static final String FUNC_SETOWNER = "setOwner";
    public static final String FUNC_SETRECORD = "setRecord";
    public static final String FUNC_SETRESOLVER = "setResolver";
    public static final String FUNC_SETSUBNODEOWNER = "setSubnodeOwner";
    public static final String FUNC_SETSUBNODERECORD = "setSubnodeRecord";
    public static final String FUNC_SETTTL = "setTTL";
    public static final String FUNC_TTL = "ttl";
    public static final Event APPROVALFORALL_EVENT = new Event("ApprovalForAll", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Bool>(){}));
    public static final Event NEWOWNER_EVENT = new Event("NewOwner", Arrays.asList(new TypeReference<Bytes32>(true){}, new TypeReference<Bytes32>(true){}, new TypeReference<Address>(){}));
    public static final Event NEWRESOLVER_EVENT = new Event("NewResolver", Arrays.asList(new TypeReference<Bytes32>(true){}, new TypeReference<Address>(){}));
    public static final Event NEWTTL_EVENT = new Event("NewTTL", Arrays.asList(new TypeReference<Bytes32>(true){}, new TypeReference<Uint64>(){}));
    public static final Event TRANSFER_EVENT = new Event("Transfer", Arrays.asList(new TypeReference<Bytes32>(true){}, new TypeReference<Address>(){}));

    @Deprecated
    protected ENSRegistryWithFallbackContract(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected ENSRegistryWithFallbackContract(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected ENSRegistryWithFallbackContract(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected ENSRegistryWithFallbackContract(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public List<ApprovalForAllEventResponse> getApprovalForAllEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(APPROVALFORALL_EVENT, transactionReceipt);
        ArrayList<ApprovalForAllEventResponse> responses = new ArrayList<ApprovalForAllEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalForAllEventResponse typedResponse = new ApprovalForAllEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.owner = (String)eventValues.getIndexedValues().get(0).getValue();
            typedResponse.operator = (String)eventValues.getIndexedValues().get(1).getValue();
            typedResponse.approved = (Boolean)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ApprovalForAllEventResponse> approvalForAllEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ApprovalForAllEventResponse>(){

            public ApprovalForAllEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ENSRegistryWithFallbackContract.this.extractEventParametersWithLog(APPROVALFORALL_EVENT, log);
                ApprovalForAllEventResponse typedResponse = new ApprovalForAllEventResponse();
                typedResponse.log = log;
                typedResponse.owner = (String)eventValues.getIndexedValues().get(0).getValue();
                typedResponse.operator = (String)eventValues.getIndexedValues().get(1).getValue();
                typedResponse.approved = (Boolean)eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ApprovalForAllEventResponse> approvalForAllEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)APPROVALFORALL_EVENT));
        return this.approvalForAllEventFlowable(filter);
    }

    public List<NewOwnerEventResponse> getNewOwnerEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(NEWOWNER_EVENT, transactionReceipt);
        ArrayList<NewOwnerEventResponse> responses = new ArrayList<NewOwnerEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            NewOwnerEventResponse typedResponse = new NewOwnerEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
            typedResponse.label = (byte[])eventValues.getIndexedValues().get(1).getValue();
            typedResponse.owner = (String)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<NewOwnerEventResponse> newOwnerEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, NewOwnerEventResponse>(){

            public NewOwnerEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ENSRegistryWithFallbackContract.this.extractEventParametersWithLog(NEWOWNER_EVENT, log);
                NewOwnerEventResponse typedResponse = new NewOwnerEventResponse();
                typedResponse.log = log;
                typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
                typedResponse.label = (byte[])eventValues.getIndexedValues().get(1).getValue();
                typedResponse.owner = (String)eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<NewOwnerEventResponse> newOwnerEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)NEWOWNER_EVENT));
        return this.newOwnerEventFlowable(filter);
    }

    public List<NewResolverEventResponse> getNewResolverEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(NEWRESOLVER_EVENT, transactionReceipt);
        ArrayList<NewResolverEventResponse> responses = new ArrayList<NewResolverEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            NewResolverEventResponse typedResponse = new NewResolverEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
            typedResponse.resolver = (String)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<NewResolverEventResponse> newResolverEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, NewResolverEventResponse>(){

            public NewResolverEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ENSRegistryWithFallbackContract.this.extractEventParametersWithLog(NEWRESOLVER_EVENT, log);
                NewResolverEventResponse typedResponse = new NewResolverEventResponse();
                typedResponse.log = log;
                typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
                typedResponse.resolver = (String)eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<NewResolverEventResponse> newResolverEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)NEWRESOLVER_EVENT));
        return this.newResolverEventFlowable(filter);
    }

    public List<NewTTLEventResponse> getNewTTLEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(NEWTTL_EVENT, transactionReceipt);
        ArrayList<NewTTLEventResponse> responses = new ArrayList<NewTTLEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            NewTTLEventResponse typedResponse = new NewTTLEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
            typedResponse.ttl = (BigInteger)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<NewTTLEventResponse> newTTLEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, NewTTLEventResponse>(){

            public NewTTLEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ENSRegistryWithFallbackContract.this.extractEventParametersWithLog(NEWTTL_EVENT, log);
                NewTTLEventResponse typedResponse = new NewTTLEventResponse();
                typedResponse.log = log;
                typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
                typedResponse.ttl = (BigInteger)eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<NewTTLEventResponse> newTTLEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)NEWTTL_EVENT));
        return this.newTTLEventFlowable(filter);
    }

    public List<TransferEventResponse> getTransferEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = this.extractEventParametersWithLog(TRANSFER_EVENT, transactionReceipt);
        ArrayList<TransferEventResponse> responses = new ArrayList<TransferEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferEventResponse typedResponse = new TransferEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
            typedResponse.owner = (String)eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferEventResponse> transferEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TransferEventResponse>(){

            public TransferEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ENSRegistryWithFallbackContract.this.extractEventParametersWithLog(TRANSFER_EVENT, log);
                TransferEventResponse typedResponse = new TransferEventResponse();
                typedResponse.log = log;
                typedResponse.node = (byte[])eventValues.getIndexedValues().get(0).getValue();
                typedResponse.owner = (String)eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferEventResponse> transferEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFER_EVENT));
        return this.transferEventFlowable(filter);
    }

    public RemoteFunctionCall<Boolean> isApprovedForAll(String owner, String operator) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISAPPROVEDFORALL, Arrays.asList(new Address(160, owner), new Address(160, operator)), Arrays.asList(new TypeReference<Bool>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<String> old() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_OLD, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> owner(byte[] node) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_OWNER, Arrays.asList(new Bytes32(node)), Arrays.asList(new TypeReference<Address>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<Boolean> recordExists(byte[] node) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_RECORDEXISTS, Arrays.asList(new Bytes32(node)), Arrays.asList(new TypeReference<Bool>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<String> resolver(byte[] node) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_RESOLVER, Arrays.asList(new Bytes32(node)), Arrays.asList(new TypeReference<Address>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> setApprovalForAll(String operator, Boolean approved) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETAPPROVALFORALL, Arrays.asList(new Address(160, operator), new Bool(approved)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setOwner(byte[] node, String owner) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETOWNER, Arrays.asList(new Bytes32(node), new Address(160, owner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setRecord(byte[] node, String owner, String resolver, BigInteger ttl) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETRECORD, Arrays.asList(new Bytes32(node), new Address(160, owner), new Address(160, resolver), new Uint64(ttl)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setResolver(byte[] node, String resolver) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETRESOLVER, Arrays.asList(new Bytes32(node), new Address(160, resolver)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setSubnodeOwner(byte[] node, byte[] label, String owner) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETSUBNODEOWNER, Arrays.asList(new Bytes32(node), new Bytes32(label), new Address(160, owner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setSubnodeRecord(byte[] node, byte[] label, String owner, String resolver, BigInteger ttl) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETSUBNODERECORD, Arrays.asList(new Bytes32(node), new Bytes32(label), new Address(160, owner), new Address(160, resolver), new Uint64(ttl)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setTTL(byte[] node, BigInteger ttl) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETTTL, Arrays.asList(new Bytes32(node), new Uint64(ttl)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> ttl(byte[] node) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TTL, Arrays.asList(new Bytes32(node)), Arrays.asList(new TypeReference<Uint64>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    @Deprecated
    public static ENSRegistryWithFallbackContract load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new ENSRegistryWithFallbackContract(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static ENSRegistryWithFallbackContract load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new ENSRegistryWithFallbackContract(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static ENSRegistryWithFallbackContract load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new ENSRegistryWithFallbackContract(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static ENSRegistryWithFallbackContract load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new ENSRegistryWithFallbackContract(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static class ApprovalForAllEventResponse
    extends BaseEventResponse {
        public String owner;
        public String operator;
        public Boolean approved;
    }

    public static class NewOwnerEventResponse
    extends BaseEventResponse {
        public byte[] node;
        public byte[] label;
        public String owner;
    }

    public static class NewResolverEventResponse
    extends BaseEventResponse {
        public byte[] node;
        public String resolver;
    }

    public static class NewTTLEventResponse
    extends BaseEventResponse {
        public byte[] node;
        public BigInteger ttl;
    }

    public static class TransferEventResponse
    extends BaseEventResponse {
        public byte[] node;
        public String owner;
    }
}

