/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.methods.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.Response;
import org.web3j.utils.Numeric;

public class EthFeeHistory
extends Response<FeeHistory> {
    @Override
    @JsonDeserialize(using=ResponseDeserialiser.class)
    public void setResult(FeeHistory result) {
        super.setResult(result);
    }

    public FeeHistory getFeeHistory() {
        return (FeeHistory)this.getResult();
    }

    public static class FeeHistory {
        private String oldestBlock;
        private List<List<String>> reward;
        private List<String> baseFeePerGas;
        private List<Double> gasUsedRatio;

        public FeeHistory() {
        }

        public FeeHistory(String oldestBlock, List<List<String>> reward, List<String> baseFeePerGas, List<Double> gasUsedRatio) {
            this.oldestBlock = oldestBlock;
            this.reward = reward;
            this.baseFeePerGas = baseFeePerGas;
            this.gasUsedRatio = gasUsedRatio;
        }

        public BigInteger getOldestBlock() {
            return Numeric.decodeQuantity((String)this.oldestBlock);
        }

        public String getOldestBlockRaw() {
            return this.oldestBlock;
        }

        public void setOldestBlock(String oldestBlock) {
            this.oldestBlock = oldestBlock;
        }

        public List<List<BigInteger>> getReward() {
            return this.reward.stream().map(rewardPercentile -> rewardPercentile.stream().map(Numeric::decodeQuantity).toList()).toList();
        }

        public void setReward(List<List<String>> reward) {
            this.reward = reward;
        }

        public List<List<String>> getRewardRaw() {
            return this.reward;
        }

        public List<BigInteger> getBaseFeePerGas() {
            return this.baseFeePerGas.stream().map(Numeric::decodeQuantity).toList();
        }

        public void setBaseFeePerGas(List<String> baseFeePerGas) {
            this.baseFeePerGas = baseFeePerGas;
        }

        public List<String> getBaseFeePerGasRaw() {
            return this.baseFeePerGas;
        }

        public List<Double> getGasUsedRatio() {
            return this.gasUsedRatio;
        }

        public void setGasUsedRatio(List<Double> gasUsedRatio) {
            this.gasUsedRatio = gasUsedRatio;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FeeHistory)) {
                return false;
            }
            FeeHistory feeHistory = (FeeHistory)o;
            if (this.getOldestBlockRaw() != null ? !this.getOldestBlockRaw().equals(feeHistory.getOldestBlockRaw()) : feeHistory.getOldestBlockRaw() != null) {
                return false;
            }
            if (this.getRewardRaw() != null ? !this.getRewardRaw().equals(feeHistory.getRewardRaw()) : feeHistory.getRewardRaw() != null) {
                return false;
            }
            if (this.getBaseFeePerGasRaw() != null ? !this.getBaseFeePerGasRaw().equals(feeHistory.getBaseFeePerGasRaw()) : feeHistory.getBaseFeePerGasRaw() != null) {
                return false;
            }
            return this.getGasUsedRatio() != null ? this.getGasUsedRatio().equals(feeHistory.getGasUsedRatio()) : feeHistory.getGasUsedRatio() == null;
        }

        public int hashCode() {
            int result = this.getOldestBlockRaw() != null ? this.getOldestBlockRaw().hashCode() : 0;
            result = 31 * result + (this.getRewardRaw() != null ? this.getRewardRaw().hashCode() : 0);
            result = 31 * result + (this.getBaseFeePerGasRaw() != null ? this.getBaseFeePerGasRaw().hashCode() : 0);
            result = 31 * result + (this.getGasUsedRatio() != null ? this.getGasUsedRatio().hashCode() : 0);
            return result;
        }
    }

    public static class ResponseDeserialiser
    extends JsonDeserializer<FeeHistory> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public FeeHistory deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.getCurrentToken() != JsonToken.VALUE_NULL) {
                return (FeeHistory)this.objectReader.readValue(jsonParser, FeeHistory.class);
            }
            return null;
        }
    }
}

