/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.methods.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.Response;
import org.web3j.utils.Numeric;

public class EthGetProof
extends Response<Proof> {
    @Override
    @JsonDeserialize(using=ResponseDeserializer.class)
    public void setResult(Proof result) {
        super.setResult(result);
    }

    public Proof getProof() {
        return (Proof)this.getResult();
    }

    public static class Proof {
        private String address;
        private String balance;
        private String codeHash;
        private String nonce;
        private String storageHash;
        private List<String> accountProof;
        private List<StorageProof> storageProof;

        public Proof() {
        }

        public Proof(String address, String balance, String codeHash, String nonce, String storageHash, List<String> accountProof, List<StorageProof> storageProof) {
            this.address = address;
            this.balance = balance;
            this.codeHash = codeHash;
            this.nonce = nonce;
            this.storageHash = storageHash;
            this.accountProof = accountProof;
            this.storageProof = storageProof;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getBalanceRaw() {
            return this.balance;
        }

        public BigInteger getBalance() {
            return Numeric.decodeQuantity((String)this.balance);
        }

        public void setBalance(String balance) {
            this.balance = balance;
        }

        public String getCodeHash() {
            return this.codeHash;
        }

        public void setCodeHash(String codeHash) {
            this.codeHash = codeHash;
        }

        public String getNonce() {
            return this.nonce;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public String getStorageHash() {
            return this.storageHash;
        }

        public void setStorageHash(String storageHash) {
            this.storageHash = storageHash;
        }

        public List<String> getAccountProof() {
            return this.accountProof;
        }

        public void setAccountProof(List<String> accountProof) {
            this.accountProof = accountProof;
        }

        public List<StorageProof> getStorageProof() {
            return this.storageProof;
        }

        public void setStorageProof(List<StorageProof> storageProof) {
            this.storageProof = storageProof;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Proof)) {
                return false;
            }
            Proof proof = (Proof)o;
            if (this.getAddress() != null ? !this.getAddress().equals(proof.getAddress()) : proof.getAddress() != null) {
                return false;
            }
            if (this.getBalanceRaw() != null ? !this.getBalanceRaw().equals(proof.getBalanceRaw()) : proof.getBalanceRaw() != null) {
                return false;
            }
            if (this.getCodeHash() != null ? !this.getCodeHash().equals(proof.getCodeHash()) : proof.getCodeHash() != null) {
                return false;
            }
            if (this.getNonce() != null ? !this.getNonce().equals(proof.getNonce()) : proof.getNonce() != null) {
                return false;
            }
            if (this.getStorageHash() != null ? !this.getStorageHash().equals(proof.getStorageHash()) : proof.getStorageHash() != null) {
                return false;
            }
            if (this.getAccountProof() != null ? !this.getAccountProof().equals(proof.getAccountProof()) : proof.getAccountProof() != null) {
                return false;
            }
            return this.getStorageProof() != null ? this.getStorageProof().equals(proof.getStorageProof()) : proof.getStorageProof() == null;
        }

        public int hashCode() {
            int result = this.getAddress() != null ? this.getAddress().hashCode() : 0;
            result = 31 * result + (this.getBalanceRaw() != null ? this.getBalanceRaw().hashCode() : 0);
            result = 31 * result + (this.getCodeHash() != null ? this.getCodeHash().hashCode() : 0);
            result = 31 * result + (this.getNonce() != null ? this.getNonce().hashCode() : 0);
            result = 31 * result + (this.getStorageHash() != null ? this.getStorageHash().hashCode() : 0);
            result = 31 * result + (this.getAccountProof() != null ? this.getAccountProof().hashCode() : 0);
            result = 31 * result + (this.getStorageProof() != null ? this.getStorageProof().hashCode() : 0);
            return result;
        }
    }

    public static class ResponseDeserializer
    extends JsonDeserializer<Proof> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public Proof deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.getCurrentToken() != JsonToken.VALUE_NULL) {
                return (Proof)this.objectReader.readValue(jsonParser, Proof.class);
            }
            return null;
        }
    }

    public static class StorageProof {
        private String key;
        private String value;
        private List<String> proof;

        public StorageProof() {
        }

        public StorageProof(String key, String value, List<String> proof) {
            this.key = key;
            this.value = value;
            this.proof = proof;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public List<String> getProof() {
            return this.proof;
        }

        public void setProof(List<String> proof) {
            this.proof = proof;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StorageProof)) {
                return false;
            }
            StorageProof proof = (StorageProof)o;
            if (this.getKey() != null ? !this.getKey().equals(proof.getKey()) : proof.getKey() != null) {
                return false;
            }
            if (this.getValue() != null ? !this.getValue().equals(proof.getValue()) : proof.getValue() != null) {
                return false;
            }
            return this.getProof() != null ? this.getProof().equals(proof.getProof()) : proof.getProof() == null;
        }

        public int hashCode() {
            int result = this.getKey() != null ? this.getKey().hashCode() : 0;
            result = 31 * result + (this.getValue() != null ? this.getValue().hashCode() : 0);
            result = 31 * result + (this.getProof() != null ? this.getProof().hashCode() : 0);
            return result;
        }
    }
}

