/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.methods.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigInteger;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.Response;
import org.web3j.utils.Numeric;

public class LineaEstimateGas
extends Response<LineaEstimateGasResponse> {
    @Override
    @JsonDeserialize(using=ResponseDeserialiser.class)
    public void setResult(LineaEstimateGasResponse result) {
        super.setResult(result);
    }

    public LineaEstimateGasResponse getLineaEstimateGas() {
        return (LineaEstimateGasResponse)this.getResult();
    }

    public static class LineaEstimateGasResponse {
        private BigInteger baseFeePerGas;
        private BigInteger gasLimit;
        private BigInteger priorityFeePerGas;

        public LineaEstimateGasResponse() {
        }

        public LineaEstimateGasResponse(BigInteger baseFeePerGas, BigInteger gasLimit, BigInteger priorityFeePerGas) {
            this.baseFeePerGas = baseFeePerGas;
            this.gasLimit = gasLimit;
            this.priorityFeePerGas = priorityFeePerGas;
        }

        public BigInteger getBaseFeePerGas() {
            return this.baseFeePerGas;
        }

        public void setBaseFeePerGas(String baseFeePerGas) {
            this.baseFeePerGas = Numeric.decodeQuantity((String)baseFeePerGas);
        }

        public BigInteger getGasLimit() {
            return this.gasLimit;
        }

        public void setGasLimit(String gasLimit) {
            this.gasLimit = Numeric.decodeQuantity((String)gasLimit);
        }

        public BigInteger getPriorityFeePerGas() {
            return this.priorityFeePerGas;
        }

        public void setPriorityFeePerGas(String priorityFeePerGas) {
            this.priorityFeePerGas = Numeric.decodeQuantity((String)priorityFeePerGas);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LineaEstimateGasResponse)) {
                return false;
            }
            LineaEstimateGasResponse res = (LineaEstimateGasResponse)o;
            if (this.getGasLimit() != null ? !this.getGasLimit().equals(res.getGasLimit()) : res.getGasLimit() != null) {
                return false;
            }
            if (this.getBaseFeePerGas() != null ? !this.getBaseFeePerGas().equals(res.getBaseFeePerGas()) : res.getBaseFeePerGas() != null) {
                return false;
            }
            return this.getPriorityFeePerGas() != null ? this.getPriorityFeePerGas().equals(res.getPriorityFeePerGas()) : res.getPriorityFeePerGas() == null;
        }
    }

    public static class ResponseDeserialiser
    extends JsonDeserializer<LineaEstimateGasResponse> {
        private ObjectReader objectReader = ObjectMapperFactory.getObjectReader();

        public LineaEstimateGasResponse deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.getCurrentToken() != JsonToken.VALUE_NULL) {
                return (LineaEstimateGasResponse)this.objectReader.readValue(jsonParser, LineaEstimateGasResponse.class);
            }
            return null;
        }
    }
}

