/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.utils;

import java.io.IOException;
import java.math.BigInteger;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class RevertReasonExtractor {
    public static final String MISSING_REASON = "N/A";

    public static String extractRevertReason(TransactionReceipt transactionReceipt, String data, Web3j web3j, Boolean revertReasonCallEnabled, BigInteger weiValue) throws IOException {
        String revertReason;
        if (transactionReceipt.getRevertReason() != null) {
            return transactionReceipt.getRevertReason();
        }
        if (revertReasonCallEnabled.booleanValue() && (revertReason = RevertReasonExtractor.retrieveRevertReason(transactionReceipt, data, web3j, weiValue)) != null) {
            transactionReceipt.setRevertReason(revertReason);
            return revertReason;
        }
        return MISSING_REASON;
    }

    public static String extractRevertReasonEncodedData(TransactionReceipt transactionReceipt, String data, Web3j web3j, BigInteger weiValue) throws IOException {
        String revertReason = RevertReasonExtractor.retrieveRevertReasonEncodedData(transactionReceipt, data, web3j, weiValue);
        if (revertReason != null) {
            return revertReason;
        }
        return MISSING_REASON;
    }

    @Deprecated
    public static String extractRevertReason(TransactionReceipt transactionReceipt, String data, Web3j web3j, Boolean revertReasonCallEnabled) throws IOException {
        return RevertReasonExtractor.extractRevertReason(transactionReceipt, data, web3j, revertReasonCallEnabled, null);
    }

    public static String retrieveRevertReason(TransactionReceipt transactionReceipt, String data, Web3j web3j, BigInteger weiValue) throws IOException {
        if (transactionReceipt.getBlockNumber() == null) {
            return null;
        }
        return web3j.ethCall(Transaction.createEthCallTransaction(transactionReceipt.getFrom(), transactionReceipt.getTo(), data, weiValue), DefaultBlockParameter.valueOf(transactionReceipt.getBlockNumber())).send().getRevertReason();
    }

    public static String retrieveRevertReasonEncodedData(TransactionReceipt transactionReceipt, String data, Web3j web3j, BigInteger weiValue) throws IOException {
        if (transactionReceipt.getBlockNumber() == null) {
            return null;
        }
        return web3j.ethCall(Transaction.createEthCallTransaction(transactionReceipt.getFrom(), transactionReceipt.getTo(), data, weiValue), DefaultBlockParameter.valueOf(transactionReceipt.getBlockNumber())).send().getRevertReasonEncodedData();
    }

    @Deprecated
    public static String retrieveRevertReason(TransactionReceipt transactionReceipt, String data, Web3j web3j) throws IOException {
        return RevertReasonExtractor.retrieveRevertReason(transactionReceipt, data, web3j, null);
    }
}

