/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.nio.charset.StandardCharsets;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.web3j.utils.Numeric;

public class Hash {
    private Hash() {
    }

    public static String sha3(String hexInput) {
        byte[] bytes = Numeric.hexStringToByteArray(hexInput);
        byte[] result = Hash.sha3(bytes);
        return Numeric.toHexString(result);
    }

    public static byte[] sha3(byte[] input, int offset, int length) {
        Keccak.Digest256 kecc = new Keccak.Digest256();
        kecc.update(input, offset, length);
        return kecc.digest();
    }

    public static byte[] sha3(byte[] input) {
        return Hash.sha3(input, 0, input.length);
    }

    public static String sha3String(String utf8String) {
        return Numeric.toHexString(Hash.sha3(utf8String.getBytes(StandardCharsets.UTF_8)));
    }
}

