/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.web3j.exceptions.MessageDecodingException;
import org.web3j.exceptions.MessageEncodingException;
import org.web3j.utils.Strings;

public final class Numeric {
    private static final String HEX_PREFIX = "0x";
    private static final char[] HEX_CHAR_MAP = "0123456789abcdef".toCharArray();

    private Numeric() {
    }

    public static String encodeQuantity(BigInteger value) {
        if (value.signum() != -1) {
            return HEX_PREFIX + value.toString(16);
        }
        throw new MessageEncodingException("Negative values are not supported");
    }

    public static BigInteger decodeQuantity(String value) {
        if (Numeric.isLongValue(value)) {
            return BigInteger.valueOf(Long.parseLong(value));
        }
        if (!Numeric.isValidHexQuantity(value)) {
            throw new MessageDecodingException("Value must be in format 0x[0-9a-fA-F]+");
        }
        try {
            return Numeric.parsePaddedNumberHex(value);
        }
        catch (NumberFormatException e) {
            throw new MessageDecodingException("Negative ", e);
        }
    }

    public static BigInteger parsePaddedNumberHex(String value) {
        String numWithoutLeadingZeros = Numeric.cleanHexPrefix(value).replaceFirst("^0+(?!$)", "");
        return new BigInteger(numWithoutLeadingZeros, 16);
    }

    private static boolean isLongValue(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected static boolean isValidHexQuantity(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() < 3) {
            return false;
        }
        if (!value.startsWith(HEX_PREFIX)) {
            return false;
        }
        return value.matches("0[xX][0-9a-fA-F]+");
    }

    public static String cleanHexPrefix(String input) {
        if (Numeric.containsHexPrefix(input)) {
            return input.substring(2);
        }
        return input;
    }

    public static String prependHexPrefix(String input) {
        if (!Numeric.containsHexPrefix(input)) {
            return HEX_PREFIX + input;
        }
        return input;
    }

    public static boolean containsHexPrefix(String input) {
        return !Strings.isEmpty(input) && input.length() > 1 && input.charAt(0) == '0' && input.charAt(1) == 'x';
    }

    public static BigInteger toBigInt(byte[] value, int offset, int length) {
        return Numeric.toBigInt(Arrays.copyOfRange(value, offset, offset + length));
    }

    public static BigInteger toBigInt(byte[] value) {
        return new BigInteger(1, value);
    }

    public static BigInteger toBigInt(String hexValue) {
        String cleanValue = Numeric.cleanHexPrefix(hexValue);
        return Numeric.toBigIntNoPrefix(cleanValue);
    }

    public static BigInteger toBigIntNoPrefix(String hexValue) {
        return new BigInteger(hexValue, 16);
    }

    public static String toHexStringWithPrefix(BigInteger value) {
        return HEX_PREFIX + value.toString(16);
    }

    public static String toHexStringNoPrefix(BigInteger value) {
        return value.toString(16);
    }

    public static String toHexStringNoPrefix(byte[] input) {
        return Numeric.toHexString(input, 0, input.length, false);
    }

    public static String toHexStringWithPrefixZeroPadded(BigInteger value, int size) {
        return Numeric.toHexStringZeroPadded(value, size, true);
    }

    @Deprecated
    public static String toHexStringWithPrefixSafe(BigInteger value) {
        Object result = Numeric.toHexStringNoPrefix(value);
        if (((String)result).length() < 2) {
            result = Strings.zeros(1) + (String)result;
        }
        return HEX_PREFIX + (String)result;
    }

    public static String toHexStringNoPrefixZeroPadded(BigInteger value, int size) {
        return Numeric.toHexStringZeroPadded(value, size, false);
    }

    private static String toHexStringZeroPadded(BigInteger value, int size, boolean withPrefix) {
        Object result = Numeric.toHexStringNoPrefix(value);
        int length = ((String)result).length();
        if (length > size) {
            throw new UnsupportedOperationException("Value " + (String)result + "is larger then length " + size);
        }
        if (value.signum() < 0) {
            throw new UnsupportedOperationException("Value cannot be negative");
        }
        if (length < size) {
            result = Strings.zeros(size - length) + (String)result;
        }
        if (withPrefix) {
            return HEX_PREFIX + (String)result;
        }
        return result;
    }

    public static byte[] toBytesPadded(BigInteger value, int length) {
        int srcOffset;
        int bytesLength;
        byte[] result = new byte[length];
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0) {
            bytesLength = bytes.length - 1;
            srcOffset = 1;
        } else {
            bytesLength = bytes.length;
            srcOffset = 0;
        }
        if (bytesLength > length) {
            throw new RuntimeException("Input is too large to put in byte array of size " + length);
        }
        int destOffset = length - bytesLength;
        System.arraycopy(bytes, srcOffset, result, destOffset, bytesLength);
        return result;
    }

    public static byte[] hexStringToByteArray(String input) {
        byte[] data;
        String cleanInput = Numeric.cleanHexPrefix(input);
        int len = cleanInput.length();
        if (len == 0) {
            return new byte[0];
        }
        if (len % 2 != 0) {
            data = new byte[len / 2 + 1];
            data[0] = (byte)Character.digit(cleanInput.charAt(0), 16);
            startIdx = 1;
        } else {
            data = new byte[len / 2];
            startIdx = 0;
        }
        for (int i = startIdx; i < len; i += 2) {
            data[(i + 1) / 2] = (byte)((Character.digit(cleanInput.charAt(i), 16) << 4) + Character.digit(cleanInput.charAt(i + 1), 16));
        }
        return data;
    }

    public static String toHexString(byte[] input, int offset, int length, boolean withPrefix) {
        String output = new String(Numeric.toHexCharArray(input, offset, length));
        return withPrefix ? HEX_PREFIX + output : output;
    }

    private static char[] toHexCharArray(byte[] input, int offset, int length) {
        char[] output = new char[length << 1];
        int i = offset;
        int j = 0;
        while (i < length + offset) {
            int v = input[i] & 0xFF;
            output[j++] = HEX_CHAR_MAP[v >>> 4];
            output[j] = HEX_CHAR_MAP[v & 0xF];
            ++i;
            ++j;
        }
        return output;
    }

    public static String toHexString(byte[] input) {
        return Numeric.toHexString(input, 0, input.length, true);
    }

    public static byte asByte(int m, int n) {
        return (byte)(m << 4 | n);
    }

    public static boolean isIntegerValue(BigDecimal value) {
        return value.signum() == 0 || value.scale() <= 0 || value.stripTrailingZeros().scale() <= 0;
    }

    public static String removeDoubleQuotes(String string) {
        return string != null ? string.replace("\"", "") : null;
    }
}

