/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.evm;

import com.google.common.io.Resources;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.cli.config.EthNetworkConfig;
import org.hyperledger.besu.cli.config.NetworkName;
import org.hyperledger.besu.config.GenesisConfigFile;
import org.hyperledger.besu.config.GenesisConfigOptions;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.BlockResult;
import org.hyperledger.besu.ethereum.api.jsonrpc.internal.results.BlockResultFactory;
import org.hyperledger.besu.ethereum.api.query.BlockWithMetadata;
import org.hyperledger.besu.ethereum.api.query.BlockchainQueries;
import org.hyperledger.besu.ethereum.api.query.TransactionWithMetadata;
import org.hyperledger.besu.ethereum.chain.Blockchain;
import org.hyperledger.besu.ethereum.chain.BlockchainStorage;
import org.hyperledger.besu.ethereum.chain.DefaultBlockchain;
import org.hyperledger.besu.ethereum.chain.GenesisState;
import org.hyperledger.besu.ethereum.chain.MutableBlockchain;
import org.hyperledger.besu.ethereum.core.Address;
import org.hyperledger.besu.ethereum.core.Block;
import org.hyperledger.besu.ethereum.core.BlockBody;
import org.hyperledger.besu.ethereum.core.BlockHeader;
import org.hyperledger.besu.ethereum.core.BlockHeaderBuilder;
import org.hyperledger.besu.ethereum.core.BlockHeaderFunctions;
import org.hyperledger.besu.ethereum.core.Difficulty;
import org.hyperledger.besu.ethereum.core.EvmAccount;
import org.hyperledger.besu.ethereum.core.Hash;
import org.hyperledger.besu.ethereum.core.MutableAccount;
import org.hyperledger.besu.ethereum.core.MutableWorldState;
import org.hyperledger.besu.ethereum.core.PrivacyParameters;
import org.hyperledger.besu.ethereum.core.ProcessableBlockHeader;
import org.hyperledger.besu.ethereum.core.SealableBlockHeader;
import org.hyperledger.besu.ethereum.core.Transaction;
import org.hyperledger.besu.ethereum.core.TransactionReceipt;
import org.hyperledger.besu.ethereum.core.Wei;
import org.hyperledger.besu.ethereum.core.WorldState;
import org.hyperledger.besu.ethereum.core.WorldUpdater;
import org.hyperledger.besu.ethereum.mainnet.AbstractBlockProcessor;
import org.hyperledger.besu.ethereum.mainnet.BodyValidation;
import org.hyperledger.besu.ethereum.mainnet.MainnetBlockHeaderFunctions;
import org.hyperledger.besu.ethereum.mainnet.MainnetProtocolSchedule;
import org.hyperledger.besu.ethereum.mainnet.MainnetTransactionProcessor;
import org.hyperledger.besu.ethereum.mainnet.ProtocolSchedule;
import org.hyperledger.besu.ethereum.mainnet.ProtocolSpec;
import org.hyperledger.besu.ethereum.mainnet.ScheduleBasedBlockHeaderFunctions;
import org.hyperledger.besu.ethereum.mainnet.ValidationResult;
import org.hyperledger.besu.ethereum.processing.TransactionProcessingResult;
import org.hyperledger.besu.ethereum.storage.keyvalue.KeyValueStoragePrefixedKeyBlockchainStorage;
import org.hyperledger.besu.ethereum.storage.keyvalue.WorldStateKeyValueStorage;
import org.hyperledger.besu.ethereum.storage.keyvalue.WorldStatePreimageKeyValueStorage;
import org.hyperledger.besu.ethereum.transaction.CallParameter;
import org.hyperledger.besu.ethereum.transaction.TransactionSimulator;
import org.hyperledger.besu.ethereum.transaction.TransactionSimulatorResult;
import org.hyperledger.besu.ethereum.vm.BlockHashLookup;
import org.hyperledger.besu.ethereum.vm.OperationTracer;
import org.hyperledger.besu.ethereum.worldstate.DefaultWorldStateArchive;
import org.hyperledger.besu.ethereum.worldstate.WorldStateArchive;
import org.hyperledger.besu.ethereum.worldstate.WorldStatePreimageStorage;
import org.hyperledger.besu.ethereum.worldstate.WorldStateStorage;
import org.hyperledger.besu.metrics.noop.NoOpMetricsSystem;
import org.hyperledger.besu.plugin.services.MetricsSystem;
import org.hyperledger.besu.plugin.services.storage.KeyValueStorage;
import org.hyperledger.besu.services.kvstore.InMemoryKeyValueStorage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.evm.Configuration;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 >2\u00020\u0001:\u0001>B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020+J\n\u0010,\u001a\u0004\u0018\u00010-H\u0002J\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00020/0(2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203J\u001c\u00104\u001a\b\u0012\u0004\u0012\u00020/0(2\u0006\u00105\u001a\u0002062\u0006\u00102\u001a\u000203J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J\u0018\u0010;\u001a\u00020<2\u0006\u0010!\u001a\u00020\"2\u0006\u0010=\u001a\u00020\u001bH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/web3j/evm/InMemoryBesuChain;", "", "configuration", "Lorg/web3j/evm/Configuration;", "operationTracer", "Lorg/hyperledger/besu/ethereum/vm/OperationTracer;", "networkName", "Lorg/hyperledger/besu/cli/config/NetworkName;", "genesisConfigOverrides", "", "", "(Lorg/web3j/evm/Configuration;Lorg/hyperledger/besu/ethereum/vm/OperationTracer;Lorg/hyperledger/besu/cli/config/NetworkName;Ljava/util/Map;)V", "blockChain", "Lorg/hyperledger/besu/ethereum/chain/MutableBlockchain;", "blockResultFactory", "Lorg/hyperledger/besu/ethereum/api/jsonrpc/internal/results/BlockResultFactory;", "blockchainQueries", "Lorg/hyperledger/besu/ethereum/api/query/BlockchainQueries;", "getBlockchainQueries", "()Lorg/hyperledger/besu/ethereum/api/query/BlockchainQueries;", "chainId", "Ljava/math/BigInteger;", "getChainId", "()Ljava/math/BigInteger;", "genesisState", "Lorg/hyperledger/besu/ethereum/chain/GenesisState;", "miningBeneficiary", "Lorg/hyperledger/besu/ethereum/core/Address;", "kotlin.jvm.PlatformType", "protocolSchedule", "Lorg/hyperledger/besu/ethereum/mainnet/ProtocolSchedule;", "simulator", "Lorg/hyperledger/besu/ethereum/transaction/TransactionSimulator;", "worldState", "Lorg/hyperledger/besu/ethereum/core/MutableWorldState;", "worldStateArchive", "Lorg/hyperledger/besu/ethereum/worldstate/WorldStateArchive;", "worldStateUpdater", "Lorg/hyperledger/besu/ethereum/core/WorldUpdater;", "call", "Ljava/util/Optional;", "Lorg/hyperledger/besu/ethereum/transaction/TransactionSimulatorResult;", "callParameter", "Lorg/hyperledger/besu/ethereum/transaction/CallParameter;", "createPendingBlockHeader", "Lorg/hyperledger/besu/ethereum/core/ProcessableBlockHeader;", "ethBlockByHash", "Lorg/hyperledger/besu/ethereum/api/jsonrpc/internal/results/BlockResult;", "hash", "Lorg/hyperledger/besu/ethereum/core/Hash;", "completeTransaction", "", "ethBlockByNumber", "number", "", "processTransaction", "Lorg/hyperledger/besu/ethereum/core/TransactionReceipt;", "transaction", "Lorg/hyperledger/besu/ethereum/core/Transaction;", "rewardMiner", "", "coinbaseAddress", "Companion", "web3j-evm"})
public final class InMemoryBesuChain {
    @NotNull
    private final BigInteger chainId;
    @NotNull
    private final BlockchainQueries blockchainQueries;
    private final GenesisState genesisState;
    private final Address miningBeneficiary;
    private final BlockResultFactory blockResultFactory;
    private final MutableWorldState worldState;
    private final WorldStateArchive worldStateArchive;
    private final WorldUpdater worldStateUpdater;
    private final ProtocolSchedule protocolSchedule;
    private final MutableBlockchain blockChain;
    private final TransactionSimulator simulator;
    private final OperationTracer operationTracer;
    private static final Logger LOG;
    private static final Map<String, String> DEFAULT_GENESIS_OVERRIDES;
    public static final Companion Companion;

    @NotNull
    public final BigInteger getChainId() {
        return this.chainId;
    }

    @NotNull
    public final BlockchainQueries getBlockchainQueries() {
        return this.blockchainQueries;
    }

    @NotNull
    public final TransactionReceipt processTransaction(@NotNull Transaction transaction) {
        TransactionProcessingResult result2;
        ProtocolSpec spec;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        long nextBlockNumber = this.blockChain.getChainHeadBlockNumber() + 1L;
        ProtocolSpec protocolSpec = spec = this.protocolSchedule.getByBlockNumber(nextBlockNumber);
        Intrinsics.checkNotNullExpressionValue((Object)protocolSpec, (String)"spec");
        MainnetTransactionProcessor transactionProcessor = protocolSpec.getTransactionProcessor();
        AbstractBlockProcessor.TransactionReceiptFactory transactionReceiptFactory = spec.getTransactionReceiptFactory();
        List transactions = CollectionsKt.listOf((Object)transaction);
        ProcessableBlockHeader processableBlockHeader = this.createPendingBlockHeader();
        BlockHashLookup blockHashLookup = new BlockHashLookup(processableBlockHeader, (Blockchain)this.blockChain);
        TransactionProcessingResult transactionProcessingResult = result2 = transactionProcessor.processTransaction((Blockchain)this.blockChain, this.worldStateUpdater, processableBlockHeader, transaction, this.miningBeneficiary, this.operationTracer, blockHashLookup, Boolean.valueOf(true));
        Intrinsics.checkNotNullExpressionValue((Object)transactionProcessingResult, (String)"result");
        if (transactionProcessingResult.isInvalid()) {
            ValidationResult validationResult = result2.getValidationResult();
            Intrinsics.checkNotNullExpressionValue((Object)validationResult, (String)"result.validationResult");
            throw (Throwable)new Exception(validationResult.getErrorMessage());
        }
        this.worldStateUpdater.commit();
        Address address = this.miningBeneficiary;
        Intrinsics.checkNotNullExpressionValue((Object)address, (String)"miningBeneficiary");
        this.rewardMiner(this.worldState, address);
        long gasUsed = result2.getEstimateGasUsedByTransaction();
        TransactionReceipt transactionReceipt = transactionReceiptFactory.create(transaction.getType(), result2, (WorldState)this.worldState, gasUsed);
        List receipts = CollectionsKt.listOf((Object)transactionReceipt);
        SealableBlockHeader sealableBlockHeader = BlockHeaderBuilder.create().populateFrom(processableBlockHeader).ommersHash(Hash.EMPTY_LIST_HASH).stateRoot(this.worldState.rootHash()).transactionsRoot(BodyValidation.transactionsRoot((List)transactions)).receiptsRoot(BodyValidation.receiptsRoot((List)receipts)).logsBloom(BodyValidation.logsBloom((List)receipts)).gasUsed(gasUsed).extraData(Bytes.EMPTY).buildSealableBlockHeader();
        BlockHeaderFunctions blockHeaderFunctions = ScheduleBasedBlockHeaderFunctions.create((ProtocolSchedule)this.protocolSchedule);
        BlockHeaderBuilder blockHeaderBuilder = BlockHeaderBuilder.create().populateFrom(sealableBlockHeader);
        BlockHeader blockHeader = this.blockChain.getChainHeadHeader();
        Intrinsics.checkNotNullExpressionValue((Object)blockHeader, (String)"blockChain.chainHeadHeader");
        BlockHeader blockHeader2 = blockHeaderBuilder.nonce(blockHeader.getNonce() + 1L).mixHash(Hash.ZERO).blockHeaderFunctions(blockHeaderFunctions).buildBlockHeader();
        Block block = new Block(blockHeader2, new BlockBody(transactions, CollectionsKt.emptyList()));
        this.worldState.persist(blockHeader2);
        this.blockChain.appendBlock(block, receipts);
        TransactionReceipt transactionReceipt2 = transactionReceipt;
        Intrinsics.checkNotNullExpressionValue((Object)transactionReceipt2, (String)"transactionReceipt");
        return transactionReceipt2;
    }

    private final ProcessableBlockHeader createPendingBlockHeader() {
        BlockHeader parentHeader;
        BlockHeader blockHeader = parentHeader = this.blockChain.getChainHeadHeader();
        Intrinsics.checkNotNullExpressionValue((Object)blockHeader, (String)"parentHeader");
        long newBlockNumber = blockHeader.getNumber() + 1L;
        return BlockHeaderBuilder.create().parentHash(parentHeader.getHash()).coinbase(this.miningBeneficiary).difficulty((Difficulty)parentHeader.getDifficulty().plus(100000L)).number(newBlockNumber).gasLimit(parentHeader.getGasLimit()).timestamp(System.currentTimeMillis()).baseFee(parentHeader.getBaseFee().orElse(0L)).buildProcessableBlockHeader();
    }

    @NotNull
    public final Optional<TransactionSimulatorResult> call(@NotNull CallParameter callParameter) {
        Intrinsics.checkNotNullParameter((Object)callParameter, (String)"callParameter");
        Optional optional = this.simulator.processAtHead(callParameter);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"simulator.processAtHead(callParameter)");
        return optional;
    }

    @NotNull
    public final Optional<BlockResult> ethBlockByHash(@NotNull Hash hash, boolean completeTransaction) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        if (completeTransaction) {
            Optional<BlockResult> optional = this.blockchainQueries.blockByHash(hash).map((Function)new Function<BlockWithMetadata<TransactionWithMetadata, Hash>, BlockResult>(this){
                final /* synthetic */ InMemoryBesuChain this$0;

                public final BlockResult apply(BlockWithMetadata<TransactionWithMetadata, Hash> tx) {
                    return InMemoryBesuChain.access$getBlockResultFactory$p(this.this$0).transactionComplete(tx);
                }
                {
                    this.this$0 = inMemoryBesuChain;
                }
            });
            Intrinsics.checkNotNullExpressionValue(optional, (String)"blockchainQueries.blockB\u2026omplete(tx)\n            }");
            return optional;
        }
        Optional<BlockResult> optional = this.blockchainQueries.blockByHashWithTxHashes(hash).map((Function)new Function<BlockWithMetadata<Hash, Hash>, BlockResult>(this){
            final /* synthetic */ InMemoryBesuChain this$0;

            public final BlockResult apply(BlockWithMetadata<Hash, Hash> tx) {
                return InMemoryBesuChain.access$getBlockResultFactory$p(this.this$0).transactionHash(tx);
            }
            {
                this.this$0 = inMemoryBesuChain;
            }
        });
        Intrinsics.checkNotNullExpressionValue(optional, (String)"blockchainQueries.blockB\u2026sactionHash(tx)\n        }");
        return optional;
    }

    @NotNull
    public final Optional<BlockResult> ethBlockByNumber(long number, boolean completeTransaction) {
        if (completeTransaction) {
            Optional<BlockResult> optional = this.blockchainQueries.blockByNumber(number).map((Function)new Function<BlockWithMetadata<TransactionWithMetadata, Hash>, BlockResult>(this){
                final /* synthetic */ InMemoryBesuChain this$0;

                public final BlockResult apply(BlockWithMetadata<TransactionWithMetadata, Hash> tx) {
                    return InMemoryBesuChain.access$getBlockResultFactory$p(this.this$0).transactionComplete(tx);
                }
                {
                    this.this$0 = inMemoryBesuChain;
                }
            });
            Intrinsics.checkNotNullExpressionValue(optional, (String)"blockchainQueries.blockB\u2026omplete(tx)\n            }");
            return optional;
        }
        Optional<BlockResult> optional = this.blockchainQueries.blockByNumberWithTxHashes(number).map((Function)new Function<BlockWithMetadata<Hash, Hash>, BlockResult>(this){
            final /* synthetic */ InMemoryBesuChain this$0;

            public final BlockResult apply(BlockWithMetadata<Hash, Hash> tx) {
                return InMemoryBesuChain.access$getBlockResultFactory$p(this.this$0).transactionHash(tx);
            }
            {
                this.this$0 = inMemoryBesuChain;
            }
        });
        Intrinsics.checkNotNullExpressionValue(optional, (String)"blockchainQueries.blockB\u2026sactionHash(tx)\n        }");
        return optional;
    }

    private final void rewardMiner(MutableWorldState worldState, Address coinbaseAddress) {
        ProtocolSpec spec;
        ProtocolSpec protocolSpec = spec = this.protocolSchedule.getByBlockNumber(this.blockChain.getChainHeadBlockNumber());
        Intrinsics.checkNotNullExpressionValue((Object)protocolSpec, (String)"spec");
        Wei wei = protocolSpec.getBlockReward();
        Intrinsics.checkNotNullExpressionValue((Object)wei, (String)"spec.blockReward");
        Wei coinbaseReward = wei;
        WorldUpdater updater = worldState.updater();
        EvmAccount evmAccount = updater.getOrCreate(coinbaseAddress);
        Intrinsics.checkNotNullExpressionValue((Object)evmAccount, (String)"updater.getOrCreate(coinbaseAddress)");
        MutableAccount coinbase = evmAccount.getMutable();
        coinbase.incrementBalance(coinbaseReward);
        updater.commit();
    }

    public InMemoryBesuChain(@NotNull Configuration configuration, @NotNull OperationTracer operationTracer, @NotNull NetworkName networkName, @NotNull Map<String, String> genesisConfigOverrides) {
        GenesisConfigFile genesisConfigFile;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)operationTracer, (String)"operationTracer");
        Intrinsics.checkNotNullParameter((Object)networkName, (String)"networkName");
        Intrinsics.checkNotNullParameter(genesisConfigOverrides, (String)"genesisConfigOverrides");
        this.operationTracer = operationTracer;
        this.miningBeneficiary = Address.ZERO;
        this.blockResultFactory = new BlockResultFactory();
        if (configuration.getGenesisFileUrl() == null) {
            EthNetworkConfig networkConfig;
            EthNetworkConfig ethNetworkConfig = networkConfig = EthNetworkConfig.getNetworkConfig((NetworkName)networkName);
            Intrinsics.checkNotNullExpressionValue((Object)ethNetworkConfig, (String)"networkConfig");
            genesisConfigFile = GenesisConfigFile.fromConfig((String)ethNetworkConfig.getGenesisConfig());
        } else {
            genesisConfigFile = GenesisConfigFile.fromConfig((String)Resources.toString((URL)configuration.getGenesisFileUrl(), (Charset)StandardCharsets.UTF_8));
        }
        GenesisConfigFile genesisConfig = genesisConfigFile;
        GenesisConfigOptions configOptions = genesisConfig.getConfigOptions(genesisConfigOverrides);
        ProtocolSchedule protocolSchedule = MainnetProtocolSchedule.fromConfig((GenesisConfigOptions)configOptions, (PrivacyParameters)PrivacyParameters.DEFAULT, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)protocolSchedule, (String)"MainnetProtocolSchedule.\u2026           true\n        )");
        this.protocolSchedule = protocolSchedule;
        InMemoryKeyValueStorage keyValueStorage = new InMemoryKeyValueStorage();
        KeyValueStoragePrefixedKeyBlockchainStorage blockchainStorage = new KeyValueStoragePrefixedKeyBlockchainStorage((KeyValueStorage)keyValueStorage, (BlockHeaderFunctions)new MainnetBlockHeaderFunctions());
        WorldStateKeyValueStorage worldStateStorage = new WorldStateKeyValueStorage((KeyValueStorage)new InMemoryKeyValueStorage());
        WorldStatePreimageKeyValueStorage worldStatePreimageStorage = new WorldStatePreimageKeyValueStorage((KeyValueStorage)new InMemoryKeyValueStorage());
        this.worldStateArchive = (WorldStateArchive)new DefaultWorldStateArchive((WorldStateStorage)worldStateStorage, (WorldStatePreimageStorage)worldStatePreimageStorage);
        MutableWorldState mutableWorldState = ((DefaultWorldStateArchive)this.worldStateArchive).getMutable();
        Intrinsics.checkNotNullExpressionValue((Object)mutableWorldState, (String)"worldStateArchive.mutable");
        this.worldState = mutableWorldState;
        WorldUpdater worldUpdater = this.worldState.updater();
        Intrinsics.checkNotNullExpressionValue((Object)worldUpdater, (String)"worldState.updater()");
        this.worldStateUpdater = worldUpdater;
        GenesisState genesisState = GenesisState.fromConfig((GenesisConfigFile)genesisConfig, (ProtocolSchedule)this.protocolSchedule);
        Intrinsics.checkNotNullExpressionValue((Object)genesisState, (String)"GenesisState.fromConfig(\u2026Config, protocolSchedule)");
        this.genesisState = genesisState;
        this.genesisState.writeStateTo(this.worldState);
        StringBuilder stringBuilder = new StringBuilder().append("Genesis Block Hash: ");
        Block block = this.genesisState.getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"genesisState.block");
        LOG.debug(stringBuilder.append(block.getHash()).toString());
        MutableBlockchain mutableBlockchain = DefaultBlockchain.createMutable((Block)this.genesisState.getBlock(), (BlockchainStorage)((BlockchainStorage)blockchainStorage), (MetricsSystem)((MetricsSystem)new NoOpMetricsSystem()), (long)0L);
        Intrinsics.checkNotNullExpressionValue((Object)mutableBlockchain, (String)"DefaultBlockchain.create\u2026,\n            0\n        )");
        this.blockChain = mutableBlockchain;
        LOG.debug("Allocating test account " + configuration.getTestAddress());
        this.worldStateUpdater.createAccount(Address.fromHexString((String)configuration.getTestAddress()), 0L, Wei.fromEth((long)configuration.getEthFund()));
        this.worldStateUpdater.commit();
        this.blockchainQueries = new BlockchainQueries((Blockchain)this.blockChain, this.worldStateArchive);
        BigInteger bigInteger = this.protocolSchedule.getChainId().orElse(BigInteger.ONE);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"protocolSchedule.chainId.orElse(BigInteger.ONE)");
        this.chainId = bigInteger;
        this.simulator = new TransactionSimulator((Blockchain)this.blockChain, this.worldStateArchive, this.protocolSchedule, PrivacyParameters.DEFAULT);
    }

    public /* synthetic */ InMemoryBesuChain(Configuration configuration, OperationTracer operationTracer, NetworkName networkName, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            networkName = NetworkName.DEV;
        }
        if ((n & 8) != 0) {
            map = DEFAULT_GENESIS_OVERRIDES;
        }
        this(configuration, operationTracer, networkName, map);
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(InMemoryBesuChain.class);
        DEFAULT_GENESIS_OVERRIDES = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"londonblock", (Object)"1"), TuplesKt.to((Object)"petersburgblock", (Object)"0")});
    }

    public static final /* synthetic */ BlockResultFactory access$getBlockResultFactory$p(InMemoryBesuChain $this) {
        return $this.blockResultFactory;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/web3j/evm/InMemoryBesuChain$Companion;", "", "()V", "DEFAULT_GENESIS_OVERRIDES", "", "", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "web3j-evm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

