/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.evm;

import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.hyperledger.besu.ethereum.core.Gas;
import org.hyperledger.besu.ethereum.vm.MessageFrame;
import org.hyperledger.besu.ethereum.vm.OperationTracer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.web3j.evm.ConsoleDebugTracer;
import org.web3j.evm.ExceptionalHaltException;
import org.web3j.evm.PassthroughTracerContext;
import org.web3j.evm.entity.source.SourceFile;
import org.web3j.evm.entity.source.SourceLine;
import org.web3j.evm.entity.source.SourceMapElement;
import org.web3j.evm.utils.NullReader;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\b\u001a\u00020\tJ$\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/web3j/evm/PassthroughTracer;", "Lorg/web3j/evm/ConsoleDebugTracer;", "metaFile", "Ljava/io/File;", "(Ljava/io/File;)V", "passthroughTracerContext", "Lorg/web3j/evm/PassthroughTracerContext;", "lastContext", "resetContext", "", "traceExecution", "messageFrame", "Lorg/hyperledger/besu/ethereum/vm/MessageFrame;", "optional", "Ljava/util/Optional;", "Lorg/hyperledger/besu/ethereum/core/Gas;", "executeOperation", "Lorg/hyperledger/besu/ethereum/vm/OperationTracer$ExecuteOperation;", "web3j-evm"})
public final class PassthroughTracer
extends ConsoleDebugTracer {
    private PassthroughTracerContext passthroughTracerContext;

    @NotNull
    public final PassthroughTracerContext lastContext() {
        return this.passthroughTracerContext;
    }

    public final void resetContext() {
        this.passthroughTracerContext = new PassthroughTracerContext(null, null, null, null, 15, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void traceExecution(@NotNull MessageFrame messageFrame, @NotNull Optional<Gas> optional, @NotNull OperationTracer.ExecuteOperation executeOperation) throws ExceptionalHaltException {
        Intrinsics.checkNotNullParameter((Object)messageFrame, (String)"messageFrame");
        Intrinsics.checkNotNullParameter(optional, (String)"optional");
        Intrinsics.checkNotNullParameter((Object)executeOperation, (String)"executeOperation");
        if (this.getMetaFile() != null && this.getMetaFile().exists()) {
            PassthroughTracerContext passthroughTracerContext;
            String it;
            void sourceMapElement;
            SourceFile sourceFile;
            Object object = this.sourceAtMessageFrame(messageFrame);
            SourceMapElement sourceMapElement2 = (SourceMapElement)object.component1();
            SourceFile sourceFile2 = sourceFile = (SourceFile)object.component2();
            object = sourceFile2.component1();
            SortedMap<Integer, SourceLine> sourceSection = sourceFile2.component2();
            StringBuilder sb = new StringBuilder();
            if (sourceMapElement != null) {
                sb.append("At solidity source location " + sourceMapElement.getSourceFileByteOffset() + ':' + sourceMapElement.getLengthOfSourceRange() + ':' + sourceMapElement.getSourceIndex() + ':');
            } else {
                sb.append("At unknown solidity source location:");
            }
            sb.append('\n');
            sb.append('\n');
            Iterable $this$dropWhile$iv = this.mergeSourceContent(sourceSection);
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                it = (String)item$iv;
                boolean bl = false;
                if (StringsKt.isBlank((CharSequence)it)) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            $this$dropWhile$iv = CollectionsKt.reversed((Iterable)list$iv);
            $i$f$dropWhile = false;
            yielding$iv = false;
            list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                it = (String)item$iv;
                boolean bl = false;
                if (StringsKt.isBlank((CharSequence)it)) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            List trimmedSourceSection = CollectionsKt.reversed((Iterable)list$iv);
            PassthroughTracer passthroughTracer = this;
            if (trimmedSourceSection.isEmpty()) {
                passthroughTracerContext = new PassthroughTracerContext(null, null, null, null, 15, null);
            } else {
                void filePath;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map.Entry it2;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                String string = sb.append(CollectionsKt.joinToString$default((Iterable)trimmedSourceSection, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.append(trimmedSourceS\u2026oString(\"\\n\")).toString()");
                String source = string;
                Set<Map.Entry<Integer, SourceLine>> set = sourceSection.entrySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"sourceSection.entries");
                Iterable yielding$iv2 = set;
                PassthroughTracer passthroughTracer2 = passthroughTracer;
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it2 = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    if (!((SourceLine)it2.getValue()).getSelected()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection<Integer> collection = (List)destination$iv$iv;
                $this$filter$iv = collection;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it2 = (Map.Entry)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Integer n = (Integer)it2.getKey();
                    collection.add(n);
                }
                collection = (List)destination$iv$iv;
                passthroughTracer = passthroughTracer2;
                Integer firstSelectedLine = (Integer)CollectionsKt.min((Iterable)collection);
                SourceLine sourceLine = (SourceLine)sourceSection.get(firstSelectedLine);
                Integer firstSelectedOffset = sourceLine != null ? Integer.valueOf(sourceLine.getOffset()) : null;
                passthroughTracerContext = new PassthroughTracerContext(source, (String)filePath, firstSelectedLine, firstSelectedOffset);
            }
            passthroughTracer.passthroughTracerContext = passthroughTracerContext;
        }
        executeOperation.execute();
    }

    public PassthroughTracer(@Nullable File metaFile) {
        super(metaFile, new BufferedReader(new NullReader()));
        this.passthroughTracerContext = new PassthroughTracerContext(null, null, null, null, 15, null);
    }

    public /* synthetic */ PassthroughTracer(File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            file = new File("build/resources/main/solidity");
        }
        this(file);
    }

    public PassthroughTracer() {
        this(null, 1, null);
    }
}

