/*
 * Decompiled with CFR 0.152.
 */
package org.web3j;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestWatcher;
import org.junit.jupiter.api.io.TempDir;
import org.junit.platform.commons.util.AnnotationUtils;
import org.web3j.EVMTest;
import org.web3j.container.GenericService;
import org.web3j.container.ServiceBuilder;
import org.web3j.container.embedded.EmbeddedService;
import org.web3j.crypto.Credentials;
import org.web3j.evm.PassthroughTracer;
import org.web3j.evm.PassthroughTracerContext;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.tx.FastRawTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.DefaultGasProvider;
import org.web3j.tx.response.PollingTransactionReceiptProcessor;
import org.web3j.tx.response.TransactionReceiptProcessor;
import org.web3j.utils.Async;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u00100\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020-H\u0016J\u0018\u00106\u001a\u0002072\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020-H\u0016J#\u00108\u001a\b\u0012\u0004\u0012\u0002H:09\"\n\b\u0000\u0010:\u0018\u0001*\u00020;2\u0006\u0010,\u001a\u00020-H\u0086\bJ\u0012\u0010<\u001a\u00020/2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u001c\u0010=\u001a\u00020/2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010>\u001a\u0004\u0018\u00010?H\u0016J\"\u0010@\u001a\u00020/2\b\u0010,\u001a\u0004\u0018\u00010-2\u000e\u0010A\u001a\n\u0012\u0004\u0012\u00020B\u0018\u000109H\u0016J\u001c\u0010C\u001a\u00020/2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010>\u001a\u0004\u0018\u00010?H\u0016R\u001e\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006D"}, d2={"Lorg/web3j/EVMExtension;", "Lorg/junit/jupiter/api/extension/ExecutionCondition;", "Lorg/junit/jupiter/api/extension/BeforeAllCallback;", "Lorg/junit/jupiter/api/extension/AfterAllCallback;", "Lorg/junit/jupiter/api/extension/ParameterResolver;", "Lorg/junit/jupiter/api/extension/TestWatcher;", "<init>", "()V", "tempDir", "Ljava/nio/file/Path;", "getTempDir", "()Ljava/nio/file/Path;", "setTempDir", "(Ljava/nio/file/Path;)V", "credentials", "Lorg/web3j/crypto/Credentials;", "kotlin.jvm.PlatformType", "getCredentials", "()Lorg/web3j/crypto/Credentials;", "Lorg/web3j/crypto/Credentials;", "gasProvider", "Lorg/web3j/tx/gas/DefaultGasProvider;", "getGasProvider", "()Lorg/web3j/tx/gas/DefaultGasProvider;", "service", "Lorg/web3j/container/GenericService;", "getService", "()Lorg/web3j/container/GenericService;", "setService", "(Lorg/web3j/container/GenericService;)V", "web3j", "Lorg/web3j/protocol/Web3j;", "getWeb3j", "()Lorg/web3j/protocol/Web3j;", "setWeb3j", "(Lorg/web3j/protocol/Web3j;)V", "transactionManager", "Lorg/web3j/tx/TransactionManager;", "getTransactionManager", "()Lorg/web3j/tx/TransactionManager;", "setTransactionManager", "(Lorg/web3j/tx/TransactionManager;)V", "evaluateExecutionCondition", "Lorg/junit/jupiter/api/extension/ConditionEvaluationResult;", "context", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "beforeAll", "", "afterAll", "supportsParameter", "", "parameterContext", "Lorg/junit/jupiter/api/extension/ParameterContext;", "extensionContext", "resolveParameter", "", "findEvmTests", "Ljava/util/Optional;", "T", "", "testSuccessful", "testFailed", "cause", "", "testDisabled", "reason", "", "testAborted", "web3j-unit"})
@SourceDebugExtension(value={"SMAP\nEVMExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EVMExtension.kt\norg/web3j/EVMExtension\n*L\n1#1,168:1\n117#1,10:169\n*S KotlinDebug\n*F\n+ 1 EVMExtension.kt\norg/web3j/EVMExtension\n*L\n57#1:169,10\n*E\n"})
public class EVMExtension
implements ExecutionCondition,
BeforeAllCallback,
AfterAllCallback,
ParameterResolver,
TestWatcher {
    @TempDir
    public Path tempDir;
    private final Credentials credentials = Credentials.create((String)"0x8f2a55949038a9610f50fb23b5883af3b4ecb3c3bb792cbcefbd1542c692be63");
    @NotNull
    private final DefaultGasProvider gasProvider = new DefaultGasProvider();
    public GenericService service;
    public Web3j web3j;
    public TransactionManager transactionManager;

    @NotNull
    public final Path getTempDir() {
        Path path = this.tempDir;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tempDir");
        return null;
    }

    public final void setTempDir(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.tempDir = path;
    }

    public final Credentials getCredentials() {
        return this.credentials;
    }

    @NotNull
    public final DefaultGasProvider getGasProvider() {
        return this.gasProvider;
    }

    @NotNull
    public final GenericService getService() {
        GenericService genericService = this.service;
        if (genericService != null) {
            return genericService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"service");
        return null;
    }

    public final void setService(@NotNull GenericService genericService) {
        Intrinsics.checkNotNullParameter((Object)genericService, (String)"<set-?>");
        this.service = genericService;
    }

    @NotNull
    public final Web3j getWeb3j() {
        Web3j web3j = this.web3j;
        if (web3j != null) {
            return web3j;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"web3j");
        return null;
    }

    public final void setWeb3j(@NotNull Web3j web3j) {
        Intrinsics.checkNotNullParameter((Object)web3j, (String)"<set-?>");
        this.web3j = web3j;
    }

    @NotNull
    public final TransactionManager getTransactionManager() {
        TransactionManager transactionManager = this.transactionManager;
        if (transactionManager != null) {
            return transactionManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"transactionManager");
        return null;
    }

    public final void setTransactionManager(@NotNull TransactionManager transactionManager) {
        Intrinsics.checkNotNullParameter((Object)transactionManager, (String)"<set-?>");
        this.transactionManager = transactionManager;
    }

    @NotNull
    public ConditionEvaluationResult evaluateExecutionCondition(@NotNull ExtensionContext context) {
        Optional optional;
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            EVMExtension this_$iv = this;
            boolean $i$f$findEvmTests = false;
            Optional optional2 = Optional.of(context);
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(...)");
            Optional current$iv = optional2;
            while (current$iv.isPresent()) {
                Optional evmTest$iv = AnnotationUtils.findAnnotation((AnnotatedElement)current$iv.get().getRequiredTestClass(), EVMTest.class);
                if (evmTest$iv.isPresent()) {
                    Intrinsics.checkNotNull((Object)evmTest$iv);
                    optional = evmTest$iv;
                    break block2;
                }
                current$iv = current$iv.get().getParent();
            }
            Optional optional3 = Optional.empty();
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"empty(...)");
        }
        ConditionEvaluationResult conditionEvaluationResult = optional.map(arg_0 -> EVMExtension.evaluateExecutionCondition$lambda$1(EVMExtension::evaluateExecutionCondition$lambda$0, arg_0)).orElseThrow(EVMExtension::evaluateExecutionCondition$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)conditionEvaluationResult, (String)"orElseThrow(...)");
        return conditionEvaluationResult;
    }

    public void beforeAll(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        EVMTest evmTest = (EVMTest)AnnotationUtils.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), EVMTest.class).orElseThrow(EVMExtension::beforeAll$lambda$3);
        ServiceBuilder serviceBuilder = new ServiceBuilder().type(evmTest.type()).version(evmTest.version()).withGenesis(evmTest.genesis());
        String string = this.credentials.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAddress(...)");
        this.setService(serviceBuilder.withSelfAddress(string).withServicePort(evmTest.servicePort()).build());
        this.setWeb3j(Web3j.build((Web3jService)this.getService().startService(), (long)500L, (ScheduledExecutorService)Async.defaultExecutorService()));
        this.setTransactionManager((TransactionManager)new FastRawTransactionManager(this.getWeb3j(), this.credentials, (TransactionReceiptProcessor)new PollingTransactionReceiptProcessor(this.getWeb3j(), 1000L, 30)));
    }

    public void afterAll(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.getService().close();
        this.getWeb3j().shutdown();
    }

    public boolean supportsParameter(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkNotNullParameter((Object)parameterContext, (String)"parameterContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        Class<?> $this$supportsParameter_u24lambda_u244 = parameterContext.getParameter().getType();
        boolean bl = false;
        return Intrinsics.areEqual($this$supportsParameter_u24lambda_u244, Web3j.class) || Intrinsics.areEqual($this$supportsParameter_u24lambda_u244, TransactionManager.class) || Intrinsics.areEqual($this$supportsParameter_u24lambda_u244, ContractGasProvider.class) || Intrinsics.areEqual($this$supportsParameter_u24lambda_u244, GenericService.class);
    }

    @NotNull
    public Object resolveParameter(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkNotNullParameter((Object)parameterContext, (String)"parameterContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        Class<?> clazz = parameterContext.getParameter().getType();
        return Intrinsics.areEqual(clazz, Web3j.class) ? this.getWeb3j() : (Intrinsics.areEqual(clazz, TransactionManager.class) ? this.getTransactionManager() : (Intrinsics.areEqual(clazz, ContractGasProvider.class) ? this.gasProvider : new Object()));
    }

    public final /* synthetic */ <T extends Annotation> Optional<T> findEvmTests(ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean $i$f$findEvmTests = false;
        Optional optional = Optional.of(context);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        Optional current = optional;
        while (current.isPresent()) {
            AnnotatedElement annotatedElement = current.get().getRequiredTestClass();
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            Optional evmTest = AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, Annotation.class);
            if (evmTest.isPresent()) {
                Intrinsics.checkNotNull((Object)evmTest);
                return evmTest;
            }
            current = current.get().getParent();
        }
        Optional optional2 = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
        return optional2;
    }

    public void testSuccessful(@Nullable ExtensionContext context) {
        GenericService service = this.getService();
        if (service instanceof EmbeddedService && ((EmbeddedService)service).getOperationTracer() instanceof PassthroughTracer) {
            ((PassthroughTracer)((EmbeddedService)service).getOperationTracer()).resetContext();
        }
    }

    public void testFailed(@Nullable ExtensionContext context, @Nullable Throwable cause) {
        GenericService service = this.getService();
        if (service instanceof EmbeddedService && ((EmbeddedService)service).getOperationTracer() instanceof PassthroughTracer) {
            PassthroughTracerContext tracerContext = ((PassthroughTracer)((EmbeddedService)service).getOperationTracer()).lastContext();
            if (!StringsKt.isBlank((CharSequence)tracerContext.getSource())) {
                if (tracerContext.getFilePath() != null && tracerContext.getFirstSelectedLine() != null && tracerContext.getFirstSelectedOffset() != null) {
                    System.out.println((Object)("In file " + tracerContext.getFilePath() + ": (" + tracerContext.getFirstSelectedLine() + ", " + tracerContext.getFirstSelectedOffset() + ")"));
                } else {
                    System.out.println((Object)"In unknown file");
                }
                System.out.println((Object)tracerContext.getSource());
            }
            ((PassthroughTracer)((EmbeddedService)service).getOperationTracer()).resetContext();
        }
    }

    public void testDisabled(@Nullable ExtensionContext context, @Nullable Optional<String> reason) {
        GenericService service = this.getService();
        if (service instanceof EmbeddedService && ((EmbeddedService)service).getOperationTracer() instanceof PassthroughTracer) {
            ((PassthroughTracer)((EmbeddedService)service).getOperationTracer()).resetContext();
        }
    }

    public void testAborted(@Nullable ExtensionContext context, @Nullable Throwable cause) {
        GenericService service = this.getService();
        if (service instanceof EmbeddedService && ((EmbeddedService)service).getOperationTracer() instanceof PassthroughTracer) {
            ((PassthroughTracer)((EmbeddedService)service).getOperationTracer()).resetContext();
        }
    }

    private static final ConditionEvaluationResult evaluateExecutionCondition$lambda$0(EVMTest it) {
        return ConditionEvaluationResult.enabled((String)"EVMTest enabled");
    }

    private static final ConditionEvaluationResult evaluateExecutionCondition$lambda$1(Function1 $tmp0, Object p0) {
        return (ConditionEvaluationResult)$tmp0.invoke(p0);
    }

    private static final ExtensionConfigurationException evaluateExecutionCondition$lambda$2() {
        return new ExtensionConfigurationException("@EVMTest not found");
    }

    private static final RuntimeException beforeAll$lambda$3() {
        return new RuntimeException("Unable to find EVMTest annotation");
    }
}

