/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import org.webbitserver.HttpControl;
import org.webbitserver.HttpHandler;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;

public class DelayedHttpHandler
implements HttpHandler {
    private final Executor executor;
    private Timer timer;
    private final long delayInMillis;
    private final HttpHandler handler;

    public DelayedHttpHandler(Executor executor, long delayInMillis, HttpHandler handler) {
        this.delayInMillis = delayInMillis;
        this.handler = handler;
        this.timer = new Timer();
        this.executor = executor;
    }

    @Override
    public void handleHttpRequest(final HttpRequest request, final HttpResponse response, final HttpControl control) throws Exception {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                DelayedHttpHandler.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DelayedHttpHandler.this.handler.handleHttpRequest(request, response, control);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }, this.delayInMillis);
    }
}

