/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.webbitserver.HttpHandler;
import org.webbitserver.WebbitException;
import org.webbitserver.netty.ConnectionHelper;
import org.webbitserver.netty.NettyHttpControl;
import org.webbitserver.netty.NettyHttpRequest;
import org.webbitserver.netty.NettyHttpResponse;

public class NettyHttpChannelHandler
extends SimpleChannelUpstreamHandler {
    private static final Object IGNORE_REQUEST = new Object();
    private final Executor executor;
    private final List<HttpHandler> httpHandlers;
    private final Object id;
    private final long timestamp;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private final Thread.UncaughtExceptionHandler ioExceptionHandler;
    private final ConnectionHelper connectionHelper;

    public NettyHttpChannelHandler(Executor executor, List<HttpHandler> httpHandlers, Object id, long timestamp, Thread.UncaughtExceptionHandler exceptionHandler, Thread.UncaughtExceptionHandler ioExceptionHandler) {
        this.executor = executor;
        this.httpHandlers = httpHandlers;
        this.id = id;
        this.timestamp = timestamp;
        this.exceptionHandler = exceptionHandler;
        this.ioExceptionHandler = ioExceptionHandler;
        this.connectionHelper = new ConnectionHelper(executor, exceptionHandler, ioExceptionHandler){

            @Override
            protected void fireOnClose() throws Exception {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        if (messageEvent.getMessage() instanceof HttpRequest && ctx.getAttachment() != IGNORE_REQUEST) {
            this.handleHttpRequest(ctx, messageEvent, (HttpRequest)messageEvent.getMessage());
        } else {
            super.messageReceived(ctx, messageEvent);
        }
    }

    private void handleHttpRequest(final ChannelHandlerContext ctx, MessageEvent messageEvent, HttpRequest httpRequest) {
        final NettyHttpRequest nettyHttpRequest = new NettyHttpRequest(messageEvent, httpRequest, this.id, this.timestamp);
        DefaultHttpResponse ok_200 = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        final NettyHttpResponse nettyHttpResponse = new NettyHttpResponse(ctx, (HttpResponse)ok_200, HttpHeaders.isKeepAlive((HttpMessage)httpRequest), this.exceptionHandler);
        Iterator<HttpHandler> httpHandlers = this.httpHandlers.iterator();
        final NettyHttpControl control = new NettyHttpControl(httpHandlers, this.executor, ctx, nettyHttpRequest, nettyHttpResponse, httpRequest, (HttpResponse)ok_200, this.exceptionHandler, this.ioExceptionHandler);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    control.nextHandler(nettyHttpRequest, nettyHttpResponse);
                }
                catch (Exception exception) {
                    NettyHttpChannelHandler.this.exceptionHandler.uncaughtException(Thread.currentThread(), WebbitException.fromException(exception, ctx.getChannel()));
                }
            }
        });
    }

    public void exceptionCaught(final ChannelHandlerContext ctx, final ExceptionEvent e) {
        this.connectionHelper.fireConnectionException(e);
        final NettyHttpResponse nettyHttpResponse = new NettyHttpResponse(ctx, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR), true, this.exceptionHandler);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ctx.setAttachment(IGNORE_REQUEST);
                    nettyHttpResponse.error(e.getCause());
                }
                catch (Exception exception) {
                    NettyHttpChannelHandler.this.exceptionHandler.uncaughtException(Thread.currentThread(), WebbitException.fromException(exception, ctx.getChannel()));
                }
            }
        });
    }
}

