/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.wrapper;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.webbitserver.EventSourceConnection;
import org.webbitserver.EventSourceMessage;
import org.webbitserver.HttpRequest;

public class EventSourceConnectionWrapper
implements EventSourceConnection {
    private EventSourceConnection connection;

    public EventSourceConnectionWrapper(EventSourceConnection connection) {
        this.connection = connection;
    }

    public EventSourceConnection underlyingControl() {
        return this.connection;
    }

    public EventSourceConnectionWrapper underlyingControl(EventSourceConnection control) {
        this.connection = control;
        return this;
    }

    public EventSourceConnection originalControl() {
        if (this.connection instanceof EventSourceConnectionWrapper) {
            EventSourceConnectionWrapper wrapper = (EventSourceConnectionWrapper)this.connection;
            return wrapper.originalControl();
        }
        return this.connection;
    }

    @Override
    public HttpRequest httpRequest() {
        return this.connection.httpRequest();
    }

    @Override
    public EventSourceConnectionWrapper send(EventSourceMessage message) {
        this.connection.send(message);
        return this;
    }

    @Override
    public EventSourceConnectionWrapper close() {
        this.connection.close();
        return this;
    }

    @Override
    public Map<String, Object> data() {
        return this.connection.data();
    }

    @Override
    public Object data(String key) {
        return this.connection.data(key);
    }

    @Override
    public EventSourceConnectionWrapper data(String key, Object value) {
        this.connection.data(key, value);
        return this;
    }

    @Override
    public Set<String> dataKeys() {
        return this.connection.dataKeys();
    }

    @Override
    public Executor handlerExecutor() {
        return this.connection.handlerExecutor();
    }

    @Override
    public void execute(Runnable command) {
        this.connection.execute(command);
    }
}

