(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@popperjs/core'), require('video.js'), require('animejs/lib/anime.es.js'), require('@splidejs/splide'), require('masonry-layout'), require('accessible-autocomplete')) :
    typeof define === 'function' && define.amd ? define(['@popperjs/core', 'video.js', 'animejs/lib/anime.es.js', '@splidejs/splide', 'masonry-layout', 'accessible-autocomplete'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.bootstrap = factory(global.Popper, global.videojs, global.anime, global.Splide, global.MasonryPlugin, global.accessibleAutocomplete));
})(this, (function (Popper, videojs, anime, Splide, MasonryPlugin, accessibleAutocomplete) { 'use strict';

    const _interopDefaultLegacy = e => e && typeof e === 'object' && 'default' in e ? e : { default: e };

    function _interopNamespace(e) {
        if (e && e.__esModule) return e;
        const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
        if (e) {
            for (const k in e) {
                if (k !== 'default') {
                    const d = Object.getOwnPropertyDescriptor(e, k);
                    Object.defineProperty(n, k, d.get ? d : {
                        enumerable: true,
                        get: () => e[k]
                    });
                }
            }
        }
        n.default = e;
        return Object.freeze(n);
    }

    const Popper__namespace = /*#__PURE__*/_interopNamespace(Popper);
    const videojs__default = /*#__PURE__*/_interopDefaultLegacy(videojs);
    const anime__default = /*#__PURE__*/_interopDefaultLegacy(anime);
    const Splide__default = /*#__PURE__*/_interopDefaultLegacy(Splide);
    const MasonryPlugin__default = /*#__PURE__*/_interopDefaultLegacy(MasonryPlugin);
    const accessibleAutocomplete__default = /*#__PURE__*/_interopDefaultLegacy(accessibleAutocomplete);

    (function() {
        const env = {"NODE_ENV":"production"};
        try {
            if (process) {
                process.env = Object.assign({}, process.env);
                Object.assign(process.env, env);
                return;
            }
        } catch (e) {} // avoid ReferenceError: process is not defined
        globalThis.process = { env:env };
    })();

    const loadPlugin=o=>{};

    const DATA_MOUSE_FOCUS="data-focus-mouse";class TrackFocus{constructor(){this._usingMouse=!1,this._bindEvents();}_bindEvents(){if("undefined"==typeof document)return;["keydown","mousedown"].forEach((t=>{document.addEventListener(t,(t=>{this._usingMouse="mousedown"===t.type;}));})),document.addEventListener("focusin",(t=>{this._usingMouse&&t.target&&(t.target.classList.add("focus--mouse"),t.target.setAttribute(DATA_MOUSE_FOCUS,!0));})),document.addEventListener("focusout",(t=>{t.target&&(t.target.classList.remove("focus--mouse"),t.target.setAttribute(DATA_MOUSE_FOCUS,!1));}));}}new TrackFocus;const TrackFocus$1 = TrackFocus;

    const BOOTSTRAP_ITALIA_VERSION = "2.8.7";

    const init=()=>{"undefined"==typeof window||window.BOOTSTRAP_ITALIA_VERSION||(new TrackFocus$1,window.BOOTSTRAP_ITALIA_VERSION=BOOTSTRAP_ITALIA_VERSION);};const init$1 = init;init();

    const loadFonts = (t="/node_modules/bootstrap-italia/dist/fonts")=>{if("undefined"==typeof document)return;const i=document.createElement("style"),o=window.__PUBLIC_PATH__?window.__PUBLIC_PATH__:t;i.innerHTML=`\n  /* Titillium+Web:300,400,600,700 */\n\n  /* titillium-web-300 - latin-ext_latin */\n  @font-face {\n    font-family: 'Titillium Web';\n    font-style: normal;\n    font-weight: 300;\n    font-display: swap;\n    src: url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-300.eot'); /* IE9 Compat Modes */\n    src: local(''),\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-300.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-300.woff2') format('woff2'), /* Super Modern Browsers */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-300.woff') format('woff'), /* Modern Browsers */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-300.ttf') format('truetype'), /* Safari, Android, iOS */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-300.svg#TitilliumWeb') format('svg'); /* Legacy iOS */\n  }\n\n  /* titillium-web-300italic - latin-ext_latin */\n  @font-face {\n    font-family: 'Titillium Web';\n    font-style: italic;\n    font-weight: 300;\n    font-display: swap;\n    src: url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-300italic.eot'); /* IE9 Compat Modes */\n    src: local(''),\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-300italic.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-300italic.woff2') format('woff2'), /* Super Modern Browsers */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-300italic.woff') format('woff'), /* Modern Browsers */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-300italic.ttf') format('truetype'), /* Safari, Android, iOS */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-300italic.svg#TitilliumWeb') format('svg'); /* Legacy iOS */\n  }\n\n  /* titillium-web-regular - latin-ext_latin */\n  @font-face {\n    font-family: 'Titillium Web';\n    font-style: normal;\n    font-weight: 400;\n    font-display: swap;\n    src: url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-regular.eot'); /* IE9 Compat Modes */\n    src: local(''),\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-regular.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-regular.woff2') format('woff2'), /* Super Modern Browsers */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-regular.woff') format('woff'), /* Modern Browsers */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-regular.ttf') format('truetype'), /* Safari, Android, iOS */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-regular.svg#TitilliumWeb') format('svg'); /* Legacy iOS */\n  }\n\n  /* titillium-web-italic - latin-ext_latin */\n  @font-face {\n    font-family: 'Titillium Web';\n    font-style: italic;\n    font-weight: 400;\n    font-display: swap;\n    src: url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-italic.eot'); /* IE9 Compat Modes */\n    src: local(''),\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-italic.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-italic.woff2') format('woff2'), /* Super Modern Browsers */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-italic.woff') format('woff'), /* Modern Browsers */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-italic.ttf') format('truetype'), /* Safari, Android, iOS */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-italic.svg#TitilliumWeb') format('svg'); /* Legacy iOS */\n  }\n\n  /* titillium-web-700 - latin-ext_latin */\n  @font-face {\n    font-family: 'Titillium Web';\n    font-style: normal;\n    font-weight: 700;\n    font-display: swap;\n    src: url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-700.eot'); /* IE9 Compat Modes */\n    src: local(''),\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-700.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-700.woff2') format('woff2'), /* Super Modern Browsers */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-700.woff') format('woff'), /* Modern Browsers */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-700.ttf') format('truetype'), /* Safari, Android, iOS */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-700.svg#TitilliumWeb') format('svg'); /* Legacy iOS */\n  }\n\n  /* titillium-web-700italic - latin-ext_latin */\n  @font-face {\n    font-family: 'Titillium Web';\n    font-style: italic;\n    font-weight: 700;\n    font-display: swap;\n    src: url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-700italic.eot'); /* IE9 Compat Modes */\n    src: local(''),\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-700italic.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-700italic.woff2') format('woff2'), /* Super Modern Browsers */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-700italic.woff') format('woff'), /* Modern Browsers */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-700italic.ttf') format('truetype'), /* Safari, Android, iOS */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-700italic.svg#TitilliumWeb') format('svg'); /* Legacy iOS */\n  }\n  /* titillium-web-600 - latin-ext_latin */\n  @font-face {\n    font-family: 'Titillium Web';\n    font-style: normal;\n    font-weight: 600;\n    font-display: swap;\n    src: url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-600.eot'); /* IE9 Compat Modes */\n    src: local(''),\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-600.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-600.woff2') format('woff2'), /* Super Modern Browsers */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-600.woff') format('woff'), /* Modern Browsers */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-600.ttf') format('truetype'), /* Safari, Android, iOS */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-600.svg#TitilliumWeb') format('svg'); /* Legacy iOS */\n  }\n\n  /* titillium-web-600italic - latin-ext_latin */\n  @font-face {\n    font-family: 'Titillium Web';\n    font-style: italic;\n    font-weight: 600;\n    font-display: swap;\n    src: url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-600italic.eot'); /* IE9 Compat Modes */\n    src: local(''),\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-600italic.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-600italic.woff2') format('woff2'), /* Super Modern Browsers */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-600italic.woff') format('woff'), /* Modern Browsers */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-600italic.ttf') format('truetype'), /* Safari, Android, iOS */\n        url('${o}/Titillium_Web/titillium-web-v10-latin-ext_latin-600italic.svg#TitilliumWeb') format('svg'); /* Legacy iOS */\n  }\n\n  /* Lora:400,700 */\n\n  /* lora-regular - latin-ext_latin */\n  @font-face {\n    font-family: 'Lora';\n    font-style: normal;\n    font-weight: 400;\n    font-display: swap;\n    src: url('${o}/Lora/lora-v20-latin-ext_latin-regular.eot'); /* IE9 Compat Modes */\n    src: local(''),\n        url('${o}/Lora/lora-v20-latin-ext_latin-regular.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n        url('${o}/Lora/lora-v20-latin-ext_latin-regular.woff2') format('woff2'), /* Super Modern Browsers */\n        url('${o}/Lora/lora-v20-latin-ext_latin-regular.woff') format('woff'), /* Modern Browsers */\n        url('${o}/Lora/lora-v20-latin-ext_latin-regular.ttf') format('truetype'), /* Safari, Android, iOS */\n        url('${o}/Lora/lora-v20-latin-ext_latin-regular.svg#Lora') format('svg'); /* Legacy iOS */\n  }\n\n  /* lora-700 - latin-ext_latin */\n  @font-face {\n    font-family: 'Lora';\n    font-style: normal;\n    font-weight: 700;\n    font-display: swap;\n    src: url('${o}/Lora/lora-v20-latin-ext_latin-700.eot'); /* IE9 Compat Modes */\n    src: local(''),\n        url('${o}/Lora/lora-v20-latin-ext_latin-700.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n        url('${o}/Lora/lora-v20-latin-ext_latin-700.woff2') format('woff2'), /* Super Modern Browsers */\n        url('${o}/Lora/lora-v20-latin-ext_latin-700.woff') format('woff'), /* Modern Browsers */\n        url('${o}/Lora/lora-v20-latin-ext_latin-700.ttf') format('truetype'), /* Safari, Android, iOS */\n        url('${o}/Lora/lora-v20-latin-ext_latin-700.svg#Lora') format('svg'); /* Legacy iOS */\n  }\n\n  /* lora-italic - latin-ext_latin */\n  @font-face {\n    font-family: 'Lora';\n    font-style: italic;\n    font-weight: 400;\n    font-display: swap;\n    src: url('${o}/Lora/lora-v20-latin-ext_latin-italic.eot'); /* IE9 Compat Modes */\n    src: local(''),\n        url('${o}/Lora/lora-v20-latin-ext_latin-italic.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n        url('${o}/Lora/lora-v20-latin-ext_latin-italic.woff2') format('woff2'), /* Super Modern Browsers */\n        url('${o}/Lora/lora-v20-latin-ext_latin-italic.woff') format('woff'), /* Modern Browsers */\n        url('${o}/Lora/lora-v20-latin-ext_latin-italic.ttf') format('truetype'), /* Safari, Android, iOS */\n        url('${o}/Lora/lora-v20-latin-ext_latin-italic.svg#Lora') format('svg'); /* Legacy iOS */\n  }\n\n  /* lora-700italic - latin-ext_latin */\n  @font-face {\n    font-family: 'Lora';\n    font-style: italic;\n    font-weight: 700;\n    font-display: swap;\n    src: url('${o}/Lora/lora-v20-latin-ext_latin-700italic.eot'); /* IE9 Compat Modes */\n    src: local(''),\n        url('${o}/Lora/lora-v20-latin-ext_latin-700italic.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n        url('${o}/Lora/lora-v20-latin-ext_latin-700italic.woff2') format('woff2'), /* Super Modern Browsers */\n        url('${o}/Lora/lora-v20-latin-ext_latin-700italic.woff') format('woff'), /* Modern Browsers */\n        url('${o}/Lora/lora-v20-latin-ext_latin-700italic.ttf') format('truetype'), /* Safari, Android, iOS */\n        url('${o}/Lora/lora-v20-latin-ext_latin-700italic.svg#Lora') format('svg'); /* Legacy iOS */\n  }\n\n  /* Roboto+Mono:400,700 */\n\n  /* roboto-mono-regular - latin-ext_latin */\n  @font-face {\n    font-family: 'Roboto Mono';\n    font-style: normal;\n    font-weight: 400;\n    font-display: swap;\n    src: url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-regular.eot'); /* IE9 Compat Modes */\n    src: local(''),\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-regular.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-regular.woff2') format('woff2'), /* Super Modern Browsers */\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-regular.woff') format('woff'), /* Modern Browsers */\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-regular.ttf') format('truetype'), /* Safari, Android, iOS */\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-regular.svg#RobotoMono') format('svg'); /* Legacy iOS */\n  }\n\n  /* roboto-mono-700 - latin-ext_latin */\n  @font-face {\n    font-family: 'Roboto Mono';\n    font-style: normal;\n    font-weight: 700;\n    font-display: swap;\n    src: url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700.eot'); /* IE9 Compat Modes */\n    src: local(''),\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700.woff2') format('woff2'), /* Super Modern Browsers */\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700.woff') format('woff'), /* Modern Browsers */\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700.ttf') format('truetype'), /* Safari, Android, iOS */\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700.svg#RobotoMono') format('svg'); /* Legacy iOS */\n  }\n\n  /* roboto-mono-italic - latin-ext_latin */\n  @font-face {\n    font-family: 'Roboto Mono';\n    font-style: italic;\n    font-weight: 400;\n    font-display: swap;\n    src: url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-italic.eot'); /* IE9 Compat Modes */\n    src: local(''),\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-italic.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-italic.woff2') format('woff2'), /* Super Modern Browsers */\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-italic.woff') format('woff'), /* Modern Browsers */\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-italic.ttf') format('truetype'), /* Safari, Android, iOS */\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-italic.svg#RobotoMono') format('svg'); /* Legacy iOS */\n  }\n\n  /* roboto-mono-700italic - latin-ext_latin */\n  @font-face {\n    font-family: 'Roboto Mono';\n    font-style: italic;\n    font-weight: 700;\n    font-display: swap;\n    src: url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700italic.eot'); /* IE9 Compat Modes */\n    src: local(''),\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700italic.eot?#iefix') format('embedded-opentype'), /* IE6-IE8 */\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700italic.woff2') format('woff2'), /* Super Modern Browsers */\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700italic.woff') format('woff'), /* Modern Browsers */\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700italic.ttf') format('truetype'), /* Safari, Android, iOS */\n        url('${o}/Roboto_Mono/roboto-mono-v13-latin-ext_latin-700italic.svg#RobotoMono') format('svg'); /* Legacy iOS */\n  }\n  `,document.getElementsByTagName("head")[0].appendChild(i);};

    const preferencesMap={ck3:{}},rememberChoice=(e,r)=>{preferencesMap.ck3[e]=r,localStorage.setItem("bs-ck3",JSON.stringify(preferencesMap.ck3));},isChoiceRemembered=e=>(preferencesMap.ck3=JSON.parse(localStorage.getItem("bs-ck3")||"{}"),preferencesMap.ck3[e]||!1),clearAllRememberedChoices=()=>{localStorage.removeItem("bs-ck3");},cookies={rememberChoice:rememberChoice,isChoiceRemembered:isChoiceRemembered,clearAllRememberedChoices:clearAllRememberedChoices};

    const icons = /*#__PURE__*/Object.freeze(/*#__PURE__*/Object.defineProperty({
        __proto__: null
    }, Symbol.toStringTag, { value: 'Module' }));

    const elementMap=new Map;const Data = {set(e,t,n){elementMap.has(e)||elementMap.set(e,new Map);const a=elementMap.get(e);a.has(t)||0===a.size?a.set(t,n):console.error(`Bootstrap doesn't allow more than one instance per element. Bound instance: ${Array.from(a.keys())[0]}.`);},get:(e,t)=>elementMap.has(e)&&elementMap.get(e).get(t)||null,remove(e,t){if(!elementMap.has(e))return;const n=elementMap.get(e);n.delete(t),0===n.size&&elementMap.delete(e);}};

    const TRANSITION_END="transitionend",toType=e=>null==e?`${e}`:Object.prototype.toString.call(e).match(/\s([a-z]+)/i)[1].toLowerCase(),getUID=e=>{do{e+=Math.floor(1e6*Math.random());}while(document.getElementById(e));return e},getSelector=e=>{let t=e.getAttribute("data-bs-target");if(!t||"#"===t){let n=e.getAttribute("href");if(!n||!n.includes("#")&&!n.startsWith("."))return null;n.includes("#")&&!n.startsWith("#")&&(n=`#${n.split("#")[1]}`),t=n&&"#"!==n?n.trim():null;}return t},getSelectorFromElement=e=>{const t=getSelector(e);return t&&document.querySelector(t)?t:null},getElementFromSelector=e=>{const t=getSelector(e);return t?document.querySelector(t):null},getTransitionDurationFromElement=e=>{if(!e)return 0;let{transitionDuration:t,transitionDelay:n}=window.getComputedStyle(e);const o=Number.parseFloat(t),r=Number.parseFloat(n);return o||r?(t=t.split(",")[0],n=n.split(",")[0],1e3*(Number.parseFloat(t)+Number.parseFloat(n))):0},triggerTransitionEnd=e=>{e.dispatchEvent(new Event(TRANSITION_END));},isElement$1=e=>!(!e||"object"!=typeof e)&&(void 0!==e.jquery&&(e=e[0]),void 0!==e.nodeType),getElement=e=>isElement$1(e)?e.jquery?e[0]:e:"string"==typeof e&&e.length>0?document.querySelector(e):null,isVisible=e=>{if(!isElement$1(e)||0===e.getClientRects().length)return !1;const t="visible"===getComputedStyle(e).getPropertyValue("visibility"),n=e.closest("details:not([open])");if(!n)return t;if(n!==e){const t=e.closest("summary");if(t&&t.parentNode!==n)return !1;if(null===t)return !1}return t},isDisabled=e=>!e||e.nodeType!==Node.ELEMENT_NODE||(!!e.classList.contains("disabled")||(void 0!==e.disabled?e.disabled:e.hasAttribute("disabled")&&"false"!==e.getAttribute("disabled"))),findShadowRoot=e=>{if(!document.documentElement.attachShadow)return null;if("function"==typeof e.getRootNode){const t=e.getRootNode();return t instanceof ShadowRoot?t:null}return e instanceof ShadowRoot?e:e.parentNode?findShadowRoot(e.parentNode):null},noop=()=>{},reflow=e=>{e.offsetHeight;},getjQuery=()=>window.jQuery&&!document.body.hasAttribute("data-bs-no-jquery")?window.jQuery:null,DOMContentLoadedCallbacks=[],onDOMContentLoaded=e=>{"loading"===document.readyState?(DOMContentLoadedCallbacks.length||document.addEventListener("DOMContentLoaded",(()=>{for(const e of DOMContentLoadedCallbacks)e();})),DOMContentLoadedCallbacks.push(e)):e();},isRTL=()=>"rtl"===document.documentElement.dir,defineJQueryPlugin=e=>{onDOMContentLoaded((()=>{const t=getjQuery();if(t){const n=e.NAME,o=t.fn[n];t.fn[n]=e.jQueryInterface,t.fn[n].Constructor=e,t.fn[n].noConflict=()=>(t.fn[n]=o,e.jQueryInterface);}}));},execute=e=>{"function"==typeof e&&e();},executeAfterTransition=(e,t,n=!0)=>{if(!n)return void execute(e);const o=getTransitionDurationFromElement(t)+5;let r=!1;const i=({target:n})=>{n===t&&(r=!0,t.removeEventListener(TRANSITION_END,i),execute(e));};t.addEventListener(TRANSITION_END,i),setTimeout((()=>{r||triggerTransitionEnd(t);}),o);},getNextActiveElement=(e,t,n,o)=>{const r=e.length;let i=e.indexOf(t);return -1===i?!n&&o?e[r-1]:e[0]:(i+=n?1:-1,o&&(i=(i+r)%r),e[Math.max(0,Math.min(i,r-1))])};

    const namespaceRegex=/[^.]*(?=\..*)\.|.*/,stripNameRegex=/\..*/,stripUidRegex=/::\d+$/,eventRegistry={};let uidEvent=1;const customEvents={mouseenter:"mouseover",mouseleave:"mouseout"},nativeEvents=new Set(["click","dblclick","mouseup","mousedown","contextmenu","mousewheel","DOMMouseScroll","mouseover","mouseout","mousemove","selectstart","selectend","keydown","keypress","keyup","orientationchange","touchstart","touchmove","touchend","touchcancel","pointerdown","pointermove","pointerup","pointerleave","pointercancel","gesturestart","gesturechange","gestureend","focus","blur","change","reset","select","submit","focusin","focusout","load","unload","beforeunload","resize","move","DOMContentLoaded","readystatechange","error","abort","scroll"]);function makeEventUid(e,t){return t&&`${t}::${uidEvent++}`||e.uidEvent||uidEvent++}function getElementEvents(e){const t=makeEventUid(e);return e.uidEvent=t,eventRegistry[t]=eventRegistry[t]||{},eventRegistry[t]}function bootstrapHandler(e,t){return function n(r){return hydrateObj(r,{delegateTarget:e}),n.oneOff&&EventHandler.off(e,r.type,t),t.apply(e,[r])}}function bootstrapDelegationHandler(e,t,n){return function r(o){const a=e.querySelectorAll(t);for(let{target:l}=o;l&&l!==this;l=l.parentNode)for(const s of a)if(s===l)return hydrateObj(o,{delegateTarget:l}),r.oneOff&&EventHandler.off(e,o.type,t,n),n.apply(l,[o])}}function findHandler(e,t,n=null){return Object.values(e).find((e=>e.callable===t&&e.delegationSelector===n))}function normalizeParameters(e,t,n){const r="string"==typeof t,o=r?n:t||n;let a=getTypeEvent(e);return nativeEvents.has(a)||(a=e),[r,o,a]}function addHandler(e,t,n,r,o){if("string"!=typeof t||!e)return;let[a,l,s]=normalizeParameters(t,n,r);if(t in customEvents){const e=e=>function(t){if(!t.relatedTarget||t.relatedTarget!==t.delegateTarget&&!t.delegateTarget.contains(t.relatedTarget))return e.call(this,t)};l=e(l);}const i=getElementEvents(e),c=i[s]||(i[s]={}),u=findHandler(c,l,a?n:null);if(u)return void(u.oneOff=u.oneOff&&o);const d=makeEventUid(l,t.replace(namespaceRegex,"")),f=a?bootstrapDelegationHandler(e,n,l):bootstrapHandler(e,l);f.delegationSelector=a?n:null,f.callable=l,f.oneOff=o,f.uidEvent=d,c[d]=f,e.addEventListener(s,f,a);}function removeHandler(e,t,n,r,o){const a=findHandler(t[n],r,o);a&&(e.removeEventListener(n,a,Boolean(o)),delete t[n][a.uidEvent]);}function removeNamespacedHandlers(e,t,n,r){const o=t[n]||{};for(const a of Object.keys(o))if(a.includes(r)){const r=o[a];removeHandler(e,t,n,r.callable,r.delegationSelector);}}function getTypeEvent(e){return e=e.replace(stripNameRegex,""),customEvents[e]||e}const EventHandler={on(e,t,n,r){addHandler(e,t,n,r,!1);},one(e,t,n,r){addHandler(e,t,n,r,!0);},off(e,t,n,r){if("string"!=typeof t||!e)return;const[o,a,l]=normalizeParameters(t,n,r),s=l!==t,i=getElementEvents(e),c=i[l]||{},u=t.startsWith(".");if(void 0===a){if(u)for(const n of Object.keys(i))removeNamespacedHandlers(e,i,n,t.slice(1));for(const n of Object.keys(c)){const r=n.replace(stripUidRegex,"");if(!s||t.includes(r)){const t=c[n];removeHandler(e,i,l,t.callable,t.delegationSelector);}}}else {if(!Object.keys(c).length)return;removeHandler(e,i,l,a,o?n:null);}},trigger(e,t,n){if("string"!=typeof t||!e)return null;const r=getjQuery();let o=null,a=!0,l=!0,s=!1;t!==getTypeEvent(t)&&r&&(o=r.Event(t,n),r(e).trigger(o),a=!o.isPropagationStopped(),l=!o.isImmediatePropagationStopped(),s=o.isDefaultPrevented());let i=new Event(t,{bubbles:a,cancelable:!0});return i=hydrateObj(i,n),s&&i.preventDefault(),l&&e.dispatchEvent(i),i.defaultPrevented&&o&&o.preventDefault(),i}};function hydrateObj(e,t){for(const[n,r]of Object.entries(t||{}))try{e[n]=r;}catch{Object.defineProperty(e,n,{configurable:!0,get:()=>r});}return e}const EventHandler$1 = EventHandler;

    function normalizeData(t){if("true"===t)return !0;if("false"===t)return !1;if(t===Number(t).toString())return Number(t);if(""===t||"null"===t)return null;if("string"!=typeof t)return t;try{return JSON.parse(decodeURIComponent(t))}catch{return t}}function normalizeDataKey(t){return t.replace(/[A-Z]/g,(t=>`-${t.toLowerCase()}`))}const Manipulator={setDataAttribute(t,e,r){t.setAttribute(`data-bs-${normalizeDataKey(e)}`,r);},removeDataAttribute(t,e){t.removeAttribute(`data-bs-${normalizeDataKey(e)}`);},getDataAttributes(t){if(!t)return {};const e={},r=Object.keys(t.dataset).filter((t=>t.startsWith("bs")&&!t.startsWith("bsConfig")));for(const a of r){let r=a.replace(/^bs/,"");r=r.charAt(0).toLowerCase()+r.slice(1,r.length),e[r]=normalizeData(t.dataset[a]);}return e},getDataAttribute:(t,e)=>normalizeData(t.getAttribute(`data-bs-${normalizeDataKey(e)}`))};

    class Config{static get Default(){return {}}static get DefaultType(){return {}}static get NAME(){throw new Error('You have to implement the static method "NAME", for each component!')}_getConfig(t){return t=this._mergeConfigObj(t),t=this._configAfterMerge(t),this._typeCheckConfig(t),t}_configAfterMerge(t){return t}_mergeConfigObj(t,e){const o=isElement$1(e)?Manipulator.getDataAttribute(e,"config"):{};return {...this.constructor.Default,..."object"==typeof o?o:{},...isElement$1(e)?Manipulator.getDataAttributes(e):{},..."object"==typeof t?t:{}}}_typeCheckConfig(t,e=this.constructor.DefaultType){for(const o of Object.keys(e)){const r=e[o],n=t[o],i=isElement$1(n)?"element":toType(n);if(!new RegExp(r).test(i))throw new TypeError(`${this.constructor.NAME.toUpperCase()}: Option "${o}" provided type "${i}" but expected type "${r}".`)}}}

    class BaseComponent extends Config{constructor(t,e){super(),(t=getElement(t))&&(this._element=t,this._config=this._getConfig(e),Data.set(this._element,this.constructor.DATA_KEY,this));}dispose(){Data.remove(this._element,this.constructor.DATA_KEY),EventHandler$1.off(this._element,this.constructor.EVENT_KEY);for(const t of Object.getOwnPropertyNames(this))this[t]=null;}_queueCallback(t,e,n=!0){executeAfterTransition(t,e,n);}_getConfig(t){return t=this._mergeConfigObj(t,this._element),t=this._configAfterMerge(t),this._typeCheckConfig(t),t}static getInstance(t){return Data.get(getElement(t),this.DATA_KEY)}static getOrCreateInstance(t,e={}){return this.getInstance(t)||new this(t,"object"==typeof e?e:null)}static get VERSION(){return "5.2.3"}static get DATA_KEY(){return `bs.${this.NAME}`}static get EVENT_KEY(){return `.${this.DATA_KEY}`}static eventName(t){return `${t}${this.EVENT_KEY}`}}

    const SelectorEngine={find:(e,t=document.documentElement)=>[].concat(...Element.prototype.querySelectorAll.call(t,e)),findOne:(e,t=document.documentElement)=>Element.prototype.querySelector.call(t,e),children:(e,t)=>[].concat(...e.children).filter((e=>e.matches(t))),parents(e,t){const n=[];let i=e.parentNode.closest(t);for(;i;)n.push(i),i=i.parentNode.closest(t);return n},prev(e,t){let n=e.previousElementSibling;for(;n;){if(n.matches(t))return [n];n=n.previousElementSibling;}return []},next(e,t){let n=e.nextElementSibling;for(;n;){if(n.matches(t))return [n];n=n.nextElementSibling;}return []},focusableChildren(e){const t=["a","button","input","textarea","select","details","[tabindex]",'[contenteditable="true"]'].map((e=>`${e}:not([tabindex^="-"])`)).join(",");return this.find(t,e).filter((e=>!isDisabled(e)&&isVisible(e)))}};const SelectorEngine$1 = SelectorEngine;

    const NAME$E="carousel",EVENT_LOAD_DATA_API$4="load.bs.carousel.data-api",SELECTOR_CAROUSEL="[data-bs-carousel-splide]",CONFIG_DEFAULT$1={slideFocus:!0,i18n:{prev:"Slide precedente",next:"Slide successiva",first:"Vai alla prima slide",last:"Vai all’ultima slide",slideX:"Vai alla slide %s",pageX:"Vai a pagina %s",play:"Attiva autoplay",pause:"Pausa autoplay"}},CONFIGS={"it-carousel-landscape-abstract-three-cols":{type:"slide",perPage:3,gap:24,padding:{left:0,right:0},arrows:!1,breakpoints:{768:{perPage:1,gap:24,padding:{left:0,right:0},arrows:!1},992:{perPage:2,gap:24,padding:{left:40,right:40},arrows:!1}}},"it-carousel-landscape-abstract-three-cols-arrow-visible":{type:"slide",perPage:3,gap:24,padding:{left:0,right:0},arrows:!0,breakpoints:{768:{perPage:1,gap:24,padding:{left:40,right:40},arrows:!0},992:{perPage:2,gap:24,padding:{left:40,right:40},arrows:!0}}},"it-big-img":{type:"loop",perPage:1,gap:48,padding:{left:320,right:320},arrows:!1,breakpoints:{768:{perPage:1,gap:0,padding:{left:0,right:0},arrows:!1},992:{perPage:1,gap:24,padding:{left:160,right:160},arrows:!1}}},"it-standard-image":{type:"loop",perPage:3,gap:24,padding:{left:48,right:48},arrows:!1,breakpoints:{768:{perPage:1,gap:24,padding:{left:40,right:40},arrows:!1},992:{perPage:2,gap:24,padding:{left:48,right:48},arrows:!1}}},"it-carousel-landscape-abstract":{type:"slide",perPage:1,gap:24,padding:{left:0,right:0},arrows:!1,breakpoints:{768:{perPage:1,gap:24,padding:{left:0,right:0},arrows:!1},992:{perPage:1,gap:24,padding:{left:24,right:24},arrows:!1}}},"it-calendar-wrapper":{type:"slide",perPage:4,gap:0,padding:{left:0,right:0},arrows:!1,breakpoints:{560:{perPage:1,gap:0,padding:{left:24,right:24},arrows:!1},768:{perPage:2,gap:0,padding:{left:0,right:0},arrows:!1},992:{perPage:3,gap:0,padding:{left:0,right:0},arrows:!1}}}};class CarouselBI extends BaseComponent{constructor(e){super(e),this._config=this._getConfig(),this._splide=new Splide__default.default(this._element,this._config),this._init();}dispose(){this._splide.destroy(),super.dispose();}static get NAME(){return NAME$E}_init(){this._splide.mount();}_getConfig(){let e=Object.assign({},CONFIG_DEFAULT$1);return Object.keys(CONFIGS).forEach((a=>{this._element.classList.contains(a)&&(e=Object.assign({},e,CONFIGS[a]));})),e}}EventHandler$1.on(window,EVENT_LOAD_DATA_API$4,(()=>{SelectorEngine$1.find(SELECTOR_CAROUSEL).forEach((e=>{CarouselBI.getOrCreateInstance(e);}));}));const CarouselBI$1 = CarouselBI;

    const NAME$D="inputlabel",DATA_KEY$d="bs.inputlabel",EVENT_KEY$f=`.${DATA_KEY$d}`,EVENT_FOCUS=`focus${EVENT_KEY$f}`,EVENT_BLUR=`blur${EVENT_KEY$f}`,EVENT_CHANGE$2=`change${EVENT_KEY$f}`;class InputLabel{constructor(e){this._element=e,this._init();}static get NAME(){return NAME$D}static getInputFromLabel=e=>document.querySelector("#"+CSS.escape(e.getAttribute("for")));_init(){const e=this._getLabel();e&&!e.classList.contains("active")&&(this._labelOut(),this._labelOver()),e&&null===e.getAttribute("it-bs-static")&&this._bindEvents();}_bindEvents(){["date","time"].includes(this._element.getAttribute("type"))||("file"===this._element.getAttribute("type")?EventHandler$1.on(this._element,EVENT_BLUR,(()=>{this._labelOut();})):(EventHandler$1.on(this._element,EVENT_FOCUS,(()=>{this._labelOut();})),EventHandler$1.on(this._element,EVENT_BLUR,(()=>{this._labelOver();})),EventHandler$1.on(this._element,EVENT_CHANGE$2,(()=>{this._labelToggle();}))));}_getLabel(){return SelectorEngine$1.findOne('label[for="'+this._element.getAttribute("id")+'"]')}_isEmpty(){return !this._element.value&&!this._element.getAttribute("placeholder")}_labelOut(){const e=this._getLabel();e&&e.classList.add("active");}_labelOver(){if(this._isEmpty()){const e=this._getLabel();e&&e.classList.remove("active");}}_labelToggle(){this._isEmpty()?this._labelOver():this._labelOut();}}const InputLabel$1 = InputLabel;

    const NAME$C="inputnumber",DATA_KEY$c="bs.inputnumber",EVENT_KEY$e=`.${DATA_KEY$c}`,EVENT_CLICK$8=`click${EVENT_KEY$e}`,EVENT_CHANGE$1=`change${EVENT_KEY$e}`,EVENT_CLICK_DATA_API$g=`click${EVENT_KEY$e}.data-api`,CLASS_NAME_ADAPTIVE="input-number-adaptive",SELECTOR_INPUT='input[data-bs-input][type="number"]',SELECTOR_BTN='button[class^="input-number-"]';class InputNumber extends BaseComponent{constructor(e){super(e),this._wrapperElement=this._element.closest(".input-number"),this._label=new InputLabel$1(e),this._init(),this._bindEvents();}static get NAME(){return NAME$C}_init(){this._wrapperElement&&this._inputResize();}_bindEvents(){this._wrapperElement&&(SelectorEngine$1.find(SELECTOR_BTN,this._wrapperElement).forEach((e=>{EventHandler$1.on(e,EVENT_CLICK$8,(t=>{t.preventDefault(),this._incrDecr(e.classList.contains("input-number-sub")),this._label._labelOut();}));})),EventHandler$1.on(this._element,EVENT_CHANGE$1,(()=>this._checkLimit())));}_inputResize(){if(this._wrapperElement.classList.contains(CLASS_NAME_ADAPTIVE)){let e=null;e="calc(70px + "+this._element.value.length+"ch)",e&&(this._element.style.width=e);}}_incrDecr(e){var t=0;if(""!==this._element.value&&(t=parseFloat(this._element.value)),!isNaN(t)){let n=parseFloat(this._element.getAttribute("step"));n||(n=1),this._element.value=t+n*(e?-1:1),EventHandler$1.trigger(this._element,EVENT_CHANGE$1),EventHandler$1.trigger(this._element,"input");}}_checkLimit(){const e=parseFloat(this._element.value);if(!isNaN(e)){let t=e;const n=parseFloat(this._element.getAttribute("max")),i=parseFloat(this._element.getAttribute("min"));i&&e<i&&(t=i),n&&e>n&&(t=n),this._element.value=t;}this._inputResize();}}"undefined"!=typeof document&&(document.addEventListener("DOMContentLoaded",(function(){document.querySelectorAll(SELECTOR_INPUT+", label").forEach((function(e){const t=InputLabel$1.getInputFromLabel(e)||e;var n;(n=t)&&n.matches(SELECTOR_INPUT)&&n.parentNode.querySelector(SELECTOR_BTN)&&InputNumber.getOrCreateInstance(n);}));})),EventHandler$1.on(document,EVENT_CLICK_DATA_API$g,SELECTOR_BTN,(function(){const e=this.closest(".input-number");if(e){const t=SelectorEngine$1.findOne(SELECTOR_INPUT,e);t&&InputNumber.getOrCreateInstance(t);}})));const InputNumber$1 = InputNumber;

    const NAME$B="dimmer",EVENT_CLICK_DATA_API$f="click.bs.dimmer.data-api",SELECTOR_DATA_TOGGLE$c='[data-bs-toggle="dimmer"]';class Dimmer extends BaseComponent{constructor(t){super(t),this._isShown=!t.matches("[aria-hidden=true]"),this._isTransitioning=!1;}static get NAME(){return NAME$B}show(){this._isShown||this._isTransitioning||(this._isShown=!0,this._isAnimated()&&(this._isTransitioning=!0),this._showElement());}hide(){if(!this._isShown||this._isTransitioning)return;this._isShown=!1;const t=this._isAnimated();t&&(this._isTransitioning=!0),this._element.classList.remove("show"),this._queueCallback((()=>this._hideElement()),this._element,t);}_isAnimated(){return this._element.classList.contains("fade")}_showElement(){const t=this._isAnimated();this._element.removeAttribute("aria-hidden"),t&&reflow(this._element),this._element.classList.add("show");this._queueCallback((()=>{this._isTransitioning=!1;}),this._element,t);}_hideElement(){this._element.setAttribute("aria-hidden",!0),this._isTransitioning=!1;}}EventHandler$1.on(document,EVENT_CLICK_DATA_API$f,SELECTOR_DATA_TOGGLE$c,(function(){const t=getElementFromSelector(this),e=Dimmer.getOrCreateInstance(t);this.checked?e.show():e.hide();}));const Dimmer$1 = Dimmer;

    const enableDismissTrigger=(e,t="hide")=>{const s=`click.dismiss${e.EVENT_KEY}`,i=e.NAME;EventHandler$1.on(document,s,`[data-bs-dismiss="${i}"]`,(function(s){if(["A","AREA"].includes(this.tagName)&&s.preventDefault(),isDisabled(this))return;const n=getElementFromSelector(this)||this.closest(`.${i}`);e.getOrCreateInstance(n)[t]();}));};

    const NAME$A="notification",DATA_KEY$b="bs.notification",EVENT_KEY$d=`.${DATA_KEY$b}`,EVENT_CLICK_DATA_API$e=`click${EVENT_KEY$d}.data-api`,EVENT_HIDDEN$7=`hidden${EVENT_KEY$d}`,EVENT_SHOW$7=`show${EVENT_KEY$d}`,Default$m={timeout:0},SELECTOR_DATA_TOGGLE$b='[data-bs-toggle="notification"]';class Notification extends BaseComponent{constructor(t,i){super(t),this._config=this._getConfig(i),this._isShown=this._element.classList.contains("show"),this._isTransitioning=!1,this._toId=null;}static get NAME(){return NAME$A}show(t,i){if(this._isShown||this._isTransitioning)return;const e=t||this._getElementTimeout(i);this._isShown=!0,this._isAnimated()&&(this._isTransitioning=!0),this._showElement(e);}hide(){if(!this._isShown||this._isTransitioning)return;this._isShown=!1;const t=this._isAnimated();t&&(this._isTransitioning=!0),this._element.classList.remove("show"),this._queueCallback((()=>this._hideElement()),this._element,t);}toggle(t){this._isShown?this.hide():this.show(null,t);}_isAnimated(){return this._element.classList.contains("fade")}_showElement(t){const i=this._isAnimated();this._element.style.display="block",this._element.removeAttribute("aria-hidden"),i&&reflow(this._element),this._element.classList.add("show");this._queueCallback((()=>{this._isTransitioning=!1,t&&this._setTimeout(t,(()=>this.hide()));}),this._element,i);}_hideElement(){this._element.style.display="none",this._element.setAttribute("aria-hidden",!0),this._isTransitioning=!1;}_getConfig(t){return t={...Default$m,...Manipulator.getDataAttributes(this._element),..."object"==typeof t?t:{}}}_getElementTimeout(t){const i=t?parseInt(t.getAttribute("data-bs-timeout")):null;return i>0?i:this._config.timeout}_setTimeout(t,i){this._clearTimeout(),setTimeout(i,t);}_clearTimeout(){this._toId&&(clearTimeout(this._toId),this._toId=null);}}EventHandler$1.on(document,EVENT_CLICK_DATA_API$e,SELECTOR_DATA_TOGGLE$b,(function(t){const i=getElementFromSelector(this);["A","AREA"].includes(this.tagName)&&t.preventDefault(),EventHandler$1.one(i,EVENT_SHOW$7,(t=>{t.defaultPrevented||EventHandler$1.one(i,EVENT_HIDDEN$7,(()=>{isVisible(this)&&this.focus();}));}));Notification.getOrCreateInstance(i).toggle(this);})),enableDismissTrigger(Notification);const Notification$1 = Notification;

    const NAME$z="cookiebar",DATA_KEY$a="bs.cookiebar",EVENT_KEY$c=`.${DATA_KEY$a}`,COOKIE_NAME="cookies_consent",SELECTOR_ACCEPT='[data-bs-accept="cookiebar"]',EVENT_CLOSE$1=`close${EVENT_KEY$c}`,EVENT_CLOSED$1=`closed${EVENT_KEY$c}`,EVENT_LOAD_DATA_API$3=`load${EVENT_KEY$c}.data-api`,EVENT_CLICK_DATA_API$d=`click${EVENT_KEY$c}.data-api`;class Cookiebar extends BaseComponent{constructor(e){super(e),this._isShown=this._element.classList.contains("show"),this._isTransitioning=!1;}static get NAME(){return NAME$z}static get VERSION(){return "5.0.0"}show(){this._isShown||this._isTransitioning||(this._isShown=!0,this._isAnimated()&&(this._isTransitioning=!0),this._showElement());}hide(){if(!this._isShown||this._isTransitioning)return;this._isShown=!1;const e=this._isAnimated();e&&(this._isTransitioning=!0),this._element.classList.remove("show"),this._queueCallback((()=>this._hideElement()),this._element,e);}accept(e){e=e||this._element;const t=this._getRootElement(e);this._triggerCloseEvent(t).defaultPrevented||(this._setCookieEU(),this.hide());}static clearCookie(){"undefined"!=typeof document&&(document.cookie=COOKIE_NAME+"=; Path=/; Expires=Thu, 01 Jan 1970 00:00:01 GMT;");}_isAnimated(){return this._element.classList.contains("fade")}_showElement(){const e=this._isAnimated();this._element.removeAttribute("aria-hidden"),this._element.setAttribute("aria-live","polite"),e&&reflow(this._element),this._element.classList.add("show");this._queueCallback((()=>{this._isTransitioning=!1;}),this._element,e);}_hideElement(){this._element.style.display="none",this._element.setAttribute("aria-hidden",!0),this._element.removeAttribute("aria-live"),this._isTransitioning=!1;}_setCookieEU(){var e=new Date;e.setDate(e.getDate()+30);var t=escape("true")+"; expires="+e.toUTCString();"undefined"!=typeof document&&(document.cookie=COOKIE_NAME+"="+t+"; path=/; SameSite=Strict");}_getRootElement(e){const t=getElementFromSelector(e);let i=null;return t&&(i=t),i||(i=e.closest(".cookiebar")),i}_triggerCloseEvent(e){return EventHandler$1.trigger(e,EVENT_CLOSE$1)}_removeElement(e){e.classList.remove("show"),e.setAttribute("aria-hidden","true"),e.setAttribute("aria-live","off"),EventHandler$1.trigger(e,EVENT_CLOSED$1),this.dispose();}static _handleAccept(e){return function(t){t&&t.preventDefault(),e.close(this);}}static _handleConsent(e){return function(t){t&&t.preventDefault(),e.close(this);}}static _getCookieEU(){if("undefined"!=typeof document){var e,t,i,s=document.cookie.split(";");for(e=0;e<s.length;e++)if(t=s[e].substring(0,s[e].indexOf("=")),i=s[e].substring(s[e].indexOf("=")+1),(t=t.replace(/^\s+|\s+$/g,""))==COOKIE_NAME)return unescape(i)}}}EventHandler$1.on(document,EVENT_CLICK_DATA_API$d,SELECTOR_ACCEPT,(function(e){if(["A","AREA"].includes(this.tagName)&&e.preventDefault(),isDisabled(this))return;const t=getElementFromSelector(this)||this.closest(`.${NAME$z}`);Cookiebar.getOrCreateInstance(t).accept();})),EventHandler$1.on(window,EVENT_LOAD_DATA_API$3,(function(){if(!Cookiebar._getCookieEU()){if("undefined"==typeof document)return;document.querySelectorAll(".cookiebar").forEach((e=>{Cookiebar.getOrCreateInstance(e).show();}));}}));const Cookiebar$1 = Cookiebar;

    const MEDIA_MOBILE="(max-width: 991px)",isScreenMobile=()=>{if("undefined"!=typeof window)return window.matchMedia(MEDIA_MOBILE).matches};

    const getElementIndex=(e,t)=>{let i=null;return t.forEach(((t,o)=>{t===e&&(i=o);})),i};const focusSimbling=(e,t,i)=>{i={isDirectionTop:!1,isLimit:!1,loop:!1,..."object"==typeof i?i:{}};const o=getElementIndex(e,t);let n=null;if(i.isLimit&&i.isDirectionTop&&o>0)n=t[0];else if(i.isLimit&&o<t.length-1)n=t[t.length-1];else if(i.isDirectionTop){if(!i.loop&&0===o)return;n=t[0===o?t.length-1:o-1];}else {if(!i.loop&&o===t.length-1)return;n=t[o===t.length-1?0:o+1];}n&&n.focus();};

    const CLASS_SCROLL_DISABLED="pagescroll-scroll-disabled";let disabled=!1,currentScrollPos="undefined"==typeof document?0:document.scrollingElement.scrollTop;const htmlContainer="undefined"==typeof document?null:document.querySelector("html");function disablePageScroll(){"undefined"!=typeof document&&(disabled=!0,currentScrollPos=document.scrollingElement.scrollTop,htmlContainer.classList.add(CLASS_SCROLL_DISABLED));}function enablePageScroll(){"undefined"!=typeof document&&(disabled=!1,htmlContainer.classList.remove(CLASS_SCROLL_DISABLED));}"undefined"!=typeof document&&document.addEventListener("scroll",(()=>{disabled&&(document.scrollingElement.scrollTop=currentScrollPos);}));

    const NAME$y="navbarcollapsible",DATA_KEY$9="bs.navbarcollapsible",EVENT_KEY$b=`.${DATA_KEY$9}`,EVENT_CLICK_DATA_API$c=`click${EVENT_KEY$b}.data-api`,EVENT_CLICK$7=`click${EVENT_KEY$b}`,EVENT_KEYUP$2=`keyup${EVENT_KEY$b}`,EVENT_KEYDOWN$4=`keydown${EVENT_KEY$b}`,EVENT_HIDE$6=`hide${EVENT_KEY$b}`,EVENT_HIDDEN$6=`hidden${EVENT_KEY$b}`,EVENT_SHOW$6=`show${EVENT_KEY$b}`,EVENT_SHOWN$6=`shown${EVENT_KEY$b}`,EVENT_RESIZE$3=`resize${EVENT_KEY$b}`,SELECTOR_DATA_TOGGLE$a='[data-bs-toggle="navbarcollapsible"]',SELECTOR_BTN_CLOSE=".close-div button",SELECTOR_BTN_MENU_CLOSE=".close-menu",SELECTOR_NAVLINK=".nav-link",SELECTOR_MEGAMENUNAVLINK=".nav-item .list-item",SELECTOR_HEADINGLINK=".it-heading-link",SELECTOR_FOOTERLINK=".it-footer-link";class NavBarCollapsible extends BaseComponent{constructor(e){super(e),this._isShown=this._element.classList.contains("expanded"),this._isTransitioning=!1,this._isMobile=isScreenMobile(),this._isKeyShift=!1,this._currItemIdx=0,this._btnClose=SelectorEngine$1.findOne(SELECTOR_BTN_CLOSE,this._element),this._btnBack=SelectorEngine$1.findOne(".it-back-button",this._element),this._menuWrapper=SelectorEngine$1.findOne(".menu-wrapper",this._element),this._overlay=null,this._setOverlay(),this._menuItems=SelectorEngine$1.find([SELECTOR_NAVLINK,SELECTOR_MEGAMENUNAVLINK,SELECTOR_HEADINGLINK,SELECTOR_FOOTERLINK,SELECTOR_BTN_MENU_CLOSE].join(","),this._element),this._bindEvents();}static get NAME(){return NAME$y}show(e){if(this._isShown||this._isTransitioning)return;EventHandler$1.trigger(this._element,EVENT_SHOW$6,{relatedTarget:e}).defaultPrevented||(this._btnBack&&this._btnBack.classList.add("show"),this._isShown=!0,disablePageScroll(),this._showElement());}hide(){if(!this._isShown||this._isTransitioning)return;if(EventHandler$1.trigger(this._element,EVENT_HIDE$6).defaultPrevented)return;this._isShown=!1;const e=this._isAnimated();e&&(this._isTransitioning=!0),this._btnBack&&this._btnBack.classList.remove("show"),this._overlay&&this._overlay.classList.remove("show"),this._element.classList.remove("expanded"),enablePageScroll(),this._queueCallback((()=>this._hideElement()),this._menuWrapper,e);}toggle(e){this._isShown?this.hide():this.show(e);}dispose(){EventHandler$1.off(window,EVENT_RESIZE$3),super.dispose();}_bindEvents(){EventHandler$1.on(window,EVENT_RESIZE$3,(()=>this._onResize())),this._overlay&&EventHandler$1.on(this._overlay,EVENT_CLICK$7,(()=>this.hide())),EventHandler$1.on(this._btnClose,EVENT_CLICK$7,(e=>{e.preventDefault(),this.hide();})),EventHandler$1.on(this._btnBack,EVENT_CLICK$7,(e=>{e.preventDefault(),this.hide();})),this._menuItems.forEach((e=>{EventHandler$1.on(e,EVENT_KEYDOWN$4,(e=>this._isMobile&&this._onMenuItemKeyDown(e))),EventHandler$1.on(e,EVENT_KEYUP$2,(e=>this._isMobile&&this._onMenuItemKeyUp(e))),EventHandler$1.on(e,EVENT_CLICK$7,(e=>this._isMobile&&this._onMenuItemClick(e)));}));}_onResize(){this._isMobile=isScreenMobile();}_onMenuItemKeyUp(e){"Shift"===e.key&&(this._isKeyShift=!1);}_onMenuItemKeyDown(e){"Shift"===e.key&&(this._isKeyShift=!0),"Tab"===e.key&&(e.preventDefault(),this._focusNext());}_onMenuItemClick(e){this.currItemIdx=getElementIndex(e.currentTarget,this._menuItems);}_isAnimated(){return !0}_isElementHidden(e){return null===e.offsetParent}_showElement(){const e=this._isAnimated();this._element.style.display="block",this._element.removeAttribute("aria-hidden"),this._element.setAttribute("aria-expanded",!0),this._overlay&&(this._overlay.style.display="block"),e&&reflow(this._element),this._element.classList.add("expanded"),this._overlay&&this._overlay.classList.add("show");this._queueCallback((()=>{this._isTransitioning=!1;const e=this._getNextVisibleItem(0);e.item&&(e.item.focus(),this._currItemIdx=e.index),EventHandler$1.trigger(this._element,EVENT_SHOWN$6);}),this._menuWrapper,e);}_hideElement(){this._overlay&&(this._overlay.style.display="none"),this._element.style.display="none",this._element.setAttribute("aria-hidden",!0),this._element.removeAttribute("aria-expanded"),this._isTransitioning=!1,EventHandler$1.trigger(this._element,EVENT_HIDDEN$6);}_setOverlay(){this._overlay=SelectorEngine$1.findOne(".overlay",this._element),this._isAnimated&&this._overlay.classList.add("fade");}_focusNext(){let e=this._currItemIdx+(this._isKeyShift?-1:1);e<0?e=this._menuItems.length-1:e>=this._menuItems.length&&(e=0);const t=this._getNextVisibleItem(e,this._isKeyShift);t.item&&(t.item.focus(),this._currItemIdx=t.index);}_getNextVisibleItem(e,t){let i=null,s=null,n=e,E=t?-1:1,l=!1;for(;!(i||n==e&&l);)n==e&&(l=!0),this._isElementHidden(this._menuItems[n])||(i=this._menuItems[n],s=n),n+=E,n<0?n=this._menuItems.length-1:n>=this._menuItems.length&&(n=0);return {item:i,index:s}}}EventHandler$1.on(document,EVENT_CLICK_DATA_API$c,SELECTOR_DATA_TOGGLE$a,(function(e){const t=getElementFromSelector(this);["A","AREA"].includes(this.tagName)&&e.preventDefault(),EventHandler$1.one(t,EVENT_SHOW$6,(e=>{e.defaultPrevented||EventHandler$1.one(t,EVENT_HIDDEN$6,(()=>{isVisible(this)&&this.focus();}));}));NavBarCollapsible.getOrCreateInstance(t).toggle(this);}));const NavBarCollapsible$1 = NavBarCollapsible;

    const NAME$x="accordion",DATA_KEY$8="bs.accordion",EVENT_KEY$a=`.${DATA_KEY$8}`,EVENT_KEYDOWN$3=`keydown${EVENT_KEY$a}`,EVENT_KEYDOWN_DATA_API$1=`keydown${EVENT_KEY$a}.data-api`,SELECTOR_HEADBTN='.accordion-item > .accordion-header [data-bs-toggle="collapse"]';class Accordion extends BaseComponent{constructor(o){super(o),this._bindEvents();}static get NAME(){return NAME$x}handleKeyDown(o,t,e){const n={ArrowDown:o=>this._focusNext(o),ArrowUp:o=>this._focusPrev(o),Home:o=>this._focusFirst(o),End:o=>this._focusLast(o)};"function"==typeof n[o]&&(e&&e.preventDefault(),n[o](t));}_bindEvents(){SelectorEngine$1.find(SELECTOR_HEADBTN,this._element).forEach((o=>{EventHandler$1.on(o,EVENT_KEYDOWN$3,(o=>{this.handleKeyDown(o.key,o.currentTarget,o);}));}));}_getHeadButtons(){return SelectorEngine$1.find(":scope > "+SELECTOR_HEADBTN,this._element)}_focusNext(o){focusSimbling(o,this._getHeadButtons(),{loop:!0});}_focusPrev(o){focusSimbling(o,this._getHeadButtons(),{isDirectionTop:!0,loop:!0});}_focusFirst(o){focusSimbling(o,this._getHeadButtons(),{isDirectionTop:!0,isLimit:!0});}_focusLast(o){focusSimbling(o,this._getHeadButtons(),{isLimit:!0});}}EventHandler$1.on(document,EVENT_KEYDOWN_DATA_API$1,SELECTOR_HEADBTN,(function(o){const t=this.closest(".accordion");if(t){Accordion.getOrCreateInstance(t).handleKeyDown(o.key,this,o);}}));const Accordion$1 = Accordion;

    var getRandomValues,rnds8=new Uint8Array(16);function rng(){if(!getRandomValues&&!(getRandomValues="undefined"!=typeof crypto&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto)||"undefined"!=typeof msCrypto&&"function"==typeof msCrypto.getRandomValues&&msCrypto.getRandomValues.bind(msCrypto)))throw new Error("crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported");return getRandomValues(rnds8)}

    const REGEX = /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i;

    function validate(t){return "string"==typeof t&&REGEX.test(t)}

    for(var byteToHex=[],i=0;i<256;++i)byteToHex.push((i+256).toString(16).substr(1));function stringify(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,o=(byteToHex[e[t+0]]+byteToHex[e[t+1]]+byteToHex[e[t+2]]+byteToHex[e[t+3]]+"-"+byteToHex[e[t+4]]+byteToHex[e[t+5]]+"-"+byteToHex[e[t+6]]+byteToHex[e[t+7]]+"-"+byteToHex[e[t+8]]+byteToHex[e[t+9]]+"-"+byteToHex[e[t+10]]+byteToHex[e[t+11]]+byteToHex[e[t+12]]+byteToHex[e[t+13]]+byteToHex[e[t+14]]+byteToHex[e[t+15]]).toLowerCase();if(!validate(o))throw TypeError("Stringified UUID is invalid");return o}

    function v4(r,n,i){var t=(r=r||{}).random||(r.rng||rng)();if(t[6]=15&t[6]|64,t[8]=63&t[8]|128,n){i=i||0;for(var o=0;o<16;++o)n[i+o]=t[o];return n}return stringify(t)}

    let ticking=!1,callbacks=[];class ScrollCallback{constructor(c,l){this.id=c,this._callback=l;}dispose(){removeCallBack(this.id);}_execute(c){this._callback(c);}}const removeCallBack=c=>{callbacks=callbacks.filter((l=>l.id!==c));},onDocumentScroll=c=>{if("undefined"!=typeof document){if(callbacks.length||document.addEventListener("scroll",(c=>{ticking||(window.requestAnimationFrame((()=>{callbacks.forEach((l=>l.cb._execute(c))),ticking=!1;})),ticking=!0);})),"function"==typeof c){const l=new ScrollCallback(v4(),c);return callbacks.push({id:l.id,cb:l}),l}return console.error("[onDocumentScroll] the provided data has to be of type function"),null}};const onDocumentScroll$1 = onDocumentScroll;

    const AnimeDefault={duration:800,easing:"easeInOutSine"};const documentScrollTo=(e,o)=>{if("undefined"==typeof document)return;const t=("object"==typeof o?o:{}).complete,n=window.document.scrollingElement||window.document.body||window.document.documentElement,l=n.style.scrollBehavior;o={scrollTop:e||0,...AnimeDefault,..."object"==typeof o?o:{}},n.style.scrollBehavior="auto",o.complete=e=>{n.style.scrollBehavior=l,"function"==typeof t&&t(e);},anime__default.default({targets:n,...o});};

    const NAME$w="navscroll",SELECTOR_NAVSCROLL="[data-bs-navscroll]",SELECTOR_LIST$1="ul.link-list",SELECTOR_LINK_CONTAINER="li.nav-link, li.nav-item",SELECTOR_CONTAINER=".it-page-sections-container",SELECTOR_TOGGLER$1=".custom-navbar-toggler",SELECTOR_COLLAPSIBLE=".navbar-collapsable",SELECTOR_PROGRESS_BAR=".it-navscroll-progressbar",Default$l={scrollPadding:10,duration:800,easing:"easeInOutSine"};class NavScroll extends BaseComponent{constructor(e,t){super(e),this._config=this._getConfig(t),this._togglerElement=SelectorEngine$1.findOne(SELECTOR_TOGGLER$1,this._element),this._sectionContainer=SelectorEngine$1.findOne(SELECTOR_CONTAINER),this._collapsible=this._getCollapsible(),this._isCollapseOpened=!1,this._callbackQueue=[],this._scrollCb=null,this._bindEvents();}static get NAME(){return NAME$w}setScrollPadding(e){this._config.scrollPadding=e;}dispose(){this._scrollCb&&this._scrollCb.dispose(),super.dispose();}_getConfig(e){return e={...Default$l,...Manipulator.getDataAttributes(this._element),..."object"==typeof e?e:{}}}_bindEvents(){this._scrollCb=onDocumentScroll$1((()=>this._onScroll())),this._collapsible&&(EventHandler$1.on(this._collapsible._element,"shown.bs.navbarcollapsible",(()=>this._onCollapseOpened())),EventHandler$1.on(this._collapsible._element,"hidden.bs.navbarcollapsible",(()=>this._onCollapseClosed()))),SelectorEngine$1.find('a.nav-link[href^="#"]',this._element).forEach((e=>{e.addEventListener("click",(()=>{const t=()=>this._scrollToHash(e.hash);this._isCollapseOpened?(this._callbackQueue.push(t),this._collapsible.hide()):t();}));})),EventHandler$1.on(window,"load",(()=>{setTimeout((()=>this._onScroll()),150);}));}_onCollapseOpened(){this._isCollapseOpened=!0;}_onCollapseClosed(){for(;this._callbackQueue.length>0;){const e=this._callbackQueue.shift();"function"==typeof e&&e();}this._isCollapseOpened=!1;}_getParentLinks(e){const t=[];let n=e.closest(SELECTOR_LIST$1),o=null,l=!1;for(;n&&!l;){const e=n.closest(SELECTOR_LINK_CONTAINER);if(e){const n=e.querySelector("a.nav-link");n&&t.push(n);}o=n,n=(n.parentElement||n).closest(SELECTOR_LIST$1),n===o&&(l=!0);}return t}_decorateToggler(e){if(this._togglerElement){const t=SelectorEngine$1.findOne(".it-list",this._togglerElement);this._togglerElement.innerText="",this._togglerElement.textContent="",this._togglerElement.append(t),this._togglerElement.append(e);}}_scrollToHash(e){const t=SelectorEngine$1.findOne(e,this._sectionContainer);t&&(documentScrollTo(t.offsetTop-this._getScrollPadding(),{duration:this._config.duration,easing:this._config.easing}),history.pushState?history.pushState(null,null,e):location.hash=e);}_updateProgress(e){if(!e)return;const t=SelectorEngine$1.find(SELECTOR_PROGRESS_BAR);if(t){const n=Math.abs(e.getBoundingClientRect().top)/e.getBoundingClientRect().height*100,o=Math.min(100,Math.max(0,n));t.forEach((t=>{e.getBoundingClientRect().top<=0?(t.style.width=o+"%",t.setAttribute("aria-valuenow",o)):(t.style.width="0%",t.setAttribute("aria-valuenow",0));}));}}_onScroll(){const e=this._sectionContainer?this._sectionContainer.offsetTop:0;if("undefined"==typeof document)return;const t=document.scrollingElement.scrollTop-e,n=SelectorEngine$1.find("a.nav-link",this._element),o=this._getScrollPadding();SelectorEngine$1.find(".it-page-section").forEach(((l,i)=>{if(l.offsetTop-e<=t+o&&(SelectorEngine$1.find("a.nav-link.active",this._element).forEach((e=>{e.classList.remove("active");})),i<n.length)){const e=n[i];this._getParentLinks(e).forEach((e=>{e.classList.add("active");})),e.classList.add("active"),this._decorateToggler(e.innerText);}})),this._updateProgress(this._sectionContainer);}_getCollapsible(){const e=SelectorEngine$1.findOne(SELECTOR_COLLAPSIBLE,this._element);return e?NavBarCollapsible$1.getOrCreateInstance(e):null}_getScrollPadding(){return "function"==typeof this._config.scrollPadding?this._config.scrollPadding():this._config.scrollPadding}}const navs=SelectorEngine$1.find(SELECTOR_NAVSCROLL);navs.map((e=>{NavScroll.getOrCreateInstance(e);}));const NavScroll$1 = NavScroll;

    const NAME$v="sticky",EVENT_RESIZE$2="resize.bs.sticky",CLASS_NAME_WRAPPER="bs-it-sticky-wrapper",DATA_TARGET_MOBILE="data-bs-target-mobile",SELECTOR_DATA_TOGGLE$9='[data-bs-toggle="sticky"]',Default$k={positionType:"sticky",stickyClassName:"",stackable:!1,paddingTop:0};class Sticky extends BaseComponent{constructor(t,e){super(t),this._config=this._getConfig(e),this._isSticky=!1,this._wrapper=null,this._stickyTarget=SelectorEngine$1.findOne(getSelectorFromElement(this._element),this._element)||this._element,this._stickyTargetMobile=SelectorEngine$1.findOne(this._element.getAttribute(DATA_TARGET_MOBILE),this._element)||this._stickyTarget,this._stickyLimit=0,this._stickyLimitMobile=0,this._setLimit(),this._scrollCb=null,this._isMobile=isScreenMobile(),this._prevTop=0,this._onScroll(),this._bindEvents();}dispose(){EventHandler$1.off(window,EVENT_RESIZE$2),this._scrollCb.dispose(),super.dispose();}static get NAME(){return NAME$v}_getConfig(t){return t={...Default$k,...Manipulator.getDataAttributes(this._element),..."object"==typeof t?t:{}}}_bindEvents(){EventHandler$1.on(window,EVENT_RESIZE$2,(()=>this._onResize())),this._scrollCb=onDocumentScroll$1((()=>this._onScroll()));}_onResize(){this._isMobile=isScreenMobile(),this._setLimit();}_onScroll(){this._checkSticky();}_setLimit(){this._stickyLimit=this._cumulativeOffset(this._stickyTarget).top,this._stickyLimitMobile=this._cumulativeOffset(this._stickyTargetMobile).top;}_getLimit(){let t=this._isMobile?this._stickyLimitMobile:this._stickyLimit;return this._config.stackable&&this._getStickySimblings().forEach(((e,i)=>{const s=e.getBoundingClientRect();t-=s.height+(0===i?parseFloat(e.style.top):0);})),t>0?t:0}_cumulativeOffset(t){let e=0,i=0;do{e+=t.offsetTop||0,i+=t.offsetLeft||0,t=t.offsetParent;}while(t);return {top:e,left:i}}_isTypeSticky(){return "sticky"===this._config.positionType}_checkSticky(){this._isSticky||this._setLimit();const t=this._getLimit();"undefined"!=typeof window&&window.pageYOffset>t?this._setSticky():this._unsetSticky();}_setSticky(){if(!this._isSticky){this._isSticky=!0;let t="bs-is-sticky";this._isTypeSticky()||(t="bs-is-fixed",this._wrapper=this._createWrapper()),this._element.classList.add(t),this._config.stickyClassName&&this._element.classList.add(this._config.stickyClassName),this._prevTop=this._element.style.top,this._element.style.top=this._getPositionTop()+"px",EventHandler$1.trigger(this._element,"on.bs.sticky");}}_unsetSticky(){if(this._isSticky){let t="bs-is-sticky";this._isTypeSticky()||(t="bs-is-fixed",this._destroyWrapper()),this._element.classList.remove(t),this._config.stickyClassName&&this._element.classList.remove(this._config.stickyClassName),this._element.style.top=this._prevTop,this._isSticky=!1,EventHandler$1.trigger(this._element,"off.bs.sticky");}}_createWrapper(){if("undefined"==typeof document)return;const t=document.createElement("div");return t.classList.add(CLASS_NAME_WRAPPER),t.style.width="100%",t.style.height=this._element.getBoundingClientRect().height+"px",t.style.overflow="hidden",this._element.parentNode.insertBefore(t,this._element),t.appendChild(this._element),t}_destroyWrapper(){this._wrapper&&(this._wrapper.parentNode.insertBefore(this._element,this._wrapper),this._wrapper.remove());}_getStickySimblings(){return SelectorEngine$1.find(SELECTOR_DATA_TOGGLE$9).filter((t=>{const e=Sticky.getInstance(t);return !(!e||!e._isSticky||t===this._element)}))}_getPositionTop(){let t=0;return this._config.stackable?(this._getStickySimblings().forEach(((e,i)=>{const s=e.getBoundingClientRect();t+=s.height+(0===i?parseFloat(e.style.top):0);})),t):t+this._config.paddingTop}}onDocumentScroll$1((()=>{SelectorEngine$1.find(SELECTOR_DATA_TOGGLE$9).map((t=>{Sticky.getOrCreateInstance(t);}));}));const Sticky$1 = Sticky;

    const SELECTOR_HEADER=".it-header-sticky",SELECTOR_TOGGLER=".custom-navbar-toggler",SELECTOR_CLONED=".cloned-element",dataSet=new Map;class HeaderSticky{constructor(e){if(dataSet.get(e))return null;this._element=e,this._elementObj=Sticky$1.getOrCreateInstance(e),dataSet.set(e,this._elementObj),this._bindEvents(),this._toggleClonedElement(this._element.classList.contains("is-sticky"));}static getOrCreateInstance(e){return dataSet.get(e)||new this(e)}_bindEvents(){this._element.addEventListener("on.bs.sticky",(()=>this._toggleClonedElement(!0))),this._element.addEventListener("off.bs.sticky",(()=>this._toggleClonedElement(!1)));}_toggleClonedElement(e=!0){if(!isVisible(SelectorEngine$1.findOne(SELECTOR_TOGGLER,this._element))){const t=SelectorEngine$1.findOne(".menu-wrapper",this._element);if(e){const e=SelectorEngine$1.findOne(".it-brand-wrapper",this._element),n=SelectorEngine$1.findOne(".it-search-wrapper",this._element),i=SelectorEngine$1.findOne(".it-user-wrapper",this._element),l=e?e.cloneNode(!0):null,s=n?n.cloneNode(!0):null,r=i?i.cloneNode(!0):null;l&&t.insertBefore(l,t.childNodes[0]).classList.add("cloned-element"),s&&t.appendChild(s).classList.add("cloned-element"),r&&(t.appendChild(r).classList.add("cloned-element"),t.appendChild(r).classList.remove("show"));}else SelectorEngine$1.find(SELECTOR_CLONED,this._element).forEach((e=>{e.parentElement.removeChild(e);}));}}}onDocumentScroll$1((()=>{SelectorEngine$1.find(SELECTOR_HEADER).map((e=>{HeaderSticky.getOrCreateInstance(e);}));}));const HeaderSticky$1 = HeaderSticky;

    var __defProp=Object.defineProperty,__defNormalProp=(e,i,s)=>i in e?__defProp(e,i,{enumerable:!0,configurable:!0,writable:!0,value:s}):e[i]=s,__publicField=(e,i,s)=>(__defNormalProp(e,"symbol"!=typeof i?i+"":i,s),s);const EMAIL_REGEXP=/^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/,NUMBER_REGEXP=/^[0-9]+$/,PASSWORD_REGEXP=/^(?=.*[A-Za-z])(?=.*\d).{8,}$/,STRONG_PASSWORD_REGEXP=/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$/,isEmpty=e=>{let i=e;return "string"==typeof e&&(i=e.trim()),!i},isLengthMoreThanMax=(e,i)=>e.length>i,isLengthLessThanMin=(e,i)=>e.length<i,isNumber=e=>NUMBER_REGEXP.test(e),isPassword=e=>PASSWORD_REGEXP.test(e),isStrongPassword=e=>STRONG_PASSWORD_REGEXP.test(e),isNumberMoreThanMax=(e,i)=>e>i,isNumberLessThanMin=(e,i)=>e<i;var Rules=(e=>(e.Required="required",e.Email="email",e.MinLength="minLength",e.MaxLength="maxLength",e.Password="password",e.Number="number",e.MaxNumber="maxNumber",e.MinNumber="minNumber",e.StrongPassword="strongPassword",e.CustomRegexp="customRegexp",e.MinFilesCount="minFilesCount",e.MaxFilesCount="maxFilesCount",e.Files="files",e))(Rules||{}),GroupRules=(e=>(e.Required="required",e))(GroupRules||{}),CustomStyleTagIds=(e=>(e.Label="label",e.LabelArrow="labelArrow",e))(CustomStyleTagIds||{});const defaultDictionary=[{key:Rules.Required,dict:{en:"The field is required"}},{key:Rules.Email,dict:{en:"Email has invalid format"}},{key:Rules.MaxLength,dict:{en:"The field must contain a maximum of :value characters"}},{key:Rules.MinLength,dict:{en:"The field must contain a minimum of :value characters"}},{key:Rules.Password,dict:{en:"Password must contain minimum eight characters, at least one letter and one number"}},{key:Rules.StrongPassword,dict:{en:"Password should contain minimum eight characters, at least one uppercase letter, one lowercase letter, one number and one special character"}},{key:Rules.Number,dict:{en:"Value should be a number"}},{key:Rules.MaxNumber,dict:{en:"Number should be less or equal than :value"}},{key:Rules.MinNumber,dict:{en:"Number should be more or equal than :value"}},{key:Rules.MinFilesCount,dict:{en:"Files count should be more or equal than :value"}},{key:Rules.MaxFilesCount,dict:{en:"Files count should be less or equal than :value"}},{key:Rules.Files,dict:{en:"Uploaded files have one or several invalid properties (extension/size/type etc)."}}],isPromise=e=>"object"==typeof e&&null!==e&&"then"in e&&"function"==typeof e.then,getNodeParents=e=>{let i=e;const s=[];for(;i;)s.unshift(i),i=i.parentNode;return s},getClosestParent=(e,i)=>{const s=[...i].reverse();for(let i=0,t=s.length;i<t;++i){const t=s[i];for(const i in e){const s=e[i];if(s.groupElem===t)return [i,s]}}return null},getClassList=e=>Array.isArray(e)?e.filter((e=>e.length>0)):"string"==typeof e&&e.trim()?[...e.split(" ").filter((e=>e.length>0))]:[],isElement=e=>e instanceof Element||e instanceof HTMLDocument,errorLabelCss=".just-validate-error-label[data-tooltip=true]{position:fixed;padding:4px 8px;background:#423f3f;color:#fff;white-space:nowrap;z-index:10;border-radius:4px;transform:translateY(-5px)}.just-validate-error-label[data-tooltip=true]:before{content:'';width:0;height:0;border-left:solid 5px transparent;border-right:solid 5px transparent;border-bottom:solid 5px #423f3f;position:absolute;z-index:3;display:block;bottom:-5px;transform:rotate(180deg);left:calc(50% - 5px)}.just-validate-error-label[data-tooltip=true][data-direction=left]{transform:translateX(-5px)}.just-validate-error-label[data-tooltip=true][data-direction=left]:before{right:-7px;bottom:auto;left:auto;top:calc(50% - 2px);transform:rotate(90deg)}.just-validate-error-label[data-tooltip=true][data-direction=right]{transform:translateX(5px)}.just-validate-error-label[data-tooltip=true][data-direction=right]:before{right:auto;bottom:auto;left:-7px;top:calc(50% - 2px);transform:rotate(-90deg)}.just-validate-error-label[data-tooltip=true][data-direction=bottom]{transform:translateY(5px)}.just-validate-error-label[data-tooltip=true][data-direction=bottom]:before{right:auto;bottom:auto;left:calc(50% - 5px);top:-5px;transform:rotate(0)}",defaultGlobalConfig={errorFieldStyle:{color:"#b81111",border:"1px solid #B81111"},errorFieldCssClass:"just-validate-error-field",successFieldCssClass:"just-validate-success-field",errorLabelStyle:{color:"#b81111"},errorLabelCssClass:"just-validate-error-label",successLabelCssClass:"just-validate-success-label",focusInvalidField:!0,lockForm:!0,testingMode:!1,validateBeforeSubmitting:!1};class JustValidate{constructor(e,i,s){__publicField(this,"form",null),__publicField(this,"fields",{}),__publicField(this,"groupFields",{}),__publicField(this,"errors",{}),__publicField(this,"isValid",!1),__publicField(this,"isSubmitted",!1),__publicField(this,"globalConfig",defaultGlobalConfig),__publicField(this,"errorLabels",{}),__publicField(this,"successLabels",{}),__publicField(this,"eventListeners",[]),__publicField(this,"dictLocale",defaultDictionary),__publicField(this,"currentLocale","en"),__publicField(this,"customStyleTags",{}),__publicField(this,"onSuccessCallback"),__publicField(this,"onFailCallback"),__publicField(this,"tooltips",[]),__publicField(this,"lastScrollPosition"),__publicField(this,"isScrollTick"),__publicField(this,"fieldIds",new Map),__publicField(this,"getKeyByFieldSelector",(e=>this.fieldIds.get(e))),__publicField(this,"getFieldSelectorByKey",(e=>{for(const[i,s]of this.fieldIds)if(e===s)return i})),__publicField(this,"setKeyByFieldSelector",(e=>{if(this.fieldIds.has(e))return this.fieldIds.get(e);const i=String(this.fieldIds.size+1);return this.fieldIds.set(e,i),i})),__publicField(this,"refreshAllTooltips",(()=>{this.tooltips.forEach((e=>{e.refresh();}));})),__publicField(this,"handleDocumentScroll",(()=>{this.lastScrollPosition=window.scrollY,this.isScrollTick||(window.requestAnimationFrame((()=>{this.refreshAllTooltips(),this.isScrollTick=!1;})),this.isScrollTick=!0);})),__publicField(this,"formSubmitHandler",(e=>{e.preventDefault(),this.isSubmitted=!0,this.validateHandler(e);})),__publicField(this,"handleFieldChange",(e=>{let i;for(const s in this.fields){if(this.fields[s].elem===e){i=s;break}}i&&this.validateField(i,!0);})),__publicField(this,"handleGroupChange",(e=>{let i,s;for(const t in this.groupFields){const l=this.groupFields[t];if(l.elems.find((i=>i===e))){i=l,s=t;break}}i&&s&&this.validateGroup(s,i);})),__publicField(this,"handlerChange",(e=>{e.target&&(this.handleFieldChange(e.target),this.handleGroupChange(e.target),this.renderErrors());})),this.initialize(e,i,s);}initialize(e,i,s){if(this.form=null,this.errors={},this.isValid=!1,this.isSubmitted=!1,this.globalConfig=defaultGlobalConfig,this.errorLabels={},this.successLabels={},this.eventListeners=[],this.customStyleTags={},this.tooltips=[],this.currentLocale="en","string"==typeof e){const i=document.querySelector(e);if(!i)throw Error(`Form with ${e} selector not found! Please check the form selector`);this.setForm(i);}else {if(!(e instanceof HTMLFormElement))throw Error("Form selector is not valid. Please specify a string selector or a DOM element.");this.setForm(e);}if(this.globalConfig={...defaultGlobalConfig,...i},s&&(this.dictLocale=[...s,...defaultDictionary]),this.isTooltip()){const e=document.createElement("style");e.textContent=errorLabelCss,this.customStyleTags[CustomStyleTagIds.Label]=document.head.appendChild(e),this.addListener("scroll",document,this.handleDocumentScroll);}}getLocalisedString(e,i,s){var t;const l=null!=s?s:e;let r=null==(t=this.dictLocale.find((e=>e.key===l)))?void 0:t.dict[this.currentLocale];if(r||s&&(r=s),r&&void 0!==i)switch(e){case Rules.MaxLength:case Rules.MinLength:case Rules.MaxNumber:case Rules.MinNumber:case Rules.MinFilesCount:case Rules.MaxFilesCount:r=r.replace(":value",String(i));}return r||s||"Value is incorrect"}getFieldErrorMessage(e,i){const s="function"==typeof e.errorMessage?e.errorMessage(this.getElemValue(i),this.fields):e.errorMessage;return this.getLocalisedString(e.rule,e.value,s)}getFieldSuccessMessage(e,i){const s="function"==typeof e?e(this.getElemValue(i),this.fields):e;return this.getLocalisedString(void 0,void 0,s)}getGroupErrorMessage(e){return this.getLocalisedString(e.rule,void 0,e.errorMessage)}getGroupSuccessMessage(e){if(e.successMessage)return this.getLocalisedString(void 0,void 0,e.successMessage)}setFieldInvalid(e,i){this.fields[e].isValid=!1,this.fields[e].errorMessage=this.getFieldErrorMessage(i,this.fields[e].elem);}setFieldValid(e,i){this.fields[e].isValid=!0,void 0!==i&&(this.fields[e].successMessage=this.getFieldSuccessMessage(i,this.fields[e].elem));}setGroupInvalid(e,i){this.groupFields[e].isValid=!1,this.groupFields[e].errorMessage=this.getGroupErrorMessage(i);}setGroupValid(e,i){this.groupFields[e].isValid=!0,this.groupFields[e].successMessage=this.getGroupSuccessMessage(i);}getElemValue(e){switch(e.type){case"checkbox":return e.checked;case"file":return e.files;default:return e.value}}validateGroupRule(e,i,s){if(s.rule===GroupRules.Required)i.every((e=>!e.checked))?this.setGroupInvalid(e,s):this.setGroupValid(e,s);}validateFieldRule(e,i,s,t=!1){const l=s.value,r=this.getElemValue(i);if(s.plugin){s.plugin(r,this.fields)||this.setFieldInvalid(e,s);}else {switch(s.rule){case Rules.Required:isEmpty(r)&&this.setFieldInvalid(e,s);break;case Rules.Email:if("string"!=typeof r){this.setFieldInvalid(e,s);break}o=r,EMAIL_REGEXP.test(o)||this.setFieldInvalid(e,s);break;case Rules.MaxLength:if(void 0===l){console.error(`Value for ${s.rule} rule for [${e}] field is not defined. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if("number"!=typeof l){console.error(`Value for ${s.rule} rule for [${e}] should be a number. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if("string"!=typeof r){this.setFieldInvalid(e,s);break}if(""===r)break;isLengthMoreThanMax(r,l)&&this.setFieldInvalid(e,s);break;case Rules.MinLength:if(void 0===l){console.error(`Value for ${s.rule} rule for [${e}] field is not defined. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if("number"!=typeof l){console.error(`Value for ${s.rule} rule for [${e}] should be a number. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if("string"!=typeof r){this.setFieldInvalid(e,s);break}if(""===r)break;isLengthLessThanMin(r,l)&&this.setFieldInvalid(e,s);break;case Rules.Password:if("string"!=typeof r){this.setFieldInvalid(e,s);break}if(""===r)break;isPassword(r)||this.setFieldInvalid(e,s);break;case Rules.StrongPassword:if("string"!=typeof r){this.setFieldInvalid(e,s);break}if(""===r)break;isStrongPassword(r)||this.setFieldInvalid(e,s);break;case Rules.Number:if("string"!=typeof r){this.setFieldInvalid(e,s);break}if(""===r)break;isNumber(r)||this.setFieldInvalid(e,s);break;case Rules.MaxNumber:{if(void 0===l){console.error(`Value for ${s.rule} rule for [${e}] field is not defined. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if("number"!=typeof l){console.error(`Value for ${s.rule} rule for [${e}] field should be a number. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if("string"!=typeof r){this.setFieldInvalid(e,s);break}if(""===r)break;const i=+r;(Number.isNaN(i)||isNumberMoreThanMax(i,l))&&this.setFieldInvalid(e,s);break}case Rules.MinNumber:{if(void 0===l){console.error(`Value for ${s.rule} rule for [${e}] field is not defined. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if("number"!=typeof l){console.error(`Value for ${s.rule} rule for [${e}] field should be a number. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if("string"!=typeof r){this.setFieldInvalid(e,s);break}if(""===r)break;const i=+r;(Number.isNaN(i)||isNumberLessThanMin(i,l))&&this.setFieldInvalid(e,s);break}case Rules.CustomRegexp:{if(void 0===l)return console.error(`Value for ${s.rule} rule for [${e}] field is not defined. This field will be always invalid.`),void this.setFieldInvalid(e,s);let i;try{i=new RegExp(l);}catch(i){console.error(`Value for ${s.rule} rule for [${e}] should be a valid regexp. This field will be always invalid.`),this.setFieldInvalid(e,s);break}const t=String(r);""===t||i.test(t)||this.setFieldInvalid(e,s);break}case Rules.MinFilesCount:if(void 0===l){console.error(`Value for ${s.rule} rule for [${e}] field is not defined. This field will be always invalid.`),this.setFieldInvalid(e,s);break}if("number"!=typeof l){console.error(`Value for ${s.rule} rule for [${e}] field should be a number. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if(Number.isFinite(null==r?void 0:r.length)&&r.length<l){this.setFieldInvalid(e,s);break}break;case Rules.MaxFilesCount:if(void 0===l){console.error(`Value for ${s.rule} rule for [${e}] field is not defined. This field will be always invalid.`),this.setFieldInvalid(e,s);break}if("number"!=typeof l){console.error(`Value for ${s.rule} rule for [${e}] field should be a number. The field will be always invalid.`),this.setFieldInvalid(e,s);break}if(Number.isFinite(null==r?void 0:r.length)&&r.length>l){this.setFieldInvalid(e,s);break}break;case Rules.Files:{if(void 0===l)return console.error(`Value for ${s.rule} rule for [${e}] field is not defined. This field will be always invalid.`),void this.setFieldInvalid(e,s);if("object"!=typeof l)return console.error(`Value for ${s.rule} rule for [${e}] field should be an object. This field will be always invalid.`),void this.setFieldInvalid(e,s);const i=l.files;if("object"!=typeof i)return console.error(`Value for ${s.rule} rule for [${e}] field should be an object with files array. This field will be always invalid.`),void this.setFieldInvalid(e,s);const t=(e,i)=>{const s=Number.isFinite(i.minSize)&&e.size<i.minSize,t=Number.isFinite(i.maxSize)&&e.size>i.maxSize,l=Array.isArray(i.names)&&!i.names.includes(e.name),r=Array.isArray(i.extensions)&&!i.extensions.includes(e.name.split(".")[e.name.split(".").length-1]),o=Array.isArray(i.types)&&!i.types.includes(e.type);return s||t||l||r||o};if("object"==typeof r&&null!==r)for(let l=0,o=r.length;l<o;++l){const o=r.item(l);if(!o){this.setFieldInvalid(e,s);break}if(t(o,i)){this.setFieldInvalid(e,s);break}}break}default:{if("function"!=typeof s.validator)return console.error(`Validator for custom rule for [${e}] field should be a function. This field will be always invalid.`),void this.setFieldInvalid(e,s);const i=s.validator(r,this.fields);if("boolean"!=typeof i&&"function"!=typeof i&&console.error(`Validator return value for [${e}] field should be boolean or function. It will be cast to boolean.`),"function"==typeof i){if(!t){this.fields[e].asyncCheckPending=!1;const t=i();return isPromise(t)?t.then((i=>{i||this.setFieldInvalid(e,s);})).catch((()=>{this.setFieldInvalid(e,s);})):(console.error(`Validator function for custom rule for [${e}] field should return a Promise. This field will be always invalid.`),void this.setFieldInvalid(e,s))}this.fields[e].asyncCheckPending=!0;}i||this.setFieldInvalid(e,s);}}var o;}}validateField(e,i=!1){var s;const t=this.fields[e];t.isValid=!0;const l=[];return [...t.rules].reverse().forEach((s=>{const r=this.validateFieldRule(e,t.elem,s,i);isPromise(r)&&l.push(r);})),t.isValid&&this.setFieldValid(e,null==(s=t.config)?void 0:s.successMessage),Promise.allSettled(l)}revalidateField(e){if("string"!=typeof e&&!isElement(e))throw Error("Field selector is not valid. Please specify a string selector or a valid DOM element.");const i=this.getKeyByFieldSelector(e);return i&&this.fields[i]?new Promise((e=>{this.validateField(i,!0).finally((()=>{this.clearFieldStyle(i),this.clearFieldLabel(i),this.renderFieldError(i),e(!!this.fields[i].isValid);}));})):(console.error("Field not found. Check the field selector."),Promise.reject())}validateGroup(e,i){const s=[];return [...i.rules].reverse().forEach((t=>{const l=this.validateGroupRule(e,i.elems,t);isPromise(l)&&s.push(l);})),Promise.allSettled(s)}focusInvalidField(){for(const e in this.fields){const i=this.fields[e];if(!i.isValid){setTimeout((()=>i.elem.focus()),0);break}}}afterSubmitValidation(e=!1){this.renderErrors(e),this.globalConfig.focusInvalidField&&this.focusInvalidField();}validate(e=!1){return new Promise((i=>{const s=[];Object.keys(this.fields).forEach((e=>{const i=this.validateField(e);isPromise(i)&&s.push(i);})),Object.keys(this.groupFields).forEach((e=>{const i=this.groupFields[e],t=this.validateGroup(e,i);isPromise(t)&&s.push(t);})),s.length?Promise.allSettled(s).then((()=>{this.afterSubmitValidation(e),i(!0);})):(this.afterSubmitValidation(e),i(!1));}))}revalidate(){return new Promise((e=>{this.validateHandler(void 0,!0).finally((()=>{this.globalConfig.focusInvalidField&&this.focusInvalidField(),e(this.isValid);}));}))}validateHandler(e,i=!1){return this.globalConfig.lockForm&&this.lockForm(),this.validate(i).finally((()=>{var i,s;this.globalConfig.lockForm&&this.unlockForm(),this.isValid?null==(i=this.onSuccessCallback)||i.call(this,e):null==(s=this.onFailCallback)||s.call(this,this.fields,this.groupFields);}))}setForm(e){this.form=e,this.form.setAttribute("novalidate","novalidate"),this.removeListener("submit",this.form,this.formSubmitHandler),this.addListener("submit",this.form,this.formSubmitHandler);}addListener(e,i,s){i.addEventListener(e,s),this.eventListeners.push({type:e,elem:i,func:s});}removeListener(e,i,s){i.removeEventListener(e,s),this.eventListeners=this.eventListeners.filter((s=>s.type!==e||s.elem!==i));}addField(e,i,s){if("string"!=typeof e&&!isElement(e))throw Error("Field selector is not valid. Please specify a string selector or a valid DOM element.");let t;if(t="string"==typeof e?this.form.querySelector(e):e,!t)throw Error("Field doesn't exist in the DOM! Please check the field selector.");if(!Array.isArray(i)||!i.length)throw Error("Rules argument should be an array and should contain at least 1 element.");i.forEach((e=>{if(!("rule"in e||"validator"in e||"plugin"in e))throw Error("Rules argument must contain at least one rule or validator property.");if(!(e.validator||e.plugin||e.rule&&Object.values(Rules).includes(e.rule)))throw Error(`Rule should be one of these types: ${Object.values(Rules).join(", ")}. Provided value: ${e.rule}`)}));const l=this.setKeyByFieldSelector(e);return this.fields[l]={elem:t,rules:i,isValid:void 0,config:s},this.setListeners(t),this.isSubmitted&&this.validate(),this}removeField(e){if("string"!=typeof e&&!isElement(e))throw Error("Field selector is not valid. Please specify a string selector or a valid DOM element.");const i=this.getKeyByFieldSelector(e);if(!i||!this.fields[i])return console.error("Field not found. Check the field selector."),this;const s=this.getListenerType(this.fields[i].elem.type);return this.removeListener(s,this.fields[i].elem,this.handlerChange),this.clearErrors(),delete this.fields[i],this}removeGroup(e){if("string"!=typeof e)throw Error("Group selector is not valid. Please specify a string selector.");const i=this.getKeyByFieldSelector(e);return i&&this.groupFields[i]?(this.groupFields[i].elems.forEach((e=>{const i=this.getListenerType(e.type);this.removeListener(i,e,this.handlerChange);})),this.clearErrors(),delete this.groupFields[i],this):(console.error("Group not found. Check the group selector."),this)}addRequiredGroup(e,i,s,t){if("string"!=typeof e)throw Error("Group selector is not valid. Please specify a string selector.");const l=this.form.querySelector(e);if(!l)throw Error(`Group with ${e} selector not found! Please check the group selector.`);const r=l.querySelectorAll("input"),o=Array.from(r).filter((e=>{const i=getClosestParent(this.groupFields,getNodeParents(e));return !i||i[1].elems.find((i=>i!==e))})),a=this.setKeyByFieldSelector(e);return this.groupFields[a]={rules:[{rule:GroupRules.Required,errorMessage:i,successMessage:t}],groupElem:l,elems:o,isDirty:!1,isValid:void 0,config:s},r.forEach((e=>{this.setListeners(e);})),this}getListenerType(e){switch(e){case"checkbox":case"select-one":case"file":case"radio":return "change";default:return "input"}}setListeners(e){const i=this.getListenerType(e.type);this.removeListener(i,e,this.handlerChange),this.addListener(i,e,this.handlerChange);}clearFieldLabel(e){var i,s;null==(i=this.errorLabels[e])||i.remove(),null==(s=this.successLabels[e])||s.remove();}clearFieldStyle(e){var i,s,t,l;const r=this.fields[e],o=(null==(i=r.config)?void 0:i.errorFieldStyle)||this.globalConfig.errorFieldStyle;Object.keys(o).forEach((e=>{r.elem.style[e]="";}));const a=(null==(s=r.config)?void 0:s.successFieldStyle)||this.globalConfig.successFieldStyle||{};Object.keys(a).forEach((e=>{r.elem.style[e]="";})),r.elem.classList.remove(...getClassList((null==(t=r.config)?void 0:t.errorFieldCssClass)||this.globalConfig.errorFieldCssClass),...getClassList((null==(l=r.config)?void 0:l.successFieldCssClass)||this.globalConfig.successFieldCssClass));}clearErrors(){var e,i;Object.keys(this.errorLabels).forEach((e=>this.errorLabels[e].remove())),Object.keys(this.successLabels).forEach((e=>this.successLabels[e].remove()));for(const e in this.fields)this.clearFieldStyle(e);for(const s in this.groupFields){const t=this.groupFields[s],l=(null==(e=t.config)?void 0:e.errorFieldStyle)||this.globalConfig.errorFieldStyle;Object.keys(l).forEach((e=>{t.elems.forEach((i=>{var s;i.style[e]="",i.classList.remove(...getClassList((null==(s=t.config)?void 0:s.errorFieldCssClass)||this.globalConfig.errorFieldCssClass));}));}));const r=(null==(i=t.config)?void 0:i.successFieldStyle)||this.globalConfig.successFieldStyle||{};Object.keys(r).forEach((e=>{t.elems.forEach((i=>{var s;i.style[e]="",i.classList.remove(...getClassList((null==(s=t.config)?void 0:s.successFieldCssClass)||this.globalConfig.successFieldCssClass));}));}));}this.tooltips=[];}isTooltip(){return !!this.globalConfig.tooltip}lockForm(){const e=this.form.querySelectorAll("input, textarea, button, select");for(let i=0,s=e.length;i<s;++i)e[i].setAttribute("data-just-validate-fallback-disabled",e[i].disabled?"true":"false"),e[i].setAttribute("disabled","disabled"),e[i].style.pointerEvents="none",e[i].style.webkitFilter="grayscale(100%)",e[i].style.filter="grayscale(100%)";}unlockForm(){const e=this.form.querySelectorAll("input, textarea, button, select");for(let i=0,s=e.length;i<s;++i)"true"!==e[i].getAttribute("data-just-validate-fallback-disabled")&&e[i].removeAttribute("disabled"),e[i].style.pointerEvents="",e[i].style.webkitFilter="",e[i].style.filter="";}renderTooltip(e,i,s){var t;const{top:l,left:r,width:o,height:a}=e.getBoundingClientRect(),n=i.getBoundingClientRect(),d=s||(null==(t=this.globalConfig.tooltip)?void 0:t.position);switch(d){case"left":i.style.top=l+a/2-n.height/2+"px",i.style.left=r-n.width-5+"px";break;case"top":i.style.top=l-n.height-5+"px",i.style.left=r+o/2-n.width/2+"px";break;case"right":i.style.top=l+a/2-n.height/2+"px",i.style.left=`${r+o+5}px`;break;case"bottom":i.style.top=`${l+a+5}px`,i.style.left=r+o/2-n.width/2+"px";}i.dataset.direction=d;return {refresh:()=>{this.renderTooltip(e,i,s);}}}createErrorLabelElem(e,i,s){const t=document.createElement("div");t.innerHTML=i;const l=this.isTooltip()?null==s?void 0:s.errorLabelStyle:(null==s?void 0:s.errorLabelStyle)||this.globalConfig.errorLabelStyle;return Object.assign(t.style,l),t.classList.add(...getClassList((null==s?void 0:s.errorLabelCssClass)||this.globalConfig.errorLabelCssClass),"just-validate-error-label"),this.isTooltip()&&(t.dataset.tooltip="true"),this.globalConfig.testingMode&&(t.dataset.testId=`error-label-${e}`),this.errorLabels[e]=t,t}createSuccessLabelElem(e,i,s){if(void 0===i)return null;const t=document.createElement("div");t.innerHTML=i;const l=(null==s?void 0:s.successLabelStyle)||this.globalConfig.successLabelStyle;return Object.assign(t.style,l),t.classList.add(...getClassList((null==s?void 0:s.successLabelCssClass)||this.globalConfig.successLabelCssClass),"just-validate-success-label"),this.globalConfig.testingMode&&(t.dataset.testId=`success-label-${e}`),this.successLabels[e]=t,t}renderErrorsContainer(e,i){const s=i||this.globalConfig.errorsContainer;if("string"==typeof s){const i=this.form.querySelector(s);if(i)return i.appendChild(e),!0;console.error(`Error container with ${s} selector not found. Errors will be rendered as usual`);}return s instanceof Element?(s.appendChild(e),!0):(void 0!==s&&console.error("Error container not found. It should be a string or existing Element. Errors will be rendered as usual"),!1)}renderGroupLabel(e,i,s,t){if(!t){if(this.renderErrorsContainer(i,s))return}e.appendChild(i);}renderFieldLabel(e,i,s,t){var l,r,o,a,n,d,u;if(!t){if(this.renderErrorsContainer(i,s))return}if("checkbox"===e.type||"radio"===e.type){const s=document.querySelector(`label[for="${e.getAttribute("id")}"]`);"label"===(null==(r=null==(l=e.parentElement)?void 0:l.tagName)?void 0:r.toLowerCase())?null==(a=null==(o=e.parentElement)?void 0:o.parentElement)||a.appendChild(i):s?null==(n=s.parentElement)||n.appendChild(i):null==(d=e.parentElement)||d.appendChild(i);}else null==(u=e.parentElement)||u.appendChild(i);}showLabels(e,i){Object.keys(e).forEach(((s,t)=>{const l=e[s],r=this.getKeyByFieldSelector(s);if(!r||!this.fields[r])return void console.error("Field not found. Check the field selector.");const o=this.fields[r];o.isValid=!i,this.clearFieldStyle(r),this.clearFieldLabel(r),this.renderFieldError(r,l),0===t&&this.globalConfig.focusInvalidField&&setTimeout((()=>o.elem.focus()),0);}));}showErrors(e){if("object"!=typeof e)throw Error("[showErrors]: Errors should be an object with key: value format");this.showLabels(e,!0);}showSuccessLabels(e){if("object"!=typeof e)throw Error("[showSuccessLabels]: Labels should be an object with key: value format");this.showLabels(e,!1);}renderFieldError(e,i){var s,t,l,r,o,a;const n=this.fields[e];if(void 0===n.isValid)return;if(n.isValid){if(!n.asyncCheckPending){const l=this.createSuccessLabelElem(e,void 0!==i?i:n.successMessage,n.config);l&&this.renderFieldLabel(n.elem,l,null==(s=n.config)?void 0:s.errorsContainer,!0),n.elem.classList.add(...getClassList((null==(t=n.config)?void 0:t.successFieldCssClass)||this.globalConfig.successFieldCssClass));}return}this.isValid=!1,n.elem.classList.add(...getClassList((null==(l=n.config)?void 0:l.errorFieldCssClass)||this.globalConfig.errorFieldCssClass));const d=this.createErrorLabelElem(e,void 0!==i?i:n.errorMessage,n.config);this.renderFieldLabel(n.elem,d,null==(r=n.config)?void 0:r.errorsContainer),this.isTooltip()&&this.tooltips.push(this.renderTooltip(n.elem,d,null==(a=null==(o=n.config)?void 0:o.tooltip)?void 0:a.position));}renderGroupError(e){var i,s,t,l;const r=this.groupFields[e];if(void 0===r.isValid)return;if(r.isValid){r.elems.forEach((e=>{var i,s;Object.assign(e.style,(null==(i=r.config)?void 0:i.successFieldStyle)||this.globalConfig.successFieldStyle),e.classList.add(...getClassList((null==(s=r.config)?void 0:s.successFieldCssClass)||this.globalConfig.successFieldCssClass));}));const s=this.createSuccessLabelElem(e,r.successMessage,r.config);return void(s&&this.renderGroupLabel(r.groupElem,s,null==(i=r.config)?void 0:i.errorsContainer,!0))}this.isValid=!1,r.elems.forEach((e=>{var i,s;Object.assign(e.style,(null==(i=r.config)?void 0:i.errorFieldStyle)||this.globalConfig.errorFieldStyle),e.classList.add(...getClassList((null==(s=r.config)?void 0:s.errorFieldCssClass)||this.globalConfig.errorFieldCssClass));}));const o=this.createErrorLabelElem(e,r.errorMessage,r.config);this.renderGroupLabel(r.groupElem,o,null==(s=r.config)?void 0:s.errorsContainer),this.isTooltip()&&this.tooltips.push(this.renderTooltip(r.groupElem,o,null==(l=null==(t=r.config)?void 0:t.tooltip)?void 0:l.position));}renderErrors(e=!1){if(this.isSubmitted||e||this.globalConfig.validateBeforeSubmitting){this.clearErrors(),this.isValid=!0;for(const e in this.groupFields)this.renderGroupError(e);for(const e in this.fields)this.renderFieldError(e);}}destroy(){this.eventListeners.forEach((e=>{this.removeListener(e.type,e.elem,e.func);})),Object.keys(this.customStyleTags).forEach((e=>{this.customStyleTags[e].remove();})),this.clearErrors(),this.globalConfig.lockForm&&this.unlockForm();}refresh(){this.destroy(),this.form?(this.initialize(this.form,this.globalConfig),Object.keys(this.fields).forEach((e=>{const i=this.getFieldSelectorByKey(e);i&&this.addField(i,[...this.fields[e].rules],this.fields[e].config);}))):console.error("Cannot initialize the library! Form is not defined");}setCurrentLocale(e){"string"==typeof e||void 0===e?(this.currentLocale=e,this.isSubmitted&&this.validate()):console.error("Current locale should be a string");}onSuccess(e){return this.onSuccessCallback=e,this}onFail(e){return this.onFailCallback=e,this}}

    class CssClassObserver{constructor(t,e,s,a,l){this.targetNode=t,this.classToWatch=e,this.classAddedCallback=s,this.classRemovedCallback=a,this.observer=null,this.lastClassState=t.classList.contains(this.classToWatch),this.ignoreToggle=!!l,this.init();}init(){this.observer=new MutationObserver((t=>this.mutationCallback(t))),this.observe();}observe(){this.observer.observe(this.targetNode,{attributes:!0});}disconnect(){this.observer.disconnect();}mutationCallback(t){for(let e of t)if("attributes"===e.type&&"class"===e.attributeName){let t=e.target.classList.contains(this.classToWatch);(this.ignoreToggle||this.lastClassState!==t)&&(this.lastClassState=t,t?"function"==typeof this.classAddedCallback&&this.classAddedCallback():"function"==typeof this.classRemovedCallback&&this.classRemovedCallback());}}}class ContentObserver{constructor(t,e,s,a){this.targetNode=t,this.contentSelector=e,this.contentAddedCallback=s,this.contentRemovedCallback=a,this.observer=null,this.init();}init(){this.observer=new MutationObserver((t=>this.mutationCallback(t))),this.observe();}observe(){this.observer.observe(this.targetNode,{childList:!0,subtree:!0});}disconnect(){this.observer.disconnect();}mutationCallback(t){for(let e of t)"childList"===e.type&&(e.addedNodes.forEach((t=>{this._callbackExec(t);})),e.removedNodes.forEach((t=>{this._callbackExec(t,!0);})));}_callbackExec(t,e){const s=t.matches&&t.matches(this.contentSelector)?[t]:t.querySelectorAll?t.querySelectorAll(this.contentSelector):null,a=e&&"function"==typeof this.contentRemovedCallback?this.contentRemovedCallback:"function"==typeof this.contentAddedCallback?this.contentAddedCallback:null;s&&a&&s.forEach((t=>a(t)));}}

    const CONFIG_DEFAULT={errorFieldCssClass:"is-invalid",errorLabelCssClass:"just-validate-error-label"},NAME$u="justvalidatebi",CLASS_NAME_SRONLY="sr-only-justvalidate-bi",SELECTOR_SPAN_SRONLY=`.${CLASS_NAME_SRONLY}`;class FormValidate{constructor(e,t){return this.formSelector=e,this.target=document.querySelector(e),this.validate=new JustValidate(e,t),this.config=Object.assign({},CONFIG_DEFAULT,this.validate.globalConfig),this.formItems=[],this.init(),this.validate}init(){this.target.querySelectorAll("input, select").forEach((e=>{const t=new CssClassObserver(e,this.config.errorFieldCssClass,(()=>this.onInputError(e)),(()=>this.onInputErrorRemove(e)),!0);e.id||e.setAttribute("id",NAME$u+"-input-"+Math.random()),this.formItems.push({item:e,watcher:t});}));this.target.querySelectorAll("fieldset").forEach((e=>{if(e.querySelectorAll("input[type=radio],input[type=checkbox]").length>0){const t=new ContentObserver(e,"."+this.config.errorLabelCssClass,(()=>this.onFieldsetError(e)),(()=>this.onFieldsetErrorRemove(e)));e.id||e.setAttribute("id",NAME$u+"-fieldset-"+Math.random()),this.formItems.push({item:e,watcher:t});}}));}onInputError(e){const t=this.getErrorMessages(e),r=[];t.forEach(((t,s)=>{const i=e.id+"-error-"+s;t.setAttribute("id",i),r.push(i);})),r.length>0&&(e.setAttribute("aria-describedby",r.join(" ")),e.setAttribute("aria-invalid","true"));}onInputErrorRemove(e){e.removeAttribute("aria-describedby"),e.setAttribute("aria-invalid","false");}onFieldsetError(e){const t=this.getErrorMessages(e),r=[],s=[];if(t.forEach(((t,i)=>{const o=e.id+"-error-"+i;t.setAttribute("id",o),r.push(o),s.push(t.textContent);})),r.length>0){const t=e.querySelector("legend");t&&(t.setAttribute("aria-describedby",r.join(" ")),t.setAttribute("aria-invalid","true"));}}onFieldsetErrorRemove(e){const t=e.querySelector("legend");if(t){t.removeAttribute("aria-describedby"),t.setAttribute("aria-invalid","false");const e=t.querySelector(SELECTOR_SPAN_SRONLY);e&&e.remove();}}getErrorMessages(e){let t=e,r=t.querySelectorAll("."+this.config.errorLabelCssClass);for(;null!=t&&0===r.length;)t=t.parentNode,r=t.querySelectorAll("."+this.config.errorLabelCssClass);return r}}const ValidatorSelectAutocomplete=(e,t={})=>(r,s)=>{let i=!1;const o=s[e];if(!o)throw new Error("ValidatorSelectAutocomplete: "+e+" not found as form field");return t.required||r?document.querySelector("#"+o.elem.id+"-select").querySelectorAll("option").forEach((e=>{e.text===r&&(i=!0);})):i=!0,i};

    const NAME$t="input",EVENT_CHANGE="change.bs.input";class Input extends BaseComponent{constructor(e){super(e),this._label=new InputLabel$1(e),this._bindEvents();}static get NAME(){return NAME$t}_bindEvents(){"file"===this._element.getAttribute("type")&&EventHandler$1.on(this._element,EVENT_CHANGE,(()=>{this._handleFileDescription();}));}_handleFileDescription(){const e=[];let t="";Array.from(this._element.files).forEach((t=>{const n=Math.round(parseInt(t.size,10)/1024);e.push(t.name+" ("+n+"kb)");})),this._element.files.length>1&&(t=this._element.files.length+" file da caricare: ");const n=SelectorEngine$1.findOne('label[for="'+this._element.getAttribute("id")+'"] label.form-file-name',this._element);n&&(n.innerText=t+e.join("; "));}}const excludes=["select",'input[data-bs-input][type="password"]',"input.input-password[data-bs-input]",'input[data-bs-autocomplete][type="search"]','input[type="time"]','input[type="radio"]','input[type="checkbox"]'],createInput$2=e=>{const t=!!excludes.find((t=>e.matches(t))),n=!("number"!==e.getAttribute("type")||!e.parentNode.querySelector('button[class^="input-number-"]'));return t||n?null:Input.getOrCreateInstance(e)};"undefined"!=typeof document&&document.addEventListener("DOMContentLoaded",(function(){document.querySelectorAll("input, textarea, label").forEach((function(e){const t=InputLabel$1.getInputFromLabel(e)||e;createInput$2(t);}));}));const Input$1 = Input;

    const NAME$s="selectautocomplete";function onClassChange(e,t){const o=new MutationObserver((e=>{e.forEach((e=>{"attributes"===e.type&&"class"===e.attributeName&&t(e.target);}));}));return o.observe(e,{attributes:!0}),o.disconnect}class SelectAutocomplete extends BaseComponent{constructor(e,t){super(e),this._hasFormControl=e.classList.contains("form-control"),this.element_original_id=this._element.id,this._config=t,this._enhance();}static get NAME(){return NAME$s}_enhance(){accessibleAutocomplete__default.default.enhanceSelectElement(Object.assign({},{selectElement:this._element},this._config)),setTimeout((()=>{if(this._hasFormControl){if("undefined"==typeof document)return;const e=document.getElementById(this.element_original_id);e.classList.add("form-control"),onClassChange(e,(e=>{e.classList.contains("form-control")||e.classList.add("form-control");}));}}),100);}}const SelectAutocomplete$1 = SelectAutocomplete;

    const NAME$r="inputsearchautocomplete",DATA_KEY$7="bs.inputsearchautocomplete",EVENT_KEY$9=`.${DATA_KEY$7}`,Default$j={autocomplete:[]},EVENT_KEYUP$1=`keyup${EVENT_KEY$9}`,CLASS_NAME_SHOW$1="autocomplete-list-show",DATA_AUTOCOMPLETE="data-bs-autocomplete",SELECTOR_SEARCH='input[data-bs-autocomplete][type="search"]';class InputSearch extends BaseComponent{constructor(e,t){super(e),this._config=this._getConfig(t),this._items=[],this._autocompleteElement=null,this._label=new InputLabel$1(e),this._init(),this._bindEvents();}static get NAME(){return NAME$r}search(){const e=this._element.value;
    //!!! $autocomplete.empty()
    this._autocompleteElement.innerHTML="",e?this._items.forEach((t=>{let n=new RegExp("("+e+")","gi"),o=t.text.replace(n,"<mark>$1</mark>"),a=t.label?"<em>"+t.label+"</em>":"",s=t.icon?t.icon:"",l=t.link?t.link:"#";-1!==o.toLowerCase().indexOf(e.toLowerCase())&&(this._autocompleteElement.classList.add(CLASS_NAME_SHOW$1),this._autocompleteElement.appendChild(this._createOption(l,o,a,s)));})):this._autocompleteElement.classList.remove(CLASS_NAME_SHOW$1);}_getConfig(e){return e={...Default$j,..."object"==typeof e?e:{}}}_getItems(){try{return JSON.parse(this._element.getAttribute(DATA_AUTOCOMPLETE))}catch(e){return console.error("[InputSearchAutocomplete] invalid data provided for data-bs-autocomplete attribute",e),[]}}_init(){if(this._element.classList.contains("autocomplete")){if("undefined"==typeof document)return;this._items=this._getItems(),this._autocompleteElement=document.createElement("ul"),this._autocompleteElement.classList.add("autocomplete-list"),this._element.parentNode.insertBefore(this._autocompleteElement,this._element.nextSibling);}}_bindEvents(){EventHandler$1.on(this._element,EVENT_KEYUP$1,(()=>this.search()));}_createOption(e,t,n,o){if("undefined"==typeof document)return;const a=document.createElement("li");return a.innerHTML=`<a href="${e}">\n        ${o}\n        <span class="autocomplete-list-text">\n          <span>${t}</span>\n          ${n}\n        </span>\n      </a>`,a}}"undefined"!=typeof document&&document.addEventListener("DOMContentLoaded",(function(){document.querySelectorAll(SELECTOR_SEARCH+", label").forEach((function(e){const t=InputLabel$1.getInputFromLabel(e)||e;var n;(n=t)&&n.matches(SELECTOR_SEARCH)&&InputSearch.getOrCreateInstance(n);}));}));const InputSearchAutocomplete = InputSearch;

    const NAME$q="inputpassword",DATA_KEY$6="bs.inputpassword",EVENT_KEY$8=`.${DATA_KEY$6}`,Default$i={shortPass:"Password molto debole",badPass:"Password debole",goodPass:"Password sicura",strongPass:"Password molto sicura",enterPass:"Inserisci almeno 8 caratteri e una lettera maiuscola",alertCaps:"CAPS LOCK inserito",showText:!0,minimumLength:4},EVENT_CLICK$6=`click${EVENT_KEY$8}`,EVENT_KEYUP=`keyup${EVENT_KEY$8}`,EVENT_KEYDOWN$2=`keydown${EVENT_KEY$8}`,EVENT_KEYPRESS=`keypress${EVENT_KEY$8}`,EVENT_SCORE=`score${EVENT_KEY$8}`,EVENT_TEXT=`text${EVENT_KEY$8}`,EVENT_CLICK_DATA_API$b=`click${EVENT_KEY$8}.data-api`,EVENT_MOUSEDOWN_DATA_API=`mousedown${EVENT_KEY$8}.data-api`,EVENT_KEYUP_DATA_API$2=`keyup${EVENT_KEY$8}.data-api`,SELECTOR_PASSWORD='input[data-bs-input][type="password"]',SELECTOR_METER=".password-strength-meter",SELECTOR_CAPS=".password-caps";class InputPassword extends BaseComponent{constructor(t,e){super(t),this._config=this._getConfig(e),this._isCustom=this._element.classList.contains("input-password"),this._meter=this._element.parentNode.querySelector(SELECTOR_METER),this._isShiftPressed=!1,this._isCapsOn=!1,this._grayBarElement=null,this._colorBarElement=null,this._textElement=null,this._capsElement=null,this._showPwdElement=null,this._text={},this._label=new InputLabel$1(t),this._init(),this._bindEvents();}static get NAME(){return NAME$q}_getConfig(t){return t={...Default$i,...Manipulator.getDataAttributes(this._element),..."object"==typeof t?t:{}}}_init(){this._meter&&(this._grayBarElement=this._meter.querySelector(".password-meter"),this._colorBarElement=this._meter.querySelector(".progress-bar"),this._textElement=this._meter.querySelector(".form-text"),this._textElement&&(this._config=Object.assign({},this._config,{...Manipulator.getDataAttributes(this._textElement)},{enterPass:this._textElement.innerText}))),this._isCustom&&(this._capsElement=this._element.parentNode.querySelector(SELECTOR_CAPS)),this._showPwdElement=SelectorEngine$1.findOne(".password-icon",this._element.parentNode);}_bindEvents(){this._meter&&EventHandler$1.on(this._element,EVENT_KEYUP,(()=>this._checkPassword())),this._isCustom&&(EventHandler$1.on(this._element,EVENT_KEYDOWN$2,(t=>{"Shift"===t.key&&(this._isShiftPressed=!0);})),EventHandler$1.on(this._element,EVENT_KEYUP,(t=>{"Shift"===t.key&&(this._isShiftPressed=!1),"CapsLock"===t.key&&(this._isCapsOn=!this._isCapsOn,this._isCapsOn?this._showCapsMsg():this._hideCapsMsg());})),EventHandler$1.on(this._element,EVENT_KEYPRESS,(t=>{(t.key.match(/[A-Z]$/)||[]).length>0&&!this._isShiftPressed?(this._isCapsOn=!0,this._showCapsMsg()):this._isCapsOn&&(this._isCapsOn=!1,this._hideCapsMsg());}))),this._showPwdElement&&EventHandler$1.on(this._showPwdElement,EVENT_CLICK$6,(()=>this._toggleShowPassword()));}_showCapsMsg(){this._capsElement&&this._capsElement.classList.add("show");}_hideCapsMsg(){this._capsElement&&this._capsElement.classList.remove("show");}_toggleShowPassword(){const t="password"===this._element.getAttribute("type");SelectorEngine$1.find('[class^="password-icon"]',this._showPwdElement).forEach((t=>t.classList.toggle("d-none"))),t?this._element.setAttribute("type","text"):this._element.setAttribute("type","password");}_checkPassword(){const t=this._calculateScore(this._element.value),e=t<0?0:t;if(this._colorBarElement.classList.forEach((t=>{t.match(/(^|\s)bg-\S+/g)&&this._colorBarElement.classList.remove(t);})),this._colorBarElement.classList.add("bg-"+this._scoreColor(t)),this._colorBarElement.style.width=e+"%",this._colorBarElement.setAttribute("aria-valuenow",e),EventHandler$1.trigger(this._element,EVENT_SCORE),this._textElement){let e=this._scoreText(t);0===this._element.value.length&&t<=0&&(e=this._config.enterPass),-1===this._textElement.innerHTML.search(e)&&(this._textElement.innerHTML=e,this._textElement.classList.forEach((t=>{t.match(/(^|\s)text-\S+/g)&&this._textElement.classList.remove(t);})),this._textElement.classList.add("text-"+this._scoreColor(t)),EventHandler$1.trigger(this._element,EVENT_TEXT));}}_scoreText(t){return -1===t||(t=t<0?0:t)<26?this._config.shortPass:t<51?this._config.badPass:t<76?this._config.goodPass:this._config.strongPass}_scoreColor(t){return -1===t?"danger":-2===t?"muted":(t=t<0?0:t)<26?"danger":t<51?"warning":"success"}_calculateScore(t){var e=0;if(0===t.trim().length)return -2;if(t.length<this._config.minimumLength)return -1;e+=4*t.length,e+=this._checkRepetition(1,t).length-t.length,e+=this._checkRepetition(2,t).length-t.length,e+=this._checkRepetition(3,t).length-t.length,e+=this._checkRepetition(4,t).length-t.length,t.match(/(.*[0-9].*[0-9].*[0-9])/)&&(e+=5);var s=".*[!,@,#,$,%,^,&,*,?,_,~]";return s=new RegExp("("+s+s+")"),t.match(s)&&(e+=5),t.match(/([a-z].*[A-Z])|([A-Z].*[a-z])/)&&(e+=10),t.match(/([a-zA-Z])/)&&t.match(/([0-9])/)&&(e+=15),t.match(/([!,@,#,$,%,^,&,*,?,_,~])/)&&t.match(/([0-9])/)&&(e+=15),t.match(/([!,@,#,$,%,^,&,*,?,_,~])/)&&t.match(/([a-zA-Z])/)&&(e+=15),(t.match(/^\w+$/)||t.match(/^\d+$/))&&(e-=10),e>100&&(e=100),e<0&&(e=0),e}_checkRepetition(t,e){for(var s="",n=!1,i=0;i<e.length;i++){n=!0;for(var a=0;a<t&&a+i+t<e.length;a++)n=n&&e.charAt(a+i)===e.charAt(a+i+t);a<t&&(n=!1),n?(i+=t-1,n=!1):s+=e.charAt(i);}return s}}const createInput$1=t=>t&&t.matches(SELECTOR_PASSWORD)?InputPassword.getOrCreateInstance(t):null;EventHandler$1.on(document,EVENT_MOUSEDOWN_DATA_API,SELECTOR_PASSWORD+", label",(function(){const t=InputLabel$1.getInputFromLabel(this)||this;createInput$1(t);})),EventHandler$1.on(document,EVENT_KEYUP_DATA_API$2,SELECTOR_PASSWORD+", label",(function(){const t=InputLabel$1.getInputFromLabel(this)||this,e=createInput$1(t);e&&e._label&&e._label._labelOut();})),EventHandler$1.on(document,EVENT_CLICK_DATA_API$b,".password-icon",(function(){const t=this.parentNode&&this.parentNode.querySelector(SELECTOR_PASSWORD);t&&InputPassword.getOrCreateInstance(t);}));const InputPassword$1 = InputPassword;

    var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

    function commonjsRequire () {
    	throw new Error('Dynamic requires are not currently supported by rollup-plugin-commonjs');
    }

    function unwrapExports (x) {
    	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
    }

    function createCommonjsModule(fn, module) {
    	return module = { exports: {} }, fn(module, module.exports), module.exports;
    }

    var progressbar=createCommonjsModule((function(t,e){var r;r=function(){return function t(e,r,n){function i(a,s){if(!r[a]){if(!e[a]){var u="function"==typeof commonjsRequire&&commonjsRequire;if(!s&&u)return u(a,!0);if(o)return o(a,!0);var c=new Error("Cannot find module '"+a+"'");throw c.code="MODULE_NOT_FOUND",c}var l=r[a]={exports:{}};e[a][0].call(l.exports,(function(t){return i(e[a][1][t]||t)}),l,l.exports,t,e,r,n);}return r[a].exports}for(var o="function"==typeof commonjsRequire&&commonjsRequire,a=0;a<n.length;a++)i(n[a]);return i}({1:[function(t,e,r){(function(t){(function(){var n="__lodash_hash_undefined__",i=9007199254740991,o="[object Arguments]",a="[object Function]",s="[object Object]",u=/^\[object .+?Constructor\]$/,c=/^(?:0|[1-9]\d*)$/,l={};l["[object Float32Array]"]=l["[object Float64Array]"]=l["[object Int8Array]"]=l["[object Int16Array]"]=l["[object Int32Array]"]=l["[object Uint8Array]"]=l["[object Uint8ClampedArray]"]=l["[object Uint16Array]"]=l["[object Uint32Array]"]=!0,l[o]=l["[object Array]"]=l["[object ArrayBuffer]"]=l["[object Boolean]"]=l["[object DataView]"]=l["[object Date]"]=l["[object Error]"]=l[a]=l["[object Map]"]=l["[object Number]"]=l[s]=l["[object RegExp]"]=l["[object Set]"]=l["[object String]"]=l["[object WeakMap]"]=!1;var f="object"==typeof t&&t&&t.Object===Object&&t,h="object"==typeof self&&self&&self.Object===Object&&self,p=f||h||Function("return this")(),v="object"==typeof r&&r&&!r.nodeType&&r,_=v&&"object"==typeof e&&e&&!e.nodeType&&e,d=_&&_.exports===v,y=d&&f.process,g=function(){try{var t=_&&_.require&&_.require("util").types;return t||y&&y.binding&&y.binding("util")}catch(t){}}(),m=g&&g.isTypedArray;function b(t,e,r){switch(r.length){case 0:return t.call(e);case 1:return t.call(e,r[0]);case 2:return t.call(e,r[0],r[1]);case 3:return t.call(e,r[0],r[1],r[2])}return t.apply(e,r)}var w,S,j,O=Array.prototype,k=Function.prototype,x=Object.prototype,P=p["__core-js_shared__"],A=k.toString,T=x.hasOwnProperty,C=(w=/[^.]+$/.exec(P&&P.keys&&P.keys.IE_PROTO||""))?"Symbol(src)_1."+w:"",E=x.toString,M=A.call(Object),F=RegExp("^"+A.call(T).replace(/[\\^$.*+?()[\]{}|]/g,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$"),W=d?p.Buffer:void 0,I=p.Symbol,z=p.Uint8Array,D=W?W.allocUnsafe:void 0,q=(S=Object.getPrototypeOf,j=Object,function(t){return S(j(t))}),R=Object.create,L=x.propertyIsEnumerable,N=O.splice,B=I?I.toStringTag:void 0,U=function(){try{var t=_t(Object,"defineProperty");return t({},"",{}),t}catch(t){}}(),H=W?W.isBuffer:void 0,Q=Math.max,V=Date.now,$=_t(p,"Map"),G=_t(Object,"create"),J=function(){function t(){}return function(e){if(!Pt(e))return {};if(R)return R(e);t.prototype=e;var r=new t;return t.prototype=void 0,r}}();function K(t){var e=-1,r=null==t?0:t.length;for(this.clear();++e<r;){var n=t[e];this.set(n[0],n[1]);}}function X(t){var e=-1,r=null==t?0:t.length;for(this.clear();++e<r;){var n=t[e];this.set(n[0],n[1]);}}function Y(t){var e=-1,r=null==t?0:t.length;for(this.clear();++e<r;){var n=t[e];this.set(n[0],n[1]);}}function Z(t){var e=this.__data__=new X(t);this.size=e.size;}function tt(t,e){var r=St(t),n=!r&&wt(t),i=!r&&!n&&Ot(t),o=!r&&!n&&!i&&Tt(t),a=r||n||i||o,s=a?function(t,e){for(var r=-1,n=Array(t);++r<t;)n[r]=e(r);return n}(t.length,String):[],u=s.length;for(var c in t)!e&&!T.call(t,c)||a&&("length"==c||i&&("offset"==c||"parent"==c)||o&&("buffer"==c||"byteLength"==c||"byteOffset"==c)||dt(c,u))||s.push(c);return s}function et(t,e,r){(void 0!==r&&!bt(t[e],r)||void 0===r&&!(e in t))&&it(t,e,r);}function rt(t,e,r){var n=t[e];T.call(t,e)&&bt(n,r)&&(void 0!==r||e in t)||it(t,e,r);}function nt(t,e){for(var r=t.length;r--;)if(bt(t[r][0],e))return r;return -1}function it(t,e,r){"__proto__"==e&&U?U(t,e,{configurable:!0,enumerable:!0,value:r,writable:!0}):t[e]=r;}K.prototype.clear=function(){this.__data__=G?G(null):{},this.size=0;},K.prototype.delete=function(t){var e=this.has(t)&&delete this.__data__[t];return this.size-=e?1:0,e},K.prototype.get=function(t){var e=this.__data__;if(G){var r=e[t];return r===n?void 0:r}return T.call(e,t)?e[t]:void 0},K.prototype.has=function(t){var e=this.__data__;return G?void 0!==e[t]:T.call(e,t)},K.prototype.set=function(t,e){var r=this.__data__;return this.size+=this.has(t)?0:1,r[t]=G&&void 0===e?n:e,this},X.prototype.clear=function(){this.__data__=[],this.size=0;},X.prototype.delete=function(t){var e=this.__data__,r=nt(e,t);return !(r<0||(r==e.length-1?e.pop():N.call(e,r,1),--this.size,0))},X.prototype.get=function(t){var e=this.__data__,r=nt(e,t);return r<0?void 0:e[r][1]},X.prototype.has=function(t){return nt(this.__data__,t)>-1},X.prototype.set=function(t,e){var r=this.__data__,n=nt(r,t);return n<0?(++this.size,r.push([t,e])):r[n][1]=e,this},Y.prototype.clear=function(){this.size=0,this.__data__={hash:new K,map:new($||X),string:new K};},Y.prototype.delete=function(t){var e=vt(this,t).delete(t);return this.size-=e?1:0,e},Y.prototype.get=function(t){return vt(this,t).get(t)},Y.prototype.has=function(t){return vt(this,t).has(t)},Y.prototype.set=function(t,e){var r=vt(this,t),n=r.size;return r.set(t,e),this.size+=r.size==n?0:1,this},Z.prototype.clear=function(){this.__data__=new X,this.size=0;},Z.prototype.delete=function(t){var e=this.__data__,r=e.delete(t);return this.size=e.size,r},Z.prototype.get=function(t){return this.__data__.get(t)},Z.prototype.has=function(t){return this.__data__.has(t)},Z.prototype.set=function(t,e){var r=this.__data__;if(r instanceof X){var n=r.__data__;if(!$||n.length<199)return n.push([t,e]),this.size=++r.size,this;r=this.__data__=new Y(n);}return r.set(t,e),this.size=r.size,this};var at=function(t,e,r){for(var n=-1,i=Object(t),o=r(t),a=o.length;a--;){var s=o[++n];if(!1===e(i[s],s,i))break}return t};function st(t){return null==t?void 0===t?"[object Undefined]":"[object Null]":B&&B in Object(t)?function(t){var e=T.call(t,B),r=t[B];try{t[B]=void 0;var n=!0;}catch(t){}var i=E.call(t);return n&&(e?t[B]=r:delete t[B]),i}(t):function(t){return E.call(t)}(t)}function ut(t){return At(t)&&st(t)==o}function ct(t){return !(!Pt(t)||function(t){return !!C&&C in t}(t))&&(kt(t)?F:u).test(function(t){if(null!=t){try{return A.call(t)}catch(t){}try{return t+""}catch(t){}}return ""}(t))}function lt(t){if(!Pt(t))return function(t){var e=[];if(null!=t)for(var r in Object(t))e.push(r);return e}(t);var e=yt(t),r=[];for(var n in t)("constructor"!=n||!e&&T.call(t,n))&&r.push(n);return r}function ft(t,e,r,n,i){t!==e&&at(e,(function(o,a){if(i||(i=new Z),Pt(o))!function(t,e,r,n,i,o,a){var u=gt(t,r),c=gt(e,r),l=a.get(c);if(l)et(t,r,l);else {var f,h,p,v,_,d=o?o(u,c,r+"",t,e,a):void 0,y=void 0===d;if(y){var g=St(c),m=!g&&Ot(c),b=!g&&!m&&Tt(c);d=c,g||m||b?St(u)?d=u:At(_=u)&&jt(_)?d=function(t,e){var r=-1,n=t.length;for(e||(e=Array(n));++r<n;)e[r]=t[r];return e}(u):m?(y=!1,d=function(t,e){if(e)return t.slice();var r=t.length,n=D?D(r):new t.constructor(r);return t.copy(n),n}(c,!0)):b?(y=!1,p=(f=c).buffer,v=new p.constructor(p.byteLength),new z(v).set(new z(p)),h=v,d=new f.constructor(h,f.byteOffset,f.length)):d=[]:function(t){if(!At(t)||st(t)!=s)return !1;var e=q(t);if(null===e)return !0;var r=T.call(e,"constructor")&&e.constructor;return "function"==typeof r&&r instanceof r&&A.call(r)==M}(c)||wt(c)?(d=u,wt(u)?d=function(t){return function(t,e,r,n){var i=!r;r||(r={});for(var o=-1,a=e.length;++o<a;){var s=e[o],u=n?n(r[s],t[s],s,r,t):void 0;void 0===u&&(u=t[s]),i?it(r,s,u):rt(r,s,u);}return r}(t,Ct(t))}(u):Pt(u)&&!kt(u)||(d=function(t){return "function"!=typeof t.constructor||yt(t)?{}:J(q(t))}(c))):y=!1;}y&&(a.set(c,d),i(d,c,n,o,a),a.delete(c)),et(t,r,d);}}(t,e,a,r,ft,n,i);else {var u=n?n(gt(t,a),o,a+"",t,e,i):void 0;void 0===u&&(u=o),et(t,a,u);}}),Ct);}function ht(t,e){return mt(function(t,e,r){return e=Q(void 0===e?t.length-1:e,0),function(){for(var n=arguments,i=-1,o=Q(n.length-e,0),a=Array(o);++i<o;)a[i]=n[e+i];i=-1;for(var s=Array(e+1);++i<e;)s[i]=n[i];return s[e]=r(a),b(t,this,s)}}(t,e,Ft),t+"")}var pt=U?function(t,e){return U(t,"toString",{configurable:!0,enumerable:!1,value:(r=e,function(){return r}),writable:!0});var r;}:Ft;function vt(t,e){var r,n,i=t.__data__;return ("string"==(n=typeof(r=e))||"number"==n||"symbol"==n||"boolean"==n?"__proto__"!==r:null===r)?i["string"==typeof e?"string":"hash"]:i.map}function _t(t,e){var r=function(t,e){return null==t?void 0:t[e]}(t,e);return ct(r)?r:void 0}function dt(t,e){var r=typeof t;return !!(e=null==e?i:e)&&("number"==r||"symbol"!=r&&c.test(t))&&t>-1&&t%1==0&&t<e}function yt(t){var e=t&&t.constructor;return t===("function"==typeof e&&e.prototype||x)}function gt(t,e){if(("constructor"!==e||"function"!=typeof t[e])&&"__proto__"!=e)return t[e]}var mt=function(t){var e=0,r=0;return function(){var n=V(),i=16-(n-r);if(r=n,i>0){if(++e>=800)return arguments[0]}else e=0;return t.apply(void 0,arguments)}}(pt);function bt(t,e){return t===e||t!=t&&e!=e}var wt=ut(function(){return arguments}())?ut:function(t){return At(t)&&T.call(t,"callee")&&!L.call(t,"callee")},St=Array.isArray;function jt(t){return null!=t&&xt(t.length)&&!kt(t)}var Ot=H||function(){return !1};function kt(t){if(!Pt(t))return !1;var e=st(t);return e==a||"[object GeneratorFunction]"==e||"[object AsyncFunction]"==e||"[object Proxy]"==e}function xt(t){return "number"==typeof t&&t>-1&&t%1==0&&t<=i}function Pt(t){var e=typeof t;return null!=t&&("object"==e||"function"==e)}function At(t){return null!=t&&"object"==typeof t}var Tt=m?function(t){return function(e){return t(e)}}(m):function(t){return At(t)&&xt(t.length)&&!!l[st(t)]};function Ct(t){return jt(t)?tt(t,!0):lt(t)}var Et,Mt=(Et=function(t,e,r){ft(t,e,r);},ht((function(t,e){var r=-1,n=e.length,i=n>1?e[n-1]:void 0,o=n>2?e[2]:void 0;for(i=Et.length>3&&"function"==typeof i?(n--,i):void 0,o&&function(t,e,r){if(!Pt(r))return !1;var n=typeof e;return !!("number"==n?jt(r)&&dt(e,r.length):"string"==n&&e in r)&&bt(r[e],t)}(e[0],e[1],o)&&(i=n<3?void 0:i,n=1),t=Object(t);++r<n;){var a=e[r];a&&Et(t,a,r,i);}return t})));function Ft(t){return t}e.exports=Mt;}).call(this);}).call(this,void 0!==commonjsGlobal?commonjsGlobal:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{});},{}],2:[function(t,e,r){var n,i;n=self,i=function(){return function(){var t={720:function(t,e,r){r.r(e),r.d(e,{Scene:function(){return oe},Tweenable:function(){return Ot},interpolate:function(){return te},processTweens:function(){return dt},setBezierFunction:function(){return U},shouldScheduleUpdate:function(){return mt},tween:function(){return kt},unsetBezierFunction:function(){return H}});var n={};r.r(n),r.d(n,{bounce:function(){return I},bouncePast:function(){return z},easeFrom:function(){return q},easeFromTo:function(){return D},easeInBack:function(){return A},easeInCirc:function(){return O},easeInCubic:function(){return c},easeInExpo:function(){return w},easeInOutBack:function(){return C},easeInOutCirc:function(){return x},easeInOutCubic:function(){return f},easeInOutExpo:function(){return j},easeInOutQuad:function(){return u},easeInOutQuart:function(){return v},easeInOutQuint:function(){return y},easeInOutSine:function(){return b},easeInQuad:function(){return a},easeInQuart:function(){return h},easeInQuint:function(){return _},easeInSine:function(){return g},easeOutBack:function(){return T},easeOutBounce:function(){return P},easeOutCirc:function(){return k},easeOutCubic:function(){return l},easeOutExpo:function(){return S},easeOutQuad:function(){return s},easeOutQuart:function(){return p},easeOutQuint:function(){return d},easeOutSine:function(){return m},easeTo:function(){return R},elastic:function(){return E},linear:function(){return o},swingFrom:function(){return F},swingFromTo:function(){return M},swingTo:function(){return W}});var i={};r.r(i),r.d(i,{afterTween:function(){return Gt},beforeTween:function(){return $t},doesApply:function(){return Qt},tweenCreated:function(){return Vt}});var o=function(t){return t},a=function(t){return Math.pow(t,2)},s=function(t){return -(Math.pow(t-1,2)-1)},u=function(t){return (t/=.5)<1?.5*Math.pow(t,2):-.5*((t-=2)*t-2)},c=function(t){return Math.pow(t,3)},l=function(t){return Math.pow(t-1,3)+1},f=function(t){return (t/=.5)<1?.5*Math.pow(t,3):.5*(Math.pow(t-2,3)+2)},h=function(t){return Math.pow(t,4)},p=function(t){return -(Math.pow(t-1,4)-1)},v=function(t){return (t/=.5)<1?.5*Math.pow(t,4):-.5*((t-=2)*Math.pow(t,3)-2)},_=function(t){return Math.pow(t,5)},d=function(t){return Math.pow(t-1,5)+1},y=function(t){return (t/=.5)<1?.5*Math.pow(t,5):.5*(Math.pow(t-2,5)+2)},g=function(t){return 1-Math.cos(t*(Math.PI/2))},m=function(t){return Math.sin(t*(Math.PI/2))},b=function(t){return -.5*(Math.cos(Math.PI*t)-1)},w=function(t){return 0===t?0:Math.pow(2,10*(t-1))},S=function(t){return 1===t?1:1-Math.pow(2,-10*t)},j=function(t){return 0===t?0:1===t?1:(t/=.5)<1?.5*Math.pow(2,10*(t-1)):.5*(2-Math.pow(2,-10*--t))},O=function(t){return -(Math.sqrt(1-t*t)-1)},k=function(t){return Math.sqrt(1-Math.pow(t-1,2))},x=function(t){return (t/=.5)<1?-.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1)},P=function(t){return t<1/2.75?7.5625*t*t:t<2/2.75?7.5625*(t-=1.5/2.75)*t+.75:t<2.5/2.75?7.5625*(t-=2.25/2.75)*t+.9375:7.5625*(t-=2.625/2.75)*t+.984375},A=function(t){var e=1.70158;return t*t*((e+1)*t-e)},T=function(t){var e=1.70158;return (t-=1)*t*((e+1)*t+e)+1},C=function(t){var e=1.70158;return (t/=.5)<1?t*t*((1+(e*=1.525))*t-e)*.5:.5*((t-=2)*t*((1+(e*=1.525))*t+e)+2)},E=function(t){return -1*Math.pow(4,-8*t)*Math.sin((6*t-1)*(2*Math.PI)/2)+1},M=function(t){var e=1.70158;return (t/=.5)<1?t*t*((1+(e*=1.525))*t-e)*.5:.5*((t-=2)*t*((1+(e*=1.525))*t+e)+2)},F=function(t){var e=1.70158;return t*t*((e+1)*t-e)},W=function(t){var e=1.70158;return (t-=1)*t*((e+1)*t+e)+1},I=function(t){return t<1/2.75?7.5625*t*t:t<2/2.75?7.5625*(t-=1.5/2.75)*t+.75:t<2.5/2.75?7.5625*(t-=2.25/2.75)*t+.9375:7.5625*(t-=2.625/2.75)*t+.984375},z=function(t){return t<1/2.75?7.5625*t*t:t<2/2.75?2-(7.5625*(t-=1.5/2.75)*t+.75):t<2.5/2.75?2-(7.5625*(t-=2.25/2.75)*t+.9375):2-(7.5625*(t-=2.625/2.75)*t+.984375)},D=function(t){return (t/=.5)<1?.5*Math.pow(t,4):-.5*((t-=2)*Math.pow(t,3)-2)},q=function(t){return Math.pow(t,4)},R=function(t){return Math.pow(t,.25)};function L(t,e,r,n,i,o){var a,s,u,c,l,f=0,h=0,p=0,v=function(t){return ((f*t+h)*t+p)*t},_=function(t){return (3*f*t+2*h)*t+p},d=function(t){return t>=0?t:0-t};return f=1-(p=3*e)-(h=3*(n-e)-p),u=1-(l=3*r)-(c=3*(i-r)-l),a=t,s=function(t){return 1/(200*t)}(o),function(t){return ((u*t+c)*t+l)*t}(function(t,e){var r,n,i,o,a,s;for(i=t,s=0;s<8;s++){if(o=v(i)-t,d(o)<e)return i;if(a=_(i),d(a)<1e-6)break;i-=o/a;}if((i=t)<(r=0))return r;if(i>(n=1))return n;for(;r<n;){if(o=v(i),d(o-t)<e)return i;t>o?r=i:n=i,i=.5*(n-r)+r;}return i}(a,s))}var N,B=function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:.25,e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:.25,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:.75,n=arguments.length>3&&void 0!==arguments[3]?arguments[3]:.75;return function(i){return L(i,t,e,r,n,1)}},U=function(t,e,r,n,i){var o=B(e,r,n,i);return o.displayName=t,o.x1=e,o.y1=r,o.x2=n,o.y2=i,Ot.formulas[t]=o},H=function(t){return delete Ot.formulas[t]};function Q(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}function V(t){return V="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},V(t)}function $(t){return function(t){if(Array.isArray(t))return G(t)}(t)||function(t){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(t))return Array.from(t)}(t)||function(t,e){if(t){if("string"==typeof t)return G(t,e);var r=Object.prototype.toString.call(t).slice(8,-1);return "Object"===r&&t.constructor&&(r=t.constructor.name),"Map"===r||"Set"===r?Array.from(t):"Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r)?G(t,e):void 0}}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function G(t,e){(null==e||e>t.length)&&(e=t.length);for(var r=0,n=new Array(e);r<e;r++)n[r]=t[r];return n}function J(t,e){var r=Object.keys(t);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(t);e&&(n=n.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),r.push.apply(r,n);}return r}function K(t){for(var e=1;e<arguments.length;e++){var r=null!=arguments[e]?arguments[e]:{};e%2?J(Object(r),!0).forEach((function(e){X(t,e,r[e]);})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(r)):J(Object(r)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(r,e));}));}return t}function X(t,e,r){return e in t?Object.defineProperty(t,e,{value:r,enumerable:!0,configurable:!0,writable:!0}):t[e]=r,t}var Y,Z,tt,et="linear",rt="undefined"!=typeof window?window:r.g,nt="afterTween",it="afterTweenEnd",ot="beforeTween",at="tweenCreated",st="function",ut="string",ct=rt.requestAnimationFrame||rt.webkitRequestAnimationFrame||rt.oRequestAnimationFrame||rt.msRequestAnimationFrame||rt.mozCancelRequestAnimationFrame&&rt.mozRequestAnimationFrame||setTimeout,lt=function(){},ft=null,ht=null,pt=K({},n),vt=function(t,e,r,n,i,o,a){var s,u,c,l=t<o?0:(t-o)/i,f=!1;for(var h in a&&a.call&&(f=!0,s=a(l)),e)f||(s=((u=a[h]).call?u:pt[u])(l)),c=r[h],e[h]=c+(n[h]-c)*s;return e},_t=function(t,e){var r=t._timestamp,n=t._currentState,i=t._delay;if(!(e<r+i)){var o=t._duration,a=t._targetState,s=r+i+o,u=e>s?s:e;t._hasEnded=u>=s;var c=o-(s-u),l=t._filters.length>0;if(t._hasEnded)return t._render(a,t._data,c),t.stop(!0);l&&t._applyFilter(ot),u<r+i?r=o=u=1:r+=i,vt(u,n,t._originalState,a,o,r,t._easing),l&&t._applyFilter(nt),t._render(n,t._data,c);}},dt=function(){for(var t,e=Ot.now(),r=ft;r;)t=r._next,_t(r,e),r=t;},yt=Date.now||function(){return +new Date},gt=!1,mt=function(t){t&&gt||(gt=t,t&&bt());},bt=function t(){Y=yt(),gt&&ct.call(rt,t,16.666666666666668),dt();},wt=function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:et,r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(Array.isArray(e)){var n=B.apply(void 0,$(e));return n}var i=V(e);if(pt[e])return pt[e];if(i===ut||i===st)for(var o in t)r[o]=e;else for(var a in t)r[a]=e[a]||et;return r},St=function(t){t===ft?(ft=t._next)?ft._previous=null:ht=null:t===ht?(ht=t._previous)?ht._next=null:ft=null:(Z=t._previous,tt=t._next,Z._next=tt,tt._previous=Z),t._previous=t._next=null;},jt="function"==typeof Promise?Promise:null;N=Symbol.toStringTag;var Ot=function(){function t(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:void 0;Q(this,t),X(this,N,"Promise"),this._config={},this._data={},this._delay=0,this._filters=[],this._next=null,this._previous=null,this._timestamp=null,this._hasEnded=!1,this._resolve=null,this._reject=null,this._currentState=e||{},this._originalState={},this._targetState={},this._start=lt,this._render=lt,this._promiseCtor=jt,r&&this.setConfig(r);}var e;return e=[{key:"_applyFilter",value:function(t){for(var e=this._filters.length;e>0;e--){var r=this._filters[e-e][t];r&&r(this);}}},{key:"tween",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:void 0;return this._isPlaying&&this.stop(),!e&&this._config||this.setConfig(e),this._pausedAtTime=null,this._timestamp=t.now(),this._start(this.get(),this._data),this._delay&&this._render(this._currentState,this._data,0),this._resume(this._timestamp)}},{key:"setConfig",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},r=this._config;for(var n in e)r[n]=e[n];var i=r.promise,o=void 0===i?this._promiseCtor:i,a=r.start,s=void 0===a?lt:a,u=r.finish,c=r.render,l=void 0===c?this._config.step||lt:c,f=r.step,h=void 0===f?lt:f;this._data=r.data||r.attachment||this._data,this._isPlaying=!1,this._pausedAtTime=null,this._scheduleId=null,this._delay=e.delay||0,this._start=s,this._render=l||h,this._duration=r.duration||500,this._promiseCtor=o,u&&(this._resolve=u);var p=e.from,v=e.to,_=void 0===v?{}:v,d=this._currentState,y=this._originalState,g=this._targetState;for(var m in p)d[m]=p[m];var b=!1;for(var w in d){var S=d[w];b||V(S)!==ut||(b=!0),y[w]=S,g[w]=_.hasOwnProperty(w)?_[w]:S;}if(this._easing=wt(this._currentState,r.easing,this._easing),this._filters.length=0,b){for(var j in t.filters)t.filters[j].doesApply(this)&&this._filters.push(t.filters[j]);this._applyFilter(at);}return this}},{key:"then",value:function(t,e){var r=this;return this._promise=new this._promiseCtor((function(t,e){r._resolve=t,r._reject=e;})),this._promise.then(t,e)}},{key:"catch",value:function(t){return this.then().catch(t)}},{key:"finally",value:function(t){return this.then().finally(t)}},{key:"get",value:function(){return K({},this._currentState)}},{key:"set",value:function(t){this._currentState=t;}},{key:"pause",value:function(){if(this._isPlaying)return this._pausedAtTime=t.now(),this._isPlaying=!1,St(this),this}},{key:"resume",value:function(){return this._resume()}},{key:"_resume",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:t.now();return null===this._timestamp?this.tween():this._isPlaying?this._promise:(this._pausedAtTime&&(this._timestamp+=e-this._pausedAtTime,this._pausedAtTime=null),this._isPlaying=!0,null===ft?(ft=this,ht=this):(this._previous=ht,ht._next=this,ht=this),this)}},{key:"seek",value:function(e){e=Math.max(e,0);var r=t.now();return this._timestamp+e===0||(this._timestamp=r-e,_t(this,r)),this}},{key:"stop",value:function(){var t=arguments.length>0&&void 0!==arguments[0]&&arguments[0];if(!this._isPlaying)return this;this._isPlaying=!1,St(this);var e=this._filters.length>0;return t&&(e&&this._applyFilter(ot),vt(1,this._currentState,this._originalState,this._targetState,1,0,this._easing),e&&(this._applyFilter(nt),this._applyFilter(it))),this._resolve&&this._resolve({data:this._data,state:this._currentState,tweenable:this}),this._resolve=null,this._reject=null,this}},{key:"cancel",value:function(){var t=arguments.length>0&&void 0!==arguments[0]&&arguments[0],e=this._currentState,r=this._data,n=this._isPlaying;return n?(this._reject&&this._reject({data:r,state:e,tweenable:this}),this._resolve=null,this._reject=null,this.stop(t)):this}},{key:"isPlaying",value:function(){return this._isPlaying}},{key:"hasEnded",value:function(){return this._hasEnded}},{key:"setScheduleFunction",value:function(e){t.setScheduleFunction(e);}},{key:"data",value:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;return t&&(this._data=K({},t)),this._data}},{key:"dispose",value:function(){for(var t in this)delete this[t];}}],e&&function(t,e){for(var r=0;r<e.length;r++){var n=e[r];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(t,n.key,n);}}(t.prototype,e),t}();function kt(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=new Ot;return e.tween(t),e.tweenable=e,e}X(Ot,"now",(function(){return Y})),X(Ot,"setScheduleFunction",(function(t){return ct=t})),X(Ot,"filters",{}),X(Ot,"formulas",pt),mt(!0);var xt,Pt,At=/(\d|-|\.)/,Tt=/([^\-0-9.]+)/g,Ct=/[0-9.-]+/g,Et=(xt=Ct.source,Pt=/,\s*/.source,new RegExp("rgba?\\(".concat(xt).concat(Pt).concat(xt).concat(Pt).concat(xt,"(").concat(Pt).concat(xt,")?\\)"),"g")),Mt=/^.*\(/,Ft=/#([0-9]|[a-f]){3,6}/gi,Wt="VAL",It=function(t,e){return t.map((function(t,r){return "_".concat(e,"_").concat(r)}))};function zt(t){return parseInt(t,16)}var Dt=function(t){return "rgb(".concat((e=t,3===(e=e.replace(/#/,"")).length&&(e=(e=e.split(""))[0]+e[0]+e[1]+e[1]+e[2]+e[2]),[zt(e.substr(0,2)),zt(e.substr(2,2)),zt(e.substr(4,2))]).join(","),")");var e;},qt=function(t,e,r){var n=e.match(t),i=e.replace(t,Wt);return n&&n.forEach((function(t){return i=i.replace(Wt,r(t))})),i},Rt=function(t){for(var e in t){var r=t[e];"string"==typeof r&&r.match(Ft)&&(t[e]=qt(Ft,r,Dt));}},Lt=function(t){var e=t.match(Ct),r=e.slice(0,3).map(Math.floor),n=t.match(Mt)[0];if(3===e.length)return "".concat(n).concat(r.join(","),")");if(4===e.length)return "".concat(n).concat(r.join(","),",").concat(e[3],")");throw new Error("Invalid rgbChunk: ".concat(t))},Nt=function(t){return t.match(Ct)},Bt=function(t,e){var r={};return e.forEach((function(e){r[e]=t[e],delete t[e];})),r},Ut=function(t,e){return e.map((function(e){return t[e]}))},Ht=function(t,e){return e.forEach((function(e){return t=t.replace(Wt,+e.toFixed(4))})),t},Qt=function(t){for(var e in t._currentState)if("string"==typeof t._currentState[e])return !0;return !1};function Vt(t){var e=t._currentState;[e,t._originalState,t._targetState].forEach(Rt),t._tokenData=function(t){var e,r,n={};for(var i in t){var o=t[i];"string"==typeof o&&(n[i]={formatString:(e=o,r=void 0,r=e.match(Tt),r?(1===r.length||e.charAt(0).match(At))&&r.unshift(""):r=["",""],r.join(Wt)),chunkNames:It(Nt(o),i)});}return n}(e);}function $t(t){var e=t._currentState,r=t._originalState,n=t._targetState,i=t._easing,o=t._tokenData;!function(t,e){var r=function(r){var n=e[r].chunkNames,i=t[r];if("string"==typeof i){var o=i.split(" "),a=o[o.length-1];n.forEach((function(e,r){return t[e]=o[r]||a}));}else n.forEach((function(e){return t[e]=i}));delete t[r];};for(var n in e)r(n);}(i,o),[e,r,n].forEach((function(t){return function(t,e){var r=function(r){Nt(t[r]).forEach((function(n,i){return t[e[r].chunkNames[i]]=+n})),delete t[r];};for(var n in e)r(n);}(t,o)}));}function Gt(t){var e=t._currentState,r=t._originalState,n=t._targetState,i=t._easing,o=t._tokenData;[e,r,n].forEach((function(t){return function(t,e){for(var r in e){var n=e[r],i=n.chunkNames,o=n.formatString,a=Ht(o,Ut(Bt(t,i),i));t[r]=qt(Et,a,Lt);}}(t,o)})),function(t,e){for(var r in e){var n=e[r].chunkNames,i=t[n[0]];t[r]="string"==typeof i?n.map((function(e){var r=t[e];return delete t[e],r})).join(" "):i;}}(i,o);}function Jt(t,e){var r=Object.keys(t);if(Object.getOwnPropertySymbols){var n=Object.getOwnPropertySymbols(t);e&&(n=n.filter((function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),r.push.apply(r,n);}return r}function Kt(t){for(var e=1;e<arguments.length;e++){var r=null!=arguments[e]?arguments[e]:{};e%2?Jt(Object(r),!0).forEach((function(e){Xt(t,e,r[e]);})):Object.getOwnPropertyDescriptors?Object.defineProperties(t,Object.getOwnPropertyDescriptors(r)):Jt(Object(r)).forEach((function(e){Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(r,e));}));}return t}function Xt(t,e,r){return e in t?Object.defineProperty(t,e,{value:r,enumerable:!0,configurable:!0,writable:!0}):t[e]=r,t}var Yt=new Ot,Zt=Ot.filters,te=function(t,e,r,n){var i=arguments.length>4&&void 0!==arguments[4]?arguments[4]:0,o=Kt({},t),a=wt(t,n);for(var s in Yt._filters.length=0,Yt.set({}),Yt._currentState=o,Yt._originalState=t,Yt._targetState=e,Yt._easing=a,Zt)Zt[s].doesApply(Yt)&&Yt._filters.push(Zt[s]);Yt._applyFilter("tweenCreated"),Yt._applyFilter("beforeTween");var u=vt(r,o,t,e,1,i,a);return Yt._applyFilter("afterTween"),u};function ee(t,e){(null==e||e>t.length)&&(e=t.length);for(var r=0,n=new Array(e);r<e;r++)n[r]=t[r];return n}function re(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}function ne(t,e){var r=e.get(t);if(!r)throw new TypeError("attempted to get private field on non-instance");return r.get?r.get.call(t):r.value}var ie=new WeakMap,oe=function(){function t(){re(this,t),ie.set(this,{writable:!0,value:[]});for(var e=arguments.length,r=new Array(e),n=0;n<e;n++)r[n]=arguments[n];r.forEach(this.add.bind(this));}var e;return (e=[{key:"add",value:function(t){return ne(this,ie).push(t),t}},{key:"remove",value:function(t){var e=ne(this,ie).indexOf(t);return ~e&&ne(this,ie).splice(e,1),t}},{key:"empty",value:function(){return this.tweenables.map(this.remove.bind(this))}},{key:"isPlaying",value:function(){return ne(this,ie).some((function(t){return t.isPlaying()}))}},{key:"play",value:function(){return ne(this,ie).forEach((function(t){return t.tween()})),this}},{key:"pause",value:function(){return ne(this,ie).forEach((function(t){return t.pause()})),this}},{key:"resume",value:function(){return this.playingTweenables.forEach((function(t){return t.resume()})),this}},{key:"stop",value:function(t){return ne(this,ie).forEach((function(e){return e.stop(t)})),this}},{key:"tweenables",get:function(){return function(t){if(Array.isArray(t))return ee(t)}(t=ne(this,ie))||function(t){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(t))return Array.from(t)}(t)||function(t,e){if(t){if("string"==typeof t)return ee(t,e);var r=Object.prototype.toString.call(t).slice(8,-1);return "Object"===r&&t.constructor&&(r=t.constructor.name),"Map"===r||"Set"===r?Array.from(t):"Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r)?ee(t,e):void 0}}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}();var t;}},{key:"playingTweenables",get:function(){return ne(this,ie).filter((function(t){return !t.hasEnded()}))}},{key:"promises",get:function(){return ne(this,ie).map((function(t){return t.then()}))}}])&&function(t,e){for(var r=0;r<e.length;r++){var n=e[r];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(t,n.key,n);}}(t.prototype,e),t}();Ot.filters.token=i;}},e={};function r(n){if(e[n])return e[n].exports;var i=e[n]={exports:{}};return t[n](i,i.exports,r),i.exports}return r.d=function(t,e){for(var n in e)r.o(e,n)&&!r.o(t,n)&&Object.defineProperty(t,n,{enumerable:!0,get:e[n]});},r.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(t){if("object"==typeof window)return window}}(),r.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},r.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0});},r(720)}()},"object"==typeof r&&"object"==typeof e?e.exports=i():"object"==typeof r?r.shifty=i():n.shifty=i();},{}],3:[function(t,e,r){var n=t("./shape"),i=t("./utils"),o=function(t,e){this._pathTemplate="M 50,50 m 0,-{radius} a {radius},{radius} 0 1 1 0,{2radius} a {radius},{radius} 0 1 1 0,-{2radius}",this.containerAspectRatio=1,n.apply(this,arguments);};(o.prototype=new n).constructor=o,o.prototype._pathString=function(t){var e=t.strokeWidth;t.trailWidth&&t.trailWidth>t.strokeWidth&&(e=t.trailWidth);var r=50-e/2;return i.render(this._pathTemplate,{radius:r,"2radius":2*r})},o.prototype._trailString=function(t){return this._pathString(t)},e.exports=o;},{"./shape":8,"./utils":10}],4:[function(t,e,r){var n=t("./shape"),i=t("./utils"),o=function(t,e){this._pathTemplate=e.vertical?"M {center},100 L {center},0":"M 0,{center} L 100,{center}",n.apply(this,arguments);};(o.prototype=new n).constructor=o,o.prototype._initializeSvg=function(t,e){var r=e.vertical?"0 0 "+e.strokeWidth+" 100":"0 0 100 "+e.strokeWidth;t.setAttribute("viewBox",r),t.setAttribute("preserveAspectRatio","none");},o.prototype._pathString=function(t){return i.render(this._pathTemplate,{center:t.strokeWidth/2})},o.prototype._trailString=function(t){return this._pathString(t)},e.exports=o;},{"./shape":8,"./utils":10}],5:[function(t,e,r){e.exports={Line:t("./line"),Circle:t("./circle"),SemiCircle:t("./semicircle"),Square:t("./square"),Path:t("./path"),Shape:t("./shape"),utils:t("./utils")};},{"./circle":3,"./line":4,"./path":6,"./semicircle":7,"./shape":8,"./square":9,"./utils":10}],6:[function(t,e,r){var n=t("shifty"),i=t("./utils"),o=n.Tweenable,a={easeIn:"easeInCubic",easeOut:"easeOutCubic",easeInOut:"easeInOutCubic"},s=function t(e,r){if(!(this instanceof t))throw new Error("Constructor was called without new keyword");var n;r=i.extend({delay:0,duration:800,easing:"linear",from:{},to:{},step:function(){}},r),n=i.isString(e)?document.querySelector(e):e,this.path=n,this._opts=r,this._tweenable=null;var o=this.path.getTotalLength();this.path.style.strokeDasharray=o+" "+o,this.set(0);};s.prototype.value=function(){var t=this._getComputedDashOffset(),e=this.path.getTotalLength();return parseFloat((1-t/e).toFixed(6),10)},s.prototype.set=function(t){this.stop(),this.path.style.strokeDashoffset=this._progressToOffset(t);var e=this._opts.step;if(i.isFunction(e)){var r=this._easing(this._opts.easing);e(this._calculateTo(t,r),this._opts.shape||this,this._opts.attachment);}},s.prototype.stop=function(){this._stopTween(),this.path.style.strokeDashoffset=this._getComputedDashOffset();},s.prototype.animate=function(t,e,r){e=e||{},i.isFunction(e)&&(r=e,e={});var n=i.extend({},e),a=i.extend({},this._opts);e=i.extend(a,e);var s=this._easing(e.easing),u=this._resolveFromAndTo(t,s,n);this.stop(),this.path.getBoundingClientRect();var c=this._getComputedDashOffset(),l=this._progressToOffset(t),f=this;this._tweenable=new o,this._tweenable.tween({from:i.extend({offset:c},u.from),to:i.extend({offset:l},u.to),duration:e.duration,delay:e.delay,easing:s,step:function(t){f.path.style.strokeDashoffset=t.offset;var r=e.shape||f;e.step(t,r,e.attachment);}}).then((function(t){i.isFunction(r)&&r();})).catch((function(t){throw console.error("Error in tweening:",t),t}));},s.prototype._getComputedDashOffset=function(){var t=window.getComputedStyle(this.path,null);return parseFloat(t.getPropertyValue("stroke-dashoffset"),10)},s.prototype._progressToOffset=function(t){var e=this.path.getTotalLength();return e-t*e},s.prototype._resolveFromAndTo=function(t,e,r){return r.from&&r.to?{from:r.from,to:r.to}:{from:this._calculateFrom(e),to:this._calculateTo(t,e)}},s.prototype._calculateFrom=function(t){return n.interpolate(this._opts.from,this._opts.to,this.value(),t)},s.prototype._calculateTo=function(t,e){return n.interpolate(this._opts.from,this._opts.to,t,e)},s.prototype._stopTween=function(){null!==this._tweenable&&(this._tweenable.stop(!0),this._tweenable=null);},s.prototype._easing=function(t){return a.hasOwnProperty(t)?a[t]:t},e.exports=s;},{"./utils":10,shifty:2}],7:[function(t,e,r){var n=t("./shape"),i=t("./circle"),o=t("./utils"),a=function(t,e){this._pathTemplate="M 50,50 m -{radius},0 a {radius},{radius} 0 1 1 {2radius},0",this.containerAspectRatio=2,n.apply(this,arguments);};(a.prototype=new n).constructor=a,a.prototype._initializeSvg=function(t,e){t.setAttribute("viewBox","0 0 100 50");},a.prototype._initializeTextContainer=function(t,e,r){t.text.style&&(r.style.top="auto",r.style.bottom="0",t.text.alignToBottom?o.setStyle(r,"transform","translate(-50%, 0)"):o.setStyle(r,"transform","translate(-50%, 50%)"));},a.prototype._pathString=i.prototype._pathString,a.prototype._trailString=i.prototype._trailString,e.exports=a;},{"./circle":3,"./shape":8,"./utils":10}],8:[function(t,e,r){var n=t("./path"),i=t("./utils"),o="Object is destroyed",a=function t(e,r){if(!(this instanceof t))throw new Error("Constructor was called without new keyword");if(0!==arguments.length){this._opts=i.extend({color:"#555",strokeWidth:1,trailColor:null,trailWidth:null,fill:null,text:{style:{color:null,position:"absolute",left:"50%",top:"50%",padding:0,margin:0,transform:{prefix:!0,value:"translate(-50%, -50%)"}},autoStyleContainer:!0,alignToBottom:!0,value:null,className:"progressbar-text"},svgStyle:{display:"block",width:"100%"},warnings:!1},r,!0),i.isObject(r)&&void 0!==r.svgStyle&&(this._opts.svgStyle=r.svgStyle),i.isObject(r)&&i.isObject(r.text)&&void 0!==r.text.style&&(this._opts.text.style=r.text.style);var o,a=this._createSvgView(this._opts);if(!(o=i.isString(e)?document.querySelector(e):e))throw new Error("Container does not exist: "+e);this._container=o,this._container.appendChild(a.svg),this._opts.warnings&&this._warnContainerAspectRatio(this._container),this._opts.svgStyle&&i.setStyles(a.svg,this._opts.svgStyle),this.svg=a.svg,this.path=a.path,this.trail=a.trail,this.text=null;var s=i.extend({attachment:void 0,shape:this},this._opts);this._progressPath=new n(a.path,s),i.isObject(this._opts.text)&&null!==this._opts.text.value&&this.setText(this._opts.text.value);}};a.prototype.animate=function(t,e,r){if(null===this._progressPath)throw new Error(o);this._progressPath.animate(t,e,r);},a.prototype.stop=function(){if(null===this._progressPath)throw new Error(o);void 0!==this._progressPath&&this._progressPath.stop();},a.prototype.pause=function(){if(null===this._progressPath)throw new Error(o);void 0!==this._progressPath&&this._progressPath._tweenable&&this._progressPath._tweenable.pause();},a.prototype.resume=function(){if(null===this._progressPath)throw new Error(o);void 0!==this._progressPath&&this._progressPath._tweenable&&this._progressPath._tweenable.resume();},a.prototype.destroy=function(){if(null===this._progressPath)throw new Error(o);this.stop(),this.svg.parentNode.removeChild(this.svg),this.svg=null,this.path=null,this.trail=null,this._progressPath=null,null!==this.text&&(this.text.parentNode.removeChild(this.text),this.text=null);},a.prototype.set=function(t){if(null===this._progressPath)throw new Error(o);this._progressPath.set(t);},a.prototype.value=function(){if(null===this._progressPath)throw new Error(o);return void 0===this._progressPath?0:this._progressPath.value()},a.prototype.setText=function(t){if(null===this._progressPath)throw new Error(o);null===this.text&&(this.text=this._createTextContainer(this._opts,this._container),this._container.appendChild(this.text)),i.isObject(t)?(i.removeChildren(this.text),this.text.appendChild(t)):this.text.innerHTML=t;},a.prototype._createSvgView=function(t){var e=document.createElementNS("http://www.w3.org/2000/svg","svg");this._initializeSvg(e,t);var r=null;(t.trailColor||t.trailWidth)&&(r=this._createTrail(t),e.appendChild(r));var n=this._createPath(t);return e.appendChild(n),{svg:e,path:n,trail:r}},a.prototype._initializeSvg=function(t,e){t.setAttribute("viewBox","0 0 100 100");},a.prototype._createPath=function(t){var e=this._pathString(t);return this._createPathElement(e,t)},a.prototype._createTrail=function(t){var e=this._trailString(t),r=i.extend({},t);return r.trailColor||(r.trailColor="#eee"),r.trailWidth||(r.trailWidth=r.strokeWidth),r.color=r.trailColor,r.strokeWidth=r.trailWidth,r.fill=null,this._createPathElement(e,r)},a.prototype._createPathElement=function(t,e){var r=document.createElementNS("http://www.w3.org/2000/svg","path");return r.setAttribute("d",t),r.setAttribute("stroke",e.color),r.setAttribute("stroke-width",e.strokeWidth),e.fill?r.setAttribute("fill",e.fill):r.setAttribute("fill-opacity","0"),r},a.prototype._createTextContainer=function(t,e){var r=document.createElement("div");r.className=t.text.className;var n=t.text.style;return n&&(t.text.autoStyleContainer&&(e.style.position="relative"),i.setStyles(r,n),n.color||(r.style.color=t.color)),this._initializeTextContainer(t,e,r),r},a.prototype._initializeTextContainer=function(t,e,r){},a.prototype._pathString=function(t){throw new Error("Override this function for each progress bar")},a.prototype._trailString=function(t){throw new Error("Override this function for each progress bar")},a.prototype._warnContainerAspectRatio=function(t){if(this.containerAspectRatio){var e=window.getComputedStyle(t,null),r=parseFloat(e.getPropertyValue("width"),10),n=parseFloat(e.getPropertyValue("height"),10);i.floatEquals(this.containerAspectRatio,r/n)||(console.warn("Incorrect aspect ratio of container","#"+t.id,"detected:",e.getPropertyValue("width")+"(width)","/",e.getPropertyValue("height")+"(height)","=",r/n),console.warn("Aspect ratio of should be",this.containerAspectRatio));}},e.exports=a;},{"./path":6,"./utils":10}],9:[function(t,e,r){var n=t("./shape"),i=t("./utils"),o=function(t,e){this._pathTemplate="M 0,{halfOfStrokeWidth} L {width},{halfOfStrokeWidth} L {width},{width} L {halfOfStrokeWidth},{width} L {halfOfStrokeWidth},{strokeWidth}",this._trailTemplate="M {startMargin},{halfOfStrokeWidth} L {width},{halfOfStrokeWidth} L {width},{width} L {halfOfStrokeWidth},{width} L {halfOfStrokeWidth},{halfOfStrokeWidth}",n.apply(this,arguments);};(o.prototype=new n).constructor=o,o.prototype._pathString=function(t){var e=100-t.strokeWidth/2;return i.render(this._pathTemplate,{width:e,strokeWidth:t.strokeWidth,halfOfStrokeWidth:t.strokeWidth/2})},o.prototype._trailString=function(t){var e=100-t.strokeWidth/2;return i.render(this._trailTemplate,{width:e,strokeWidth:t.strokeWidth,halfOfStrokeWidth:t.strokeWidth/2,startMargin:t.strokeWidth/2-t.trailWidth/2})},e.exports=o;},{"./shape":8,"./utils":10}],10:[function(t,e,r){var n=t("lodash.merge"),i="Webkit Moz O ms".split(" ");function o(t,e,r){for(var n=t.style,o=0;o<i.length;++o)n[i[o]+a(e)]=r;n[e]=r;}function a(t){return t.charAt(0).toUpperCase()+t.slice(1)}function s(t){return !function(t){return "[object Array]"===Object.prototype.toString.call(t)}(t)&&"object"==typeof t&&!!t}function u(t,e){for(var r in t)t.hasOwnProperty(r)&&e(t[r],r);}e.exports={extend:n,render:function(t,e){var r=t;for(var n in e)if(e.hasOwnProperty(n)){var i=e[n],o=new RegExp("\\{"+n+"\\}","g");r=r.replace(o,i);}return r},setStyle:o,setStyles:function(t,e){u(e,(function(e,r){null!=e&&(s(e)&&!0===e.prefix?o(t,r,e.value):t.style[r]=e);}));},capitalize:a,isString:function(t){return "string"==typeof t||t instanceof String},isFunction:function(t){return "function"==typeof t},isObject:s,forEachObject:u,floatEquals:function(t,e){return Math.abs(t-e)<.001},removeChildren:function(t){for(;t.firstChild;)t.removeChild(t.firstChild);}};},{"lodash.merge":1}]},{},[5])(5)},t.exports=r();}));const ProgressBar = unwrapExports(progressbar);

    const NAME$p="progressdonut",SELECTOR_DONUT$1="[data-bs-progress-donut]",Default$h={color:"#5C6F82",trailColor:"#D9DADB",strokeWidth:24,trailWidth:12,easing:"easeInOut",duration:1400,text:{autoStyleContainer:!1},animate:!0,value:0};class ProgressDonut extends BaseComponent{constructor(t,e){super(t),this._config=this._getConfig(e),this._bar=null,this._init();}static get NAME(){return NAME$p}set(t){this._config.animate?this._bar.animate(t):this._bar.set(t);}dispose(){this._bar.destroy(),super.dispose();}_getConfig(t){return t={...Default$h,step:this._getStepCallback(),...Manipulator.getDataAttributes(this._element),..."object"==typeof t?t:{}}}_getStepCallback(){return (t,e)=>{const s=Math.round(100*e.value());e.setText(s+"%");}}_init(){this._bar=new ProgressBar.Circle(this._element,this._config),this._config.value>0&&this.set(this._config.value);}}SelectorEngine$1.find(SELECTOR_DONUT$1).forEach((t=>{ProgressDonut.getOrCreateInstance(t);}));const ProgressDonut$1 = ProgressDonut;

    const NAME$o="upload",EVENT_CLICK_DATA_API$a="click.bs.upload.data-api",SELECTOR_FORM="[data-bs-upload-dragdrop]",SELECTOR_DONUT="[data-bs-progress-donut]";class UploadDragDrop extends BaseComponent{constructor(e){super(e);const t=SelectorEngine$1.findOne(SELECTOR_DONUT,this._element);t&&(this._donut=ProgressDonut$1.getOrCreateInstance(t)),this._bindEvents();}static get NAME(){return NAME$o}progress(e){this._donut.set(e);}start(){this.reset(),this._element.classList.add("loading");}success(){this._element.classList.remove("loading"),this._element.classList.add("success");}reset(){this._element.classList.remove("loading"),this._element.classList.remove("success"),this._donut.set(0);}dispose(){this._donut.dispose(),super.dispose();}_bindEvents(){EventHandler$1.on(this._element,"drag",(e=>this._preventEvent(e))),EventHandler$1.on(this._element,"dragstart",(e=>this._preventEvent(e))),EventHandler$1.on(this._element,"dragend",(e=>this._preventEvent(e))),EventHandler$1.on(this._element,"dragover",(e=>this._preventEvent(e))),EventHandler$1.on(this._element,"dragenter",(e=>this._preventEvent(e))),EventHandler$1.on(this._element,"dragleave",(e=>this._preventEvent(e))),EventHandler$1.on(this._element,"drop",(e=>this._preventEvent(e))),EventHandler$1.on(this._element,"dragover",(()=>this._dropIn())),EventHandler$1.on(this._element,"dragenter",(()=>this._dropIn())),EventHandler$1.on(this._element,"dragleave",(()=>this._dropOut())),EventHandler$1.on(this._element,"dragend",(()=>this._dropOut())),EventHandler$1.on(this._element,"drop",(()=>this._dropOut())),EventHandler$1.on(this._element,"drop",(()=>this._drop()));}_preventEvent(e){e.preventDefault(),e.stopPropagation();}_dropIn(){this._isSuccess()||this._element.classList.add("dragover");}_dropOut(){this._isSuccess()||this._element.classList.remove("dragover");}_drop(){this._isSuccess()||this.start();}_isSuccess(){return this._element.classList.contains("success")}}const createInput=e=>{let t=e.matches&&e.matches(SELECTOR_FORM)?e:e.closest?e.closest(SELECTOR_FORM):null;return t&&UploadDragDrop.getOrCreateInstance(t),null};"undefined"!=typeof document&&(document.addEventListener("dragenter",(function(e){createInput(e.target);})),EventHandler$1.on(document,EVENT_CLICK_DATA_API$a,SELECTOR_FORM+" label",(function(){createInput(this);})));const UploadDragDrop$1 = UploadDragDrop;

    const NAME$n="backtotop",DATA_KEY$5="bs.backtotop",EVENT_KEY$7=`.${DATA_KEY$5}`,EVENT_CLICK$5=`click${EVENT_KEY$7}`,CLASS_NAME_SHOW="back-to-top-show",SELECTOR_TOGGLE$3='[data-bs-toggle="backtotop"]',Default$g={positionTop:0,scrollLimit:100,duration:800,easing:"easeInOutSine"};class BackToTop extends BaseComponent{constructor(t,o){super(t),this._config=this._getConfig(o),this._scrollCb=null,this._isAnim=!1,this._prevScrollBehavior="",this._bindEvents();}static get NAME(){return NAME$n}show(){this._element.classList.contains(CLASS_NAME_SHOW)||this._element.classList.add(CLASS_NAME_SHOW);}hide(){this._element.classList.contains(CLASS_NAME_SHOW)&&this._element.classList.remove(CLASS_NAME_SHOW);}toggleShow(){"undefined"!=typeof document&&document.scrollingElement.scrollTop>this._config.scrollLimit?this.show():this.hide();}scrollToTop(){this._isAnim||(this._isAnim=!0,documentScrollTo(this._config.positionTop,{duration:this._config.duration,easing:this._config.easing,complete:()=>{this._isAnim=!1;}}));}dispose(){this._scrollCb&&this._scrollCb.dispose(),super.dispose();}_getConfig(t){return t={...Default$g,...Manipulator.getDataAttributes(this._element),..."object"==typeof t?t:{}}}_bindEvents(){this._scrollCb=onDocumentScroll$1((()=>this.toggleShow())),EventHandler$1.on(this._element,EVENT_CLICK$5,(t=>{t.preventDefault(),this.scrollToTop();}));}}onDocumentScroll$1((()=>{SelectorEngine$1.find(SELECTOR_TOGGLE$3).map((t=>{BackToTop.getOrCreateInstance(t);}));}));const BackToTop$1 = BackToTop;

    const NAME$m="historyback",DATA_KEY$4="bs.historyback",EVENT_KEY$6=`.${DATA_KEY$4}`,EVENT_CLICK$4=`click${EVENT_KEY$6}`,EVENT_CLICK_DATA_API$9=`click${EVENT_KEY$6}.data-api`,SELECTOR_TOGGLE$2='[data-bs-toggle="historyback"]';class HistoryBack extends BaseComponent{constructor(t){super(t),this._bindEvents();}static get NAME(){return NAME$m}back(){"undefined"!=typeof window&&window.history.back();}_bindEvents(){EventHandler$1.on(this._element,EVENT_CLICK$4,(t=>{t.preventDefault(),this.back();}));}}EventHandler$1.on(document,EVENT_CLICK_DATA_API$9,SELECTOR_TOGGLE$2,(function(t){t.preventDefault();HistoryBack.getOrCreateInstance(this).back();}));const HistoryBack$1 = HistoryBack;

    const NAME$l="historyback",DATA_KEY$3="bs.historyback",EVENT_KEY$5=`.${DATA_KEY$3}`,EVENT_CLICK$3=`click${EVENT_KEY$5}`,EVENT_CLICK_DATA_API$8=`click${EVENT_KEY$5}.data-api`,SELECTOR_TOGGLE$1='[data-bs-toggle="forward"]',Default$f={duration:800,easing:"easeInOutSine"};class Forward extends BaseComponent{constructor(t,e){super(t),this._config=this._getConfig(e),this._bindEvents();}static get NAME(){return NAME$l}goToTarget(){const t=getElementFromSelector(this._element);t&&documentScrollTo(t.offsetTop,{duration:this._config.duration,easing:this._config.easing});}_getConfig(t){return t={...Default$f,...Manipulator.getDataAttributes(this._element),..."object"==typeof t?t:{}}}_bindEvents(){EventHandler$1.on(this._element,EVENT_CLICK$3,(t=>{t.preventDefault(),this.goToTarget();}));}}EventHandler$1.on(document,EVENT_CLICK_DATA_API$8,SELECTOR_TOGGLE$1,(function(t){t.preventDefault();Forward.getOrCreateInstance(this).goToTarget();}));const Forward$1 = Forward;

    const NAME$k="masonry",SELECTOR_DATA_TOGGLE$8='[data-bs-toggle="masonry"]',SELECTOR_LOADER=".masonry-loader",Default$e={percentPosition:!0};class Masonry extends BaseComponent{constructor(e,t){super(e),this._config=this._getConfig(t),this._masonry=null,this._images=SelectorEngine$1.find("img",this._element),this._loadCounter=0,this._init();}static get NAME(){return NAME$k}dispose(){this._masonry&&(this._masonry.destroy(),this._masonry=null),super.dispose();}_getConfig(e){return e={...Default$e,...Manipulator.getDataAttributes(this._element),..."object"==typeof e?e:{}}}_init(){this._images.length>0?this._images.forEach((e=>{const t=new Image;t.onload=()=>this._onLoadEnd(),t.src=e.src;})):this._initMasonry();}_onLoadEnd(){this._loadCounter++,this._loadCounter>=this._images.length&&this._initMasonry();}_initMasonry(){this._masonry=new MasonryPlugin__default.default(this._element,this._config);}_createLoader(){if("undefined"==typeof document)return;const e=document.createElement("div");return e.classList.add("masonry-loader","fade","d-flex","justify-content-center","align-items-center"),e.innerHTML='<div class="progress-spinner progress-spinner-active"><span class="visually-hidden">Caricamento...</span></div>',this._element.appendChild(e),e}_getOrCreateLoader(){const e=SelectorEngine$1.findOne(SELECTOR_LOADER,this._element);return e||this._createLoader()}_destroyLoader(){const e=SelectorEngine$1.findOne(SELECTOR_LOADER,this._element);e&&e.remove();}_showLoader(){this._getOrCreateLoader().classList.add("show");}_hideLoader(){this._destroyLoader();}}const masonries=SelectorEngine$1.find(SELECTOR_DATA_TOGGLE$8);masonries.length>0&&masonries.forEach((e=>{Masonry.getOrCreateInstance(e);}));const Masonry$1 = Masonry;

    const NAME$j="list",EVENT_CLICK$2="click.bs.list",EVENT_CLICK_DATA_API$7="click.bs.list.data-api",SELECTOR_LIST="[data-bs-list-checkbox]";class List extends BaseComponent{constructor(e){super(e),this._init();}static get NAME(){return NAME$j}toggleCheckbox(e){const t=SelectorEngine$1.findOne("input",e);t&&(t.checked?(t.checked=!1,e.classList.remove("active")):(t.checked=!0,e.classList.add("active")));}_init(){this._initCheckbox();}_initCheckbox(){SelectorEngine$1.find("input[type=checkbox]",this._element).forEach((e=>{EventHandler$1.on(e.closest("a"),EVENT_CLICK$2,(t=>{t.preventDefault(),this.toggleCheckbox(e.closest("a"));}));}));}}SelectorEngine$1.find(SELECTOR_LIST).forEach((e=>{SelectorEngine$1.find("input[type=checkbox]",e).forEach((t=>{EventHandler$1.one(t.closest("a"),EVENT_CLICK_DATA_API$7,(t=>{if(!List.getInstance(e)){t.preventDefault();List.getOrCreateInstance(e).toggleCheckbox(t.currentTarget);}}));}));}));const List$1 = List;

    const NAME$i="transfer",EVENT_CLICK_DATA_API$6="click.bs.transfer.data-api",EVENT_KEYUP_DATA_API$1="keyup.bs.transfer.data-api",EVENT_CLICK$1="click.bs.transfer",SELECTOR_BLOCK="[data-bs-transfer]",SELECTOR_HEAD=".transfer-header",SELECTOR_HEAD_INPUT=".transfer-header input",SELECTOR_HEAD_LABEL=".transfer-header span.num",SELECTOR_LIST_INPUT=".transfer-group input",SELECTOR_SOURCE=".it-transfer-wrapper.source",SELECTOR_TARGET=".it-transfer-wrapper.target";class Transfer extends BaseComponent{constructor(e){super(e),this._addBtnElement=SelectorEngine$1.findOne("a.transfer",this._element),this._invBtnElement=SelectorEngine$1.findOne("a.backtransfer",this._element),this._resetBtnElement=SelectorEngine$1.findOne("a.reset",this._element),this._listDefault={source:SelectorEngine$1.find(SELECTOR_SOURCE+" .transfer-group .form-check",this._element),target:SelectorEngine$1.find(SELECTOR_TARGET+" .transfer-group .form-check",this._element)},this._bindEvents();}static get NAME(){return NAME$i}_bindEvents(){SelectorEngine$1.find(SELECTOR_HEAD_INPUT,this._element).forEach((e=>{EventHandler$1.on(e,EVENT_CLICK$1,(()=>{this._checkListHeader(e.closest(".it-transfer-wrapper"));}));})),SelectorEngine$1.find(SELECTOR_LIST_INPUT,this._element).forEach((e=>{EventHandler$1.on(e,EVENT_CLICK$1,(()=>{this._checkList(e.closest(".it-transfer-wrapper"));}));})),EventHandler$1.on(this._addBtnElement,EVENT_CLICK$1,(e=>{e.preventDefault(),this._disableElement(this._addBtnElement),this._addItems();})),EventHandler$1.on(this._invBtnElement,EVENT_CLICK$1,(e=>{e.preventDefault(),this._disableElement(this._invBtnElement),this._addItems(!0);})),EventHandler$1.on(this._resetBtnElement,EVENT_CLICK$1,(e=>{e.preventDefault(),this._disableElement(this._addBtnElement),this._disableElement(this._invBtnElement),this._disableElement(this._resetBtnElement),this._resetAll();}));}_disableElement(e){e.classList.remove("active"),e.setAttribute("disabled","disabled"),e.setAttribute("aria-disabled","true");}_enableElement(e){e.classList.add("active"),e.removeAttribute("disabled"),e.removeAttribute("aria-disabled");}_getScopeData(e){return {scope:e,list:SelectorEngine$1.find(SELECTOR_LIST_INPUT,e),listChecked:SelectorEngine$1.find(SELECTOR_LIST_INPUT+":checked",e),head:SelectorEngine$1.findOne(SELECTOR_HEAD,e),inputHead:SelectorEngine$1.findOne(SELECTOR_HEAD_INPUT,e),labelNumHead:SelectorEngine$1.findOne(SELECTOR_HEAD_LABEL,e),group:SelectorEngine$1.findOne(".transfer-group",e)}}_checkList(e){const t=this._getScopeData(e);0==t.listChecked.length?(t.inputHead.classList.remove("semi-checked"),t.inputHead.checked=!0,e.classList.contains("source")?this._disableElement(this._addBtnElement):this._disableElement(this._invBtnElement)):(t.listChecked.length==t.list.length?(t.inputHead.classList.remove("semi-checked"),t.inputHead.checked=!0):(t.inputHead.classList.add("semi-checked"),t.inputHead.checked=!1),e.classList.contains("source")?this._enableElement(this._addBtnElement):this._enableElement(this._invBtnElement));}_checkListHeader(e){const t=this._getScopeData(e);t.listChecked.length>0?(t.list.forEach((e=>{e.checked=!1;})),t.inputHead.classList.remove("semi-checked"),t.inputHead.checked=!1,e.classList.contains("source")?this._disableElement(this._addBtnElement):this._disableElement(this._invBtnElement)):(t.list.forEach((e=>{e.checked=!0;})),e.classList.contains("source")?this._enableElement(this._addBtnElement):this._enableElement(this._invBtnElement));}_addItems(e){const t=this._getScopeData(SelectorEngine$1.findOne(e?SELECTOR_TARGET:SELECTOR_SOURCE,this._element)),n=this._getScopeData(SelectorEngine$1.findOne(e?SELECTOR_SOURCE:SELECTOR_TARGET,this._element)),s=t.listChecked,i=t.inputHead,a=t.labelNumHead,E=s.length,r=t.list.length,l=n.group,c=n.list.length+E,_=n.labelNumHead,d=n.inputHead;s.forEach((e=>{const t=e.closest(".form-check");t.remove(),l.appendChild(t),e.checked=!1;}));const o=r-E,h=c;a.innerText=o,_.innerText=h,0==o&&i.setAttribute("disabled",!0),h>0&&d.removeAttribute("disabled"),i.classList.remove("semi-checked"),i.checked=!1,this._enableElement(this._resetBtnElement);}_resetAll(){const e={source:this._getScopeData(SelectorEngine$1.findOne(SELECTOR_SOURCE,this._element)),target:this._getScopeData(SelectorEngine$1.findOne(SELECTOR_TARGET,this._element))};Object.keys(e).forEach((t=>{e[t].list.forEach((e=>e.closest(".form-check").remove()));})),Object.keys(e).forEach((t=>{this._listDefault[t].forEach((n=>{n.checked=!1,e[t].group.appendChild(n);})),e[t].labelNumHead.innerText=this._listDefault[t].length,e[t].inputHead.removeAttribute("disabled"),e[t].inputHead.classList.remove("semi-checked"),e[t].inputHead.checked=!1;}));}}EventHandler$1.on(document,EVENT_CLICK_DATA_API$6,SELECTOR_BLOCK+" .form-check label",(function(){Transfer.getOrCreateInstance(this.closest(SELECTOR_BLOCK));})),EventHandler$1.on(document,EVENT_KEYUP_DATA_API$1,SELECTOR_BLOCK+" .form-check label",(function(){Transfer.getOrCreateInstance(this.closest(SELECTOR_BLOCK));}));const Transfer$1 = Transfer;

    const NAME$h="alert",EVENT_CLOSE="close.bs.alert",EVENT_CLOSED="closed.bs.alert";class Alert$2 extends BaseComponent{static get NAME(){return NAME$h}close(){if(EventHandler$1.trigger(this._element,EVENT_CLOSE).defaultPrevented)return;this._element.classList.remove("show");const e=this._element.classList.contains("fade");this._queueCallback((()=>this._destroyElement()),this._element,e);}_destroyElement(){this._element.remove(),EventHandler$1.trigger(this._element,EVENT_CLOSED),this.dispose();}static jQueryInterface(e){return this.each((function(){const t=Alert$2.getOrCreateInstance(this);if("string"==typeof e){if(void 0===t[e]||e.startsWith("_")||"constructor"===e)throw new TypeError(`No method named "${e}"`);t[e](this);}}))}}enableDismissTrigger(Alert$2,"close"),defineJQueryPlugin(Alert$2);

    class Alert extends Alert$2{}const Alert$1 = Alert;

    const NAME$g="button",SELECTOR_DATA_TOGGLE$7='[data-bs-toggle="button"]',EVENT_CLICK_DATA_API$5="click.bs.button.data-api";class Button$2 extends BaseComponent{static get NAME(){return NAME$g}toggle(){this._element.setAttribute("aria-pressed",this._element.classList.toggle("active"));}static jQueryInterface(t){return this.each((function(){const e=Button$2.getOrCreateInstance(this);"toggle"===t&&e[t]();}))}}EventHandler$1.on(document,EVENT_CLICK_DATA_API$5,SELECTOR_DATA_TOGGLE$7,(t=>{t.preventDefault();const e=t.target.closest(SELECTOR_DATA_TOGGLE$7);Button$2.getOrCreateInstance(e).toggle();})),defineJQueryPlugin(Button$2);

    class Button extends Button$2{}const Button$1 = Button;

    const NAME$f="swipe",EVENT_KEY$4=".bs.swipe",EVENT_TOUCHSTART="touchstart.bs.swipe",EVENT_TOUCHMOVE="touchmove.bs.swipe",EVENT_TOUCHEND="touchend.bs.swipe",EVENT_POINTERDOWN="pointerdown.bs.swipe",EVENT_POINTERUP="pointerup.bs.swipe",Default$d={endCallback:null,leftCallback:null,rightCallback:null},DefaultType$c={endCallback:"(function|null)",leftCallback:"(function|null)",rightCallback:"(function|null)"};class Swipe extends Config{constructor(t,e){super(),this._element=t,t&&Swipe.isSupported()&&(this._config=this._getConfig(e),this._deltaX=0,this._supportPointerEvents=Boolean(window.PointerEvent),this._initEvents());}static get Default(){return Default$d}static get DefaultType(){return DefaultType$c}static get NAME(){return NAME$f}dispose(){EventHandler$1.off(this._element,EVENT_KEY$4);}_start(t){this._supportPointerEvents?this._eventIsPointerPenTouch(t)&&(this._deltaX=t.clientX):this._deltaX=t.touches[0].clientX;}_end(t){this._eventIsPointerPenTouch(t)&&(this._deltaX=t.clientX-this._deltaX),this._handleSwipe(),execute(this._config.endCallback);}_move(t){this._deltaX=t.touches&&t.touches.length>1?0:t.touches[0].clientX-this._deltaX;}_handleSwipe(){const t=Math.abs(this._deltaX);if(t<=40)return;const e=t/this._deltaX;this._deltaX=0,e&&execute(e>0?this._config.rightCallback:this._config.leftCallback);}_initEvents(){this._supportPointerEvents?(EventHandler$1.on(this._element,EVENT_POINTERDOWN,(t=>this._start(t))),EventHandler$1.on(this._element,EVENT_POINTERUP,(t=>this._end(t))),this._element.classList.add("pointer-event")):(EventHandler$1.on(this._element,EVENT_TOUCHSTART,(t=>this._start(t))),EventHandler$1.on(this._element,EVENT_TOUCHMOVE,(t=>this._move(t))),EventHandler$1.on(this._element,EVENT_TOUCHEND,(t=>this._end(t))));}_eventIsPointerPenTouch(t){return this._supportPointerEvents&&("pen"===t.pointerType||"touch"===t.pointerType)}static isSupported(){return "ontouchstart"in document.documentElement||navigator.maxTouchPoints>0}}

    const NAME$e="carousel",EVENT_SLIDE="slide.bs.carousel",EVENT_SLID="slid.bs.carousel",EVENT_KEYDOWN$1="keydown.bs.carousel",EVENT_MOUSEENTER="mouseenter.bs.carousel",EVENT_MOUSELEAVE="mouseleave.bs.carousel",EVENT_DRAG_START="dragstart.bs.carousel",EVENT_LOAD_DATA_API$2="load.bs.carousel.data-api",EVENT_CLICK_DATA_API$4="click.bs.carousel.data-api",CLASS_NAME_END="carousel-item-end",CLASS_NAME_START="carousel-item-start",CLASS_NAME_NEXT="carousel-item-next",CLASS_NAME_PREV="carousel-item-prev",SELECTOR_ITEM=".carousel-item",SELECTOR_ACTIVE_ITEM=".active.carousel-item",SELECTOR_ITEM_IMG=".carousel-item img",SELECTOR_INDICATORS=".carousel-indicators",SELECTOR_DATA_SLIDE="[data-bs-slide], [data-bs-slide-to]",SELECTOR_DATA_RIDE='[data-bs-ride="carousel"]',KEY_TO_DIRECTION={ArrowLeft:"right",ArrowRight:"left"},Default$c={interval:5e3,keyboard:!0,pause:"hover",ride:!1,touch:!0,wrap:!0},DefaultType$b={interval:"(number|boolean)",keyboard:"boolean",pause:"(string|boolean)",ride:"(boolean|string)",touch:"boolean",wrap:"boolean"};class Carousel$2 extends BaseComponent{constructor(e,t){super(e,t),this._interval=null,this._activeElement=null,this._isSliding=!1,this.touchTimeout=null,this._swipeHelper=null,this._indicatorsElement=SelectorEngine$1.findOne(SELECTOR_INDICATORS,this._element),this._addEventListeners(),"carousel"===this._config.ride&&this.cycle();}static get Default(){return Default$c}static get DefaultType(){return DefaultType$b}static get NAME(){return NAME$e}next(){this._slide("next");}nextWhenVisible(){!document.hidden&&isVisible(this._element)&&this.next();}prev(){this._slide("prev");}pause(){this._isSliding&&triggerTransitionEnd(this._element),this._clearInterval();}cycle(){this._clearInterval(),this._updateInterval(),this._interval=setInterval((()=>this.nextWhenVisible()),this._config.interval);}_maybeEnableCycle(){this._config.ride&&(this._isSliding?EventHandler$1.one(this._element,EVENT_SLID,(()=>this.cycle())):this.cycle());}to(e){const t=this._getItems();if(e>t.length-1||e<0)return;if(this._isSliding)return void EventHandler$1.one(this._element,EVENT_SLID,(()=>this.to(e)));const i=this._getItemIndex(this._getActive());if(i===e)return;const s=e>i?"next":"prev";this._slide(s,t[e]);}dispose(){this._swipeHelper&&this._swipeHelper.dispose(),super.dispose();}_configAfterMerge(e){return e.defaultInterval=e.interval,e}_addEventListeners(){this._config.keyboard&&EventHandler$1.on(this._element,EVENT_KEYDOWN$1,(e=>this._keydown(e))),"hover"===this._config.pause&&(EventHandler$1.on(this._element,EVENT_MOUSEENTER,(()=>this.pause())),EventHandler$1.on(this._element,EVENT_MOUSELEAVE,(()=>this._maybeEnableCycle()))),this._config.touch&&Swipe.isSupported()&&this._addTouchEventListeners();}_addTouchEventListeners(){for(const e of SelectorEngine$1.find(SELECTOR_ITEM_IMG,this._element))EventHandler$1.on(e,EVENT_DRAG_START,(e=>e.preventDefault()));const e={leftCallback:()=>this._slide(this._directionToOrder("left")),rightCallback:()=>this._slide(this._directionToOrder("right")),endCallback:()=>{"hover"===this._config.pause&&(this.pause(),this.touchTimeout&&clearTimeout(this.touchTimeout),this.touchTimeout=setTimeout((()=>this._maybeEnableCycle()),500+this._config.interval));}};this._swipeHelper=new Swipe(this._element,e);}_keydown(e){if(/input|textarea/i.test(e.target.tagName))return;const t=KEY_TO_DIRECTION[e.key];t&&(e.preventDefault(),this._slide(this._directionToOrder(t)));}_getItemIndex(e){return this._getItems().indexOf(e)}_setActiveIndicatorElement(e){if(!this._indicatorsElement)return;const t=SelectorEngine$1.findOne(".active",this._indicatorsElement);t.classList.remove("active"),t.removeAttribute("aria-current");const i=SelectorEngine$1.findOne(`[data-bs-slide-to="${e}"]`,this._indicatorsElement);i&&(i.classList.add("active"),i.setAttribute("aria-current","true"));}_updateInterval(){const e=this._activeElement||this._getActive();if(!e)return;const t=Number.parseInt(e.getAttribute("data-bs-interval"),10);this._config.interval=t||this._config.defaultInterval;}_slide(e,t=null){if(this._isSliding)return;const i=this._getActive(),s="next"===e,n=t||getNextActiveElement(this._getItems(),i,s,this._config.wrap);if(n===i)return;const r=this._getItemIndex(n),a=t=>EventHandler$1.trigger(this._element,t,{relatedTarget:n,direction:this._orderToDirection(e),from:this._getItemIndex(i),to:r});if(a(EVENT_SLIDE).defaultPrevented)return;if(!i||!n)return;const l=Boolean(this._interval);this.pause(),this._isSliding=!0,this._setActiveIndicatorElement(r),this._activeElement=n;const o=s?CLASS_NAME_START:CLASS_NAME_END,_=s?CLASS_NAME_NEXT:CLASS_NAME_PREV;n.classList.add(_),reflow(n),i.classList.add(o),n.classList.add(o);this._queueCallback((()=>{n.classList.remove(o,_),n.classList.add("active"),i.classList.remove("active",_,o),this._isSliding=!1,a(EVENT_SLID);}),i,this._isAnimated()),l&&this.cycle();}_isAnimated(){return this._element.classList.contains("slide")}_getActive(){return SelectorEngine$1.findOne(SELECTOR_ACTIVE_ITEM,this._element)}_getItems(){return SelectorEngine$1.find(SELECTOR_ITEM,this._element)}_clearInterval(){this._interval&&(clearInterval(this._interval),this._interval=null);}_directionToOrder(e){return isRTL()?"left"===e?"prev":"next":"left"===e?"next":"prev"}_orderToDirection(e){return isRTL()?"prev"===e?"left":"right":"prev"===e?"right":"left"}static jQueryInterface(e){return this.each((function(){const t=Carousel$2.getOrCreateInstance(this,e);if("number"!=typeof e){if("string"==typeof e){if(void 0===t[e]||e.startsWith("_")||"constructor"===e)throw new TypeError(`No method named "${e}"`);t[e]();}}else t.to(e);}))}}EventHandler$1.on(document,EVENT_CLICK_DATA_API$4,SELECTOR_DATA_SLIDE,(function(e){const t=getElementFromSelector(this);if(!t||!t.classList.contains("carousel"))return;e.preventDefault();const i=Carousel$2.getOrCreateInstance(t),s=this.getAttribute("data-bs-slide-to");return s?(i.to(s),void i._maybeEnableCycle()):"next"===Manipulator.getDataAttribute(this,"slide")?(i.next(),void i._maybeEnableCycle()):(i.prev(),void i._maybeEnableCycle())})),EventHandler$1.on(window,EVENT_LOAD_DATA_API$2,(()=>{const e=SelectorEngine$1.find(SELECTOR_DATA_RIDE);for(const t of e)Carousel$2.getOrCreateInstance(t);})),defineJQueryPlugin(Carousel$2);

    class Carousel extends Carousel$2{}const Carousel$1 = Carousel;

    const NAME$d="collapse",EVENT_SHOW$5="show.bs.collapse",EVENT_SHOWN$5="shown.bs.collapse",EVENT_HIDE$5="hide.bs.collapse",EVENT_HIDDEN$5="hidden.bs.collapse",EVENT_CLICK_DATA_API$3="click.bs.collapse.data-api",CLASS_NAME_DEEPER_CHILDREN=":scope .collapse .collapse",WIDTH="width",HEIGHT="height",SELECTOR_ACTIVES=".collapse.show, .collapse.collapsing",SELECTOR_DATA_TOGGLE$6='[data-bs-toggle="collapse"]',Default$b={parent:null,toggle:!0},DefaultType$a={parent:"(null|element)",toggle:"boolean"};class Collapse$2 extends BaseComponent{constructor(e,t){super(e,t),this._isTransitioning=!1,this._triggerArray=[];const s=SelectorEngine$1.find(SELECTOR_DATA_TOGGLE$6);for(const e of s){const t=getSelectorFromElement(e),s=SelectorEngine$1.find(t).filter((e=>e===this._element));null!==t&&s.length&&this._triggerArray.push(e);}this._initializeChildren(),this._config.parent||this._addAriaAndCollapsedClass(this._triggerArray,this._isShown()),this._config.toggle&&this.toggle();}static get Default(){return Default$b}static get DefaultType(){return DefaultType$a}static get NAME(){return NAME$d}toggle(){this._isShown()?this.hide():this.show();}show(){if(this._isTransitioning||this._isShown())return;let e=[];if(this._config.parent&&(e=this._getFirstLevelChildren(SELECTOR_ACTIVES).filter((e=>e!==this._element)).map((e=>Collapse$2.getOrCreateInstance(e,{toggle:!1})))),e.length&&e[0]._isTransitioning)return;if(EventHandler$1.trigger(this._element,EVENT_SHOW$5).defaultPrevented)return;for(const t of e)t.hide();const t=this._getDimension();this._element.classList.remove("collapse"),this._element.classList.add("collapsing"),this._element.style[t]=0,this._addAriaAndCollapsedClass(this._triggerArray,!0),this._isTransitioning=!0;const s=`scroll${t[0].toUpperCase()+t.slice(1)}`;this._queueCallback((()=>{this._isTransitioning=!1,this._element.classList.remove("collapsing"),this._element.classList.add("collapse","show"),this._element.style[t]="",EventHandler$1.trigger(this._element,EVENT_SHOWN$5);}),this._element,!0),this._element.style[t]=`${this._element[s]}px`;}hide(){if(this._isTransitioning||!this._isShown())return;if(EventHandler$1.trigger(this._element,EVENT_HIDE$5).defaultPrevented)return;const e=this._getDimension();this._element.style[e]=`${this._element.getBoundingClientRect()[e]}px`,reflow(this._element),this._element.classList.add("collapsing"),this._element.classList.remove("collapse","show");for(const e of this._triggerArray){const t=getElementFromSelector(e);t&&!this._isShown(t)&&this._addAriaAndCollapsedClass([e],!1);}this._isTransitioning=!0;this._element.style[e]="",this._queueCallback((()=>{this._isTransitioning=!1,this._element.classList.remove("collapsing"),this._element.classList.add("collapse"),EventHandler$1.trigger(this._element,EVENT_HIDDEN$5);}),this._element,!0);}_isShown(e=this._element){return e.classList.contains("show")}_configAfterMerge(e){return e.toggle=Boolean(e.toggle),e.parent=getElement(e.parent),e}_getDimension(){return this._element.classList.contains("collapse-horizontal")?WIDTH:HEIGHT}_initializeChildren(){if(!this._config.parent)return;const e=this._getFirstLevelChildren(SELECTOR_DATA_TOGGLE$6);for(const t of e){const e=getElementFromSelector(t);e&&this._addAriaAndCollapsedClass([t],this._isShown(e));}}_getFirstLevelChildren(e){const t=SelectorEngine$1.find(CLASS_NAME_DEEPER_CHILDREN,this._config.parent);return SelectorEngine$1.find(e,this._config.parent).filter((e=>!t.includes(e)))}_addAriaAndCollapsedClass(e,t){if(e.length)for(const s of e)s.classList.toggle("collapsed",!t),s.setAttribute("aria-expanded",t);}static jQueryInterface(e){const t={};return "string"==typeof e&&/show|hide/.test(e)&&(t.toggle=!1),this.each((function(){const s=Collapse$2.getOrCreateInstance(this,t);if("string"==typeof e){if(void 0===s[e])throw new TypeError(`No method named "${e}"`);s[e]();}}))}}EventHandler$1.on(document,EVENT_CLICK_DATA_API$3,SELECTOR_DATA_TOGGLE$6,(function(e){("A"===e.target.tagName||e.delegateTarget&&"A"===e.delegateTarget.tagName)&&e.preventDefault();const t=getSelectorFromElement(this),s=SelectorEngine$1.find(t);for(const e of s)Collapse$2.getOrCreateInstance(e,{toggle:!1}).toggle();})),defineJQueryPlugin(Collapse$2);

    class Collapse extends Collapse$2{}const Collapse$1 = Collapse;

    const NAME$c="dropdown",ARROW_UP_KEY$2="ArrowUp",ARROW_DOWN_KEY$2="ArrowDown",EVENT_HIDE$4="hide.bs.dropdown",EVENT_HIDDEN$4="hidden.bs.dropdown",EVENT_SHOW$4="show.bs.dropdown",EVENT_SHOWN$4="shown.bs.dropdown",EVENT_CLICK_DATA_API$2="click.bs.dropdown.data-api",EVENT_KEYDOWN_DATA_API="keydown.bs.dropdown.data-api",EVENT_KEYUP_DATA_API="keyup.bs.dropdown.data-api",SELECTOR_DATA_TOGGLE$5='[data-bs-toggle="dropdown"]:not(.disabled):not(:disabled)',SELECTOR_DATA_TOGGLE_SHOWN=`${SELECTOR_DATA_TOGGLE$5}.show`,SELECTOR_MENU=".dropdown-menu",SELECTOR_VISIBLE_ITEMS=".dropdown-menu .dropdown-item:not(.disabled):not(:disabled)",PLACEMENT_TOP=isRTL()?"top-end":"top-start",PLACEMENT_TOPEND=isRTL()?"top-start":"top-end",PLACEMENT_BOTTOM=isRTL()?"bottom-end":"bottom-start",PLACEMENT_BOTTOMEND=isRTL()?"bottom-start":"bottom-end",PLACEMENT_RIGHT=isRTL()?"left-start":"right-start",PLACEMENT_LEFT=isRTL()?"right-start":"left-start",Default$a={autoClose:!0,boundary:"clippingParents",display:"dynamic",offset:[0,2],popperConfig:null,reference:"toggle"},DefaultType$9={autoClose:"(boolean|string)",boundary:"(string|element)",display:"string",offset:"(array|string|function)",popperConfig:"(null|object|function)",reference:"(string|element|object)"};class Dropdown$2 extends BaseComponent{constructor(e,t){super(e,t),this._popper=null,this._parent=this._element.parentNode,this._menu=SelectorEngine$1.next(this._element,SELECTOR_MENU)[0]||SelectorEngine$1.prev(this._element,SELECTOR_MENU)[0]||SelectorEngine$1.findOne(SELECTOR_MENU,this._parent),this._inNavbar=this._detectNavbar();}static get Default(){return Default$a}static get DefaultType(){return DefaultType$9}static get NAME(){return NAME$c}toggle(){return this._isShown()?this.hide():this.show()}show(){if(isDisabled(this._element)||this._isShown())return;const e={relatedTarget:this._element};if(!EventHandler$1.trigger(this._element,EVENT_SHOW$4,e).defaultPrevented){if(this._createPopper(),"ontouchstart"in document.documentElement&&!this._parent.closest(".navbar-nav"))for(const e of [].concat(...document.body.children))EventHandler$1.on(e,"mouseover",noop);this._element.focus(),this._element.setAttribute("aria-expanded",!0),this._menu.classList.add("show"),this._element.classList.add("show"),EventHandler$1.trigger(this._element,EVENT_SHOWN$4,e);}}hide(){if(isDisabled(this._element)||!this._isShown())return;const e={relatedTarget:this._element};this._completeHide(e);}dispose(){this._popper&&this._popper.destroy(),super.dispose();}update(){this._inNavbar=this._detectNavbar(),this._popper&&this._popper.update();}_completeHide(e){if(!EventHandler$1.trigger(this._element,EVENT_HIDE$4,e).defaultPrevented){if("ontouchstart"in document.documentElement)for(const e of [].concat(...document.body.children))EventHandler$1.off(e,"mouseover",noop);this._popper&&this._popper.destroy(),this._menu.classList.remove("show"),this._element.classList.remove("show"),this._element.setAttribute("aria-expanded","false"),Manipulator.removeDataAttribute(this._menu,"popper"),EventHandler$1.trigger(this._element,EVENT_HIDDEN$4,e);}}_getConfig(e){if("object"==typeof(e=super._getConfig(e)).reference&&!isElement$1(e.reference)&&"function"!=typeof e.reference.getBoundingClientRect)throw new TypeError(`${NAME$c.toUpperCase()}: Option "reference" provided type "object" without a required "getBoundingClientRect" method.`);return e}_createPopper(){if(void 0===Popper__namespace)throw new TypeError("Bootstrap's dropdowns require Popper (https://popper.js.org)");let e=this._element;"parent"===this._config.reference?e=this._parent:isElement$1(this._config.reference)?e=getElement(this._config.reference):"object"==typeof this._config.reference&&(e=this._config.reference);const t=this._getPopperConfig();this._popper=Popper__namespace.createPopper(e,this._menu,t);}_isShown(){return this._menu.classList.contains("show")}_getPlacement(){const e=this._parent;if(e.classList.contains("dropend"))return PLACEMENT_RIGHT;if(e.classList.contains("dropstart"))return PLACEMENT_LEFT;if(e.classList.contains("dropup-center"))return "top";if(e.classList.contains("dropdown-center"))return "bottom";const t="end"===getComputedStyle(this._menu).getPropertyValue("--bs-position").trim();return e.classList.contains("dropup")?t?PLACEMENT_TOPEND:PLACEMENT_TOP:t?PLACEMENT_BOTTOMEND:PLACEMENT_BOTTOM}_detectNavbar(){return null!==this._element.closest(".navbar")}_getOffset(){const{offset:e}=this._config;return "string"==typeof e?e.split(",").map((e=>Number.parseInt(e,10))):"function"==typeof e?t=>e(t,this._element):e}_getPopperConfig(){const e={placement:this._getPlacement(),modifiers:[{name:"preventOverflow",options:{boundary:this._config.boundary}},{name:"offset",options:{offset:this._getOffset()}}]};return (this._inNavbar||"static"===this._config.display)&&(Manipulator.setDataAttribute(this._menu,"popper","static"),e.modifiers=[{name:"applyStyles",enabled:!1}]),{...e,..."function"==typeof this._config.popperConfig?this._config.popperConfig(e):this._config.popperConfig}}_selectMenuItem({key:e,target:t}){const n=SelectorEngine$1.find(SELECTOR_VISIBLE_ITEMS,this._menu).filter((e=>isVisible(e)));n.length&&getNextActiveElement(n,t,e===ARROW_DOWN_KEY$2,!n.includes(t)).focus();}static jQueryInterface(e){return this.each((function(){const t=Dropdown$2.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===t[e])throw new TypeError(`No method named "${e}"`);t[e]();}}))}static clearMenus(e){if(2===e.button||"keyup"===e.type&&"Tab"!==e.key)return;const t=SelectorEngine$1.find(SELECTOR_DATA_TOGGLE_SHOWN);for(const n of t){const t=Dropdown$2.getInstance(n);if(!t||!1===t._config.autoClose)continue;const o=e.composedPath(),r=o.includes(t._menu);if(o.includes(t._element)||"inside"===t._config.autoClose&&!r||"outside"===t._config.autoClose&&r)continue;if(t._menu.contains(e.target)&&("keyup"===e.type&&"Tab"===e.key||/input|select|option|textarea|form/i.test(e.target.tagName)))continue;const i={relatedTarget:t._element};"click"===e.type&&(i.clickEvent=e),t._completeHide(i);}}static dataApiKeydownHandler(e){const t=/input|textarea/i.test(e.target.tagName),n="Escape"===e.key,o=[ARROW_UP_KEY$2,ARROW_DOWN_KEY$2].includes(e.key);if(!o&&!n)return;if(t&&!n)return;e.preventDefault();const r=this.matches(SELECTOR_DATA_TOGGLE$5)?this:SelectorEngine$1.prev(this,SELECTOR_DATA_TOGGLE$5)[0]||SelectorEngine$1.next(this,SELECTOR_DATA_TOGGLE$5)[0]||SelectorEngine$1.findOne(SELECTOR_DATA_TOGGLE$5,e.delegateTarget.parentNode),i=Dropdown$2.getOrCreateInstance(r);if(o)return e.stopPropagation(),i.show(),void i._selectMenuItem(e);i._isShown()&&(e.stopPropagation(),i.hide(),r.focus());}}EventHandler$1.on(document,EVENT_KEYDOWN_DATA_API,SELECTOR_DATA_TOGGLE$5,Dropdown$2.dataApiKeydownHandler),EventHandler$1.on(document,EVENT_KEYDOWN_DATA_API,SELECTOR_MENU,Dropdown$2.dataApiKeydownHandler),EventHandler$1.on(document,EVENT_CLICK_DATA_API$2,Dropdown$2.clearMenus),EventHandler$1.on(document,EVENT_KEYUP_DATA_API,Dropdown$2.clearMenus),EventHandler$1.on(document,EVENT_CLICK_DATA_API$2,SELECTOR_DATA_TOGGLE$5,(function(e){e.preventDefault(),Dropdown$2.getOrCreateInstance(this).toggle();})),defineJQueryPlugin(Dropdown$2);

    class Dropdown extends Dropdown$2{}const Dropdown$1 = Dropdown;

    const SELECTOR_FIXED_CONTENT=".fixed-top, .fixed-bottom, .is-fixed, .sticky-top";class ScrollBarHelper{constructor(){this._element=document.body;}getWidth(){const t=document.documentElement.clientWidth;return Math.abs(window.innerWidth-t)}hide(){const t=this.getWidth();this._disableOverFlow(),this._setElementAttributes(this._element,"padding-right",(e=>e+t)),this._setElementAttributes(SELECTOR_FIXED_CONTENT,"padding-right",(e=>e+t)),this._setElementAttributes(".sticky-top","margin-right",(e=>e-t));}reset(){this._resetElementAttributes(this._element,"overflow"),this._resetElementAttributes(this._element,"padding-right"),this._resetElementAttributes(SELECTOR_FIXED_CONTENT,"padding-right"),this._resetElementAttributes(".sticky-top","margin-right");}isOverflowing(){return this.getWidth()>0}_disableOverFlow(){this._saveInitialAttribute(this._element,"overflow"),this._element.style.overflow="hidden";}_setElementAttributes(t,e,i){const r=this.getWidth();this._applyManipulationCallback(t,(t=>{if(t!==this._element&&window.innerWidth>t.clientWidth+r)return;this._saveInitialAttribute(t,e);const n=window.getComputedStyle(t).getPropertyValue(e);t.style.setProperty(e,`${i(Number.parseFloat(n))}px`);}));}_saveInitialAttribute(t,e){const i=t.style.getPropertyValue(e);i&&Manipulator.setDataAttribute(t,e,i);}_resetElementAttributes(t,e){this._applyManipulationCallback(t,(t=>{const i=Manipulator.getDataAttribute(t,e);null!==i?(Manipulator.removeDataAttribute(t,e),t.style.setProperty(e,i)):t.style.removeProperty(e);}));}_applyManipulationCallback(t,e){if(isElement$1(t))e(t);else for(const i of SelectorEngine$1.find(t,this._element))e(i);}}

    const NAME$b="backdrop",EVENT_MOUSEDOWN=`mousedown.bs.${NAME$b}`,Default$9={className:"modal-backdrop",clickCallback:null,isAnimated:!1,isVisible:!0,rootElement:"body"},DefaultType$8={className:"string",clickCallback:"(function|null)",isAnimated:"boolean",isVisible:"boolean",rootElement:"(element|string)"};class Backdrop extends Config{constructor(e){super(),this._config=this._getConfig(e),this._isAppended=!1,this._element=null;}static get Default(){return Default$9}static get DefaultType(){return DefaultType$8}static get NAME(){return NAME$b}show(e){if(!this._config.isVisible)return void execute(e);this._append();const t=this._getElement();this._config.isAnimated&&reflow(t),t.classList.add("show"),this._emulateAnimation((()=>{execute(e);}));}hide(e){this._config.isVisible?(this._getElement().classList.remove("show"),this._emulateAnimation((()=>{this.dispose(),execute(e);}))):execute(e);}dispose(){this._isAppended&&(EventHandler$1.off(this._element,EVENT_MOUSEDOWN),this._element.remove(),this._isAppended=!1);}_getElement(){if(!this._element){const e=document.createElement("div");e.className=this._config.className,this._config.isAnimated&&e.classList.add("fade"),this._element=e;}return this._element}_configAfterMerge(e){return e.rootElement=getElement(e.rootElement),e}_append(){if(this._isAppended)return;const e=this._getElement();this._config.rootElement.append(e),EventHandler$1.on(e,EVENT_MOUSEDOWN,(()=>{execute(this._config.clickCallback);})),this._isAppended=!0;}_emulateAnimation(e){executeAfterTransition(e,this._getElement(),this._config.isAnimated);}}

    const NAME$a="focustrap",DATA_KEY$2="bs.focustrap",EVENT_KEY$3=`.${DATA_KEY$2}`,EVENT_FOCUSIN$1=`focusin${EVENT_KEY$3}`,EVENT_KEYDOWN_TAB=`keydown.tab${EVENT_KEY$3}`,Default$8={autofocus:!0,trapElement:null},DefaultType$7={autofocus:"boolean",trapElement:"element"};class FocusTrap extends Config{constructor(t){super(),this._config=this._getConfig(t),this._isActive=!1,this._lastTabNavDirection=null;}static get Default(){return Default$8}static get DefaultType(){return DefaultType$7}static get NAME(){return NAME$a}activate(){this._isActive||(this._config.autofocus&&this._config.trapElement.focus(),EventHandler$1.off(document,EVENT_KEY$3),EventHandler$1.on(document,EVENT_FOCUSIN$1,(t=>this._handleFocusin(t))),EventHandler$1.on(document,EVENT_KEYDOWN_TAB,(t=>this._handleKeydown(t))),this._isActive=!0);}deactivate(){this._isActive&&(this._isActive=!1,EventHandler$1.off(document,EVENT_KEY$3));}_handleFocusin(t){const{trapElement:e}=this._config;if(t.target===document||t.target===e||e.contains(t.target))return;const n=SelectorEngine$1.focusableChildren(e);0===n.length?e.focus():"backward"===this._lastTabNavDirection?n[n.length-1].focus():n[0].focus();}_handleKeydown(t){"Tab"===t.key&&(this._lastTabNavDirection=t.shiftKey?"backward":"forward");}}

    const NAME$9="modal",EVENT_KEY$2=".bs.modal",EVENT_HIDE$3="hide.bs.modal",EVENT_HIDE_PREVENTED$1="hidePrevented.bs.modal",EVENT_HIDDEN$3="hidden.bs.modal",EVENT_SHOW$3="show.bs.modal",EVENT_SHOWN$3="shown.bs.modal",EVENT_RESIZE$1="resize.bs.modal",EVENT_CLICK_DISMISS="click.dismiss.bs.modal",EVENT_MOUSEDOWN_DISMISS="mousedown.dismiss.bs.modal",EVENT_KEYDOWN_DISMISS$1="keydown.dismiss.bs.modal",EVENT_CLICK_DATA_API$1="click.bs.modal.data-api",SELECTOR_DATA_TOGGLE$4='[data-bs-toggle="modal"]',Default$7={backdrop:!0,focus:!0,keyboard:!0},DefaultType$6={backdrop:"(boolean|string)",focus:"boolean",keyboard:"boolean"};class Modal$2 extends BaseComponent{constructor(e,t){super(e,t),this._dialog=SelectorEngine$1.findOne(".modal-dialog",this._element),this._backdrop=this._initializeBackDrop(),this._focustrap=this._initializeFocusTrap(),this._isShown=!1,this._isTransitioning=!1,this._scrollBar=new ScrollBarHelper,this._addEventListeners();}static get Default(){return Default$7}static get DefaultType(){return DefaultType$6}static get NAME(){return NAME$9}toggle(e){return this._isShown?this.hide():this.show(e)}show(e){if(this._isShown||this._isTransitioning)return;EventHandler$1.trigger(this._element,EVENT_SHOW$3,{relatedTarget:e}).defaultPrevented||(this._isShown=!0,this._isTransitioning=!0,this._scrollBar.hide(),document.body.classList.add("modal-open"),this._adjustDialog(),this._backdrop.show((()=>this._showElement(e))));}hide(){if(!this._isShown||this._isTransitioning)return;EventHandler$1.trigger(this._element,EVENT_HIDE$3).defaultPrevented||(this._isShown=!1,this._isTransitioning=!0,this._focustrap.deactivate(),this._element.classList.remove("show"),this._queueCallback((()=>this._hideModal()),this._element,this._isAnimated()));}dispose(){for(const e of [window,this._dialog])EventHandler$1.off(e,EVENT_KEY$2);this._backdrop.dispose(),this._focustrap.deactivate(),super.dispose();}handleUpdate(){this._adjustDialog();}_initializeBackDrop(){return new Backdrop({isVisible:Boolean(this._config.backdrop),isAnimated:this._isAnimated()})}_initializeFocusTrap(){return new FocusTrap({trapElement:this._element})}_showElement(e){document.body.contains(this._element)||document.body.append(this._element),this._element.style.display="block",this._element.removeAttribute("aria-hidden"),this._element.setAttribute("aria-modal",!0),this._element.setAttribute("role","dialog"),this._element.scrollTop=0;const t=SelectorEngine$1.findOne(".modal-body",this._dialog);t&&(t.scrollTop=0),reflow(this._element),this._element.classList.add("show");this._queueCallback((()=>{this._config.focus&&this._focustrap.activate(),this._isTransitioning=!1,EventHandler$1.trigger(this._element,EVENT_SHOWN$3,{relatedTarget:e});}),this._dialog,this._isAnimated());}_addEventListeners(){EventHandler$1.on(this._element,EVENT_KEYDOWN_DISMISS$1,(e=>{if("Escape"===e.key)return this._config.keyboard?(e.preventDefault(),void this.hide()):void this._triggerBackdropTransition()})),EventHandler$1.on(window,EVENT_RESIZE$1,(()=>{this._isShown&&!this._isTransitioning&&this._adjustDialog();})),EventHandler$1.on(this._element,EVENT_MOUSEDOWN_DISMISS,(e=>{EventHandler$1.one(this._element,EVENT_CLICK_DISMISS,(t=>{this._element===e.target&&this._element===t.target&&("static"!==this._config.backdrop?this._config.backdrop&&this.hide():this._triggerBackdropTransition());}));}));}_hideModal(){this._element.style.display="none",this._element.setAttribute("aria-hidden",!0),this._element.removeAttribute("aria-modal"),this._element.removeAttribute("role"),this._isTransitioning=!1,this._backdrop.hide((()=>{document.body.classList.remove("modal-open"),this._resetAdjustments(),this._scrollBar.reset(),EventHandler$1.trigger(this._element,EVENT_HIDDEN$3);}));}_isAnimated(){return this._element.classList.contains("fade")}_triggerBackdropTransition(){if(EventHandler$1.trigger(this._element,EVENT_HIDE_PREVENTED$1).defaultPrevented)return;const e=this._element.scrollHeight>document.documentElement.clientHeight,t=this._element.style.overflowY;"hidden"===t||this._element.classList.contains("modal-static")||(e||(this._element.style.overflowY="hidden"),this._element.classList.add("modal-static"),this._queueCallback((()=>{this._element.classList.remove("modal-static"),this._queueCallback((()=>{this._element.style.overflowY=t;}),this._dialog);}),this._dialog),this._element.focus());}_adjustDialog(){const e=this._element.scrollHeight>document.documentElement.clientHeight,t=this._scrollBar.getWidth(),i=t>0;if(i&&!e){const e=isRTL()?"paddingLeft":"paddingRight";this._element.style[e]=`${t}px`;}if(!i&&e){const e=isRTL()?"paddingRight":"paddingLeft";this._element.style[e]=`${t}px`;}}_resetAdjustments(){this._element.style.paddingLeft="",this._element.style.paddingRight="";}static jQueryInterface(e,t){return this.each((function(){const i=Modal$2.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===i[e])throw new TypeError(`No method named "${e}"`);i[e](t);}}))}}EventHandler$1.on(document,EVENT_CLICK_DATA_API$1,SELECTOR_DATA_TOGGLE$4,(function(e){const t=getElementFromSelector(this);["A","AREA"].includes(this.tagName)&&e.preventDefault(),EventHandler$1.one(t,EVENT_SHOW$3,(e=>{e.defaultPrevented||EventHandler$1.one(t,EVENT_HIDDEN$3,(()=>{isVisible(this)&&this.focus();}));}));const i=SelectorEngine$1.findOne(".modal.show");i&&Modal$2.getInstance(i).hide();Modal$2.getOrCreateInstance(t).toggle(this);})),enableDismissTrigger(Modal$2),defineJQueryPlugin(Modal$2);

    class Modal extends Modal$2{}const Modal$1 = Modal;

    const NAME$8="offcanvas",DATA_KEY$1="bs.offcanvas",EVENT_KEY$1=`.${DATA_KEY$1}`,EVENT_LOAD_DATA_API$1=`load${EVENT_KEY$1}.data-api`,CLASS_NAME_BACKDROP="offcanvas-backdrop",OPEN_SELECTOR=".offcanvas.show",EVENT_SHOW$2=`show${EVENT_KEY$1}`,EVENT_SHOWN$2=`shown${EVENT_KEY$1}`,EVENT_HIDE$2=`hide${EVENT_KEY$1}`,EVENT_HIDE_PREVENTED=`hidePrevented${EVENT_KEY$1}`,EVENT_HIDDEN$2=`hidden${EVENT_KEY$1}`,EVENT_RESIZE=`resize${EVENT_KEY$1}`,EVENT_CLICK_DATA_API=`click${EVENT_KEY$1}.data-api`,EVENT_KEYDOWN_DISMISS=`keydown.dismiss${EVENT_KEY$1}`,SELECTOR_DATA_TOGGLE$3='[data-bs-toggle="offcanvas"]',Default$6={backdrop:!0,keyboard:!0,scroll:!1},DefaultType$5={backdrop:"(boolean|string)",keyboard:"boolean",scroll:"boolean"};class Offcanvas$2 extends BaseComponent{constructor(e,t){super(e,t),this._isShown=!1,this._backdrop=this._initializeBackDrop(),this._focustrap=this._initializeFocusTrap(),this._addEventListeners();}static get Default(){return Default$6}static get DefaultType(){return DefaultType$5}static get NAME(){return NAME$8}toggle(e){return this._isShown?this.hide():this.show(e)}show(e){if(this._isShown)return;if(EventHandler$1.trigger(this._element,EVENT_SHOW$2,{relatedTarget:e}).defaultPrevented)return;this._isShown=!0,this._backdrop.show(),this._config.scroll||(new ScrollBarHelper).hide(),this._element.setAttribute("aria-modal",!0),this._element.setAttribute("role","dialog"),this._element.classList.add("showing");this._queueCallback((()=>{this._config.scroll&&!this._config.backdrop||this._focustrap.activate(),this._element.classList.add("show"),this._element.classList.remove("showing"),EventHandler$1.trigger(this._element,EVENT_SHOWN$2,{relatedTarget:e});}),this._element,!0);}hide(){if(!this._isShown)return;if(EventHandler$1.trigger(this._element,EVENT_HIDE$2).defaultPrevented)return;this._focustrap.deactivate(),this._element.blur(),this._isShown=!1,this._element.classList.add("hiding"),this._backdrop.hide();this._queueCallback((()=>{this._element.classList.remove("show","hiding"),this._element.removeAttribute("aria-modal"),this._element.removeAttribute("role"),this._config.scroll||(new ScrollBarHelper).reset(),EventHandler$1.trigger(this._element,EVENT_HIDDEN$2);}),this._element,!0);}dispose(){this._backdrop.dispose(),this._focustrap.deactivate(),super.dispose();}_initializeBackDrop(){const e=Boolean(this._config.backdrop);return new Backdrop({className:CLASS_NAME_BACKDROP,isVisible:e,isAnimated:!0,rootElement:this._element.parentNode,clickCallback:e?()=>{"static"!==this._config.backdrop?this.hide():EventHandler$1.trigger(this._element,EVENT_HIDE_PREVENTED);}:null})}_initializeFocusTrap(){return new FocusTrap({trapElement:this._element})}_addEventListeners(){EventHandler$1.on(this._element,EVENT_KEYDOWN_DISMISS,(e=>{"Escape"===e.key&&(this._config.keyboard?this.hide():EventHandler$1.trigger(this._element,EVENT_HIDE_PREVENTED));}));}static jQueryInterface(e){return this.each((function(){const t=Offcanvas$2.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===t[e]||e.startsWith("_")||"constructor"===e)throw new TypeError(`No method named "${e}"`);t[e](this);}}))}}EventHandler$1.on(document,EVENT_CLICK_DATA_API,SELECTOR_DATA_TOGGLE$3,(function(e){const t=getElementFromSelector(this);if(["A","AREA"].includes(this.tagName)&&e.preventDefault(),isDisabled(this))return;EventHandler$1.one(t,EVENT_HIDDEN$2,(()=>{isVisible(this)&&this.focus();}));const i=SelectorEngine$1.findOne(OPEN_SELECTOR);i&&i!==t&&Offcanvas$2.getInstance(i).hide();Offcanvas$2.getOrCreateInstance(t).toggle(this);})),EventHandler$1.on(window,EVENT_LOAD_DATA_API$1,(()=>{for(const e of SelectorEngine$1.find(OPEN_SELECTOR))Offcanvas$2.getOrCreateInstance(e).show();})),EventHandler$1.on(window,EVENT_RESIZE,(()=>{for(const e of SelectorEngine$1.find("[aria-modal][class*=show][class*=offcanvas-]"))"fixed"!==getComputedStyle(e).position&&Offcanvas$2.getOrCreateInstance(e).hide();})),enableDismissTrigger(Offcanvas$2),defineJQueryPlugin(Offcanvas$2);

    class Offcanvas extends Offcanvas$2{}const Offcanvas$1 = Offcanvas;

    const uriAttributes=new Set(["background","cite","href","itemtype","longdesc","poster","src","xlink:href"]),ARIA_ATTRIBUTE_PATTERN=/^aria-[\w-]*$/i,SAFE_URL_PATTERN=/^(?:(?:https?|mailto|ftp|tel|file|sms):|[^#&/:?]*(?:[#/?]|$))/i,DATA_URL_PATTERN=/^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[\d+/a-z]+=*$/i,allowedAttribute=(e,t)=>{const o=e.nodeName.toLowerCase();return t.includes(o)?!uriAttributes.has(o)||Boolean(SAFE_URL_PATTERN.test(e.nodeValue)||DATA_URL_PATTERN.test(e.nodeValue)):t.filter((e=>e instanceof RegExp)).some((e=>e.test(o)))};const DefaultAllowlist={"*":["class","dir","id","lang","role",ARIA_ATTRIBUTE_PATTERN],a:["target","href","title","rel"],area:[],b:[],br:[],col:[],code:[],div:[],em:[],hr:[],h1:[],h2:[],h3:[],h4:[],h5:[],h6:[],i:[],img:["src","srcset","alt","title","width","height"],li:[],ol:[],p:[],pre:[],s:[],small:[],span:[],sub:[],sup:[],strong:[],u:[],ul:[]};function sanitizeHtml(e,t,o){if(!e.length)return e;if(o&&"function"==typeof o)return o(e);const r=(new window.DOMParser).parseFromString(e,"text/html"),i=[].concat(...r.body.querySelectorAll("*"));for(const e of i){const o=e.nodeName.toLowerCase();if(!Object.keys(t).includes(o)){e.remove();continue}const r=[].concat(...e.attributes),i=[].concat(t["*"]||[],t[o]||[]);for(const t of r)allowedAttribute(t,i)||e.removeAttribute(t.nodeName);}return r.body.innerHTML}

    const NAME$7="TemplateFactory",Default$5={allowList:DefaultAllowlist,content:{},extraClass:"",html:!1,sanitize:!0,sanitizeFn:null,template:"<div></div>"},DefaultType$4={allowList:"object",content:"object",extraClass:"(string|function)",html:"boolean",sanitize:"boolean",sanitizeFn:"(null|function)",template:"string"},DefaultContentType={entry:"(string|element|function|null)",selector:"(string|element)"};class TemplateFactory extends Config{constructor(t){super(),this._config=this._getConfig(t);}static get Default(){return Default$5}static get DefaultType(){return DefaultType$4}static get NAME(){return NAME$7}getContent(){return Object.values(this._config.content).map((t=>this._resolvePossibleFunction(t))).filter(Boolean)}hasContent(){return this.getContent().length>0}changeContent(t){return this._checkContent(t),this._config.content={...this._config.content,...t},this}toHtml(){const t=document.createElement("div");t.innerHTML=this._maybeSanitize(this._config.template);for(const[e,n]of Object.entries(this._config.content))this._setContent(t,n,e);const e=t.children[0],n=this._resolvePossibleFunction(this._config.extraClass);return n&&e.classList.add(...n.split(" ")),e}_typeCheckConfig(t){super._typeCheckConfig(t),this._checkContent(t.content);}_checkContent(t){for(const[e,n]of Object.entries(t))super._typeCheckConfig({selector:e,entry:n},DefaultContentType);}_setContent(t,e,n){const i=SelectorEngine$1.findOne(n,t);i&&((e=this._resolvePossibleFunction(e))?isElement$1(e)?this._putElementInTemplate(getElement(e),i):this._config.html?i.innerHTML=this._maybeSanitize(e):i.textContent=e:i.remove());}_maybeSanitize(t){return this._config.sanitize?sanitizeHtml(t,this._config.allowList,this._config.sanitizeFn):t}_resolvePossibleFunction(t){return "function"==typeof t?t(this):t}_putElementInTemplate(t,e){if(this._config.html)return e.innerHTML="",void e.append(t);e.textContent=t.textContent;}}

    const NAME$6="tooltip",DISALLOWED_ATTRIBUTES=new Set(["sanitize","allowList","sanitizeFn"]),AttachmentMap={AUTO:"auto",TOP:"top",RIGHT:isRTL()?"left":"right",BOTTOM:"bottom",LEFT:isRTL()?"right":"left"},Default$4={allowList:DefaultAllowlist,animation:!0,boundary:"clippingParents",container:!1,customClass:"",delay:0,fallbackPlacements:["top","right","bottom","left"],html:!1,offset:[0,0],placement:"top",popperConfig:null,sanitize:!0,sanitizeFn:null,selector:!1,template:'<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',title:"",trigger:"hover focus"},DefaultType$3={allowList:"object",animation:"boolean",boundary:"(string|element)",container:"(string|element|boolean)",customClass:"(string|function)",delay:"(number|object)",fallbackPlacements:"array",html:"boolean",offset:"(array|string|function)",placement:"(string|function)",popperConfig:"(null|object|function)",sanitize:"boolean",sanitizeFn:"(null|function)",selector:"(string|boolean)",template:"string",title:"(string|element|function)",trigger:"string"};class Tooltip$2 extends BaseComponent{constructor(t,e){if(void 0===Popper__namespace)throw new TypeError("Bootstrap's tooltips require Popper (https://popper.js.org)");super(t,e),this._isEnabled=!0,this._timeout=0,this._isHovered=null,this._activeTrigger={},this._popper=null,this._templateFactory=null,this._newContent=null,this.tip=null,this._setListeners(),this._config.selector||this._fixTitle();}static get Default(){return Default$4}static get DefaultType(){return DefaultType$3}static get NAME(){return NAME$6}enable(){this._isEnabled=!0;}disable(){this._isEnabled=!1;}toggleEnabled(){this._isEnabled=!this._isEnabled;}toggle(){this._isEnabled&&(this._activeTrigger.click=!this._activeTrigger.click,this._isShown()?this._leave():this._enter());}dispose(){clearTimeout(this._timeout),EventHandler$1.off(this._element.closest(".modal"),"hide.bs.modal",this._hideModalHandler),this._element.getAttribute("data-bs-original-title")&&this._element.setAttribute("title",this._element.getAttribute("data-bs-original-title")),this._disposePopper(),super.dispose();}show(){if("none"===this._element.style.display)throw new Error("Please use show on visible elements");if(!this._isWithContent()||!this._isEnabled)return;const t=EventHandler$1.trigger(this._element,this.constructor.eventName("show")),e=(findShadowRoot(this._element)||this._element.ownerDocument.documentElement).contains(this._element);if(t.defaultPrevented||!e)return;this._disposePopper();const i=this._getTipElement();this._element.setAttribute("aria-describedby",i.getAttribute("id"));const{container:n}=this._config;if(this._element.ownerDocument.documentElement.contains(this.tip)||(n.append(i),EventHandler$1.trigger(this._element,this.constructor.eventName("inserted"))),this._popper=this._createPopper(i),i.classList.add("show"),"ontouchstart"in document.documentElement)for(const t of [].concat(...document.body.children))EventHandler$1.on(t,"mouseover",noop);this._queueCallback((()=>{EventHandler$1.trigger(this._element,this.constructor.eventName("shown")),!1===this._isHovered&&this._leave(),this._isHovered=!1;}),this.tip,this._isAnimated());}hide(){if(!this._isShown())return;if(EventHandler$1.trigger(this._element,this.constructor.eventName("hide")).defaultPrevented)return;if(this._getTipElement().classList.remove("show"),"ontouchstart"in document.documentElement)for(const t of [].concat(...document.body.children))EventHandler$1.off(t,"mouseover",noop);this._activeTrigger.click=!1,this._activeTrigger.focus=!1,this._activeTrigger.hover=!1,this._isHovered=null;this._queueCallback((()=>{this._isWithActiveTrigger()||(this._isHovered||this._disposePopper(),this._element.removeAttribute("aria-describedby"),EventHandler$1.trigger(this._element,this.constructor.eventName("hidden")));}),this.tip,this._isAnimated());}update(){this._popper&&this._popper.update();}_isWithContent(){return Boolean(this._getTitle())}_getTipElement(){return this.tip||(this.tip=this._createTipElement(this._newContent||this._getContentForTemplate())),this.tip}_createTipElement(t){const e=this._getTemplateFactory(t).toHtml();if(!e)return null;e.classList.remove("fade","show"),e.classList.add(`bs-${this.constructor.NAME}-auto`);const i=getUID(this.constructor.NAME).toString();return e.setAttribute("id",i),this._isAnimated()&&e.classList.add("fade"),e}setContent(t){this._newContent=t,this._isShown()&&(this._disposePopper(),this.show());}_getTemplateFactory(t){return this._templateFactory?this._templateFactory.changeContent(t):this._templateFactory=new TemplateFactory({...this._config,content:t,extraClass:this._resolvePossibleFunction(this._config.customClass)}),this._templateFactory}_getContentForTemplate(){return {".tooltip-inner":this._getTitle()}}_getTitle(){return this._resolvePossibleFunction(this._config.title)||this._element.getAttribute("data-bs-original-title")}_initializeOnDelegatedTarget(t){return this.constructor.getOrCreateInstance(t.delegateTarget,this._getDelegateConfig())}_isAnimated(){return this._config.animation||this.tip&&this.tip.classList.contains("fade")}_isShown(){return this.tip&&this.tip.classList.contains("show")}_createPopper(t){const e="function"==typeof this._config.placement?this._config.placement.call(this,t,this._element):this._config.placement,i=AttachmentMap[e.toUpperCase()];return Popper__namespace.createPopper(this._element,t,this._getPopperConfig(i))}_getOffset(){const{offset:t}=this._config;return "string"==typeof t?t.split(",").map((t=>Number.parseInt(t,10))):"function"==typeof t?e=>t(e,this._element):t}_resolvePossibleFunction(t){return "function"==typeof t?t.call(this._element):t}_getPopperConfig(t){const e={placement:t,modifiers:[{name:"flip",options:{fallbackPlacements:this._config.fallbackPlacements}},{name:"offset",options:{offset:this._getOffset()}},{name:"preventOverflow",options:{boundary:this._config.boundary}},{name:"arrow",options:{element:`.${this.constructor.NAME}-arrow`}},{name:"preSetPlacement",enabled:!0,phase:"beforeMain",fn:t=>{this._getTipElement().setAttribute("data-popper-placement",t.state.placement);}}]};return {...e,..."function"==typeof this._config.popperConfig?this._config.popperConfig(e):this._config.popperConfig}}_setListeners(){const t=this._config.trigger.split(" ");for(const e of t)if("click"===e)EventHandler$1.on(this._element,this.constructor.eventName("click"),this._config.selector,(t=>{this._initializeOnDelegatedTarget(t).toggle();}));else if("manual"!==e){const t="hover"===e?this.constructor.eventName("mouseenter"):this.constructor.eventName("focusin"),i="hover"===e?this.constructor.eventName("mouseleave"):this.constructor.eventName("focusout");EventHandler$1.on(this._element,t,this._config.selector,(t=>{const e=this._initializeOnDelegatedTarget(t);e._activeTrigger["focusin"===t.type?"focus":"hover"]=!0,e._enter();})),EventHandler$1.on(this._element,i,this._config.selector,(t=>{const e=this._initializeOnDelegatedTarget(t);e._activeTrigger["focusout"===t.type?"focus":"hover"]=e._element.contains(t.relatedTarget),e._leave();}));}this._hideModalHandler=()=>{this._element&&this.hide();},EventHandler$1.on(this._element.closest(".modal"),"hide.bs.modal",this._hideModalHandler);}_fixTitle(){const t=this._element.getAttribute("title");t&&(this._element.getAttribute("aria-label")||this._element.textContent.trim()||this._element.setAttribute("aria-label",t),this._element.setAttribute("data-bs-original-title",t),this._element.removeAttribute("title"));}_enter(){this._isShown()||this._isHovered?this._isHovered=!0:(this._isHovered=!0,this._setTimeout((()=>{this._isHovered&&this.show();}),this._config.delay.show));}_leave(){this._isWithActiveTrigger()||(this._isHovered=!1,this._setTimeout((()=>{this._isHovered||this.hide();}),this._config.delay.hide));}_setTimeout(t,e){clearTimeout(this._timeout),this._timeout=setTimeout(t,e);}_isWithActiveTrigger(){return Object.values(this._activeTrigger).includes(!0)}_getConfig(t){const e=Manipulator.getDataAttributes(this._element);for(const t of Object.keys(e))DISALLOWED_ATTRIBUTES.has(t)&&delete e[t];return t={...e,..."object"==typeof t&&t?t:{}},t=this._mergeConfigObj(t),t=this._configAfterMerge(t),this._typeCheckConfig(t),t}_configAfterMerge(t){return t.container=!1===t.container?document.body:getElement(t.container),"number"==typeof t.delay&&(t.delay={show:t.delay,hide:t.delay}),"number"==typeof t.title&&(t.title=t.title.toString()),"number"==typeof t.content&&(t.content=t.content.toString()),t}_getDelegateConfig(){const t={};for(const e in this._config)this.constructor.Default[e]!==this._config[e]&&(t[e]=this._config[e]);return t.selector=!1,t.trigger="manual",t}_disposePopper(){this._popper&&(this._popper.destroy(),this._popper=null),this.tip&&(this.tip.remove(),this.tip=null);}static jQueryInterface(t){return this.each((function(){const e=Tooltip$2.getOrCreateInstance(this,t);if("string"==typeof t){if(void 0===e[t])throw new TypeError(`No method named "${t}"`);e[t]();}}))}}defineJQueryPlugin(Tooltip$2);

    const NAME$5="popover",SELECTOR_TITLE=".popover-header",Default$3={...Tooltip$2.Default,content:"",offset:[0,8],placement:"right",template:'<div class="popover" role="tooltip"><div class="popover-arrow"></div><h3 class="popover-header"></h3><div class="popover-body"></div></div>',trigger:"click"},DefaultType$2={...Tooltip$2.DefaultType,content:"(null|string|element|function)"};class Popover$2 extends Tooltip$2{static get Default(){return Default$3}static get DefaultType(){return DefaultType$2}static get NAME(){return NAME$5}_isWithContent(){return this._getTitle()||this._getContent()}_getContentForTemplate(){return {[SELECTOR_TITLE]:this._getTitle(),".popover-body":this._getContent()}}_getContent(){return this._resolvePossibleFunction(this._config.content)}static jQueryInterface(t){return this.each((function(){const e=Popover$2.getOrCreateInstance(this,t);if("string"==typeof t){if(void 0===e[t])throw new TypeError(`No method named "${t}"`);e[t]();}}))}}defineJQueryPlugin(Popover$2);

    class Popover extends Popover$2{}const Popover$1 = Popover;

    const NAME$4="scrollspy",DATA_KEY="bs.scrollspy",EVENT_KEY=`.${DATA_KEY}`,EVENT_ACTIVATE=`activate${EVENT_KEY}`,EVENT_CLICK=`click${EVENT_KEY}`,EVENT_LOAD_DATA_API=`load${EVENT_KEY}.data-api`,SELECTOR_DATA_SPY='[data-bs-spy="scroll"]',SELECTOR_LINK_ITEMS=".nav-link, .nav-item > .nav-link, .list-group-item",Default$2={offset:null,rootMargin:"0px 0px -25%",smoothScroll:!1,target:null,threshold:[.1,.5,1]},DefaultType$1={offset:"(number|null)",rootMargin:"string",smoothScroll:"boolean",target:"element",threshold:"array"};class ScrollSpy$2 extends BaseComponent{constructor(e,t){super(e,t),this._targetLinks=new Map,this._observableSections=new Map,this._rootElement="visible"===getComputedStyle(this._element).overflowY?null:this._element,this._activeTarget=null,this._observer=null,this._previousScrollData={visibleEntryTop:0,parentScrollTop:0},this.refresh();}static get Default(){return Default$2}static get DefaultType(){return DefaultType$1}static get NAME(){return NAME$4}refresh(){this._initializeTargetsAndObservables(),this._maybeEnableSmoothScroll(),this._observer?this._observer.disconnect():this._observer=this._getNewObserver();for(const e of this._observableSections.values())this._observer.observe(e);}dispose(){this._observer.disconnect(),super.dispose();}_configAfterMerge(e){return e.target=getElement(e.target)||document.body,e.rootMargin=e.offset?`${e.offset}px 0px -30%`:e.rootMargin,"string"==typeof e.threshold&&(e.threshold=e.threshold.split(",").map((e=>Number.parseFloat(e)))),e}_maybeEnableSmoothScroll(){this._config.smoothScroll&&(EventHandler$1.off(this._config.target,EVENT_CLICK),EventHandler$1.on(this._config.target,EVENT_CLICK,"[href]",(e=>{const t=this._observableSections.get(e.target.hash);if(t){e.preventDefault();const o=this._rootElement||window,s=t.offsetTop-this._element.offsetTop;if(o.scrollTo)return void o.scrollTo({top:s,behavior:"smooth"});o.scrollTop=s;}})));}_getNewObserver(){const e={root:this._rootElement,threshold:this._config.threshold,rootMargin:this._config.rootMargin};return new IntersectionObserver((e=>this._observerCallback(e)),e)}_observerCallback(e){const t=e=>this._targetLinks.get(`#${e.target.id}`),o=e=>{this._previousScrollData.visibleEntryTop=e.target.offsetTop,this._process(t(e));},s=(this._rootElement||document.documentElement).scrollTop,r=s>=this._previousScrollData.parentScrollTop;this._previousScrollData.parentScrollTop=s;for(const i of e){if(!i.isIntersecting){this._activeTarget=null,this._clearActiveClass(t(i));continue}const e=i.target.offsetTop>=this._previousScrollData.visibleEntryTop;if(r&&e){if(o(i),!s)return}else r||e||o(i);}}_initializeTargetsAndObservables(){this._targetLinks=new Map,this._observableSections=new Map;const e=SelectorEngine$1.find("[href]",this._config.target);for(const t of e){if(!t.hash||isDisabled(t))continue;const e=SelectorEngine$1.findOne(t.hash,this._element);isVisible(e)&&(this._targetLinks.set(t.hash,t),this._observableSections.set(t.hash,e));}}_process(e){this._activeTarget!==e&&(this._clearActiveClass(this._config.target),this._activeTarget=e,e.classList.add("active"),this._activateParents(e),EventHandler$1.trigger(this._element,EVENT_ACTIVATE,{relatedTarget:e}));}_activateParents(e){if(e.classList.contains("dropdown-item"))SelectorEngine$1.findOne(".dropdown-toggle",e.closest(".dropdown")).classList.add("active");else for(const t of SelectorEngine$1.parents(e,".nav, .list-group"))for(const e of SelectorEngine$1.prev(t,SELECTOR_LINK_ITEMS))e.classList.add("active");}_clearActiveClass(e){e.classList.remove("active");const t=SelectorEngine$1.find("[href].active",e);for(const e of t)e.classList.remove("active");}static jQueryInterface(e){return this.each((function(){const t=ScrollSpy$2.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===t[e]||e.startsWith("_")||"constructor"===e)throw new TypeError(`No method named "${e}"`);t[e]();}}))}}EventHandler$1.on(window,EVENT_LOAD_DATA_API,(()=>{for(const e of SelectorEngine$1.find(SELECTOR_DATA_SPY))ScrollSpy$2.getOrCreateInstance(e);})),defineJQueryPlugin(ScrollSpy$2);

    class ScrollSpy extends ScrollSpy$2{}const ScrollSpy$1 = ScrollSpy;

    const NAME$3="tab",EVENT_HIDE$1="hide.bs.tab",EVENT_HIDDEN$1="hidden.bs.tab",EVENT_SHOW$1="show.bs.tab",EVENT_SHOWN$1="shown.bs.tab",EVENT_KEYDOWN="keydown.bs.tab",ARROW_LEFT_KEY$1="ArrowLeft",ARROW_RIGHT_KEY$1="ArrowRight",ARROW_UP_KEY$1="ArrowUp",ARROW_DOWN_KEY$1="ArrowDown",SELECTOR_TAB_PANEL='.list-group, .nav, [role="tablist"]',SELECTOR_OUTER=".nav-item, .list-group-item",SELECTOR_INNER='.nav-link:not(.dropdown-toggle), .list-group-item:not(.dropdown-toggle), [role="tab"]:not(.dropdown-toggle)',SELECTOR_DATA_TOGGLE$2='[data-bs-toggle="tab"], [data-bs-toggle="pill"], [data-bs-toggle="list"]',SELECTOR_INNER_ELEM=`${SELECTOR_INNER}, ${SELECTOR_DATA_TOGGLE$2}`,SELECTOR_DATA_TOGGLE_ACTIVE$1='.active[data-bs-toggle="tab"], .active[data-bs-toggle="pill"], .active[data-bs-toggle="list"]';class Tab$2 extends BaseComponent{constructor(t){super(t),this._parent=this._element.closest(SELECTOR_TAB_PANEL),this._parent&&(this._setInitialAttributes(this._parent,this._getChildren()),EventHandler$1.on(this._element,EVENT_KEYDOWN,(t=>this._keydown(t))));}static get NAME(){return NAME$3}show(){const t=this._element;if(this._elemIsActive(t))return;const e=this._getActiveElem(),i=e?EventHandler$1.trigger(e,EVENT_HIDE$1,{relatedTarget:t}):null;EventHandler$1.trigger(t,EVENT_SHOW$1,{relatedTarget:e}).defaultPrevented||i&&i.defaultPrevented||(this._deactivate(e,t),this._activate(t,e));}_activate(t,e){if(!t)return;t.classList.add("active"),this._activate(getElementFromSelector(t));this._queueCallback((()=>{"tab"===t.getAttribute("role")?(t.removeAttribute("tabindex"),t.setAttribute("aria-selected",!0),this._toggleDropDown(t,!0),EventHandler$1.trigger(t,EVENT_SHOWN$1,{relatedTarget:e})):t.classList.add("show");}),t,t.classList.contains("fade"));}_deactivate(t,e){if(!t)return;t.classList.remove("active"),t.blur(),this._deactivate(getElementFromSelector(t));this._queueCallback((()=>{"tab"===t.getAttribute("role")?(t.setAttribute("aria-selected",!1),t.setAttribute("tabindex","-1"),this._toggleDropDown(t,!1),EventHandler$1.trigger(t,EVENT_HIDDEN$1,{relatedTarget:e})):t.classList.remove("show");}),t,t.classList.contains("fade"));}_keydown(t){if(![ARROW_LEFT_KEY$1,ARROW_RIGHT_KEY$1,ARROW_UP_KEY$1,ARROW_DOWN_KEY$1].includes(t.key))return;t.stopPropagation(),t.preventDefault();const e=[ARROW_RIGHT_KEY$1,ARROW_DOWN_KEY$1].includes(t.key),i=getNextActiveElement(this._getChildren().filter((t=>!isDisabled(t))),t.target,e,!0);i&&(i.focus({preventScroll:!0}),Tab$2.getOrCreateInstance(i).show());}_getChildren(){return SelectorEngine$1.find(SELECTOR_INNER_ELEM,this._parent)}_getActiveElem(){return this._getChildren().find((t=>this._elemIsActive(t)))||null}_setInitialAttributes(t,e){this._setAttributeIfNotExists(t,"role","tablist");for(const t of e)this._setInitialAttributesOnChild(t);}_setInitialAttributesOnChild(t){t=this._getInnerElement(t);const e=this._elemIsActive(t),i=this._getOuterElement(t);t.setAttribute("aria-selected",e),i!==t&&this._setAttributeIfNotExists(i,"role","presentation"),e||t.setAttribute("tabindex","-1"),this._setAttributeIfNotExists(t,"role","tab"),this._setInitialAttributesOnTargetPanel(t);}_setInitialAttributesOnTargetPanel(t){const e=getElementFromSelector(t);e&&(this._setAttributeIfNotExists(e,"role","tabpanel"),t.id&&this._setAttributeIfNotExists(e,"aria-labelledby",`#${t.id}`));}_toggleDropDown(t,e){const i=this._getOuterElement(t);if(!i.classList.contains("dropdown"))return;const s=(t,s)=>{const n=SelectorEngine$1.findOne(t,i);n&&n.classList.toggle(s,e);};s(".dropdown-toggle","active"),s(".dropdown-menu","show"),i.setAttribute("aria-expanded",e);}_setAttributeIfNotExists(t,e,i){t.hasAttribute(e)||t.setAttribute(e,i);}_elemIsActive(t){return t.classList.contains("active")}_getInnerElement(t){return t.matches(SELECTOR_INNER_ELEM)?t:SelectorEngine$1.findOne(SELECTOR_INNER_ELEM,t)}_getOuterElement(t){return t.closest(SELECTOR_OUTER)||t}static jQueryInterface(t){return this.each((function(){const e=Tab$2.getOrCreateInstance(this);if("string"==typeof t){if(void 0===e[t]||t.startsWith("_")||"constructor"===t)throw new TypeError(`No method named "${t}"`);e[t]();}}))}}EventHandler$1.on(document,"click.bs.tab",SELECTOR_DATA_TOGGLE$2,(function(t){["A","AREA"].includes(this.tagName)&&t.preventDefault(),isDisabled(this)||Tab$2.getOrCreateInstance(this).show();})),EventHandler$1.on(window,"load.bs.tab",(()=>{for(const t of SelectorEngine$1.find(SELECTOR_DATA_TOGGLE_ACTIVE$1))Tab$2.getOrCreateInstance(t);})),defineJQueryPlugin(Tab$2);

    const ARROW_LEFT_KEY="ArrowLeft",ARROW_RIGHT_KEY="ArrowRight",ARROW_UP_KEY="ArrowUp",ARROW_DOWN_KEY="ArrowDown",ENTER_KEY="Enter",SPACE_BAR_KEY=" ",SELECTOR_DATA_TOGGLE$1='[data-bs-toggle="tab"], [data-bs-toggle="pill"], [data-bs-toggle="list"]',SELECTOR_DATA_TOGGLE_ACTIVE='.active[data-bs-toggle="tab"], .active[data-bs-toggle="pill"], .active[data-bs-toggle="list"]';class Tab extends Tab$2{constructor(e){super(e);}_keydown(e){if(![ARROW_LEFT_KEY,ARROW_RIGHT_KEY,ARROW_UP_KEY,ARROW_DOWN_KEY,ENTER_KEY,SPACE_BAR_KEY].includes(e.key))return;if(e.stopPropagation(),e.preventDefault(),e.key===ENTER_KEY||e.key===SPACE_BAR_KEY)return void Tab.getOrCreateInstance(e.target).show();const t=[ARROW_RIGHT_KEY,ARROW_DOWN_KEY].includes(e.key),a=getNextActiveElement(this._getChildren().filter((e=>!isDisabled(e))),e.target,t,!0);a&&a.focus({preventScroll:!0});}}EventHandler$1.on(document,"click.bs.tab",SELECTOR_DATA_TOGGLE$1,(function(e){if(["A","AREA"].includes(this.tagName)&&e.preventDefault(),isDisabled(this))return;Tab.getOrCreateInstance(this).dispose(),Tab.getOrCreateInstance(this).show();})),EventHandler$1.on(window,"load.bs.tab",(()=>{for(const e of SelectorEngine$1.find(SELECTOR_DATA_TOGGLE_ACTIVE)){Tab.getOrCreateInstance(e).dispose(),Tab.getOrCreateInstance(e);}})),defineJQueryPlugin(Tab);const Tab$1 = Tab;

    const NAME$2="toast",EVENT_MOUSEOVER="mouseover.bs.toast",EVENT_MOUSEOUT="mouseout.bs.toast",EVENT_FOCUSIN="focusin.bs.toast",EVENT_FOCUSOUT="focusout.bs.toast",EVENT_HIDE="hide.bs.toast",EVENT_HIDDEN="hidden.bs.toast",EVENT_SHOW="show.bs.toast",EVENT_SHOWN="shown.bs.toast",DefaultType={animation:"boolean",autohide:"boolean",delay:"number"},Default$1={animation:!0,autohide:!0,delay:5e3};class Toast$2 extends BaseComponent{constructor(e,t){super(e,t),this._timeout=null,this._hasMouseInteraction=!1,this._hasKeyboardInteraction=!1,this._setListeners();}static get Default(){return Default$1}static get DefaultType(){return DefaultType}static get NAME(){return NAME$2}show(){if(EventHandler$1.trigger(this._element,EVENT_SHOW).defaultPrevented)return;this._clearTimeout(),this._config.animation&&this._element.classList.add("fade");this._element.classList.remove("hide"),reflow(this._element),this._element.classList.add("show","showing"),this._queueCallback((()=>{this._element.classList.remove("showing"),EventHandler$1.trigger(this._element,EVENT_SHOWN),this._maybeScheduleHide();}),this._element,this._config.animation);}hide(){if(!this.isShown())return;if(EventHandler$1.trigger(this._element,EVENT_HIDE).defaultPrevented)return;this._element.classList.add("showing"),this._queueCallback((()=>{this._element.classList.add("hide"),this._element.classList.remove("showing","show"),EventHandler$1.trigger(this._element,EVENT_HIDDEN);}),this._element,this._config.animation);}dispose(){this._clearTimeout(),this.isShown()&&this._element.classList.remove("show"),super.dispose();}isShown(){return this._element.classList.contains("show")}_maybeScheduleHide(){this._config.autohide&&(this._hasMouseInteraction||this._hasKeyboardInteraction||(this._timeout=setTimeout((()=>{this.hide();}),this._config.delay)));}_onInteraction(e,t){switch(e.type){case"mouseover":case"mouseout":this._hasMouseInteraction=t;break;case"focusin":case"focusout":this._hasKeyboardInteraction=t;}if(t)return void this._clearTimeout();const s=e.relatedTarget;this._element===s||this._element.contains(s)||this._maybeScheduleHide();}_setListeners(){EventHandler$1.on(this._element,EVENT_MOUSEOVER,(e=>this._onInteraction(e,!0))),EventHandler$1.on(this._element,EVENT_MOUSEOUT,(e=>this._onInteraction(e,!1))),EventHandler$1.on(this._element,EVENT_FOCUSIN,(e=>this._onInteraction(e,!0))),EventHandler$1.on(this._element,EVENT_FOCUSOUT,(e=>this._onInteraction(e,!1)));}_clearTimeout(){clearTimeout(this._timeout),this._timeout=null;}static jQueryInterface(e){return this.each((function(){const t=Toast$2.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===t[e])throw new TypeError(`No method named "${e}"`);t[e](this);}}))}}enableDismissTrigger(Toast$2),defineJQueryPlugin(Toast$2);

    class Toast extends Toast$2{}const Toast$1 = Toast;

    class Tooltip extends Tooltip$2{}const Tooltip$1 = Tooltip;

    const initYoutubePlugin=t=>{const e=t.browser.IS_IOS||t.browser.IS_NATIVE_ANDROID,i=t.getTech("Tech");class s extends i{constructor(t,i){super(t,i),this.setPoster(t.poster),this.setSrc(this.options_.source,!0),this.setTimeout(function(){this.el_&&(this.el_.parentNode.className+=" vjs-youtube",e&&(this.el_.parentNode.className+=" vjs-youtube-mobile"),s.isApiReady?this.initYTPlayer():s.apiReadyQueue.push(this));}.bind(this));}dispose(){if(this.ytPlayer)this.ytPlayer.stopVideo&&this.ytPlayer.stopVideo(),this.ytPlayer.destroy&&this.ytPlayer.destroy();else {var t=s.apiReadyQueue.indexOf(this);-1!==t&&s.apiReadyQueue.splice(t,1);}this.ytPlayer=null,this.el_.parentNode.className=this.el_.parentNode.className.replace(" vjs-youtube","").replace(" vjs-youtube-mobile",""),this.el_.parentNode.removeChild(this.el_),i.prototype.dispose.call(this);}createEl(){if("undefined"!=typeof document){var t=document.createElement("div");t.setAttribute("id",this.options_.techId),t.setAttribute("style","width:100%;height:100%;top:0;left:0;position:absolute"),t.setAttribute("class","vjs-tech");var i=document.createElement("div");if(i.appendChild(t),!e&&!this.options_.ytControls){var s=document.createElement("div");s.setAttribute("class","vjs-iframe-blocker"),s.setAttribute("style","position:absolute;top:0;left:0;width:100%;height:100%"),s.onclick=function(){this.pause();}.bind(this),i.appendChild(s);}return i}}initYTPlayer(){var t={controls:0,modestbranding:1,rel:0,showinfo:0,loop:this.options_.loop?1:0};if(void 0!==this.options_.autohide&&(t.autohide=this.options_.autohide),void 0!==this.options_.cc_load_policy&&(t.cc_load_policy=this.options_.cc_load_policy),void 0!==this.options_.ytControls&&(t.controls=this.options_.ytControls),void 0!==this.options_.disablekb&&(t.disablekb=this.options_.disablekb),void 0!==this.options_.color&&(t.color=this.options_.color),t.controls?void 0!==this.options_.fs&&(t.fs=this.options_.fs):t.fs=0,-1!==this.options_.source.src.indexOf("end=")){var e=this.options_.source.src.match(/end=([0-9]*)/);this.options_.end=parseInt(e[1]);}if(void 0!==this.options_.end&&(t.end=this.options_.end),void 0!==this.options_.hl?t.hl=this.options_.hl:void 0!==this.options_.language&&(t.hl=this.options_.language.substr(0,2)),void 0!==this.options_.iv_load_policy&&(t.iv_load_policy=this.options_.iv_load_policy),void 0!==this.options_.list?t.list=this.options_.list:this.url&&void 0!==this.url.listId&&(t.list=this.url.listId),void 0!==this.options_.listType&&(t.listType=this.options_.listType),void 0!==this.options_.modestbranding&&(t.modestbranding=this.options_.modestbranding),void 0!==this.options_.playlist&&(t.playlist=this.options_.playlist),void 0!==this.options_.playsinline&&(t.playsinline=this.options_.playsinline),void 0!==this.options_.rel&&(t.rel=this.options_.rel),void 0!==this.options_.showinfo&&(t.showinfo=this.options_.showinfo),-1!==this.options_.source.src.indexOf("start=")){var i=this.options_.source.src.match(/start=([0-9]*)/);this.options_.start=parseInt(i[1]);}if(void 0!==this.options_.start&&(t.start=this.options_.start),void 0!==this.options_.theme&&(t.theme=this.options_.theme),void 0!==this.options_.customVars){var s=this.options_.customVars;Object.keys(s).forEach((function(e){t[e]=s[e];}));}this.activeVideoId=this.url?this.url.videoId:null,this.activeList=t.list;var o={videoId:this.activeVideoId,playerVars:t,events:{onReady:this.onPlayerReady.bind(this),onPlaybackQualityChange:this.onPlayerPlaybackQualityChange.bind(this),onPlaybackRateChange:this.onPlayerPlaybackRateChange.bind(this),onStateChange:this.onPlayerStateChange.bind(this),onVolumeChange:this.onPlayerVolumeChange.bind(this),onError:this.onPlayerError.bind(this)}};void 0!==this.options_.enablePrivacyEnhancedMode&&this.options_.enablePrivacyEnhancedMode&&(o.host="https://www.youtube-nocookie.com"),this.ytPlayer=new YT.Player(this.options_.techId,o);}onPlayerReady(){this.options_.muted&&this.ytPlayer.mute(),this.ytPlayer.getAvailablePlaybackRates().length>1&&(this.featuresPlaybackRate=!0),this.playerReady_=!0,this.triggerReady(),this.playOnReady?this.play():this.cueOnReady&&(this.cueVideoById_(this.url.videoId),this.activeVideoId=this.url.videoId);}onPlayerPlaybackQualityChange(){}onPlayerPlaybackRateChange(){this.trigger("ratechange");}onPlayerStateChange(t){var e=t.data;if(e!==this.lastState&&!this.errorNumber)switch(this.lastState=e,e){case-1:this.trigger("loadstart"),this.trigger("loadedmetadata"),this.trigger("durationchange"),this.trigger("ratechange");break;case YT.PlayerState.ENDED:this.trigger("ended");break;case YT.PlayerState.PLAYING:this.trigger("timeupdate"),this.trigger("durationchange"),this.trigger("playing"),this.trigger("play"),this.isSeeking&&this.onSeeked();break;case YT.PlayerState.PAUSED:this.trigger("canplay"),this.isSeeking?this.onSeeked():this.trigger("pause");break;case YT.PlayerState.BUFFERING:this.player_.trigger("timeupdate"),this.player_.trigger("waiting");}}onPlayerVolumeChange(){this.trigger("volumechange");}onPlayerError(t){this.errorNumber=t.data,this.trigger("pause"),this.trigger("error");}error(){var t=1e3+this.errorNumber;switch(this.errorNumber){case 5:return {code:t,message:"Error while trying to play the video"};case 2:case 100:return {code:t,message:"Unable to find the video"};case 101:case 150:return {code:t,message:"Playback on other Websites has been disabled by the video owner."}}return {code:t,message:"YouTube unknown error ("+this.errorNumber+")"}}loadVideoById_(t){var e={videoId:t};this.options_.start&&(e.startSeconds=this.options_.start),this.options_.end&&(e.endSeconds=this.options_.end),this.ytPlayer.loadVideoById(e);}cueVideoById_(t){var e={videoId:t};this.options_.start&&(e.startSeconds=this.options_.start),this.options_.end&&(e.endSeconds=this.options_.end),this.ytPlayer.cueVideoById(e);}src(t){return t&&this.setSrc({src:t}),this.source}poster(){return e?null:this.poster_}setPoster(t){this.poster_=t;}setSrc(t){t&&t.src&&(delete this.errorNumber,this.source=t,this.url=s.parseUrl(t.src),this.options_.poster||this.url.videoId&&(this.poster_="https://img.youtube.com/vi/"+this.url.videoId+"/0.jpg",this.trigger("posterchange"),this.checkHighResPoster()),this.options_.autoplay&&!e?this.isReady_?this.play():this.playOnReady=!0:this.activeVideoId!==this.url.videoId&&(this.isReady_?(this.cueVideoById_(this.url.videoId),this.activeVideoId=this.url.videoId):this.cueOnReady=!0));}autoplay(){return this.options_.autoplay}setAutoplay(t){this.options_.autoplay=t;}loop(){return this.options_.loop}setLoop(t){this.options_.loop=t;}play(){this.url&&this.url.videoId&&(this.wasPausedBeforeSeek=!1,this.isReady_?(this.url.listId&&(this.activeList===this.url.listId?this.ytPlayer.playVideo():(this.ytPlayer.loadPlaylist(this.url.listId),this.activeList=this.url.listId)),this.activeVideoId===this.url.videoId?this.ytPlayer.playVideo():(this.loadVideoById_(this.url.videoId),this.activeVideoId=this.url.videoId)):(this.trigger("waiting"),this.playOnReady=!0));}pause(){this.ytPlayer&&this.ytPlayer.pauseVideo();}paused(){return !this.ytPlayer||this.lastState!==YT.PlayerState.PLAYING&&this.lastState!==YT.PlayerState.BUFFERING}currentTime(){return this.ytPlayer?this.ytPlayer.getCurrentTime():0}setCurrentTime(t){this.lastState===YT.PlayerState.PAUSED&&(this.timeBeforeSeek=this.currentTime()),this.isSeeking||(this.wasPausedBeforeSeek=this.paused()),this.ytPlayer.seekTo(t,!0),this.trigger("timeupdate"),this.trigger("seeking"),this.isSeeking=!0,this.lastState===YT.PlayerState.PAUSED&&this.timeBeforeSeek!==t&&(clearInterval(this.checkSeekedInPauseInterval),this.checkSeekedInPauseInterval=setInterval(function(){this.lastState===YT.PlayerState.PAUSED&&this.isSeeking?this.currentTime()!==this.timeBeforeSeek&&(this.trigger("timeupdate"),this.onSeeked()):clearInterval(this.checkSeekedInPauseInterval);}.bind(this),250));}seeking(){return this.isSeeking}seekable(){return this.ytPlayer?t.createTimeRange(0,this.ytPlayer.getDuration()):t.createTimeRange()}onSeeked(){clearInterval(this.checkSeekedInPauseInterval),this.isSeeking=!1,this.wasPausedBeforeSeek&&this.pause(),this.trigger("seeked");}playbackRate(){return this.ytPlayer?this.ytPlayer.getPlaybackRate():1}setPlaybackRate(t){this.ytPlayer&&this.ytPlayer.setPlaybackRate(t);}duration(){return this.ytPlayer?this.ytPlayer.getDuration():0}currentSrc(){return this.source&&this.source.src}ended(){return !!this.ytPlayer&&this.lastState===YT.PlayerState.ENDED}volume(){return this.ytPlayer?this.ytPlayer.getVolume()/100:1}setVolume(t){this.ytPlayer&&this.ytPlayer.setVolume(100*t);}muted(){return !!this.ytPlayer&&this.ytPlayer.isMuted()}setMuted(t){this.ytPlayer&&(this.muted(!0),t?this.ytPlayer.mute():this.ytPlayer.unMute(),this.setTimeout((function(){this.trigger("volumechange");}),50));}buffered(){if(!this.ytPlayer||!this.ytPlayer.getVideoLoadedFraction)return t.createTimeRange();var e=this.ytPlayer.getVideoLoadedFraction()*this.ytPlayer.getDuration();return t.createTimeRange(0,e)}preload(){}load(){}reset(){}networkState(){if(!this.ytPlayer)return 0;switch(this.ytPlayer.getPlayerState()){case-1:return 0;case 3:return 2;default:return 1}}readyState(){if(!this.ytPlayer)return 0;switch(this.ytPlayer.getPlayerState()){case-1:return 0;case 5:return 1;case 3:return 2;default:return 4}}supportsFullScreen(){if("undefined"!=typeof document)return document.fullscreenEnabled||document.webkitFullscreenEnabled||document.mozFullScreenEnabled||document.msFullscreenEnabled}checkHighResPoster(){var t="https://img.youtube.com/vi/"+this.url.videoId+"/maxresdefault.jpg";try{var e=new Image;e.onload=function(){if("naturalHeight"in e){if(e.naturalHeight<=90||e.naturalWidth<=120)return}else if(e.height<=90||e.width<=120)return;this.poster_=t,this.trigger("posterchange");}.bind(this),e.onerror=function(){},e.src=t;}catch(t){}}}s.isSupported=function(){return !0},s.canPlaySource=function(t){return s.canPlayType(t.type)},s.canPlayType=function(t){return "video/youtube"===t},s.parseUrl=function(t){var e={videoId:null},i=t.match(/^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=)([^#\&\?]*).*/);i&&11===i[2].length&&(e.videoId=i[2]);return (i=t.match(/[?&]list=([^#\&\?]+)/))&&i[1]&&(e.listId=i[1]),e},s.apiReadyQueue=[],"undefined"!=typeof document&&(function(t,e){if("undefined"!=typeof document){var i=!1,s=document.createElement("script"),o=document.getElementsByTagName("script")[0];o&&(o.parentNode.insertBefore(s,o),s.onload=function(){i||(i=!0,e());},s.onreadystatechange=function(){i||"complete"!==this.readyState&&"loaded"!==this.readyState||(i=!0,e());},s.src=t);}}("https://www.youtube.com/iframe_api",(function(){YT.ready((function(){s.isApiReady=!0;for(var t=0;t<s.apiReadyQueue.length;++t)s.apiReadyQueue[t].initYTPlayer();}));})),function(){if("undefined"!=typeof document){var t=".vjs-youtube .vjs-iframe-blocker { display: none; }.vjs-youtube.vjs-user-inactive .vjs-iframe-blocker { display: block; }.vjs-youtube .vjs-poster { background-size: cover; }.vjs-youtube-mobile .vjs-big-play-button { display: none; }",e=document.head||document.getElementsByTagName("head")[0],i=document.createElement("style");i.type="text/css",i.styleSheet?i.styleSheet.cssText=t:i.appendChild(document.createTextNode(t)),e.appendChild(i);}}()),void 0!==t.registerTech?t.registerTech("Youtube",s):t.registerComponent("Youtube",s);};

    const NAME$1="videoplayer",SELECTOR_TOGGLE="[data-bs-video]",itLang={"Audio Player":"Lettore audio","Video Player":"Lettore video",Play:"Play",Pause:"Pausa",Replay:"Replay","Current Time":"Orario attuale",Duration:"Durata","Remaining Time":"Tempo rimanente","Stream Type":"Tipo di streaming",LIVE:"LIVE",Loaded:"Caricato",Progress:"Stato","Progress Bar":"Barra di avanzamento","progress bar timing: currentTime={1} duration={2}":"{1} di {2}",Fullscreen:"Schermo intero","Exit Fullscreen":"Chiudi Schermo intero",Mute:"Disattiva l’audio",Unmute:"Attiva l’audio","Playback Rate":"Velocità di riproduzione",Subtitles:"Sottotitoli","subtitles off":"Senza sottotitoli",Captions:"Sottotitoli non udenti","captions off":"Senza sottotitoli non udenti",Chapters:"Capitolo",Descriptions:"Descrizioni","descriptions off":"Descrizioni disattivate","Audio Track":"Traccia audio","Volume Level":"Livello del volume","You aborted the media playback":"La riproduzione del filmato è stata interrotta.","A network error caused the media download to fail part-way.":"Il download del filmato è stato interrotto a causa di un problema rete.","The media could not be loaded, either because the server or network failed or because the format is not supported.":"Il filmato non può essere caricato a causa di un errore nel server o nella rete o perché il formato non viene supportato.","The media playback was aborted due to a corruption problem or because the media used features your browser did not support.":"La riproduzione del filmato è stata interrotta a causa di un file danneggiato o per l’utilizzo di impostazioni non supportate dal browser.","No compatible source was found for this media.":"Non ci sono fonti compatibili per questo filmato.","The media is encrypted and we do not have the keys to decrypt it.":"Il contenuto multimediale è criptato e non disponiamo delle chiavi per decifrarlo.","Play Video":"Riproduci il video",Close:"Chiudi","Close Modal Dialog":"Chiudi la finestra di dialogo","Modal Window":"Finestra di dialogo","This is a modal window":"Questa è una finestra di dialogo","This modal can be closed by pressing the Escape key or activating the close button.":"Questa finestra di dialogo può essere chiusa premendo sul tasto Esc o attivando il pulsante di chiusura.",", opens captions settings dialog":", aprire i parametri della trascrizione dei sottotitoli",", opens subtitles settings dialog":", aprire i parametri dei sottotitoli",", opens descriptions settings dialog":", aprire i parametri delle descrizioni",", selected":", selezionato","captions settings":"Parametri sottotitoli non udenti","subtitles settings":"Parametri sottotitoli","descriptions settings":"Parametri descrizioni",Text:"Testo",White:"Bianco",Black:"Nero",Red:"Rosso",Green:"Verde",Blue:"Blu",Yellow:"Giallo",Magenta:"Magenta",Cyan:"Ciano",Background:"Sfondo",Window:"Finestra",Transparent:"Trasparente","Semi-Transparent":"Semi-Trasparente",Opaque:"Opaco","Font Size":"Dimensione dei caratteri","Text Edge Style":"Stile dei bordi del testo",None:"Nessuno",Uniform:"Uniforme","Drop shadow":"Ombra","Font Family":"Carattere","Proportional Sans-Serif":"Sans-Serif proporzionale","Monospace Sans-Serif":"Sans-Serif monospaziato","Proportional Serif":"Serif proporzionale","Monospace Serif":"Serif monospaziato","Small Caps":"Maiuscoletto",Reset:"Reinizializza","restore all settings to the default values":"Ripristina i valori predefiniti per tutti i parametri",Done:"Fatto","Caption Settings Dialog":"Finestra di dialogo dei parametri della trascrizione dei sottotitoli","Beginning of dialog window. Escape will cancel and close the window.":"Inizio della finestra di dialogo. Il tasto Esc annullerà l’operazione e chiuderà la finestra.","End of dialog window.":"Fine della finestra di dialogo.","{1} is loading.":"{1} in fase di caricamento.","Exit Picture-in-Picture":"Esci dalla modalità Picture-in-Picture","Picture-in-Picture":"Picture-in-Picture",Color:"Colore",Opacity:"Opacità","Text Background":"Sfondo testo","Caption Area Background":"Sfondo area sottotitoli","Skip forward {1} seconds":"Avanti {1} secondi","Skip backward {1} seconds":"Indietro {1} secondi"},DEFAULT_CONFIG={languages:{it:itLang},language:"it"},Default={};"undefined"!=typeof window&&(window.videojs=videojs__default.default);class VideoPlayer extends BaseComponent{constructor(e,i){super(e),e.classList.add("video-js","vjs-theme-bootstrap-italia","vjs-fluid","vjs-big-play-centered"),this._config=this._getConfig(i),this.player=videojs__default.default(e,DEFAULT_CONFIG);}setYouTubeVideo(e){initYoutubePlugin(videojs__default.default),this.player.tech("youtube"),this.player.src({type:"video/youtube",src:e});}static get NAME(){return NAME$1}_getConfig(e){return e={...Default,...Manipulator.getDataAttributes(this._element),..."object"==typeof e?e:{}}}}const players=SelectorEngine$1.find(SELECTOR_TOGGLE);players.length>0&&players.forEach((e=>{VideoPlayer.getOrCreateInstance(e);}));const VideoPlayer$1 = VideoPlayer;

    const NAME="acceptoverlay",SELECTOR_DATA_TOGGLE="[data-bs-accept-from]",SELECTOR_DATA_REMEMBER="[data-bs-accept-remember]";class AcceptOverlay extends BaseComponent{constructor(e,t){super(e.closest(".acceptoverlay")),this._overlayable=e.closest(".acceptoverlayable");const s=cookies.isChoiceRemembered(t.service);if(this._isShown=!0,this._toggleElement=e,this._element.classList.contains("show")&&this._overlayable.classList.add("show"),s)return this.hide(),void setTimeout((()=>{this._toggleElement.dispatchEvent(new Event("click"));}),100);this._toggleElement.addEventListener("click",(()=>{this.hide(),this._remember=this._toggleElement.parentElement.querySelector(SELECTOR_DATA_REMEMBER).checked,cookies.rememberChoice(t.service,this._remember);}));}static get NAME(){return NAME}show(){this._isShown||this._isTransitioning||(this._isShown=!0,this._isAnimated()&&(this._isTransitioning=!0),this._showElement());}hide(){if(!this._isShown||this._isTransitioning)return;this._isShown=!1;const e=this._isAnimated();e&&(this._isTransitioning=!0),this._element.classList.remove("show"),this._overlayable.classList.remove("show"),this._queueCallback((()=>this._hideElement()),this._element,e);}_isAnimated(){return this._element.classList.contains("fade")}_showElement(){const e=this._isAnimated();this._element.removeAttribute("aria-hidden"),e&&reflow(this._element),this._element.classList.add("show"),this._overlayable.add("show");this._queueCallback((()=>{this._isTransitioning=!1;}),this._element,e);}_hideElement(){this._element.setAttribute("aria-hidden",!0),this._isTransitioning=!1;}}const acceptOverlays=SelectorEngine$1.find(SELECTOR_DATA_TOGGLE);acceptOverlays.length>0&&acceptOverlays.forEach((e=>{AcceptOverlay.getOrCreateInstance(e,{service:e.dataset.bsAcceptFrom});}));const AcceptOverlay$1 = AcceptOverlay;

    loadPlugin(icons),init$1();const bootstrapItalia_entry = {Alert:Alert$1,Button:Button$1,Carousel:Carousel$1,Collapse:Collapse$1,Dropdown:Dropdown$1,Modal:Modal$1,Offcanvas:Offcanvas$1,Popover:Popover$1,ScrollSpy:ScrollSpy$1,Tab:Tab$1,Toast:Toast$1,Tooltip:Tooltip$1,VideoPlayer:VideoPlayer$1,AcceptOverlay:AcceptOverlay$1,Accordion:Accordion$1,BackToTop:BackToTop$1,CarouselBI:CarouselBI$1,Cookiebar:Cookiebar$1,Dimmer:Dimmer$1,FormValidate:FormValidate,Forward:Forward$1,HistoryBack:HistoryBack$1,Input:Input$1,InputNumber:InputNumber$1,InputPassword:InputPassword$1,InputSearchAutocomplete:InputSearchAutocomplete,List:List$1,Masonry:Masonry$1,NavBarCollapsible:NavBarCollapsible$1,NavScroll:NavScroll$1,Notification:Notification$1,ProgressDonut:ProgressDonut$1,SelectAutocomplete:SelectAutocomplete$1,Sticky:Sticky$1,HeaderSticky:HeaderSticky$1,Transfer:Transfer$1,UploadDragDrop:UploadDragDrop$1,ValidatorSelectAutocomplete:ValidatorSelectAutocomplete,loadFonts:loadFonts,cookies:cookies};

    return bootstrapItalia_entry;

}));
