/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/m/Button','sap/m/Label','sap/m/Toolbar','sap/m/ToolbarSpacer','sap/m/OverflowToolbarAssociativeActionSheet','sap/m/OverflowToolbarLayoutData'],function(q,l,B,L,T,a,O,b){"use strict";var c=T.extend("sap.m.OverflowToolbar",{metadata:{aggregations:{_overflowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_overflowButtonLabel:{type:"sap.m.Label",multiple:false,visibility:"hidden"},_actionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"}}}});c.prototype._callToolbarMethod=function(f,A){return T.prototype[f].apply(this,A);};c.prototype.init=function(){this._callToolbarMethod("init",arguments);this._iPreviousToolbarWidth=null;this._bOverflowButtonNeeded=false;this._bListenForControlPropertyChanges=false;this._bControlsInfoCached=false;this._bSkipOptimization=false;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");};c.prototype.onAfterRendering=function(){if(this._bControlWasFocused){this._getOverflowButton().focus();this._bControlWasFocused=false;}if(this._bOverflowButtonWasFocused&&!this._getOverflowButtonNeeded()){this.$().lastFocusableDomRef().focus();this._bOverflowButtonWasFocused=false;}this._getOverflowButton().$().attr("aria-haspopup","true");this._getOverflowButtonLabel().$().attr("aria-hidden","true");this._doLayout();};c.prototype._doLayout=function(){this._bListenForControlPropertyChanges=false;this._deregisterToolbarResize();this._polyfillFlexboxSupport();if(!this._bControlsInfoCached){this._cacheControlsInfo();}if(this._iPreviousToolbarWidth!==this.$().width()){this._iPreviousToolbarWidth=this.$().width();this._setControlsOverflowAndShrinking();}this._registerToolbarResize();this._bListenForControlPropertyChanges=true;};c.prototype._polyfillFlexboxSupport=function(){if(T.hasNewFlexBoxSupport){return;}if(T.hasFlexBoxSupport){var t=this.$();var d=t[0]||{};t.removeClass("sapMTBOverflow");var o=d.scrollWidth>d.clientWidth;o&&t.addClass("sapMTBOverflow");}else{T.flexie(this.$());}};c.prototype._cacheControlsInfo=function(){var s,m;this._aMovableControls=[];this._aToolbarOnlyControls=[];this._aActionSheetOnlyControls=[];this._aControlSizes={};this._iContentSize=0;this.getContent().forEach(function(C){var o=C.getLayoutData();if(o instanceof b){s=o.getStayInOverflow();m=o.getMoveToOverflow();}else{s=false;m=true;}var i=c._getOptimalControlWidth(C);this._aControlSizes[C.getId()]=i;if(O._acceptsControl(C)&&s){this._aActionSheetOnlyControls.push(C);}else{this._iContentSize+=i;if(O._acceptsControl(C)&&m){this._aMovableControls.push(C);}else{this._aToolbarOnlyControls.push(C);}}},this);this._bControlsInfoCached=true;};c.prototype._setControlsOverflowAndShrinking=function(){var t=this.$().width(),C=this._iContentSize,d=[],I,i,f=function(g){g.forEach(function(o){this._moveButtonToActionSheet(o);},this);},e=function(h){if(typeof h==="undefined"||this._getActionSheet()._getButtonsIdsHash()!==h){this.invalidate();if(this._getControlsIds().indexOf(sap.ui.getCore().getCurrentFocusedControlId())!==-1){this._bControlWasFocused=true;}if(sap.ui.getCore().getCurrentFocusedControlId()===this._getOverflowButton().getId()){this._bOverflowButtonWasFocused=true;}}},A=function(C){if(!this._getOverflowButtonNeeded()){C+=this._getOverflowButtonSize();this._setOverflowButtonNeeded(true);}return C;};if(this._bSkipOptimization){this._bSkipOptimization=false;}else{I=this._getActionSheet()._getButtonsIdsHash();}this._resetToolbar();if(this._aActionSheetOnlyControls.length){for(i=this._aActionSheetOnlyControls.length-1;i>=0;i--){d.unshift(this._aActionSheetOnlyControls[i]);}C=A.call(this,C);}if(C<=t){f.call(this,d);e.call(this,I);return;}if(this._aMovableControls.length){C=A.call(this,C);for(i=this._aMovableControls.length-1;i>=0;i--){d.unshift(this._aMovableControls[i]);C-=this._aControlSizes[this._aMovableControls[i].getId()];if(C<=t){break;}}}f.call(this,d);if(C>t){this._checkContents();}e.call(this,I);};c.prototype._resetToolbar=function(){this._getActionSheet()._closeWithoutAnimation();this._getActionSheet()._getAllButtons().forEach(function(o){this._restoreButtonInToolbar(o);},this);this._setOverflowButtonNeeded(false);this.getContent().forEach(function(C){C.removeStyleClass(T.shrinkClass);});};c.prototype._moveButtonToActionSheet=function(o){this._getActionSheet().addAssociatedButton(o);};c.prototype._restoreButtonInToolbar=function(v){if(typeof v==="object"){v=v.getId();}this._getActionSheet().removeAssociatedButton(v);};c.prototype._resetAndInvalidateToolbar=function(h){this._resetToolbar();this._bControlsInfoCached=false;this._iPreviousToolbarWidth=null;if(h){this._bSkipOptimization=true;}this.invalidate();};c.prototype._getVisibleContent=function(){var t=this.getContent(),A=this._getActionSheet()._getAllButtons();return t.filter(function(C){return A.indexOf(C)===-1;});};c.prototype._getOverflowButton=function(){var o;if(!this.getAggregation("_overflowButton")){o=new B({icon:"sap-icon://overflow",press:this._overflowButtonPressed.bind(this),ariaLabelledBy:this._getOverflowButtonLabel(),tooltip:this._oResourceBundle.getText("LOAD_MORE_DATA"),type:sap.m.ButtonType.Transparent});this.setAggregation("_overflowButton",o,true);}return this.getAggregation("_overflowButton");};c.prototype._getOverflowButtonLabel=function(){var o;if(!this.getAggregation("_overflowButtonLabel")){o=new L({text:this._oResourceBundle.getText("LOAD_MORE_DATA"),width:"0px"});o.addStyleClass("sapUiHidden");this.setAggregation("_overflowButtonLabel",o,true);}return this.getAggregation("_overflowButtonLabel");};c.prototype._overflowButtonPressed=function(e){var A=this._getActionSheet(),s=this._getBestActionSheetPlacement();if(A.getPlacement()!==s){A.setPlacement(s);}A.openBy(e.getSource());};c.prototype._getActionSheet=function(){var A;if(!this.getAggregation("_actionSheet")){A=new O(this.getId()+"-associativeactionsheet",{showCancelButton:sap.ui.Device.browser.mobile?true:false});this.setAggregation("_actionSheet",A,true);}return this.getAggregation("_actionSheet");};c.prototype._getOverflowButtonNeeded=function(){return this._bOverflowButtonNeeded;};c.prototype._setOverflowButtonNeeded=function(v){if(this._bOverflowButtonNeeded!==v){this._bOverflowButtonNeeded=v;}return this;};c.prototype.onLayoutDataChange=function(){this._resetAndInvalidateToolbar(true);};c.prototype.addContent=function(C){this._registerControlListener(C);this._resetAndInvalidateToolbar(false);return this._callToolbarMethod("addContent",arguments);};c.prototype.insertContent=function(C,i){this._registerControlListener(C);this._resetAndInvalidateToolbar(false);return this._callToolbarMethod("insertContent",arguments);};c.prototype.removeContent=function(C){var v=this._callToolbarMethod("removeContent",arguments);this._resetAndInvalidateToolbar(false);this._deregisterControlListener(v);return v;};c.prototype.removeAllContent=function(){var C=this._callToolbarMethod("removeAllContent",arguments);C.forEach(this._deregisterControlListener,this);this._resetAndInvalidateToolbar(false);return C;};c.prototype.destroyContent=function(){this._resetAndInvalidateToolbar(false);var t=this;setTimeout(function(){t._resetAndInvalidateToolbar(false);},0);return this._callToolbarMethod("destroyContent",arguments);};c.prototype._registerControlListener=function(C){if(C){C.attachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);}};c.prototype._deregisterControlListener=function(C){if(C){C.detachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);}};c.prototype._onContentPropertyChangedOverflowToolbar=function(e){if(!this._bListenForControlPropertyChanges){return;}var i={"sap.m.SearchField":["value"],"sap.m.Select":["selectedItemId","selectedKey"],"sap.m.ComboBox":["value","selectedItemId","selectedKey"],"sap.m.CheckBox":["selected"],"sap.m.Input":["value"],"sap.m.ToggleButton":["pressed"],"sap.m.RadioButton":["selected"],"sap.m.DateTimeInput":["value","dateValue"]};var s=e.getSource().getMetadata().getName();var p=e.getParameter("name");if(typeof i[s]!=="undefined"&&i[s].indexOf(p)!==-1){return;}this._resetAndInvalidateToolbar(true);};c.prototype._getOverflowButtonSize=function(){var i=parseInt(sap.m.BaseFontSize,10),C=this.$().parents().hasClass('sapUiSizeCompact')?2.5:3;return parseInt(i*C,10);};c.prototype._getBestActionSheetPlacement=function(){var h=this.getHTMLTag();if(h==="Footer"){return sap.m.PlacementType.Top;}else if(h==="Header"){return sap.m.PlacementType.Bottom;}return sap.m.PlacementType.Auto;};c.prototype._getControlsIds=function(){return this.getContent().map(function(i){return i.getId();});};c._getOptimalControlWidth=function(C){var o;if(C instanceof a){o=parseInt(C.$().css('min-width'),10)||0+C.$().outerWidth(true)-C.$().outerWidth();}else{o=C.$().outerWidth(true);}return o;};return c;},true);
