/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','./library'],function(q,C,I,l){"use strict";var A=C.extend("sap.ui.ux3.ActionBar",{metadata:{library:"sap.ui.ux3",properties:{followState:{type:"sap.ui.ux3.FollowActionState",group:"Misc",defaultValue:sap.ui.ux3.FollowActionState.Default},flagState:{type:"boolean",group:"Misc",defaultValue:null},favoriteState:{type:"boolean",group:"Misc",defaultValue:null},updateState:{type:"boolean",group:"Misc",defaultValue:null},thingIconURI:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},alwaysShowMoreMenu:{type:"boolean",group:"Misc",defaultValue:true},showUpdate:{type:"boolean",group:"Misc",defaultValue:true},showFollow:{type:"boolean",group:"Misc",defaultValue:true},showFlag:{type:"boolean",group:"Misc",defaultValue:true},showFavorite:{type:"boolean",group:"Misc",defaultValue:true},showOpen:{type:"boolean",group:"Misc",defaultValue:true},dividerWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null}},aggregations:{businessActions:{type:"sap.ui.ux3.ThingAction",multiple:true,singularName:"businessAction"},_businessActionButtons:{type:"sap.ui.commons.Button",multiple:true,singularName:"_businessActionButton",visibility:"hidden"},_socialActions:{type:"sap.ui.ux3.ThingAction",multiple:true,singularName:"_socialAction",visibility:"hidden"}},events:{actionSelected:{parameters:{id:{type:"string"},action:{type:"sap.ui.ux3.ThingAction"},newState:{type:"string"}}},feedSubmit:{parameters:{text:{type:"string"}}}}}});A.prototype.init=function(){this.mActionMap={};this.mActionKeys=sap.ui.ux3.ActionBarSocialActions;this.oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Update),true);this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Follow),true);this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Flag),true);this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Favorite),true);this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Open),true);if(!this._oItemNavigation){this._oItemNavigation=new I();this.addDelegate(this._oItemNavigation);}};A.prototype.exit=function(){this.closePopups();if(this._oUpdatePopup){this._oUpdatePopup.destroy();this._oUpdatePopup=null;}if(this._oMoreMenuButton){this._oMoreMenuButton.destroy();this._oMoreMenuButton=null;}if(this._oMoreMenu){this._oMoreMenu.destroy();this._oMoreMenu=null;}if(this._oHoldItem){this._oHoldItem.destroy();}if(this._oUnFollowItem){this._oUnFollowItem.destroy();}if(this._oUnHoldItem){this._oUnHoldItem.destroy();}if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.mActionKeys=null;this.mActionKeys=null;this.oRb=null;this.destroyAggregation("_socialActions");this.destroyAggregation("_businessActionButtons");if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};A.prototype.isActive=function(){var r=this.getDomRef()!=null;return r;};A.prototype._getLocalizedText=function(k,a){var t;if(this.oRb){t=this.oRb.getText(k);}if(t&&a){for(var i=0;i<a.length;i++){t=t.replace("{"+i+"}",a[i]);}}return t?t:k;};A.prototype._getSocialAction=function(a){var r=this.mActionMap[a];if(!r){r=new sap.ui.ux3.ThingAction({id:this.getId()+"-"+a});switch(a){case this.mActionKeys.Update:r.name=this.mActionKeys.Update;r.tooltipKey="ACTIONBAR_UPDATE_ACTION_TOOLTIP";r.cssClass="sapUiUx3ActionBarUpdateAction";r.fnInit=function(o){o._oUpdatePopup=new sap.ui.ux3.ToolPopup({id:o.getId()+"-UpdateActionPopup"}).addStyleClass("sapUiUx3ActionBarUpdatePopup");o._oUpdatePopup._ensurePopup().setAutoClose(true);o._feeder=new sap.ui.ux3.Feeder({id:o.getId()+"-Feeder",type:sap.ui.ux3.FeederType.Comment,thumbnailSrc:o.getThingIconURI(),text:"",submit:q.proxy(function(e){var d=e.getParameter("text");this.fireFeedSubmit({text:d});this._oUpdatePopup.close();},o)});o._feeder.addStyleClass("sapUiUx3ActionBarFeeder");o._oUpdatePopup.addContent(o._feeder);};r.fnActionSelected=function(e,o){o._setUpdateState(!o.getUpdateState());if(o._oUpdatePopup.isOpen()){o._oUpdatePopup.close();}else{var d,t,i;o._oUpdatePopup.setPosition(sap.ui.core.Popup.Dock.BeginBottom,sap.ui.core.Popup.Dock.BeginTop,e.getSource().getDomRef(),"-8 -13","none");o._oUpdatePopup.open();d=q(o._oUpdatePopup.getDomRef());t=q(window).height();i=q(o.getDomRef()).offset().top;d.css("top","auto").css("bottom",(t-i+7)+"px");q.sap.delayedCall(1000,this,function(){q.sap.focus(o._feeder.getFocusDomRef());});}o._updateSocialActionDomRef(r);};r.fnExit=function(o){if(o._oUpdatePopup){o._oUpdatePopup.destroy();o._oUpdatePopup=null;}};r.fnCalculateState=function(o){var d=null;if(o.getUpdateState()){d="Selected";}return d;};break;case this.mActionKeys.Follow:var f=r;r.name=this.mActionKeys.Follow;r.tooltipKey="ACTIONBAR_FOLLOW_ACTION_TOOLTIP_FOLLOW";r.cssClass="sapUiUx3ActionBarFollowAction";r.isMenu=function(o){return o.getFollowState()!=sap.ui.ux3.FollowActionState.Default;};r.fnActionSelected=function(e,o){if(o.getFollowState()==sap.ui.ux3.FollowActionState.Default){o._setFollowState(sap.ui.ux3.FollowActionState.Follow);o.fireActionSelected({id:f.name,state:"followState",action:f});this._fnPrepareFollowMenu(e,o);}else{var d=sap.ui.core.Popup.Dock;o._oMenu.open(false,f.getFocusDomRef(),d.BeginBottom,d.BeginTop,f.getDomRef());}};r.fnCalculateState=function(o){return o.getFollowState();};r._fnPrepareFollowMenu=function(e,o){var i=sap.ui.resource("sap.ui.ux3","themes/"+sap.ui.getCore().getConfiguration().getTheme());if(o.mActionMap[o.mActionKeys.Follow]){if(!o._oUnFollowItem){o._oUnFollowItem=new sap.ui.commons.MenuItem({id:o.getId()+"-unfollowState",text:o._getLocalizedText("TI_FOLLOW_ACTION_MENU_TXT_UNFOLLOW"),icon:i+"/img/menu_unlisten.png"});}if(!o._oHoldItem){o._oHoldItem=new sap.ui.commons.MenuItem({id:o.getId()+"-holdState",text:o._getLocalizedText("TI_FOLLOW_ACTION_MENU_TXT_HOLD"),icon:i+"/img/menu_hold.png"});}if(!o._oUnHoldItem){o._oUnHoldItem=new sap.ui.commons.MenuItem({id:o.getId()+"-unholdState",text:o._getLocalizedText("TI_FOLLOW_ACTION_MENU_TXT_UNHOLD"),icon:i+"/img/menu_follow.png"});}if(!o._oMenu){o._oMenu=new sap.ui.commons.Menu({id:o.getId()+"-followActionMenu"});o._oMenu.attachItemSelect(q.proxy(function(d){this._fnFollowMenuSelected(d,o);},this));o._oMenu.addItem(o._oHoldItem);o._oMenu.addItem(o._oUnHoldItem);o._oMenu.addItem(o._oUnFollowItem);}if(o.getFollowState()==sap.ui.ux3.FollowActionState.Default){o.mActionMap[o.mActionKeys.Follow].setTooltip(o._getLocalizedText("TI_FOLLOW_ACTION_TOOLTIP_FOLLOW"));o._oHoldItem.setVisible(false);o._oUnFollowItem.setVisible(false);o._oUnHoldItem.setVisible(false);}else if(o.getFollowState()==sap.ui.ux3.FollowActionState.Follow){o.mActionMap[o.mActionKeys.Follow].setTooltip(o._getLocalizedText("TI_FOLLOW_ACTION_TOOLTIP_STOPPAUSE_FOLLOW"));o._oHoldItem.setVisible(true);o._oUnFollowItem.setVisible(true);o._oUnHoldItem.setVisible(false);}else if(o.getFollowState()==sap.ui.ux3.FollowActionState.Hold){o.mActionMap[o.mActionKeys.Follow].setTooltip(o._getLocalizedText("TI_FOLLOW_ACTION_TOOLTIP_STOPCONTINUE_FOLLOW"));o._oHoldItem.setVisible(false);o._oUnFollowItem.setVisible(true);o._oUnHoldItem.setVisible(true);}o._updateSocialActionDomRef(r);}};r._fnFollowMenuSelected=function(e,o){if(o.mActionMap[o.mActionKeys.Follow]){var i=e.getParameters().item.getId();if(i==o.getId()+"-followState"){o._setFollowState(sap.ui.ux3.FollowActionState.Follow);}else if(i==o.getId()+"-unfollowState"){o._setFollowState(sap.ui.ux3.FollowActionState.Default);}else if(i==o.getId()+"-holdState"){o._setFollowState(sap.ui.ux3.FollowActionState.Hold);}else if(i+"-unholdState"){o._setFollowState(sap.ui.ux3.FollowActionState.Follow);}o.fireActionSelected({id:f.name,state:i,action:f});this._fnPrepareFollowMenu(e,o);}};break;case this.mActionKeys.Favorite:var b=r;r.name=this.mActionKeys.Favorite;r.tooltipKey="ACTIONBAR_FAVORITE_ACTION_TOOLTIP";r.cssClass="sapUiUx3ActionBarFavoriteAction";r.fnActionSelected=function(e,o){if(o.getFavoriteState()==true){o._setFavoriteState(false);}else{o._setFavoriteState(true);}o.fireActionSelected({id:b.name,state:o.getFavoriteState(),action:b});o._updateSocialActionDomRef(r);};r.fnCalculateState=function(o){var d=null;if(o.getFavoriteState()){d="Selected";}return d;};break;case this.mActionKeys.Flag:var c=r;r.name=this.mActionKeys.Flag;r.tooltipKey="ACTIONBAR_FLAG_ACTION_TOOLTIP";r.cssClass="sapUiUx3ActionBarFlagAction";r.fnActionSelected=function(e,o){o._setFlagState(!o.getFlagState());o.fireActionSelected({id:c.name,state:o.getFlagState(),action:c});o._updateSocialActionDomRef(r);};r.fnCalculateState=function(o){var d=null;if(o.getFlagState()){d="Selected";}return d;};break;case this.mActionKeys.Open:r.name=this.mActionKeys.Open;r.tooltipKey="ACTIONBAR_OPEN_THING_ACTION_TOOLTIP";r.cssClass="sapUiUx3ActionBarOpenThingAction";break;default:q.sap.log.warning("Function \"sap.ui.ux3.ActionBar.prototype._getSocialAction\" was called with unknown action key \""+a+"\".\n\tNo action will not be rendered.");return undefined;}}return r;};A.prototype._updateSocialActionDomRef=function(s){var c=s.$();if(c){c.attr("class",s.cssClass);if(s.fnCalculateState){c.addClass("sapUiUx3ActionBarAction");c.addClass(s.fnCalculateState(this));}if(s.name==this.mActionKeys.Update||s.name==this.mActionKeys.Flag||s.name==this.mActionKeys.Favorite){c.attr("aria-pressed",s.fnCalculateState(this)=="Selected"?"true":"false");}if(s.isMenu){c.attr("aria-haspopup",s.isMenu(this)?"true":"false");}}};A.prototype._rerenderSocialActions=function(){var c=this.$("socialActions");if(c.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.ActionBarRenderer.renderSocialActions(r,this);r.flush(c[0]);r.destroy();}};A.prototype._rerenderBusinessAction=function(b){var c=b.$();if(c.length>0){var r=sap.ui.getCore().createRenderManager();r.renderControl(b);r.flush(c[0].parentNode);r.destroy();}};A.prototype._rerenderBusinessActions=function(){if(!this.getAlwaysShowMoreMenu()){var c=this.$("businessActions");if(c&&c.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.ActionBarRenderer.renderBusinessActionButtons(r,this);r.flush(c[0]);r.destroy();}}this._onresize();};A.prototype.setFollowState=function(f){this.setProperty("followState",f);if(!this._oMenu){var F=this._getSocialAction(this.mActionKeys.Follow);F._fnPrepareFollowMenu(null,this);}return this;};A.prototype.setShowUpdate=function(f){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Update),f);this.setProperty("showUpdate",f,true);return this;};A.prototype.setShowFollow=function(f){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Follow),f);this.setProperty("showFollow",f,true);return this;};A.prototype.setShowFlag=function(f){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Flag),f);this.setProperty("showFlag",f,true);return this;};A.prototype.setShowFavorite=function(f){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Favorite),f);this.setProperty("showFavorite",f,true);return this;};A.prototype.setShowOpen=function(f){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Open),f);this.setProperty("showOpen",f,true);return this;};A.prototype._setFollowState=function(f){this.setProperty("followState",f,true);return this;};A.prototype._setFlagState=function(f){this.setProperty("flagState",f,true);return this;};A.prototype._setUpdateState=function(u){this.setProperty("updateState",u,true);return this;};A.prototype._setFavoriteState=function(f){this.setProperty("favoriteState",f,true);return this;};A.prototype.setThingIconURI=function(i){this.setProperty("thingIconURI",i,true);var u=this.mActionMap[this.mActionKeys.Update];if(u&&this._feeder){this._feeder.setThumbnailSrc(i);}else{q.sap.log.warning("Function \"sap.ui.ux3.ActionBar.setThingIconURI\": failed to set new icon \""+i+"\".\n\tReason: either updateAction "+u+" or feeder "+this._feeder+" is not defined.");}return this;};A.prototype.setDividerWidth=function(w){this._iSocActListWidth=null;this.setProperty("dividerWidth",w);return this;};A.prototype.setAlwaysShowMoreMenu=function(f){var o=this.getProperty("alwaysShowMoreMenu");var b=this.getAggregation("businessActions",[]);this.setProperty("alwaysShowMoreMenu",f,true);if(o!=f&&b){if(!f){for(var i=0;i<b.length;i++){var B=b[i];this._createButtonForAction(B,this._oMoreMenu._getMenuItemForAction(B));}}else{var a=this._getBusinessActionButtons();for(var c=0;c<a.length;c++){if(a[c].oMenuItem){a[c].oMenuItem.setVisible(true);a[c].oMenuItem=null;}}this.destroyAggregation("_businessActionButtons");}this._styleMoreMenuButton();}this._bCallOnresize=true;this._rerenderBusinessActions();return this;};A.prototype.closePopups=function(){if(this._oUpdatePopup){this._oUpdatePopup.close();}if(this._oMoreMenu){this._oMoreMenu.close();}if(this._oMenu){this._oMenu.close();}};A.prototype._removeSocialAction=function(s){var r=null;if(s.name&&this.mActionMap[s.name]){if(this.mActionMap[s.name].fnExit){this.mActionMap[s.name].fnExit(this);}r=this.removeAggregation("_socialActions",this.mActionMap[s.name],true);this.mActionMap[s.name].destroy();delete this.mActionMap[s.name];this._rerenderSocialActions();this._iSocActListWidth=null;}return r;};A.prototype._removeAllSocialActions=function(){for(var k in this.mActionMap){if(this.mActionMap[k]&&this.mActionMap[k].fnExit){this.mActionMap[k].fnExit(this);}}this.mActionMap={};var r=this.removeAllAggregation("_socialActions",true);this._iSocActListWidth=null;this._rerenderSocialActions();return r;};A.prototype._addSocialAction=function(s,i){var r=null;if(!this.mActionMap[s.name]){r=this._prepareSocialAction(s,i);if(s.fnInit){s.fnInit(this);}this._iSocActListWidth=null;}if(r){this._rerenderSocialActions();}return r;};A.prototype._prepareSocialAction=function(s,i){s.attachSelect(q.proxy(function(c){if(s.fnActionSelected){s.fnActionSelected(c,this);}else{this.fireActionSelected({id:s.name,action:s});}},this));s.setTooltip(this._getLocalizedText(s.tooltipKey));this.mActionMap[s.name]=s;if(i){this.insertAggregation("_socialActions",s,i,true);}else{this.addAggregation("_socialActions",s,true);}return s;};A.prototype._setShowSocialAction=function(s,f){return f?this._addSocialAction(s):this._removeSocialAction(s);};A.prototype.addBusinessAction=function(b){return this._addBusinessAction(b);};A.prototype.insertBusinessAction=function(b,i){return this._addBusinessAction(b,i);};A.prototype.removeBusinessAction=function(b){return this._removeBusinessAction(b,true);};A.prototype._removeBusinessAction=function(b,r){if(typeof b==="string"){var c;var a=b;for(var i=0;i<this.getBusinessActions().length;i++){var o=this.getBusinessActions()[i];if(o.getId()===a){c=o;break;}}b=c;}if(this._oMoreMenu){var m=this._oMoreMenu._getMenuItemForAction(b);if(m){this._oMoreMenu.removeItem(m);m.destroy();}if(this._oMoreMenu.getItems().length==0){this._oMoreMenuButton.destroy();this._oMoreMenuButton=null;this._oMoreMenu.destroy();this._oMoreMenu=null;}}if(!this.getAlwaysShowMoreMenu()){var B=this._getButtonForAction(b);if(B){this.removeAggregation("_businessActionButtons",B,true);B.destroy();}}var d=this.removeAggregation("businessActions",b,true);if(r){this._rerenderBusinessActions();}return d;};A.prototype.removeAllBusinessActions=function(){var b=this.getAggregation("businessActions",[]);if(b){for(var i=0;i<b.length;i++){this._removeBusinessAction(b[i],false);}}this._rerenderBusinessActions();var r=this.removeAllAggregation("businessActions",true);return r;};A.prototype.destroyBusinessActions=function(){var b=this.getAggregation("businessActions",[]);if(b){for(var i=0;i<b.length;i++){var c=this._removeBusinessAction(b[i],false);if(c instanceof sap.ui.core.Element){c.destroy(true);}}}this._rerenderBusinessActions();var r=this.destroyAggregation("businessActions",true);return r;};A.prototype._getBusinessActionButtons=function(){return this.getAggregation("_businessActionButtons",[]);};A.prototype._addBusinessAction=function(b,a){var r;if(!a&&a!=0){r=this.addAggregation("businessActions",b,true);}else{r=this.insertAggregation("businessActions",b,a,true);}if(!this._oMoreMenuButton){this._oMoreMenuButton=new sap.ui.commons.MenuButton(this.getId()+"-MoreMenuButton");this._oMoreMenuButton.setText(this._getLocalizedText("ACTIONBAR_BUTTON_MORE_TEXT"));this._oMoreMenuButton.setTooltip(this._getLocalizedText("ACTIONBAR_BUTTON_MORE_TOOLTIP"));var e=sap.ui.core.Popup.Dock;this._oMoreMenuButton.setDockButton(e.EndTop);this._oMoreMenuButton.setDockMenu(e.EndBottom);this._styleMoreMenuButton();this._oMoreMenu=new sap.ui.commons.Menu(this.getId()+"-MoreMenu",{ariaDescription:this._getLocalizedText("ACTIONBAR_BUTTON_MORE_TOOLTIP")});this._oMoreMenu._getMenuItemForAction=function(o){for(var i=0;i<this.getItems().length;i++){var M=this.getItems()[i];if(M.action==o){return M;}}return null;};this._oMoreMenuButton.setMenu(this._oMoreMenu);}var m=this._oMoreMenu.getId()+"-MenuItem-"+b.getId();var M=new sap.ui.commons.MenuItem(m,{text:b.getText(),enabled:b.getEnabled()});M.action=b;M.attachSelect(q.proxy(function(c){this.fireActionSelected({id:b.getId(),action:b});},this));if(a){this._oMoreMenu.insertItem(M,a);}else{this._oMoreMenu.addItem(M);}this._createButtonForAction(b,M,a);this._rerenderBusinessActions();return r;};A.prototype._getMoreMenuButton=function(){return this._oMoreMenuButton;};A.prototype._onresize=function(e){var a=this.$();if(a){var s=this.getActionBarMinWidth()+"px";if(a.css('minWidth')!=s){a.css('minWidth',s);}}if(!this.getAlwaysShowMoreMenu()&&this._oMoreMenuButton){var S=false;if(this._getBusinessActionButtons().length>1){var m=this._oMoreMenuButton.$().outerWidth();var M=a.outerWidth()-this._getSocialActionListMinWidth()-m;var b=this._getBusinessActionButtons();var B=0;for(var i=0;i<b.length;i++){var o=b[i].$().parent();B+=o.outerWidth();if(i==b.length-1){B-=m;}if(B>=M){if(o.length>0){o.css('display','none');if(b[i].oMenuItem){b[i].oMenuItem.setVisible(true);}S=true;}}else{if(o.length>0){o.css('display','');if(!!sap.ui.Device.browser.internet_explorer){this._rerenderBusinessAction(b[i]);}if(b[i].oMenuItem){b[i].oMenuItem.setVisible(false);}}}}S|=this.getAggregation("businessActions").length>b.length;}var c=this._oMoreMenuButton.$().parent();if(c.length>0){S?c.css('display',''):c.css('display','none');}if(!S&&this._oMoreMenu){this._oMoreMenu.close();}}this._setItemNavigation();};A.prototype.onBeforeRendering=function(){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;};A.prototype.onAfterRendering=function(){this._sResizeListenerId=sap.ui.core.ResizeHandler.register(this.getDomRef(),q.proxy(this._onresize,this));if(this._bCallOnresize){this._onresize();}this._setItemNavigation();};A.prototype._getSocialActionListMinWidth=function(){if(!this._iSocActListWidth){if(this.getDividerWidth()){this._iSocActListWidth=parseInt(this.getDividerWidth(),10);}else{var s=this.getAggregation("_socialActions",[]);var a=s.length;this._iSocActListWidth=24*a+12;}}return this._iSocActListWidth;};A.prototype.getActionBarMinWidth=function(){var r=this._getSocialActionListMinWidth();var R=this._oMoreMenuButton;if(!this.getAlwaysShowMoreMenu()&&this._getBusinessActionButtons().length==1){R=this._getBusinessActionButtons()[0];}if(R){var p=R.$().parent();if(p){r+=p.outerWidth()-3;}}return r;};A.prototype._getButtonForAction=function(a){for(var i=0;i<this._getBusinessActionButtons().length;i++){var b=this._getBusinessActionButtons()[i];if(b.action==a){return b;}}return null;};A.prototype._createButtonForAction=function(b,m,i){if(!this.getAlwaysShowMoreMenu()&&!b.showInMoreMenu){var B=new sap.ui.commons.Button({id:this.getId()+"-"+b.getId()+"Button",text:b.getText(),tooltip:b.getTooltip(),enabled:b.getEnabled()});B.attachPress(q.proxy(function(c){this.fireActionSelected({id:b.getId(),action:b});},this));B.oMenuItem=m;B.action=b;if(i){this.insertAggregation("_businessActionButtons",B,i,true);}else{this.addAggregation("_businessActionButtons",B,true);}return B;}return null;};A.prototype._styleMoreMenuButton=function(){if(this._oMoreMenuButton){if(this.getAlwaysShowMoreMenu()){this._oMoreMenuButton.setLite(true);this._oMoreMenuButton.addStyleClass("sapUiUx3ActionBarLiteMoreButton");}else{this._oMoreMenuButton.setLite(false);this._oMoreMenuButton.removeStyleClass("sapUiUx3ActionBarLiteMoreButton");}}};A.prototype._setItemNavigation=function(){if(this.getDomRef()){this._oItemNavigation.setRootDomRef(q(this.getDomRef()).get(0));var a=[];var o=this.getAggregation("_socialActions",[]);for(var i=0;i<o.length;i++){a.push(o[i].getDomRef());}o=this.getAggregation("_businessActionButtons",[]);for(var i=0;i<o.length;i++){a.push(o[i].getDomRef());}if(this._oMoreMenuButton&&this._oMoreMenuButton.getDomRef()){a.push(this._oMoreMenuButton.getDomRef());}this._oItemNavigation.setItemDomRefs(a);}};A.prototype.invalidate=function(c){if(c instanceof sap.ui.ux3.ThingAction){var b=sap.ui.getCore().byId(this.getId()+"-"+c.getId()+"Button");var B=this._oMoreMenu&&this._oMoreMenu._getMenuItemForAction(c);if(b){b.setTooltip(c.getTooltip());b.setText(c.getText());b.setEnabled(c.getEnabled());}if(B){B.setTooltip(c.getTooltip());B.setText(c.getText());B.setEnabled(c.getEnabled());}if(!b&&!B){C.prototype.invalidate.apply(this,arguments);}}C.prototype.invalidate.apply(this,arguments);};return A;},true);
