/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/MonthsRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library'],function(q,C,L,D,a,H,M,b,Y,U,l){"use strict";var c=C.extend("sap.ui.unified.CalendarMonthInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Misc"},intervalSelection:{type:"boolean",group:"Misc",defaultValue:false},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},months:{type:"int",group:"Misc",defaultValue:12}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},monthsRow:{type:"sap.ui.unified.calendar.MonthsRow",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{},cancel:{}}}});(function(){c.prototype.init=function(){this._iMode=0;this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new U(U.UTC(1,0,1));this._oMinDate.setUTCFullYear(1);this._oMaxDate=new U(U.UTC(9999,11,31));var v=new H(this.getId()+"--Head",{visibleButton0:false,visibleButton1:false,visibleButton2:true});v.attachEvent("pressPrevious",this._handlePrevious,this);v.attachEvent("pressNext",this._handleNext,this);v.attachEvent("pressButton2",o,this);this.setAggregation("header",v);var w=new M(this.getId()+"--MonthsRow");w.attachEvent("focus",r,this);w.attachEvent("select",p,this);w._bNoThemeChange=true;this.setAggregation("monthsRow",w);var y=new Y(this.getId()+"--YP",{columns:0,years:6});y.attachEvent("select",s,this);this.setAggregation("yearPicker",y);this._iDaysMonthsHead=15;};c.prototype.exit=function(){if(this._sInvalidateContent){q.sap.clearDelayedCall(this._sInvalidateContent);}};c.prototype.onBeforeRendering=function(){var v=this.getAggregation("monthsRow");var w=this._getFocusedDate();i.call(this);v.setDate(a._createLocalDate(w));};c.prototype.setStartDate=function(S){if(!(S instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var y=S.getFullYear();if(y<1||y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}var v=a._createUniversalUTCDate(S);this.setProperty("startDate",S,true);this._oUTCStartDate=v;this._oUTCStartDate.setUTCDate(1);var w=this.getAggregation("monthsRow");w.setStartDate(S);i.call(this);var x=a._createLocalDate(this._getFocusedDate());if(!w.checkDateFocusable(x)){this._setFocusedDate(this._oUTCStartDate);w.setDate(S);}return this;};c.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=q.sap.delayedCall(0,this,t);}};c.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};c.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var v=this.destroyAggregation("selectedDates");return v;};c.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};c.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var v=this.destroyAggregation("specialDates");return v;};c.prototype.setLocale=function(v){if(this._sLocale!=v){this._sLocale=v;this._oLocaleData=undefined;this.invalidate();}return this;};c.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};c.prototype._getFocusedDate=function(){if(!this._oFocusedDate){f.call(this);}return this._oFocusedDate;};c.prototype._setFocusedDate=function(v){if(!(v instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=new U(v.getTime());};c.prototype.focusDate=function(v){var w=this.getAggregation("monthsRow");if(!w.checkDateFocusable(v)){var x=a._createUniversalUTCDate(v);u.call(this,x);}n.call(this,v,false);return this;};c.prototype.displayDate=function(v){n.call(this,v,true);return this;};c.prototype.setMonths=function(v){this.setProperty("months",v,true);v=this._getMonths();var w=this.getAggregation("monthsRow");w.setMonths(v);var x=a._createLocalDate(this._getFocusedDate());if(!w.checkDateFocusable(x)){var S=d.call(this);this._setFocusedDate(this._oUTCStartDate);w.setDate(a._createLocalDate(S));}var y=this.getAggregation("yearPicker");var z=Math.floor(v/2);if(z>20){z=20;}y.setYears(z);i.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}};c.prototype._getMonths=function(){var v=this.getMonths();if(sap.ui.Device.system.phone&&v>6){return 6;}else{return v;}};c.prototype._getLocaleData=function(){if(!this._oLocaleData){var v=this.getLocale();var w=new sap.ui.core.Locale(v);this._oLocaleData=L.getInstance(w);}return this._oLocaleData;};c.prototype.onclick=function(E){if(E.isMarked("delayedMouseEvent")){return;}if(E.target.id==this.getId()+"-cancel"){this.onsapescape(E);}};c.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};c.prototype.onsapescape=function(E){switch(this._iMode){case 0:this.fireCancel();break;case 1:h.call(this);break;}};c.prototype.onsaptabnext=function(E){var v=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){q.sap.focus(v.getDomRef("B2"));if(!this._bPoupupMode){var w=this.getAggregation("monthsRow");var y=this.getAggregation("yearPicker");q(w._oItemNavigation.getItemDomRefs()[w._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(y.getDomRef()){q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}E.preventDefault();}};c.prototype.onsaptabprevious=function(E){var v=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._bPoupupMode){q.sap.focus(v.getDomRef("B2"));E.preventDefault();}}else if(E.target.id==v.getId()+"-B2"){var w=this.getAggregation("monthsRow");var y=this.getAggregation("yearPicker");switch(this._iMode){case 0:w._oItemNavigation.focusItem(w._oItemNavigation.getFocusedIndex());break;case 1:y._oItemNavigation.focusItem(y._oItemNavigation.getFocusedIndex());break;}E.preventDefault();}};c.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var v=this.getAggregation("header");var w=this.getAggregation("monthsRow");var y=this.getAggregation("yearPicker");q.sap.focus(v.getDomRef("B2"));if(!this._bPoupupMode){q(w._oItemNavigation.getItemDomRefs()[w._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(y.getDomRef()){q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this.$("end").attr("tabindex","-1");};c.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var v=this.getAggregation("monthsRow");var y=this.getAggregation("yearPicker");switch(this._iMode){case 0:q(v._oItemNavigation.getItemDomRefs()[v._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 1:q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;}}}};c.prototype._handlePrevious=function(E){var F=this._getFocusedDate();var y=this.getAggregation("yearPicker");var v=this._getMonths();var S=new U(d.call(this).getTime());switch(this._iMode){case 0:S.setUTCMonth(S.getUTCMonth()-v);F.setUTCMonth(F.getUTCMonth()-v);this._setFocusedDate(F);_.call(this,S,true);break;case 1:y.previousPage();break;}};c.prototype._handleNext=function(E){var F=this._getFocusedDate();var y=this.getAggregation("yearPicker");var v=this._getMonths();var S=new U(d.call(this).getTime());switch(this._iMode){case 0:S.setUTCMonth(S.getUTCMonth()+v);F.setUTCMonth(F.getUTCMonth()+v);this._setFocusedDate(F);_.call(this,S,true);break;case 1:y.nextPage();break;}};c.prototype._getShowItemHeader=function(){var v=this.getMonths();if(v>this._iDaysMonthsHead){return true;}else{return false;}};function _(S,v){var w=new U(this._oMaxDate.getTime());w.setUTCMonth(w.getUTCDate()-this._getMonths());if(S.getTime()<this._oMinDate.getTime()){S=this._oMinDate;}else if(S.getTime()>w.getTime()){S=w;}S.setUTCDate(1);var x=a._createLocalDate(S);this.setProperty("startDate",x,true);this._oUTCStartDate=S;var y=this.getAggregation("monthsRow");y.setStartDate(x);i.call(this);if(v){var z=a._createLocalDate(this._getFocusedDate());if(!y.checkDateFocusable(z)){this._setFocusedDate(S);y.setDate(x);}else{y.setDate(z);}}}function d(){if(!this._oUTCStartDate){this._oUTCStartDate=this._getFocusedDate();this._oUTCStartDate.setUTCDate(1);}return this._oUTCStartDate;}function e(N){var v=this._getFocusedDate();var w=this.getAggregation("monthsRow");if(!N){w.setDate(a._createLocalDate(v));}else{w.displayDate(a._createLocalDate(v));}i.call(this);}function f(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=a._createUniversalUTCDate(S[0].getStartDate());this._oFocusedDate.setUTCDate(1);}else{var N=new Date();this._oFocusedDate=a._createUniversalUTCDate(N);this._oFocusedDate.setUTCDate(1);}}function g(){var v=this._getFocusedDate();var y=v.getUTCFullYear();var w=this._oMaxDate.getUTCFullYear();var x=this._oMinDate.getUTCFullYear();if(w-x<=20){return;}var z=this.getAggregation("header");if(y>(w-10)){y=w-9;z.setEnabledNext(false);}else{z.setEnabledNext(true);}if(y<(x+9)){y=x+10;z.setEnabledPrevious(false);}else{z.setEnabledPrevious(true);}var A=this.getAggregation("yearPicker");if(A.getDomRef()){A.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=this.$("content");R.renderControl(A);R.flush($[0],false,true);R.destroy();}this.$("contentOver").css("display","");A.setYear(y);if(this._iMode==0){var B=this.getAggregation("monthsRow");q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=1;}function h(N){this._iMode=0;var y=this.getAggregation("yearPicker");y.$().css("display","none");this.$("contentOver").css("display","none");if(!N){e.call(this);var v=this.getAggregation("monthsRow");q(v._oItemNavigation.getItemDomRefs()[v._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function i(){k.call(this);j.call(this);}function j(){var v=new U(d.call(this).getTime());var w=this._getMonths();var y=v.getUTCFullYear();var x=this._oMaxDate.getUTCFullYear();var z=this._oMinDate.getUTCFullYear();var A=v.getUTCMonth();var B=this._oMaxDate.getUTCMonth();var E=this._oMinDate.getUTCMonth();var F=this.getAggregation("header");if(y<z||(y==z&&A<=E)){F.setEnabledPrevious(false);}else{F.setEnabledPrevious(true);}v.setUTCMonth(v.getUTCMonth()+w-1);y=v.getUTCFullYear();A=v.getUTCMonth();if(y>x||(y==x&&A>=B)){F.setEnabledNext(false);}else{F.setEnabledNext(true);}}function k(){var T;var S=d.call(this);var v=S.getUTCFullYear();var E=new U(S.getTime());E.setUTCMonth(E.getUTCMonth()+this._getMonths()-1);var w=E.getUTCFullYear();if(v!=w){var x=this._getLocaleData();var P=x.getIntervalPattern();T=P.replace(/\{0\}/,v.toString()).replace(/\{1\}/,w.toString());}else{T=v.toString();}var y=this.getAggregation("header");y.setTextButton2(T);}function m(v,N){var F;var w=false;if(v.getTime()<this._oMinDate.getTime()){F=this._oMinDate;w=true;}else if(v.getTime()>this._oMaxDate.getTime()){F=this._oMaxDate;w=true;}else{F=v;}this._setFocusedDate(F);if(w||N){u.call(this,F);e.call(this,false);}}function n(v,N){if(v&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=v.getTime())){if(!(v instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}v=a._createUniversalUTCDate(v);var y=v.getUTCFullYear();if(y<1||y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}this._setFocusedDate(v);if(this.getDomRef()&&this._iMode==0){e.call(this,N);}}}function o(E){if(this._iMode!=1){g.call(this);}else{h.call(this);}}function p(E){this.fireSelect();}function r(E){var v=a._createUniversalUTCDate(E.getParameter("date"));var N=E.getParameter("notVisible");m.call(this,v,N);}function s(E){var F=new U(this._getFocusedDate().getTime());var y=this.getAggregation("yearPicker");var v=y.getYear();F.setUTCFullYear(v);m.call(this,F,true);h.call(this);}function t(){this._sInvalidateContent=undefined;var v=this.getAggregation("monthsRow");v._bDateRangeChanged=true;v._bInvalidateSync=true;v.invalidate();v._bInvalidateSync=undefined;this._bDateRangeChanged=undefined;}function u(v){var w=this.getAggregation("monthsRow");var S=d.call(this);var x=w._oItemNavigation.getFocusedIndex();S=new U(v.getTime());S.setUTCMonth(S.getUTCMonth()-x);_.call(this,S,false);}}());return c;},true);
