/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','./Button','./Dialog','./NavContainer','./List','./Page','./MenuListItem','sap/ui/unified/Menu','sap/ui/unified/MenuItem','sap/ui/Device','sap/ui/core/EnabledPropagator','sap/ui/core/CustomData',"sap/ui/thirdparty/jquery"],function(l,C,B,D,N,L,P,M,U,a,b,E,c,q){"use strict";var d=l.ListType;var e=l.ListMode;var f=C.extend("sap.m.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"},_dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{itemSelected:{parameters:{item:{type:"sap.m.MenuItem"}}},closed:{}}}});E.call(f.prototype);f.UNIFIED_MENU_ITEMS_ID_SUFFIX='-unifiedmenu';f.UNFIFIED_MENU_ITEMS_PROPS=a.getMetadata().getAllProperties();f.LIST_ITEMS_ID_SUFFIX='-menuinnerlist';f.MENU_LIST_ITEMS_PROPS=M.getMetadata().getAllProperties();f.prototype.init=function(){if(b.system.phone){this._initDialog();}this._bIsInitialized=false;};f.prototype.exit=function(){if(this._navContainerId){this._navContainerId=null;}if(this._bIsInitialized){this._bIsInitialized=null;}if(this._getMenu()&&this._getMenu().getPopup()){this._getMenu().getPopup().detachClosed(this._menuClosed,this);}};f.prototype.invalidate=function(){};f.prototype.setTitle=function(t){var n=this._getNavContainer();this.setProperty("title",t,true);if(n&&n.getPages().length){n.getPages()[0].setTitle(t);}return this;};f.prototype.openBy=function(o,w,s,i,O){if(b.system.phone){this._openDialog();}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true;}var j=sap.ui.core.Popup.Dock;if(!s){s=j.BeginTop;}if(!i){i=j.BeginBottom;}if(!O){O="0 -2";}this._getMenu().open(w,o,s,i,o,O);}};f.prototype.close=function(){if(b.system.phone){this._getDialog().close();}else{this._getVisualParent().close();}};f.prototype._initDialog=function(){var o=new D({showHeader:false,stretch:true,content:this._initNavContainer(),buttons:[this._initCloseButton()]});o.addStyleClass("sapMRespMenuDialog");o.removeStyleClass("sapUiPopupWithPadding");this.setAggregation("_dialog",o,true);};f.prototype._getDialog=function(){return this.getAggregation("_dialog");};f.prototype._openDialog=function(){if(!this._bIsInitialized){this._initAllPages();this._bIsInitialized=true;}this._getNavContainer().to(this._getNavContainer().getPages()[0]);this._getDialog().open();};f.prototype._initAllMenuItems=function(){this._initMenuForItems(this.getItems());};f.prototype._setCustomEnhanceAccStateFunction=function(i){this._fnEnhanceUnifiedMenuAccState=i;};f.prototype._initMenuForItems=function(i,p){var m=new U();m._setCustomEnhanceAccStateFunction(this._fnEnhanceUnifiedMenuAccState);m.isCozy=this._isMenuCozy.bind(this,m);this.addStyleClass('sapMMenu');m.aCustomStyleClasses=this.aCustomStyleClasses;m.mCustomStyleClassMap=this.mCustomStyleClassMap;i.forEach(function(I){this._addVisualMenuItemFromItem(I,m);}.bind(this));if(p){p.setSubmenu(m);}else{m.getPopup().attachClosed(this._menuClosed,this);this.setAggregation('_menu',m,true);}m.attachItemSelect(this._handleMenuItemSelect,this);};f.prototype._menuClosed=function(){this.fireClosed();};f.prototype._getMenu=function(){return this.getAggregation("_menu");};f.prototype._initCloseButton=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("MENU_CLOSE"),press:g.bind(this)});};function g(){this._getDialog().close();}f.prototype._initNavContainer=function(){var n=new N();this._navContainerId=n.getId();return n;};f.prototype._getNavContainer=function(){return sap.ui.getCore().byId(this._navContainerId);};f.prototype._initAllPages=function(){this._initPageForParent(this);};f.prototype._initPageForParent=function(p){var i=p.getItems(),j=p instanceof f,s=j?p.getTitle():p.getText(),o=new L({mode:e.None}),k=new P({title:s,showNavButton:!j,content:o});if(!j){this._setBackButtonTooltipForPageWithParent(p,k);}k.attachNavButtonPress(function(){this._getNavContainer().back();},this);this._getNavContainer().addPage(k);i.forEach(function(I){this._addListItemFromItem(I,k);},this);this._updateListInset(o);o.attachEvent("itemPress",this._handleListItemPress,this);return k;};f.prototype._handleListItemPress=function(o){var i=o.getParameter("listItem"),m=sap.ui.getCore().byId(i.getMenuItem()),p=m._getVisualChild();if(p){this._getNavContainer().to(p);}else{this._getDialog().close();this.fireItemSelected({item:m});}m.firePress();};f.prototype._setBackButtonTooltipForPageWithParent=function(p,o){var i=p.getParent(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s;s=i instanceof f?i.getTitle():i.getText();s=r.getText("MENU_PAGE_BACK_BUTTON")+" "+s;o.setNavButtonTooltip(s);};f.prototype._createMenuListItemFromItem=function(i){return new M({id:this._generateListItemId(i.getId()),type:d.Active,icon:i.getIcon(),title:i.getText(),startsSection:i.getStartsSection(),menuItem:i,tooltip:i.getTooltip(),visible:i.getVisible()});};f.prototype._createVisualMenuItemFromItem=function(i){var u=new a({id:this._generateUnifiedMenuItemId(i.getId()),icon:i.getIcon(),text:i.getText(),startsSection:i.getStartsSection(),tooltip:i.getTooltip(),visible:i.getVisible(),enabled:i.getEnabled()}),j=i.getCustomData();j.forEach(function(o){u.addCustomData(new c({key:o.getKey(),value:o.getValue()}));});return u;};f.prototype._addVisualMenuItemFromItem=function(i,m,I){var o=this._createVisualMenuItemFromItem(i);i._setVisualParent(m);i._setVisualControl(o);var j=['aggregationChanged','propertyChanged'];j.forEach(function(s){var k='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[k],this);},this);if(i.getItems().length!==0){this._initMenuForItems(i.getItems(),o);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){m.addItem(o);}else{m.insertItem(o,I);}};f.prototype._addListItemFromItem=function(i,p,I){var m=this._createMenuListItemFromItem(i),o=p.getContent()[0];i._setVisualParent(p);i._setVisualControl(m);var j=['aggregationChanged','propertyChanged'];j.forEach(function(s){var k='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[k],this);},this);if(i.getItems().length!==0){this._initPageForParent(i);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){o.addItem(m);}else{o.insertItem(m,I);}o.rerender();};f.prototype._connectVisualItem=function(i,o,I){if(!o||sap.ui.getCore().byId(i._getVisualControl())){return;}if(b.system.phone){this._addListItemFromItem(i,o,I);var j=o.getContent()[0];this._updateListInset(j);}else{this._addVisualMenuItemFromItem(i,o,I);}};f.prototype._updateListInset=function(o){var H=false,I="sapMListIcons",j=o.getItems();for(var i=0;i<j.length;i++){if(j[i].getIcon()){H=true;break;}}if(H){o.addStyleClass(I);}else{o.removeStyleClass(I);}};f.prototype._handleMenuItemSelect=function(o){var u=o.getParameter("item"),m;if(!u){return;}m=this._findMenuItemByUnfdMenuItem(u);if(m&&!m.getItems().length){this.fireItemSelected({item:m});}if(m){m.firePress();}};f.prototype._generateListItemId=function(m){return m+f.LIST_ITEMS_ID_SUFFIX;};f.prototype._generateUnifiedMenuItemId=function(m){return m+f.UNIFIED_MENU_ITEMS_ID_SUFFIX;};f.prototype._findMenuItemByUnfdMenuItem=function(u){var j=[],o=u,I,k,i;do{j.push(o.getId());o=o.getParent().getParent();}while(o instanceof a);I=this.getItems();do{k=j.pop();for(i=0;i<I.length;i++){if(I[i]._getVisualControl()===k){if(j.length===0){return I[i];}else{I=I[i].getItems();break;}}}}while(j.length);return null;};f.prototype._isMenuCozy=function(m){if(!m.bCozySupported){return false;}if(m.hasStyleClass("sapUiSizeCozy")){return true;}if(h(m.oOpenerRef)){return true;}return false;};function h(r){if(!r){return false;}r=r.$?r.$():q(r);var $=r.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy");return(!$.hasClass("sapUiSizeCompact")&&!$.hasClass("sapUiSizeCondensed"))||$.hasClass("sapUiSizeCozy");}f.prototype.addAggregation=function(A,o,s){C.prototype.addAggregation.apply(this,arguments);if(A==="items"){this._connectVisualItem(o,this._getVisualParent());}return this;};f.prototype.insertAggregation=function(A,o,i,s){C.prototype.insertAggregation.apply(this,arguments);if(A==="items"){this._connectVisualItem(o,this._getVisualParent(),i);}return this;};f.prototype.removeAggregation=function(A,o,s){var i=C.prototype.removeAggregation.apply(this,arguments);if(A==="items"){this._removeVisualItem(i);}return i;};f.prototype.removeAllAggregation=function(A,s){var I=C.prototype.removeAllAggregation.apply(this,arguments);if(A==="items"){for(var i=0;i<I.length;i++){this._removeVisualItem(I[i]);}}return I;};f.prototype._removeVisualItem=function(i,p){var v=sap.ui.getCore().byId(i._getVisualControl()),m;if(v){m=v.getParent();m.removeItem(v);if(b.system.phone){this._removeSubPageForItem(i);if(m.getItems().length===0){if(p){p._setVisualChild(null);sap.ui.getCore().byId(p._getVisualControl()).rerender();}}if(m){m.rerender();}}}};f.prototype.destroyAggregation=function(A,s){if(A==="items"){for(var i=0;i<this.getItems().length;i++){this._removeVisualItem(this.getItems()[i]);}}return C.prototype.destroyAggregation.apply(this,arguments);};f.prototype._removeSubPageForItem=function(I,s){var S;if(!s){for(var i=0;i<I.getItems().length;i++){this._removeSubPageForItem(I.getItems()[i]);}}if(I._getVisualChild()){S=sap.ui.getCore().byId(I._getVisualChild());if(this._getNavContainer()&&S){this._getNavContainer().removePage(S);}!!S&&S.destroy();}};f.prototype._getVisualParent=function(){var n=this._getNavContainer(),m=this._getMenu();if(n&&n.getPages().length){return n.getPages()[0];}else{return m;}};f.prototype._onPropertyChanged=function(o){var p=o.getParameter("propertyKey"),i=o.getParameter("propertyValue"),t=b.system.phone?f.MENU_LIST_ITEMS_PROPS:f.UNFIFIED_MENU_ITEMS_PROPS,G=b.system.phone?this._generateListItemId:this._generateUnifiedMenuItemId,T;if(b.system.phone&&p==='text'){p='title';}if(!t[p]){return;}T=G(o.getSource().getId());if(T){sap.ui.getCore().byId(T).setProperty(p,i);if(b.system.phone&&this._getDialog().isOpen()){this._getDialog().close();}}};f.prototype._onAggregationChanged=function(o){var A=o.getParameter("aggregationName");switch(A){case'items':this._onItemsAggregationChanged(o);break;}};f.prototype._onItemsAggregationChanged=function(o){var I=o.getSource(),m=o.getParameter("methodName"),j=o.getParameter("methodParams"),k;if(m==="add"||m==="insert"){if(m==="insert"){k=j.index;}this._addOrInsertItem(I,j.item,k);}if(m==="remove"){this._removeVisualItem(j.item,I);}if(m==="removeall"){for(var i=0;i<j.items.length;i++){this._removeVisualItem(j.items[i],I);}}if(m==="destroy"){this._destroyItem(I);}};f.prototype._addOrInsertItem=function(p,n,i){var o;if(p._getVisualChild()){this._connectVisualItem(n,sap.ui.getCore().byId(p._getVisualChild()),i);}else{if(b.system.phone){this._initPageForParent(p);p._setVisualChild(p.getItems()[0]._getVisualParent());o=sap.ui.getCore().byId(p._getVisualControl());o.rerender();}else{this._initMenuForItems(p.getItems(),sap.ui.getCore().byId(p._getVisualControl()));p._setVisualChild(p.getItems()[0]._getVisualParent());}}};f.prototype._destroyItem=function(i){var v=sap.ui.getCore().byId(i._getVisualControl());if(v&&v.setMenuItem){v.setMenuItem(null);}this._removeSubPageForItem(i,true);i._setVisualChild(null);if(v&&v.setMenuItem){v.rerender();v.setMenuItem(i);}};f.prototype.getDomRefId=function(){if(b.system.phone){return this._getDialog().getId();}else{return this._getMenu().getId();}};f.prototype.openAsContextMenu=function(o,O){if(b.system.phone){this._openDialog();}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true;}this._getMenu().openAsContextMenu(o,O);}};["addStyleClass","removeStyleClass","toggleStyleClass"].forEach(function(m){f.prototype[m]=function(s,S){var o=this._getDialog();C.prototype[m].apply(this,arguments);if(o){o[m].apply(o,arguments);}return this;};});return f;});
