/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./StandardListItemRenderer", "sap/ui/core/Renderer"],
	function (StandardListItemRenderer, Renderer) {
		"use strict";


		/**
		 * MessageListItem renderer.
		 * @namespace
		 */
		var MessageListItemRenderer = Renderer.extend(StandardListItemRenderer);

		MessageListItemRenderer.renderTitle = function (oRm, oControl) {
			if (oControl.getActiveTitle()) {
				oRm.renderControl(oControl.getLink());
			} else {
				StandardListItemRenderer.renderTitle.apply(this, arguments);
			}
		};

		return MessageListItemRenderer;

	}, /* bExport= */ true);
