/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/ValueStateSupport','sap/ui/core/library','./ObjectStatusRenderer'],function(l,C,V,c,O){"use strict";var I=l.ImageHelper;var T=c.TextDirection;var a=c.ValueState;var b=C.extend("sap.m.ObjectStatus",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",designtime:"sap/m/designtime/ObjectStatus.designtime",properties:{title:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},active:{type:"boolean",group:"Misc",defaultValue:false},state:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:a.None},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{press:{}}}});b.prototype.exit=function(){if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=null;}};b.prototype._getImageControl=function(){var i=this.getId()+'-icon';var p={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};this._oImageControl=I.getImageControl(i,this._oImageControl,this,p);return this._oImageControl;};b.prototype.setTitle=function(t){var $=this.$().children(".sapMObjStatusTitle"),s=!!$.length&&!!this.validateProperty("title",t).trim();this.setProperty("title",t,s);if(s){$.text(this.getTitle()+":");}return this;};b.prototype.setText=function(t){var $=this.$().children(".sapMObjStatusText"),s=!!$.length&&!!this.validateProperty("text",t).trim();this.setProperty("text",t,s);if(s){$.text(this.getText());}return this;};b.prototype.ontap=function(e){if(this._isClickable(e)){this.firePress();}};b.prototype.onsapenter=function(e){if(this._isActive()){this.firePress();e.setMarked();}};b.prototype.onsapspace=function(e){this.onsapenter(e);};b.prototype._isActive=function(){return this.getActive()&&(this.getText().trim()||this.getIcon().trim());};b.prototype._isEmpty=function(){return!(this.getText().trim()||this.getIcon().trim()||this.getTitle().trim());};b.prototype.ontouchstart=function(e){if(this._isClickable(e)){e.setMarked();}};b.prototype.getAccessibilityInfo=function(){var s=this.getState()!=a.None?V.getAdditionalText(this.getState()):"";return{description:((this.getTitle()||"")+" "+(this.getText()||"")+" "+s+" "+(this.getTooltip()||"")).trim()};};b.prototype._isClickable=function(e){var s=e.target.id;return this._isActive()&&(s===this.getId()+"-link"||s===this.getId()+"-text"||s===this.getId()+"-icon");};return b;});
