/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./InputBase','./DateTimeField','./MaskInputRule','./ResponsivePopover','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','./TimePickerSliders','./MaskEnabler','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/Locale','sap/m/library','sap/ui/core/LocaleData','./TimePickerRenderer',"sap/ui/events/KeyCodes","sap/base/Log","sap/ui/thirdparty/jquery"],function(I,D,M,R,E,a,T,b,c,d,L,l,e,f,K,g,q){"use strict";var P=l.PlacementType,h=l.TimePickerMaskMode,j=1;var k=D.extend("sap.m.TimePicker",{metadata:{library:"sap.m",designtime:"sap/m/designtime/TimePicker.designtime",properties:{localeId:{type:"string",group:"Data"},title:{type:"string",group:"Misc",defaultValue:null},minutesStep:{type:"int",group:"Misc",defaultValue:j},secondsStep:{type:"int",group:"Misc",defaultValue:j},placeholderSymbol:{type:"string",group:"Misc",defaultValue:"_"},mask:{type:"string",group:"Misc",defaultValue:null},maskMode:{type:"sap.m.TimePickerMaskMode",group:"Misc",defaultValue:h.On},support2400:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{rules:{type:"sap.m.MaskInputRule",multiple:true,singularName:"rule"},_picker:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}}}});a.insertFontFaceStyle();E.call(k.prototype,true);b.call(k.prototype);var m={Short:"short",Medium:"medium",Long:"long"},n={Hour:"hour",Minute:"minute",Second:"second"},o='-';k.prototype.init=function(){D.prototype.init.apply(this,arguments);b.init.apply(this,arguments);this.setDisplayFormat(r());this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._bValid=false;this._sUsedDisplayPattern=null;this._sUsedValuePattern=null;this._oDisplayFormat=null;this._sValueFormat=null;this._oPopoverKeydownEventDelegate=null;this._rPlaceholderRegEx=new RegExp(o,'g');this._sLastChangeValue=null;var i=this.addEndIcon({id:this.getId()+"-icon",src:this.getIconSrc(),noTabStop:true,title:""});this._bShouldClosePicker=false;i.addEventDelegate({onmousedown:function(s){this._bShouldClosePicker=this.isOpen();}},this);i.attachPress(function(){this.toggleOpen(this._bShouldClosePicker);},this);};k.prototype.exit=function(){if(this._oTimeSemanticMaskHelper){this._oTimeSemanticMaskHelper.destroy();}b.exit.apply(this,arguments);this._removePickerEvents();this._oResourceBundle=null;this._bValid=false;this._sUsedDisplayPattern=null;this._oDisplayFormat=null;this._oPopoverKeydownEventDelegate=null;this._sUsedValuePattern=null;this._sValueFormat=null;this._sLastChangeValue=null;};k.prototype.getIconSrc=function(){return a.getIconURI("time-entry-request");};k.prototype.isOpen=function(){return this._getPicker()&&this._getPicker().isOpen();};k.prototype.toggleOpen=function(O){this[O?"_closePicker":"_openPicker"]();};k.prototype.onfocusin=function(i){var s=this._getPicker();var t=q(i.target).hasClass("sapUiIcon");b.onfocusin.apply(this,arguments);if(s&&s.isOpen()&&!t){this._closePicker();}};k.prototype.onBeforeOpen=function(){var s=this._getSliders(),i=this.getDateValue(),t=this._$input.val(),F=this.getValueFormat(),u=F.indexOf("HH"),v=F.indexOf("H");s.setValue(t);if(this._shouldSetInitialFocusedDateValue()){i=this.getInitialFocusedDateValue();}s._setTimeValues(i,T._isHoursValue24(t,u,v));s.collapseAll();this.$().addClass(I.ICON_PRESSED_CSS_CLASS);};k.prototype.onAfterOpen=function(){var s=this._getSliders();if(s){s.openFirstSlider();this._handleAriaOnExpandCollapse();}};k.prototype.onAfterClose=function(){this.$().removeClass(I.ICON_PRESSED_CSS_CLASS);this._handleAriaOnExpandCollapse();};k.prototype._handleInputChange=function(v){var i,t,s,F=this.getValueFormat(),u=F.indexOf("HH"),w=F.indexOf("H");v=v||this._$input.val();t=v;s=T._isHoursValue24(t,u,w);this._bValid=true;if(v!==""){i=this._parseValue(T._isHoursValue24(v,u,w)?T._replace24HoursWithZero(v,u,w):v,true);if(!i){this._bValid=false;}else{v=this._formatValue(i);}}t=this.getSupport2400()&&s?"24:"+v.replace(/[0-9]/g,"0").slice(0,-3):v;this.updateDomValue(t);if(i){t=v=this._formatValue(i,true);}this.setProperty("value",t,true);this._lastValue=v;if(this._bValid){this.setProperty("dateValue",i,true);}this.fireChangeEvent(t,{valid:this._bValid});return true;};k.prototype.onChange=function(i){var v=i?i.value:null;if(this.getEditable()&&this.getEnabled()){return this._handleInputChange(v);}return false;};k.prototype.setMinutesStep=function(s){var S=this._getSliders();s=Math.max(j,s||j);if(S){S.setMinutesStep(s);}return this.setProperty("minutesStep",s,true);};k.prototype.setSecondsStep=function(s){var S=this._getSliders();s=Math.max(j,s||j);if(S){S.setSecondsStep(s);}return this.setProperty("secondsStep",s,true);};k.prototype.setTitle=function(t){var s=this._getSliders();if(s){s.setLabelText(t);}this.setProperty("title",t,true);return this;};k.prototype._handleDateValidation=function(i){if(!i){this._bValid=false;g.warning("Value can not be converted to a valid date",this);}else{this._bValid=true;this.setProperty("dateValue",i,true);var v=this._formatValue(i);if(this.isActive()){this.updateDomValue(v);}else{this.setProperty("value",v,true);this._lastValue=v;this._sLastChangeValue=v;}}};k.prototype.setSupport2400=function(s){var S=this._getSliders();this.setProperty("support2400",s,true);if(S){S.setSupport2400(s);}this._initMask();return this;};k.prototype.setDisplayFormat=function(s){var S=this._getSliders();this.setProperty("displayFormat",s,true);this._initMask();if(S){S.setDisplayFormat(s);}var i=this.getDateValue();if(!i){return this;}var O=this._formatValue(i);this.updateDomValue(O);this._lastValue=O;return this;};k.prototype.setValue=function(v){var i,O,F=this.getValueFormat(),s=F.indexOf("HH"),t=F.indexOf("H"),S=this._getSliders();v=this.validateProperty("value",v);this._initMask();b.setValue.call(this,v);this._sLastChangeValue=v;this._bValid=true;if(v){i=this._parseValue(T._isHoursValue24(v,s,t)?T._replace24HoursWithZero(v,s,t):v);if(!i){this._bValid=false;g.warning("Value can not be converted to a valid date",this);}}if(this._bValid){this.setProperty("dateValue",i,true);}if(i&&!this.getSupport2400()){O=this._formatValue(i);}else{O=v;}if(S){S.setValue(v);}this.updateDomValue(O);this._lastValue=O;return this;};k.prototype.setTooltip=function(t){var i=this.getDomRef(),s;this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t,true);if(!i){return this;}s=this.getTooltip_AsString();if(s){i.setAttribute("title",s);}else{i.removeAttribute("title");}this._handleTooltipHiddenTextLifecycle();return this;};k.prototype._handleTooltipHiddenTextLifecycle=function(){var i,s,A,H,C,t;if(!sap.ui.getCore().getConfiguration().getAccessibility()){return;}i=this.getRenderer();s=i.getAriaDescribedBy(this);A=i.getDescribedByAnnouncement(this);H=this.getId()+"-describedby";C=s.indexOf(H)>-1;t=this.getDomRef("describedby");if(C){t=document.createElement("span");t.id=H;t.setAttribute("aria-hidden","true");t.className="sapUiInvisibleText";t.textContent=A;this.getDomRef().appendChild(t);}else{this.getDomRef().removeChild(t);}this._$input.attr("aria-describedby",s);};k.prototype.setLocaleId=function(s){var C=this.getValue(),S=this._getSliders();this.setProperty("localeId",s,true);this._initMask();this._oDisplayFormat=null;this._sValueFormat=null;if(C){this.setValue(C);}if(S){S.setLocaleId(s);}return this;};k.prototype._getDefaultDisplayStyle=function(){return m.Medium;};k.prototype._getDefaultValueStyle=function(){return m.Medium;};k.prototype._getFormatterInstance=function(F,s,i,C,t){if(s===m.Short||s===m.Medium||s===m.Long){F=d.getTimeInstance({style:s,strictParsing:true,relative:i},new L(this.getLocaleId()));}else{F=d.getTimeInstance({pattern:s,strictParsing:true,relative:i},new L(this.getLocaleId()));}if(t){this._sUsedDisplayPattern=s;this._oDisplayFormat=F;}else{this._sUsedValuePattern=s;this._sValueFormat=F;}return F;};k.prototype._getFormat=function(){var F=this._getDisplayFormatPattern();if(!F){F=m.Medium;}if(Object.keys(m).indexOf(F)!==-1){F=r();}return F;};k.prototype.onsappageup=function(i){this._increaseTime(1,n.Hour);i.preventDefault();};k.prototype.onsappageupmodifiers=function(i){if(!(i.ctrlKey||i.metaKey||i.altKey)&&i.shiftKey){this._increaseTime(1,n.Minute);}if(!i.altKey&&i.shiftKey&&(i.ctrlKey||i.metaKey)){this._increaseTime(1,n.Second);}i.preventDefault();};k.prototype.onsappagedown=function(i){this._increaseTime(-1,n.Hour);i.preventDefault();};k.prototype.onsappagedownmodifiers=function(i){if(!(i.ctrlKey||i.metaKey||i.altKey)&&i.shiftKey){this._increaseTime(-1,n.Minute);}if(!i.altKey&&i.shiftKey&&(i.ctrlKey||i.metaKey)){this._increaseTime(-1,n.Second);}i.preventDefault();};k.prototype.onkeydown=function(i){var s=K,t=i.which||i.keyCode,A=i.altKey,u;if(t===s.F4||(A&&(t===s.ARROW_UP||t===s.ARROW_DOWN))){u=this._getPicker()&&this._getPicker().isOpen();if(!u){this._openPicker();}else{this._closePicker();}i.preventDefault();}else{b.onkeydown.call(this,i);}};k.prototype._getPicker=function(){return this.getAggregation("_picker");};k.prototype._removePickerEvents=function(){var i,s=this._getPicker();if(s){i=s.getAggregation("_popup");if(typeof this._oPopoverKeydownEventDelegate==='function'){i.removeEventDelegate(this._oPopoverKeydownEventDelegate);}}};k.prototype._openPicker=function(){var i=this._getPicker(),s;if(!i){i=this._createPicker(this._getDisplayFormatPattern());}i.open();s=this._getSliders();setTimeout(s._updateSlidersValues.bind(s),0);return i;};k.prototype._closePicker=function(){var i=this._getPicker();if(i){i.close();}else{g.warning("There is no picker to close.");}return i;};k.prototype._createPicker=function(F){var t=this,i,s,u,O,C,v,w=this.getAggregation("_endIcon")[0],x=this.getLocaleId();u=sap.ui.getCore().getLibraryResourceBundle("sap.m");O=u.getText("TIMEPICKER_SET");C=u.getText("TIMEPICKER_CANCEL");v=this.getTitle();s=new R(t.getId()+"-RP",{showCloseButton:false,showHeader:false,horizontalScrolling:false,verticalScrolling:false,placement:P.VerticalPreferedBottom,beginButton:new sap.m.Button({text:O,press:q.proxy(this._handleOkPress,this)}),endButton:new sap.m.Button({text:C,press:q.proxy(this._handleCancelPress,this)}),content:[new T(this.getId()+"-sliders",{support2400:this.getSupport2400(),displayFormat:F,valueFormat:this.getValueFormat(),labelText:v?v:"",localeId:x,minutesStep:this.getMinutesStep(),secondsStep:this.getSecondsStep()})._setShouldOpenSliderAfterRendering(true)],contentHeight:k._PICKER_CONTENT_HEIGHT});i=s.getAggregation("_popup");if(i.setShowArrow){i.setShowArrow(false);}i.oPopup.setAutoCloseAreas([w]);s.addStyleClass(this.getRenderer().CSS_CLASS+"DropDown").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachAfterClose(this.onAfterClose,this);s.open=function(){return this.openBy(t);};if(c.system.desktop){this._oPopoverKeydownEventDelegate={onkeydown:function(y){var z=K,A=y.which||y.keyCode,B=y.altKey;if((B&&(A===z.ARROW_UP||A===z.ARROW_DOWN))||A===z.F4){this._handleOkPress(y);this.focus();y.preventDefault();}}};i.addEventDelegate(this._oPopoverKeydownEventDelegate,this);i._afterAdjustPositionAndArrowHook=function(){t._getSliders()._onOrientationChanged();};}this.setAggregation("_picker",s,true);return s;};k.prototype._getSliders=function(){var i=this._getPicker();if(!i){return null;}return i.getContent()[0];};k.prototype._handleOkPress=function(i){var s=this._getSliders().getTimeValues(),v=this._formatValue(s);if(this.getSupport2400()){v=this._getSliders().getValue();}this.updateDomValue(v);this._handleInputChange();this._closePicker();};k.prototype._handleCancelPress=function(i){this._closePicker();};k.prototype._getLocaleBasedPattern=function(s){return e.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()).getTimePattern(s);};k.prototype._parseValue=function(v,i){if(i){v=this._oTimeSemanticMaskHelper.stripValueOfLeadingSpaces(v);v=v.replace(this._rPlaceholderRegEx,'');}return D.prototype._parseValue.call(this,v,i);};k.prototype._formatValue=function(i,v){var V=D.prototype._formatValue.apply(this,arguments),F=this.getValueFormat(),s=F.indexOf("HH"),t=F.indexOf("H");if(i){if(!v&&this._oTimeSemanticMaskHelper){V=this._oTimeSemanticMaskHelper.formatValueWithLeadingTrailingSpaces(V);}}if(this.getSupport2400()&&T._isHoursValue24(this.getValue(),s,t)&&T._replaceZeroHoursWith24(V,s,t)===this.getValue()){V=this.getValue();}return V;};k.prototype._handleAriaOnExpandCollapse=function(){this.getFocusDomRef().setAttribute("aria-expanded",this._getPicker().isOpen());};k.prototype._increaseTime=function(N,u){var O=this.getDateValue(),i,s;if(O&&this.getEditable()&&this.getEnabled()){i=new Date(O.getTime());switch(u){case n.Hour:i.setHours(i.getHours()+N);s=60*60*1000;break;case n.Minute:i.setMinutes(i.getMinutes()+N);s=60*1000;break;case n.Second:s=1000;i.setSeconds(i.getSeconds()+N);}if(N<0&&i.getTime()-O.getTime()!==N*s){i=new Date(O.getTime()+N*s);}this.setDateValue(i);this.fireChangeEvent(this.getValue(),{valid:true});}};k.prototype._initMask=function(){if(this._oTimeSemanticMaskHelper){this._oTimeSemanticMaskHelper.destroy();}this._oTimeSemanticMaskHelper=new p(this);};k.prototype._isMaskEnabled=function(){return this.getMaskMode()===h.On;};k.prototype._shouldSetInitialFocusedDateValue=function(){if(!this._isValidValue()){return true;}return!this.getValue()&&!!this.getInitialFocusedDateValue();};k.prototype._isValidValue=function(){return this._bValid;};k.prototype.fireChangeEvent=function(v,i){if(v){v=v.trim();}if(v!==this._sLastChangeValue){this._sLastChangeValue=v;I.prototype.fireChangeEvent.call(this,v,i);}};var p=function(t){var s=t._getDisplayFormatPattern(),u,A,v=t.getLocaleId()||sap.ui.getCore().getConfiguration().getFormatLocale(),w=new L(v),i;if(t._checkStyle(s)){u=e.getInstance(w).getTimePattern(s);}else{u=s;}t.setProperty("localeId",v,true);this._oTimePicker=t;this.aOriginalAmPmValues=e.getInstance(w).getDayPeriods("abbreviated");this.aAmPmValues=this.aOriginalAmPmValues.slice(0);this.iAmPmValueMaxLength=Math.max(this.aAmPmValues[0].length,this.aAmPmValues[1].length);for(i=0;i<this.aAmPmValues.length;i++){while(this.aAmPmValues[i].length<this.iAmPmValueMaxLength){this.aAmPmValues[i]+=" ";}}this.b24H=s.indexOf("H")!==-1;this.bLeadingZero=s.indexOf("HH")!==-1||s.indexOf("hh")!==-1;this.sLeadingChar=this.bLeadingZero?"0":" ";this.sAlternativeLeadingChar=this.bLeadingZero?" ":"0";this.sLeadingRegexChar=this.bLeadingZero?"0":"\\s";t.setPlaceholderSymbol(o);u=u.replace(/hh/ig,"h").replace(/h/ig,"h9");if(this.b24H){A="["+this.sLeadingRegexChar+"012]";}else{A="["+this.sLeadingRegexChar+"1]";}this._maskRuleHours=new M({maskFormatSymbol:"h",regex:A});t.addRule(this._maskRuleHours);this.iHourNumber1Index=u.indexOf("h9");this.iHourNumber2Index=this.iHourNumber1Index!==-1?this.iHourNumber1Index+1:-1;this.iMinuteNumber1Index=u.indexOf("mm");u=u.replace(/mm/g,"59");this.iSecondNumber1Index=u.indexOf("ss");u=u.replace(/ss/g,"59");this._maskRuleMinSec=new M({maskFormatSymbol:"5",regex:"[0-5]"});t.addRule(this._maskRuleMinSec);this.aAllowedHours=G.call(this,this.b24H,this.sLeadingChar);this.aAllowedMinutesAndSeconds=H.call(this);this.iAmPmChar1Index=u.indexOf("a");this.iAfterAmPmValueIndex=-1;if(this.iAmPmChar1Index!==-1){this.iAfterAmPmValueIndex=this.iAmPmChar1Index+this.iAmPmValueMaxLength;var C=this.iAmPmValueMaxLength-"a".length;this.shiftIndexes(C);var x=65;var y="";var z="";var B="";for(i=0;i<this.iAmPmValueMaxLength;i++){z="[";if(this.aAmPmValues[0][i]){z+=this.aAmPmValues[0][i];}else{z+="\\s";}if(this.aAmPmValues[1][i]!==this.aAmPmValues[0][i]){if(this.aAmPmValues[1][i]){z+=this.aAmPmValues[1][i];}else{z+="\\s";}}z+="]";B=String.fromCharCode(x++);y+=B;this._maskRuleChars=new M({maskFormatSymbol:B,regex:z});t.addRule(this._maskRuleChars);}u=u.replace(/a/g,y);}t.setMask(u);function F(S,J,N){var O=[],Q,i;for(i=S;i<=J;i++){Q=i.toString();if(i<10){Q=N+Q;}O.push(Q);}return O;}function G(J,N){var S=J?0:1,O=this._oTimePicker.getSupport2400()?24:23,Q=J?O:12;return F(S,Q,N);}function H(){return F(0,59,"0");}};p.prototype.replaceChar=function(C,s,t){var A=s-this.iAmPmChar1Index,u,v,w,S,x,y,i;if(s===this.iHourNumber1Index&&this.sAlternativeLeadingChar===C){if(this.aAllowedHours.indexOf(this.sLeadingChar+C)!==-1){return this.sLeadingChar+C;}else{return this.sLeadingChar;}}else if(s===this.iHourNumber1Index&&!this._oTimePicker._isCharAllowed(C,s)&&this.aAllowedHours.indexOf(this.sLeadingChar+C)!==-1){return this.sLeadingChar+C;}else if(s===this.iHourNumber2Index&&this.aAllowedHours.indexOf(t[this.iHourNumber1Index]+C)===-1){return"";}else if((s===this.iMinuteNumber1Index||s===this.iSecondNumber1Index)&&!this._oTimePicker._isCharAllowed(C,s)&&this.aAllowedMinutesAndSeconds.indexOf("0"+C)!==-1){return"0"+C;}else if(A>=0&&s<this.iAfterAmPmValueIndex){u=t.slice(this.iAmPmChar1Index,s);v=this.aAmPmValues[0].slice(0,A);w=this.aAmPmValues[1].slice(0,A);x=this.aAmPmValues[0].slice(A,this.iAfterAmPmValueIndex);y=this.aAmPmValues[1].slice(A,this.iAfterAmPmValueIndex);S=(v===w);var z="";for(i=A;i<this.iAmPmValueMaxLength;i++){if(this.aAmPmValues[0][i]===this.aAmPmValues[1][i]){z+=this.aAmPmValues[0][i];}else{break;}}if(i===this.iAmPmValueMaxLength||i!==A){return z;}else{if(!S){if(u===v){return x;}else if(u===w){return y;}else{return C;}}else{if(this.aAmPmValues[0][A].toLowerCase()===C.toLowerCase()&&this.aAmPmValues[0]===u+x){return x;}else if(this.aAmPmValues[1][A].toLowerCase()===C.toLowerCase()&&this.aAmPmValues[1]===u+y){return y;}else{return C;}}}}else{return C;}};p.prototype.formatValueWithLeadingTrailingSpaces=function(v){var i=this._oTimePicker.getMask().length;if(this.aOriginalAmPmValues[0]!==this.aAmPmValues[0]){v=v.replace(this.aOriginalAmPmValues[0],this.aAmPmValues[0]);}if(this.aOriginalAmPmValues[1]!==this.aAmPmValues[1]){v=v.replace(this.aOriginalAmPmValues[1],this.aAmPmValues[1]);}while(i>v.length){v=[v.slice(0,this.iHourNumber1Index)," ",v.slice(this.iHourNumber1Index)].join('');}return v;};p.prototype.stripValueOfLeadingSpaces=function(v){if(v[this.iHourNumber1Index]===" "){v=[v.slice(0,this.iHourNumber1Index),v.slice(this.iHourNumber1Index+1)].join('');}return v;};p.prototype.shiftIndexes=function(s){if(this.iAmPmChar1Index<this.iHourNumber1Index){this.iHourNumber1Index+=s;this.iHourNumber2Index+=s;}if(this.iAmPmChar1Index<this.iMinuteNumber1Index){this.iMinuteNumber1Index+=s;}if(this.iAmPmChar1Index<this.iSecondNumber1Index){this.iSecondNumber1Index+=s;}};p.prototype.destroy=function(){if(this._maskRuleHours){this._maskRuleHours.destroy();this._maskRuleHours=null;}if(this._maskRuleMinSec){this._maskRuleMinSec.destroy();this._maskRuleMinSec=null;}if(this._maskRuleChars){this._maskRuleChars.destroy();this._maskRuleChars=null;}};k.prototype._feedReplaceChar=function(C,i,s){return this._oTimeSemanticMaskHelper.replaceChar(C,i,s);};k.prototype.getAccessibilityInfo=function(){var i=this.getRenderer();var s=I.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var t=this.getDateValue();if(t){v=this._formatValue(t);}}q.extend(true,s,{role:i.getAriaRole(this),type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_TIMEINPUT"),description:[v,i.getLabelledByAnnouncement(this),i.getDescribedByAnnouncement(this)].join(" ").trim(),multiline:false,autocomplete:"none",expanded:false,haspopup:true,owns:this.getId()+"-sliders"});return s;};function r(){var i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),s=e.getInstance(i);return s.getTimePattern(m.Medium);}k._PICKER_CONTENT_HEIGHT="25rem";return k;});
