/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./TextField','sap/ui/model/type/Date','sap/ui/core/date/UniversalDate','./library',"./DatePickerRenderer"],function(q,T,D,U,l,a){"use strict";var b=T.extend("sap.ui.commons.DatePicker",{metadata:{library:"sap.ui.commons",properties:{locale:{type:"string",group:"Misc",defaultValue:null},yyyymmdd:{type:"string",group:"Misc",defaultValue:null}}}});(function(){b.prototype.init=function(){T.prototype.init.apply(this,arguments);this._oFormatYyyymmdd=sap.ui.core.format.DateFormat.getInstance({pattern:"yyyyMMdd",strictParsing:true,calendarType:sap.ui.core.CalendarType.Gregorian});if(!sap.ui.Device.system.desktop){this._bMobile=true;this._oFormatMobile=sap.ui.core.format.DateFormat.getInstance({pattern:"yyyy-MM-dd",strictParsing:true,calendarType:sap.ui.core.CalendarType.Gregorian});}this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=new Date(9999,11,31,23,59,59,99);};b.prototype.exit=function(){this._oDate=undefined;this._oLocale=undefined;if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close();}delete this._oPopup;}if(this._oCalendar){this._oCalendar.destroy();delete this._oCalendar;}};b.prototype.onAfterRendering=function(){T.prototype.onAfterRendering.apply(this,arguments);if(this._bMobile){if(this._oDate){var I=q(this.getInputDomRef());var o=this._oFormatMobile.format(this._oDate);I.val(o);}}};b.prototype.invalidate=function(o){if(!o||o!=this._oCalendar){sap.ui.core.Control.prototype.invalidate.apply(this,arguments);}};b.prototype.onsapshow=function(E){var t=this;f(t);E.preventDefault();};b.prototype.onsaphide=b.prototype.onsapshow;b.prototype.onsappageup=function(E){var t=this;j(t,1,"day");E.preventDefault();};b.prototype.onsappageupmodifiers=function(E){var t=this;if(!E.ctrlKey&&E.shiftKey){j(t,1,"month");}else{j(t,1,"year");}E.preventDefault();};b.prototype.onsappagedown=function(E){var t=this;j(t,-1,"day");E.preventDefault();};b.prototype.onsappagedownmodifiers=function(E){var t=this;if(!E.ctrlKey&&E.shiftKey){j(t,-1,"month");}else{j(t,-1,"year");}E.preventDefault();};b.prototype.onkeypress=function(E){if(E.charCode){var t=this;var F=_(t);var C=String.fromCharCode(E.charCode);if(C&&F.sAllowedCharacters&&F.sAllowedCharacters.indexOf(C)<0){E.preventDefault();}}};b.prototype.onclick=function(E){if(q(E.target).hasClass("sapUiTfDateIcon")&&!this._bMobile){var t=this;f(t);}};b.prototype.onsapfocusleave=function(E){if(this._oCalendar&&E.relatedControlId&&(q.sap.containsOrEquals(this._oCalendar.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())||this.getId()==E.relatedControlId)){return;}T.prototype.onsapfocusleave.apply(this,arguments);};b.prototype.setValue=function(v){var o=this.getValue();if(v==o){return this;}var t=this;d(t);this.setProperty("value",v,true);this._bValueSet=true;if(v){this._oDate=this._parseValue(v);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;q.sap.log.warning("Value can not be converted to a valid date",this);}}else{this._oDate=undefined;}var y="";if(this._oDate){y=this._oFormatYyyymmdd.format(this._oDate);}this.setProperty("yyyymmdd",y,true);if(this.getDomRef()){var O="";var I=q(this.getInputDomRef());if(this._bMobile&&this._oDate){O=this._oFormatMobile.format(this._oDate);}else{O=v;}I.val(O);}return this;};b.prototype.setYyyymmdd=function(y){var o=this.getYyyymmdd();if(y==o){return this;}this.setProperty("yyyymmdd",y,true);this._bValueSet=false;var v="";if(y){this._oDate=this._oFormatYyyymmdd.parse(y);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;q.sap.log.warning("Value can not be converted to a valid date",this);}}else{this._oDate=undefined;}if(this._oDate){v=this._formatValue(this._oDate);}this.setProperty("value",v,true);if(this.getDomRef()){var O="";var I=q(this.getInputDomRef());if(this._bMobile&&this._oDate){O=this._oFormatMobile.format(this._oDate);}else{O=v;}I.val(O);}return this;};b.prototype.setLocale=function(L){var o=this.getLocale();if(L==o){return this;}this.setProperty("locale",L,true);var t=this;d(t);this._oLocale=new sap.ui.core.Locale(L);this._sUsedPattern=undefined;var v="";if(this._bValueSet){v=this.getValue();if(v){this._oDate=this._parseValue(v);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;q.sap.log.warning("Value can not be converted to a valid date",this);}}else{this._oDate=undefined;}var y="";if(this._oDate){y=this._oFormatYyyymmdd.format(this._oDate);}this.setProperty("yyyymmdd",y,true);}else{if(this._oDate){v=this._formatValue(this._oDate);}this.setProperty("value",v,true);}if(this.getDomRef()){var O="";var I=q(this.getInputDomRef());if(this._bMobile&&this._oDate){O=this._oFormatMobile.format(this._oDate);}else{O=v;}I.val(O);}return this;};b.prototype.oninput=function(E){if(this._bMobile){var I=this.getInputDomRef();var n=I&&I.value;if(n){var o=this._oFormatMobile.parse(n);}if(!n||o){this._checkChange(E);}}else{T.prototype.oninput.apply(this,arguments);}};b.prototype._checkChange=function(E){var I=this.getInputDomRef();var n=I&&I.value;if(this._bMobile&&n!=""){this._oDate=this._oFormatMobile.parse(n);n=this._formatValue(this._oDate);}if(this.getEditable()&&this.getEnabled()&&n!=this.getValue()){var w=false;if(n!=""){if(!this._bMobile){this._oDate=this._parseValue(n);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;w=true;}else{n=this._formatValue(this._oDate);I.value=n;if(this._oPopup&&this._oPopup.isOpen()){this._oCalendar.focusDate(this._oDate);if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=this._oDate.getTime()){this._oDateRange.setStartDate(new Date(this._oDate.getTime()));}}}}}else{this._oDate=undefined;}this.setProperty("value",n,true);this._bValueSet=false;if(!w){var y="";if(this._oDate){y=this._oFormatYyyymmdd.format(this._oDate);}this.setProperty("yyyymmdd",y,true);}this.fireChange(w);}else if(this.getEditable()&&this.getEnabled()&&n==this.getYyyymmdd()){I.value=this.getValue();}};b.prototype.fireChange=function(I){this.fireEvent("change",{newValue:this.getValue(),newYyyymmdd:this.getYyyymmdd(),invalidValue:I});return this;};b.prototype._parseValue=function(v){var t=this;var F=_(t);var o=F.parse(v);return o;};b.prototype._formatValue=function(o){var t=this;var F=_(t);var v=F.format(o);return v;};b.prototype.getAccessibilityInfo=function(){var I=T.prototype.getAccessibilityInfo.apply(this,arguments);I.type=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("ACC_CTR_TYPE_DATEINPUT");return I;};function _(t){var p="";var r=false;var B=t.getBinding("value");var L;var C;if(B&&B.oType&&(B.oType instanceof D)){p=B.oType.getOutputPattern();r=!!B.oType.oOutputFormat.oFormatOptions.relative;C=B.oType.oOutputFormat.oFormatOptions.calendarType;}if(!p){L=c(t);var o=sap.ui.core.LocaleData.getInstance(L);p=o.getDatePattern("medium");C=sap.ui.getCore().getConfiguration().getCalendarType();}if(p!=t._sUsedPattern||C!=t._sUsedCalendarType){t._sUsedPattern=p;t._sUsedCalendarType=C;if(p=="short"||p=="medium"||p=="long"){t._oFormat=sap.ui.core.format.DateFormat.getInstance({style:p,strictParsing:true,relative:r,calendarType:C},L);}else{t._oFormat=sap.ui.core.format.DateFormat.getInstance({pattern:p,strictParsing:true,relative:r,calendarType:C},L);}}return t._oFormat;}function c(t){var L=t.getLocale();var o;if(L){o=t._oLocale;}else{o=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}return o;}function d(t){var B=t.getBinding("value");var L=t.getLocale();if(B&&B.oType&&(B.oType instanceof D)&&L){q.sap.log.warning("DatePicker "+t.getId()+": Using a locale and Databinding at the same time is not supported");t._bIgnoreLocale=true;}}function e(t){if(!t._oPopup){q.sap.require("sap.ui.core.Popup");t._oPopup=new sap.ui.core.Popup();t._oPopup.setAutoClose(true);t._oPopup.setDurations(0,0);t._oPopup.attachClosed(i,t);}if(!t._oCalendar){sap.ui.getCore().loadLibrary("sap.ui.unified");q.sap.require("sap.ui.unified.library");t._oCalendar=new sap.ui.unified.Calendar(t.getId()+"-cal");t._oDateRange=new sap.ui.unified.DateRange();t._oCalendar.addSelectedDate(t._oDateRange);t._oCalendar.attachSelect(g,t);t._oCalendar.attachCancel(h,t);t._oPopup.setContent(t._oCalendar);t._oCalendar.addStyleClass("sapUiSizeCompact");t._oCalendar.setPopupMode(true);t._oCalendar.setParent(t,undefined,true);}var v="";if(t._oDate){v=t._formatValue(t._oDate);}if(v!=t.$("input").val()){t._checkChange();}var C;var B=t.getBinding("value");if(B&&B.oType&&(B.oType instanceof D)){C=B.oType.oOutputFormat.oFormatOptions.calendarType;}if(C){t._oCalendar.setPrimaryCalendarType(C);}var o=t._oDate;if(o){t._oCalendar.focusDate(o);if(!t._oDateRange.getStartDate()||t._oDateRange.getStartDate().getTime()!=o.getTime()){t._oDateRange.setStartDate(new Date(o.getTime()));}}else{t._oCalendar.focusDate(new Date());if(t._oDateRange.getStartDate()){t._oDateRange.setStartDate(undefined);}}if(!t._bIgnoreLocale){t._oCalendar.setLocale(t.getLocale());}t._oPopup.setAutoCloseAreas([t.getDomRef()]);var k=sap.ui.core.Popup.Dock;t._oPopup.open(0,k.BeginTop,k.BeginBottom,t,null,null,true);}function f(t){if(t.getEditable()&&t.getEnabled()){if(!t._oPopup||!t._oPopup.isOpen()){e(t);}else{t._oPopup.close();t.focus();}}}function g(E){var s=this._oCalendar.getSelectedDates();var o="";if(s.length>0){this._oDate=s[0].getStartDate();o=this._formatValue(this._oDate);}this._oPopup.close();this.focus();var n=this._formatValue(this._oDate);this.setProperty("value",n,true);this._bValueSet=false;var y=this._oFormatYyyymmdd.format(this._oDate);this.setProperty("yyyymmdd",y,true);var I=this.$("input");if(I.val()!==o){I.val(o);this._curpos=o.length;I.cursorPos(this._curpos);}this.fireChange();}function h(E){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();this.focus();}}function i(E){if(!q.sap.containsOrEquals(this.getDomRef(),document.activeElement)&&this.getRenderer().onblur){this.getRenderer().onblur(this);}}function j(t,n,u){var o=t._oDate;if(o&&t.getEditable()&&t.getEnabled()){var B=t.getBinding("value");var C;if(B&&B.oType&&(B.oType instanceof D)){C=B.oType.oOutputFormat.oFormatOptions.calendarType;}else{C=sap.ui.getCore().getConfiguration().getCalendarType();}var k=U.getInstance(new Date(o.getTime()),C);o=U.getInstance(new Date(o.getTime()),C);var I=q(t.getInputDomRef());var p=I.cursorPos();switch(u){case"day":k.setDate(k.getDate()+n);break;case"month":k.setMonth(k.getMonth()+n);var m=(o.getMonth()+n)%12;if(m<0){m=12+m;}while(k.getMonth()!=m){k.setDate(k.getDate()-1);}break;case"year":k.setFullYear(k.getFullYear()+n);while(k.getMonth()!=o.getMonth()){k.setDate(k.getDate()-1);}break;default:break;}if(k.getTime()<t._oMinDate.getTime()){k=new U(t._oMinDate.getTime());}else if(k.getTime()>t._oMaxDate.getTime()){k=new U(t._oMaxDate.getTime());}t._oDate=new Date(k.getTime());var O=t._formatValue(t._oDate);I.val(O);I.cursorPos(p);}}}());return b;},true);
