/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/Renderer','sap/ui/core/format/DateFormat','./calendar/CalendarUtils','./calendar/Header','./calendar/MonthsRow','./calendar/YearPicker','./calendar/CalendarDate','./Calendar','./CalendarRenderer',"./CalendarMonthIntervalRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery"],function(D,C,L,a,R,b,c,H,M,Y,d,e,f,g,h,i,j,q){"use strict";var k=C.extend("sap.ui.unified.CalendarMonthInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:12},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},monthsRow:{type:"sap.ui.unified.calendar.MonthsRow",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});k.prototype.init=function(){this._iMode=0;this.data("sap-ui-fastnavgroup","true",true);this._oYearFormat=b.getDateInstance({format:"y"});this._oMinDate=c._minDate();this._oMaxDate=c._maxDate();this._initializeHeader();this._initializeMonthsRow();this._initilizeYearPicker();this._iDaysMonthsHead=15;};k.prototype.exit=function(){if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent);}};k.prototype.onBeforeRendering=function(){var O=this.getAggregation("monthsRow");var P=this._getFocusedDate();r.call(this);O.displayDate(P.toLocalJSDate());};k.prototype._initializeHeader=function(){var O=new H(this.getId()+"--Head",{visibleButton0:false,visibleButton1:false,visibleButton2:true});O.attachEvent("pressPrevious",this._handlePrevious,this);O.attachEvent("pressNext",this._handleNext,this);O.attachEvent("pressButton2",x,this);this.setAggregation("header",O);};k.prototype._initializeMonthsRow=function(){var O=new M(this.getId()+"--MonthsRow");O.attachEvent("focus",A,this);O.attachEvent("select",z,this);O._bNoThemeChange=true;this.setAggregation("monthsRow",O);};k.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};k.prototype._createYearPicker=function(){var O=new Y(this.getId()+"--YP",{columns:0,years:6});O.attachEvent("select",E,this);O.attachEvent("pageChange",K,this);O._oMinDate.setYear(this._oMinDate.getYear());O._oMaxDate.setYear(this._oMaxDate.getYear());return O;};k.prototype._getCalendarPicker=function(){var O=this.getAggregation("calendarPicker");if(!O){O=new N(this.getId()+"--Cal");O.setPopupMode(true);O.attachEvent("select",B,this);O.attachEvent("cancel",function(P){this._oPopup.close();var Q=this.getAggregation("header").getDomRef("B2");if(Q){Q.focus();}},this);this.setAggregation("calendarPicker",O);}return O;};k.prototype.setStartDate=function(S){c._checkJSDateObject(S);if(i(this.getStartDate(),S)){return this;}var O=S.getFullYear();c._checkYearInValidRange(O);this.setProperty("startDate",S,true);this._oStartDate=d.fromLocalJSDate(S);this._oStartDate.setDate(1);var P=this.getAggregation("monthsRow");P.setStartDate(S);r.call(this);var Q=this._getFocusedDate().toLocalJSDate();if(!P.checkDateFocusable(Q)){this._setFocusedDate(this._oStartDate);P.displayDate(S);}return this;};k.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=setTimeout(F.bind(this),0);}};k.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var O=this.removeAllAggregation("selectedDates");return O;};k.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var O=this.destroyAggregation("selectedDates");return O;};k.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var O=this.removeAllAggregation("specialDates");return O;};k.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var O=this.destroyAggregation("specialDates");return O;};k.prototype.setLocale=function(O){if(this._sLocale!=O){this._sLocale=O;this._oLocaleData=undefined;this.invalidate();}return this;};k.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};k.prototype._getFocusedDate=function(){if(!this._oFocusedDate){n.call(this);}return this._oFocusedDate;};k.prototype._setFocusedDate=function(O){c._checkCalendarDate(O);this._oFocusedDate=new d(O);};k.prototype.focusDate=function(O){var P=false;var Q=this.getAggregation("monthsRow");if(O&&!Q.checkDateFocusable(O)){G.call(this,d.fromLocalJSDate(O));P=true;}w.call(this,O,false);if(P){this.fireStartDateChange();}return this;};k.prototype.displayDate=function(O){w.call(this,O,true);return this;};k.prototype.setMonths=function(O){this.setProperty("months",O,true);O=this._getMonths();var P=this.getAggregation("monthsRow");P.setMonths(O);if(!P.checkDateFocusable(this._getFocusedDate().toLocalJSDate())){var S=l.call(this);this._setFocusedDate(this._oStartDate);P.setDate(S.toLocalJSDate());}if(!this.getPickerPopup()){var Q=this.getAggregation("yearPicker");var T=Math.floor(O/2);if(T>20){T=20;}Q.setYears(T);}r.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};k.prototype._getMonths=function(){var O=this.getMonths();if(D.system.phone&&O>6){return 6;}else{return O;}};k.prototype._getLocaleData=function(){if(!this._oLocaleData){var O=this.getLocale();var P=new L(O);this._oLocaleData=a.getInstance(P);}return this._oLocaleData;};k.prototype.setPickerPopup=function(P){var O;this.setProperty("pickerPopup",P,true);if(P){if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}}else{if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}O=this.getAggregation("yearPicker");O.setColumns(0);O.setYears(6);}return this;};k.prototype.setMinDate=function(O){if(i(O,this.getMinDate())){return this;}if(!O){this._oMinDate=c._minDate();}else{c._checkJSDateObject(O);this._oMinDate=d.fromLocalJSDate(O);this._oMinDate.setDate(1);var P=this._oMinDate.getYear();c._checkYearInValidRange(P);if(this._oMaxDate.isBefore(this._oMinDate)){j.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=d.fromLocalJSDate(O);this._oMaxDate.setDate(c._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isBefore(this._oMinDate)){j.warning("focused date < minDate -> minDate focused",this);this.focusDate(O);}}if(this._oStartDate&&this._oStartDate.isBefore(this._oMinDate)){j.warning("start date < minDate -> minDate set as start date",this);_.call(this,new d(this._oMinDate),true,true);}}this.setProperty("minDate",O,false);if(this.getPickerPopup()){var Q=this._getCalendarPicker();Q.setMinDate(O);}else{var S=this.getAggregation("yearPicker");S._oMinDate.setYear(this._oMinDate.getYear());}return this;};k.prototype.setMaxDate=function(O){if(i(O,this.getMaxDate())){return this;}if(!O){this._oMaxDate=c._maxDate();}else{c._checkJSDateObject(O);this._oMaxDate=d.fromLocalJSDate(O);this._oMaxDate.setDate(c._daysInMonth(this._oMaxDate));var P=this._oMaxDate.getYear();c._checkYearInValidRange(P);if(this._oMinDate.isAfter(this._oMaxDate)){j.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=d.fromLocalJSDate(O);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isAfter(this._oMaxDate)){j.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(O);}}if(this._oStartDate){var Q=new d(this._oStartDate);Q.setDate(1);Q.setMonth(Q.getMonth()+this._getMonths());Q.setDate(0);if(Q.isAfter(this._oMaxDate)){var S=new d(this._oMaxDate);S.setDate(1);S.setMonth(S.getMonth()-this._getMonths()+1);if(S.isSameOrAfter(this._oMinDate)){j.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,S,true,true);}}}}this.setProperty("maxDate",O,false);if(this.getPickerPopup()){var T=this._getCalendarPicker();T.setMaxDate(O);}else{var U=this.getAggregation("yearPicker");U._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};k.prototype.onclick=function(O){if(O.isMarked("delayedMouseEvent")){return;}if(O.target.id==this.getId()+"-cancel"){this.onsapescape(O);}};k.prototype.onmousedown=function(O){O.preventDefault();O.setMark("cancelAutoClose");};k.prototype.onsapescape=function(O){if(this.getPickerPopup()){y.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:p.call(this);break;}}};k.prototype.onsaptabnext=function(O){var P=this.getAggregation("header"),Q,S;if(h(this.getDomRef("content"),O.target)){if(P.getDomRef("B2")){P.getDomRef("B2").focus();}if(!this._bPoupupMode){S=this.getAggregation("monthsRow");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){Q=this.getAggregation("yearPicker");if(Q.getDomRef()){q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}O.preventDefault();}};k.prototype.onsaptabprevious=function(O){var P=this.getAggregation("header"),Q,S;if(h(this.getDomRef("content"),O.target)){if(this._bPoupupMode){if(P.getDomRef("B2")){P.getDomRef("B2").focus();}O.preventDefault();}}else if(O.target.id==P.getId()+"-B2"){switch(this._iMode){case 0:Q=this.getAggregation("monthsRow");Q._oItemNavigation.focusItem(Q._oItemNavigation.getFocusedIndex());break;case 1:if(!this.getPickerPopup()){S=this.getAggregation("yearPicker");S._oItemNavigation.focusItem(S._oItemNavigation.getFocusedIndex());}break;}O.preventDefault();}};k.prototype.onfocusin=function(O){if(O.target.id==this.getId()+"-end"){var P=this.getAggregation("header"),Q,S;if(P.getDomRef("B2")){P.getDomRef("B2").focus();}if(!this._bPoupupMode){Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){S=this.getAggregation("yearPicker");if(S.getDomRef()){q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};k.prototype.onsapfocusleave=function(O){var P,Q;if(!O.relatedControlId||!h(this.getDomRef(),sap.ui.getCore().byId(O.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){switch(this._iMode){case 0:P=this.getAggregation("monthsRow");q(P._oItemNavigation.getItemDomRefs()[P._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 1:if(!this.getPickerPopup()){Q=this.getAggregation("yearPicker");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};k.prototype._handlePrevious=function(O){var P,Q,S,T;switch(this._iMode){case 0:P=this._getFocusedDate();Q=this._getMonths();S=new d(l.call(this));S.setMonth(S.getMonth()-Q);P.setMonth(P.getMonth()-Q);this._setFocusedDate(P);_.call(this,S,true);break;case 1:if(!this.getPickerPopup()){T=this.getAggregation("yearPicker");T.previousPage();t.call(this);}break;}};k.prototype._handleNext=function(O){var P,Q,S,T;switch(this._iMode){case 0:P=this._getFocusedDate();Q=this._getMonths();S=new d(l.call(this));S.setMonth(S.getMonth()+Q);P.setMonth(P.getMonth()+Q);this._setFocusedDate(P);_.call(this,S,true);break;case 1:if(!this.getPickerPopup()){T=this.getAggregation("yearPicker");T.nextPage();t.call(this);}break;}};k.prototype._showOverlay=function(){this.$("contentOver").css("display","");};k.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};k.prototype._getShowItemHeader=function(){var O=this.getMonths();if(O>this._iDaysMonthsHead){return true;}else{return false;}};function _(S,O,P){var Q=new d(this._oMaxDate);Q.setDate(1);Q.setMonth(Q.getMonth()-this._getMonths()+1);if(Q.isBefore(this._oMinDate)){Q=new d(this._oMinDate);Q.setMonth(Q.getMonth()+this._getMonths()-1);}if(S.isBefore(this._oMinDate)){S=new d(this._oMinDate);}else if(S.isAfter(Q)){S=Q;}S.setDate(1);var T=S.toLocalJSDate();this.setProperty("startDate",T,true);this._oStartDate=S;var U=this.getAggregation("monthsRow");U.setStartDate(T);r.call(this);if(O){var V=this._getFocusedDate().toLocalJSDate();if(!U.checkDateFocusable(V)){this._setFocusedDate(S);U.setDate(T);}else{U.setDate(V);}}if(!P){this.fireStartDateChange();}}function l(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();this._oStartDate.setDate(1);}return this._oStartDate;}function m(O){var P=this._getFocusedDate();var Q=this.getAggregation("monthsRow");if(!O){Q.setDate(P.toLocalJSDate());}else{Q.displayDate(P.toLocalJSDate());}r.call(this);}function n(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=d.fromLocalJSDate(S[0].getStartDate());}else{this._oFocusedDate=new d();}this._oFocusedDate.setDate(1);if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new d(this._oMinDate);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new d(this._oMaxDate);}}function o(){var O=this._getFocusedDate();var P=this.getAggregation("yearPicker");if(P.getDomRef()){P.$().css("display","");}else{var Q=sap.ui.getCore().createRenderManager();var $=this.$("content");Q.renderControl(P);Q.flush($[0],false,true);Q.destroy();}this._showOverlay();P.setDate(O.toLocalJSDate());if(this._iMode==0){var S=this.getAggregation("monthsRow");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}t.call(this);this._iMode=1;}function p(O){this._iMode=0;var P=this.getAggregation("yearPicker");P.$().css("display","none");this._hideOverlay();if(!O){m.call(this);var Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function r(){u.call(this);s.call(this);}function s(){var O=new d(l.call(this));var P=this._getMonths();var Q=O.getYear();var S=this._oMaxDate.getYear();var T=this._oMinDate.getYear();var U=O.getMonth();var V=this._oMaxDate.getMonth();var W=this._oMinDate.getMonth();var X=this.getAggregation("header");if(Q<T||(Q==T&&U<=W)){X.setEnabledPrevious(false);}else{X.setEnabledPrevious(true);}O.setMonth(O.getMonth()+P-1);Q=O.getYear();U=O.getMonth();if(Q>S||(Q==S&&U>=V)){X.setEnabledNext(false);}else{X.setEnabledNext(true);}}function t(){var O=this.getAggregation("yearPicker");var P=O.getYears();var Q=d.fromLocalJSDate(O.getFirstRenderedDate());Q.setYear(Q.getYear()+Math.floor(P/2));var S=this.getAggregation("header");var T=new d(this._oMaxDate);T.setYear(T.getYear()-Math.ceil(P/2));T.setMonth(11,31);var U=new d(this._oMinDate);U.setYear(U.getYear()+Math.floor(P/2)+1);U.setMonth(0,1);S.setEnabledNext(!Q.isAfter(T));S.setEnabledPrevious(!Q.isBefore(U));}function u(){var T;var S=l.call(this);var O=this._oYearFormat.format(S.toUTCJSDate(),true);var P=new d(S);P.setMonth(P.getMonth()+this._getMonths()-1);var Q=this._oYearFormat.format(P.toUTCJSDate(),true);if(O!=Q){var U=this._getLocaleData();var V=U.getIntervalPattern();T=V.replace(/\{0\}/,O).replace(/\{1\}/,Q);}else{T=O;}var W=this.getAggregation("header");W.setTextButton2(T);}function v(O,P){var Q;var S=false;if(O.isBefore(this._oMinDate)){Q=this._oMinDate;S=true;}else if(O.isAfter(this._oMaxDate)){Q=this._oMaxDate;S=true;}else{Q=O;}this._setFocusedDate(Q);if(S||P){G.call(this,Q);m.call(this,false);this.fireStartDateChange();}}function w(O,S){if(!O){return;}var P=d.fromLocalJSDate(O);if(this._oFocusedDate&&this._oFocusedDate.isSame(P)){return;}var Q=P.getYear();c._checkYearInValidRange(Q);if(c._isOutside(P,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(P);if(this.getDomRef()&&this._iMode==0){m.call(this,S);}}function x(O){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=1){o.call(this);}else{p.call(this);}}}k.prototype._showCalendarPicker=function(){var O=this._getFocusedDate(true).toLocalJSDate();var P=this._getCalendarPicker();var S=new sap.ui.unified.DateRange({startDate:O});P.displayDate(O,false);P.removeAllSelectedDates();P.addSelectedDate(S);P.setMinDate(this.getMinDate());P.setMaxDate(this.getMaxDate());I.call(this,P);this._showOverlay();};function y(O){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!O){m.call(this);var P=this.getAggregation("monthsRow");q(P._oItemNavigation.getItemDomRefs()[P._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function z(O){this.fireSelect();}function A(O){var P=d.fromLocalJSDate(O.getParameter("date"));var Q=O.getParameter("notVisible");v.call(this,P,Q);}function B(O){var P=new d(this._getFocusedDate());var Q=this._getCalendarPicker();var S=Q.getSelectedDates()[0].getStartDate();var T=d.fromLocalJSDate(S);T.setMonth(P.getMonth());T.setDate(P.getDate());v.call(this,T,true);y.call(this);}function E(O){var P=new d(this._getFocusedDate());var Q=this.getAggregation("yearPicker");var S=d.fromLocalJSDate(Q.getDate());S.setMonth(P.getMonth());S.setDate(P.getDate());P=S;v.call(this,P,true);p.call(this);}function F(){this._sInvalidateContent=undefined;var O=this.getAggregation("monthsRow");O._bDateRangeChanged=true;O._bInvalidateSync=true;O.invalidate();O._bInvalidateSync=undefined;this._bDateRangeChanged=undefined;}function G(O){var P=this.getAggregation("monthsRow");var S=l.call(this);var Q=P._oItemNavigation.getFocusedIndex();S=new d(O);S.setMonth(S.getMonth()-Q);_.call(this,S,false,true);}function I(P){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(J,this);this._oPopup.onsapescape=function(S){this._oCalendar.onsapescape(S);};}this._oPopup.setContent(P);var O=this.getAggregation("header");var Q=sap.ui.core.Popup.Dock;this._oPopup.open(0,Q.CenterTop,Q.CenterTop,O,null,"flipfit",true);}function J(O){y.call(this);}function K(O){t.call(this);}var N=e.extend("CustomYearPicker",{renderer:R.extend(f)});N.prototype._initializeHeader=function(){var O=new H(this.getId()+"--Head",{visibleButton1:false});O.attachEvent("pressPrevious",this._handlePrevious,this);O.attachEvent("pressNext",this._handleNext,this);O.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("header",O);};N.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments);var O=this.getAggregation("header");O.$("B2").css("background-color","inherit").css("color","inherit").css("cursor","inherit").css("pointer-events","none");this._showYearPicker();};N.prototype.onThemeChanged=function(){e.prototype.onThemeChanged.apply(this,arguments);var O=this.getAggregation("header");O.$("B2").css("background-color","inherit").css("color","inherit").css("cursor","inherit").css("pointer-events","none");};N.prototype._selectYear=function(){var O=this.getAggregation("yearPicker");var P=this.getSelectedDates()[0];if(!P){P=new sap.ui.unified.DateRange();}P.setStartDate(O.getDate());this.addSelectedDate(P);this.fireSelect();};N.prototype.onsapescape=function(O){this.fireCancel();};N.prototype._shouldFocusB2OnTabPrevious=function(O){return false;};return k;});
