/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Bar','./Dialog','./InputBase','./List','./Popover','sap/ui/core/Item','./ColumnListItem','./StandardListItem','./DisplayListItem','sap/ui/core/ListItem','./Table','./Toolbar','./ToolbarSpacer','./library','sap/ui/core/IconPool','sap/ui/core/InvisibleText','sap/ui/Device','sap/ui/core/ResizeHandler','sap/ui/core/Control','./InputRenderer',"sap/ui/dom/containsOrEquals","sap/base/assert","sap/base/security/encodeXML","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/selectText"],function(B,D,I,L,P,a,C,S,b,c,T,d,e,l,f,g,h,R,j,k,m,n,o,q){"use strict";var p=l.ListMode;var r=l.PlacementType;var s=l.ListType;var t=l.InputTextFormatMode;var u=l.InputType;var v=I.extend("sap.m.Input",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.InputType",group:"Data",defaultValue:u.Text},maxLength:{type:"int",group:"Behavior",defaultValue:0},dateFormat:{type:"string",group:"Misc",defaultValue:'YYYY-MM-dd',deprecated:true},showValueHelp:{type:"boolean",group:"Behavior",defaultValue:false},showSuggestion:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpOnly:{type:"boolean",group:"Behavior",defaultValue:false},filterSuggests:{type:"boolean",group:"Behavior",defaultValue:true},maxSuggestionWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},startSuggestion:{type:"int",group:"Behavior",defaultValue:1},showTableSuggestionValueHelp:{type:"boolean",group:"Behavior",defaultValue:true},description:{type:"string",group:"Misc",defaultValue:null},fieldWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'50%'},valueLiveUpdate:{type:"boolean",group:"Behavior",defaultValue:false},selectedKey:{type:"string",group:"Data",defaultValue:""},textFormatMode:{type:"sap.m.InputTextFormatMode",group:"Misc",defaultValue:t.Value},textFormatter:{type:"any",group:"Misc",defaultValue:""},suggestionRowValidator:{type:"any",group:"Misc",defaultValue:""},enableSuggestionsHighlighting:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"suggestionItems",aggregations:{suggestionItems:{type:"sap.ui.core.Item",multiple:true,singularName:"suggestionItem"},suggestionColumns:{type:"sap.m.Column",multiple:true,singularName:"suggestionColumn",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"columns"}},suggestionRows:{type:"sap.m.ColumnListItem",multiple:true,singularName:"suggestionRow",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"items"}},_valueHelpIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},selectedRow:{type:"sap.m.ColumnListItem",multiple:false}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},valueHelpRequest:{parameters:{fromSuggestions:{type:"boolean"}}},suggest:{parameters:{suggestValue:{type:"string"},suggestionColumns:{type:"sap.m.ListBase"}}},suggestionItemSelected:{parameters:{selectedItem:{type:"sap.ui.core.Item"},selectedRow:{type:"sap.m.ColumnListItem"}}},submit:{parameters:{value:{type:"string"}}}},designtime:"sap/m/designtime/Input.designtime"}});f.insertFontFaceStyle();v._wordStartsWithValue=function(i,V){var w;while(i){if(typeof V==="string"&&V!==""&&i.toLowerCase().startsWith(V.toLowerCase())){return true;}w=i.indexOf(' ');if(w==-1){break;}i=i.substring(w+1);}return false;};v._DEFAULTFILTER=function(V,i){if(i instanceof c&&v._wordStartsWithValue(i.getAdditionalText(),V)){return true;}return v._wordStartsWithValue(i.getText(),V);};v._DEFAULTFILTER_TABULAR=function(V,w){var x=w.getCells(),i=0;for(;i<x.length;i++){if(x[i].getText){if(v._wordStartsWithValue(x[i].getText(),V)){return true;}}}return false;};v._DEFAULTRESULT_TABULAR=function(w){var x=w.getCells(),i=0;for(;i<x.length;i++){if(x[i].getText){return x[i].getText();}}return"";};v.prototype.init=function(){I.prototype.init.call(this);this._fnFilter=v._DEFAULTFILTER;this._bUseDialog=h.system.phone;this._bFullScreen=h.system.phone;this._iSetCount=0;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");};v.prototype.exit=function(){this._deregisterEvents();this.cancelPendingSuggest();if(this._iRefreshListTimeout){clearTimeout(this._iRefreshListTimeout);this._iRefreshListTimeout=null;}if(this._oSuggestionPopup){this._oSuggestionPopup.destroy();this._oSuggestionPopup=null;}if(this._oList){this._oList.destroy();this._oList=null;}if(this._oSuggestionTable){this._oSuggestionTable.destroy();this._oSuggestionTable=null;}if(this._oButtonToolbar){this._oButtonToolbar.destroy();this._oButtonToolbar=null;}if(this._oShowMoreButton){this._oShowMoreButton.destroy();this._oShowMoreButton=null;}};v.prototype._resizePopup=function(){var i=this;if(this._oList&&this._oSuggestionPopup){if(this.getMaxSuggestionWidth()){this._oSuggestionPopup.setContentWidth(this.getMaxSuggestionWidth());}else{this._oSuggestionPopup.setContentWidth((this.$().outerWidth())+"px");}setTimeout(function(){if(i._oSuggestionPopup&&i._oSuggestionPopup.isOpen()&&i._oSuggestionPopup.$().outerWidth()<i.$().outerWidth()){i._oSuggestionPopup.setContentWidth((i.$().outerWidth())+"px");}},0);}};v.prototype.onBeforeRendering=function(){var i=this.getSelectedKey(),w=this.getShowValueHelp()&&this.getEnabled()&&this.getEditable(),E=this.getAggregation("_endIcon")||[],x=E[0];I.prototype.onBeforeRendering.call(this);this._deregisterEvents();if(i){this.setSelectedKey(i);}if(this.getShowSuggestion()){if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton();}else{this._removeShowMoreButton();}}if(w){x=this._getValueHelpIcon();x.setProperty("visible",true,true);}else{if(x){x.setProperty("visible",false,true);}}};v.prototype.onAfterRendering=function(){I.prototype.onAfterRendering.call(this);if(this._bUseDialog&&this.getEditable()&&this.getEnabled()){this.$().on("click",q.proxy(function(E){if(this._onclick){this._onclick(E);}if(this.getShowSuggestion()&&this._oSuggestionPopup&&E.target.id!=this.getId()+"-vhi"){this._oSuggestionPopup.open();}},this));}};v.prototype._getDisplayText=function(i){var w=this.getTextFormatter();if(w){return w(i);}var x=i.getText(),K=i.getKey(),y=this.getTextFormatMode();switch(y){case t.Key:return K;case t.ValueKey:return x+' ('+K+')';case t.KeyValue:return'('+K+') '+x;default:return x;}};v.prototype._onValueUpdated=function(i){if(this._bSelectingItem||i===this._sSelectedValue){return;}var K=this.getSelectedKey(),H;if(K===''){return;}if(this._hasTabularSuggestions()){H=this._oSuggestionTable&&!!this._oSuggestionTable.getSelectedItem();}else{H=this._oList&&!!this._oList.getSelectedItem();}if(H){return;}this.setProperty("selectedKey",'',true);this.setAssociation("selectedRow",null,true);this.setAssociation("selectedItem",null,true);this.fireSuggestionItemSelected({selectedItem:null,selectedRow:null});};v.prototype._updateSelectionFromList=function(){if(this._iPopupListSelectedIndex<0){return false;}var i=this._oList.getSelectedItem();if(i){if(this._hasTabularSuggestions()){this.setSelectionRow(i,true);}else{this.setSelectionItem(i._oItem,true);}}return true;};v.prototype.setSelectionItem=function(i,w){this._bSelectingItem=true;if(!i){this.setAssociation("selectedItem",null,true);return;}var x=this._iSetCount,N;this.setAssociation("selectedItem",i,true);this.setProperty("selectedKey",i.getKey(),true);if(w){this.fireSuggestionItemSelected({selectedItem:i});}if(x!==this._iSetCount){N=this.getValue();}else{N=this._getDisplayText(i);}this._sSelectedValue=N;this.updateInputField(N);this._iPopupListSelectedIndex=-1;if(!(this._bUseDialog&&this instanceof sap.m.MultiInput&&this._isMultiLineMode)){this._closeSuggestionPopup();}if(!h.support.touch){this._doSelect();}this._bSelectingItem=false;};v.prototype.setSelectedItem=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(i!==null&&!(i instanceof a)){return this;}this.setSelectionItem(i);return this;};v.prototype.setSelectedKey=function(K){K=this.validateProperty("selectedKey",K);this.setProperty("selectedKey",K,true);if(this._hasTabularSuggestions()){return this;}if(!K){this.setSelectionItem();return this;}var i=this.getSuggestionItemByKey(K);this.setSelectionItem(i);return this;};v.prototype.getSuggestionItemByKey=function(K){var w=this.getSuggestionItems()||[],x,i;for(i=0;i<w.length;i++){x=w[i];if(x.getKey()===K){return x;}}};v.prototype.setSelectionRow=function(i,w){if(!i){this.setAssociation("selectedRow",null,true);return;}this._bSelectingItem=true;var x,y=this.getSuggestionRowValidator();if(y){x=y(i);if(!(x instanceof a)){x=null;}}var z=this._iSetCount,K="",N;this.setAssociation("selectedRow",i,true);if(x){K=x.getKey();}this.setProperty("selectedKey",K,true);if(w){this.fireSuggestionItemSelected({selectedRow:i});}if(z!==this._iSetCount){N=this.getValue();}else{if(x){N=this._getDisplayText(x);}else{N=this._fnRowResultFilter?this._fnRowResultFilter(i):v._DEFAULTRESULT_TABULAR(i);}}this._sSelectedValue=N;this.updateInputField(N);this._iPopupListSelectedIndex=-1;if(!(this._bUseDialog&&this instanceof sap.m.MultiInput&&this._isMultiLineMode)){this._closeSuggestionPopup();}if(!h.support.touch){this._doSelect();}this._bSelectingItem=false;};v.prototype.setSelectedRow=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(i!==null&&!(i instanceof C)){return this;}this.setSelectionRow(i);return this;};v.prototype._getValueHelpIcon=function(){var i=this,E=this.getAggregation("_endIcon")||[],V=E[0];if(!V){V=this.addEndIcon({id:this.getId()+"-vhi",src:f.getIconURI("value-help"),useIconTooltip:false,noTabStop:true,press:function(w){if(!i.getValueHelpOnly()){var x=this.getParent(),$;if(h.support.touch){$=x.$('inner');$.attr('readonly','readonly');x.focus();$.removeAttr('readonly');}else{x.focus();}i.bValueHelpRequested=true;i.fireValueHelpRequest({fromSuggestions:false});}}});}return V;};v.prototype._fireValueHelpRequestForValueHelpOnly=function(){if(this.getEnabled()&&this.getEditable()&&this.getShowValueHelp()&&this.getValueHelpOnly()){if(h.system.phone){this.focus();}this.fireValueHelpRequest({fromSuggestions:false});}};v.prototype.ontap=function(E){I.prototype.ontap.call(this,E);this._fireValueHelpRequestForValueHelpOnly();};v.prototype.setWidth=function(w){return I.prototype.setWidth.call(this,w||"100%");};v.prototype.getWidth=function(){return this.getProperty("width")||"100%";};v.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this._fnFilter=v._DEFAULTFILTER;return this;}n(typeof(F)==="function","Input.setFilterFunction: first argument fnFilter must be a function on "+this);this._fnFilter=F;return this;};v.prototype.setRowResultFunction=function(F){var i;if(F===null||F===undefined){this._fnRowResultFilter=v._DEFAULTRESULT_TABULAR;return this;}n(typeof(F)==="function","Input.setRowResultFunction: first argument fnFilter must be a function on "+this);this._fnRowResultFilter=F;i=this.getSelectedRow();if(i){this.setSelectedRow(i);}return this;};v.prototype.closeSuggestions=function(){this._closeSuggestionPopup();};v.prototype._doSelect=function(i,E){if(h.support.touch){return;}var w=this._$input[0];if(w){var $=this._$input;w.focus();$.selectText(i?i:0,E?E:$.val().length);}return this;};v.prototype._scrollToItem=function(i){var w=this._oSuggestionPopup,x=this._oList,y,z,A,E,F;if(!(w instanceof P)||!x){return;}y=w.getScrollDelegate();if(!y){return;}var G=x.getItems()[i],H=G&&G.getDomRef();if(!H){return;}z=w.getDomRef("cont").getBoundingClientRect();A=H.getBoundingClientRect();E=z.top-A.top;F=A.bottom-z.bottom;if(E>0){y.scrollTo(y._scrollX,Math.max(y._scrollY-E,0));}else if(F>0){y.scrollTo(y._scrollX,y._scrollY+F);}};v.prototype._isSuggestionItemSelectable=function(i){return i.getVisible()&&(this._hasTabularSuggestions()||i.getType()!==s.Inactive);};v.prototype._isIncrementalType=function(){var i=this.getType();if(i==="Number"||i==="Date"||i==="Datetime"||i==="Month"||i==="Time"||i==="Week"){return true;}return false;};v.prototype._onsaparrowkey=function(E,i,w){if(!this.getEnabled()||!this.getEditable()){return;}if(i!=="up"&&i!=="down"){return;}if(this._isIncrementalType()){E.setMarked();}if(!this._oSuggestionPopup||!this._oSuggestionPopup.isOpen()){return;}E.preventDefault();E.stopPropagation();var F=false,x=this._oList,y=this.getSuggestionItems(),z=x.getItems(),A=this._iPopupListSelectedIndex,N,O=A;if(i==="up"&&A===0){return;}if(i=="down"&&A===z.length-1){return;}var G;if(w>1){if(i=="down"&&A+w>=z.length){i="up";w=1;z[A].setSelected(false);G=A;A=z.length-1;F=true;}else if(i=="up"&&A-w<0){i="down";w=1;z[A].setSelected(false);G=A;A=0;F=true;}}if(A===-1){A=0;if(this._isSuggestionItemSelectable(z[A])){O=A;F=true;}else{i="down";}}if(i==="down"){while(A<z.length-1&&(!F||!this._isSuggestionItemSelectable(z[A]))){z[A].setSelected(false);A=A+w;F=true;w=1;if(G===A){break;}}}else{while(A>0&&(!F||!z[A].getVisible()||!this._isSuggestionItemSelectable(z[A]))){z[A].setSelected(false);A=A-w;F=true;w=1;if(G===A){break;}}}if(!this._isSuggestionItemSelectable(z[A])){if(O>=0){z[O].setSelected(true).updateAccessibilityState();this.$("inner").attr("aria-activedescendant",z[O].getId());}return;}else{z[A].setSelected(true).updateAccessibilityState();this.$("inner").attr("aria-activedescendant",z[A].getId());}if(h.system.desktop){this._scrollToItem(A);}if(C&&z[A]instanceof C){N=this._getInputValue(this._fnRowResultFilter(z[A]));}else{var H=(y[0]instanceof c?true:false);if(H){N=this._getInputValue(z[A].getLabel());}else{N=this._getInputValue(z[A].getTitle());}}this.setDOMValue(N);this._sSelectedSuggViaKeyboard=N;this._doSelect();this._iPopupListSelectedIndex=A;};v.prototype.onsapup=function(E){this._onsaparrowkey(E,"up",1);};v.prototype.onsapdown=function(E){this._onsaparrowkey(E,"down",1);};v.prototype.onsappageup=function(E){this._onsaparrowkey(E,"up",5);};v.prototype.onsappagedown=function(E){this._onsaparrowkey(E,"down",5);};v.prototype.onsaphome=function(E){if(this._oList){this._onsaparrowkey(E,"up",this._oList.getItems().length);}};v.prototype.onsapend=function(E){if(this._oList){this._onsaparrowkey(E,"down",this._oList.getItems().length);}};v.prototype.onsapescape=function(E){var i;if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){E.originalEvent._sapui_handledByControl=true;this._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();if(this._sBeforeSuggest!==undefined){if(this._sBeforeSuggest!==this.getValue()){i=this._lastValue;this.setValue(this._sBeforeSuggest);this._lastValue=i;}this._sBeforeSuggest=undefined;}return;}if(this.getValueLiveUpdate()){this.setProperty("value",this._lastValue,true);}if(I.prototype.onsapescape){I.prototype.onsapescape.apply(this,arguments);}};v.prototype.onsapenter=function(E){this.cancelPendingSuggest();if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){if(!this._updateSelectionFromList()){this._closeSuggestionPopup();}}if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}if(this.getEnabled()&&this.getEditable()&&!(this.getValueHelpOnly()&&this.getShowValueHelp())){this.fireSubmit({value:this.getValue()});}};v.prototype.onsapfocusleave=function(E){var i=this._oSuggestionPopup;if(i instanceof P){if(E.relatedControlId&&m(i.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this._bPopupHasFocus=true;this.focus();}else{if(this.getDOMValue()===this._sSelectedSuggViaKeyboard){this._sSelectedSuggViaKeyboard=null;}}}var F=sap.ui.getCore().byId(E.relatedControlId);if(!(i&&F&&m(i.getDomRef(),F.getFocusDomRef()))){I.prototype.onsapfocusleave.apply(this,arguments);}this.bValueHelpRequested=false;};v.prototype.onmousedown=function(E){var i=this._oSuggestionPopup;if((i instanceof P)&&i.isOpen()){E.stopPropagation();}};v.prototype._registerResize=function(){if(!this._bFullScreen){this._sPopupResizeHandler=R.register(this,this._resizePopup.bind(this));}};v.prototype._deregisterResize=function(){if(this._sPopupResizeHandler){this._sPopupResizeHandler=R.deregister(this._sPopupResizeHandler);}};v.prototype._deregisterEvents=function(){this._deregisterResize();if(this._bUseDialog&&this._oSuggestionPopup){this.$().off("click");}};v.prototype.updateSuggestionItems=function(){this._bSuspendInvalidate=true;this.updateAggregation("suggestionItems");this._synchronizeSuggestions();this._bSuspendInvalidate=false;return this;};v.prototype.invalidate=function(){if(!this._bSuspendInvalidate){j.prototype.invalidate.apply(this,arguments);}};v.prototype.cancelPendingSuggest=function(){if(this._iSuggestDelay){clearTimeout(this._iSuggestDelay);this._iSuggestDelay=null;}};v.prototype._triggerSuggest=function(V){this.cancelPendingSuggest();this._bShouldRefreshListItems=true;if(!V){V="";}if(V.length>=this.getStartSuggestion()){this._iSuggestDelay=setTimeout(function(){if(this._sPrevSuggValue!==V){this._bBindingUpdated=false;this.fireSuggest({suggestValue:V});if(!this._bBindingUpdated){this._refreshItemsDelayed();}this._sPrevSuggValue=V;}}.bind(this),300);}else if(this._bUseDialog){if(this._oList instanceof T){this._oList.addStyleClass("sapMInputSuggestionTableHidden");}else if(this._oList&&this._oList.destroyItems){this._oList.destroyItems();}}else if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){setTimeout(function(){var N=this.getDOMValue()||'';if(N<this.getStartSuggestion()){this._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();}}.bind(this),0);}};(function(){v.prototype.setShowSuggestion=function(V){this.setProperty("showSuggestion",V,true);this._iPopupListSelectedIndex=-1;if(V){this._lazyInitializeSuggestionPopup(this);}else{y(this);}return this;};v.prototype.setShowTableSuggestionValueHelp=function(V){this.setProperty("showTableSuggestionValueHelp",V,true);if(!this._oSuggestionPopup){return this;}if(V){this._addShowMoreButton();}else{this._removeShowMoreButton();}return this;};v.prototype._getShowMoreButton=function(){var i=this,M=this._oRb;return this._oShowMoreButton||(this._oShowMoreButton=new sap.m.Button({text:M.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:function(){if(i.getShowTableSuggestionValueHelp()){i.fireValueHelpRequest({fromSuggestions:true});i._iPopupListSelectedIndex=-1;i._closeSuggestionPopup();}}}));};v.prototype._getButtonToolbar=function(){var i=this._getShowMoreButton();return this._oButtonToolbar||(this._oButtonToolbar=new d({content:[new e(),i]}));};v.prototype._addShowMoreButton=function(i){if(!this._oSuggestionPopup||!i&&!this._hasTabularSuggestions()){return;}if(this._oSuggestionPopup instanceof D){var E=this._getShowMoreButton();this._oSuggestionPopup.setEndButton(E);}else{var F=this._getButtonToolbar();this._oSuggestionPopup.setFooter(F);}};v.prototype._removeShowMoreButton=function(){if(!this._oSuggestionPopup||!this._hasTabularSuggestions()){return;}if(this._oSuggestionPopup instanceof D){this._oSuggestionPopup.setEndButton(null);}else{this._oSuggestionPopup.setFooter(null);}};v.prototype.oninput=function(E){I.prototype.oninput.call(this,E);if(E.isMarked("invalid")){return;}var i=this.getDOMValue();if(this.getValueLiveUpdate()){this.setProperty("value",i,true);this._onValueUpdated(i);}this.fireLiveChange({value:i,newValue:i});if(this.getShowSuggestion()&&!this._bUseDialog){this._triggerSuggest(i);}};v.prototype.getValue=function(){return this.getDomRef("inner")&&this._$input?this.getDOMValue():this.getProperty("value");};v.prototype._refreshItemsDelayed=function(){clearTimeout(this._iRefreshListTimeout);this._iRefreshListTimeout=setTimeout(A.bind(this,this),0);};v.prototype.addSuggestionItem=function(i){this.addAggregation("suggestionItems",i,true);this._synchronizeSuggestions();x(this);return this;};v.prototype.insertSuggestionItem=function(i,E){this.insertAggregation("suggestionItems",E,i,true);this._synchronizeSuggestions();x(this);return this;};v.prototype.removeSuggestionItem=function(i){var E=this.removeAggregation("suggestionItems",i,true);this._synchronizeSuggestions();return E;};v.prototype.removeAllSuggestionItems=function(){var i=this.removeAllAggregation("suggestionItems",true);this._synchronizeSuggestions();return i;};v.prototype.destroySuggestionItems=function(){this.destroyAggregation("suggestionItems",true);this._synchronizeSuggestions();return this;};v.prototype.addSuggestionRow=function(i){i.setType(s.Active);this.addAggregation("suggestionRows",i);this._synchronizeSuggestions();x(this);return this;};v.prototype.insertSuggestionRow=function(i,E){i.setType(s.Active);this.insertAggregation("suggestionRows",i,E);this._synchronizeSuggestions();x(this);return this;};v.prototype.removeSuggestionRow=function(i){var E=this.removeAggregation("suggestionRows",i);this._synchronizeSuggestions();return E;};v.prototype.removeAllSuggestionRows=function(){var i=this.removeAllAggregation("suggestionRows");this._synchronizeSuggestions();return i;};v.prototype.destroySuggestionRows=function(){this.destroyAggregation("suggestionRows");this._synchronizeSuggestions();return this;};v.prototype.bindAggregation=function(){if(arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns"||arguments[0]==="suggestionItems"){x(this,arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns");this._bBindingUpdated=true;}return I.prototype.bindAggregation.apply(this,arguments);};v.prototype._lazyInitializeSuggestionPopup=function(){if(!this._oSuggestionPopup){w(this);}};v.prototype._closeSuggestionPopup=function(){if(this._oSuggestionPopup){this._bShouldRefreshListItems=false;this.cancelPendingSuggest();this._oSuggestionPopup.close();if(!this._bUseDialog&&this.$().hasClass("sapMInputFocused")){this.openValueStateMessage();}this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-haspopup");this.$("inner").removeAttr("aria-activedescendant");this._sPrevSuggValue=null;}};v.prototype._synchronizeSuggestions=function(){this._bShouldRefreshListItems=true;this._refreshItemsDelayed();if(!this.getDomRef()||(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen())){return;}this._synchronizeSelection();};v.prototype._synchronizeSelection=function(){var i=this.getSelectedKey();if(!i){return;}if(this.getValue()&&!this.getSelectedItem()&&!this.getSelectedRow()){return;}this.setSelectedKey(i);};function w(i){var M=i._oRb;if(i._bUseDialog){i._oPopupInput=new v(i.getId()+"-popup-input",{width:"100%",valueLiveUpdate:true,showValueHelp:i.getShowValueHelp(),valueHelpRequest:function(E){i.fireValueHelpRequest({fromSuggestions:true});i._iPopupListSelectedIndex=-1;i._closeSuggestionPopup();},liveChange:function(E){var V=E.getParameter("newValue");i.setDOMValue(i._getInputValue(i._oPopupInput.getValue()));i._triggerSuggest(V);i.fireLiveChange({value:V,newValue:V});}}).addStyleClass("sapMInputSuggInDialog");}i._oSuggestionPopup=!i._bUseDialog?(new P(i.getId()+"-popup",{showArrow:false,showHeader:false,placement:r.Vertical,initialFocus:i,horizontalScrolling:true}).attachAfterClose(function(){i._updateSelectionFromList();if(i._oList instanceof T){i._oList.removeSelections(true);}else{i._oList.destroyItems();}i._deregisterResize();}).attachBeforeOpen(function(){i._sBeforeSuggest=i.getValue();i._resizePopup();i._registerResize();})):(new D(i.getId()+"-popup",{beginButton:new sap.m.Button(i.getId()+"-popup-closeButton",{text:M.getText("MSGBOX_CLOSE"),press:function(){i._closeSuggestionPopup();}}),stretch:i._bFullScreen,contentHeight:i._bFullScreen?undefined:"20rem",customHeader:new B(i.getId()+"-popup-header",{contentMiddle:i._oPopupInput.addEventDelegate({onsapenter:function(){if(!(sap.m.MultiInput&&i instanceof sap.m.MultiInput)){i._closeSuggestionPopup();}}},this)}),horizontalScrolling:false,initialFocus:i._oPopupInput}).attachBeforeOpen(function(){i._oPopupInput.setPlaceholder(i.getPlaceholder());i._oPopupInput.setMaxLength(i.getMaxLength());}).attachBeforeClose(function(){i.setDOMValue(i._getInputValue(i._oPopupInput.getValue()));i.onChange();if(i instanceof sap.m.MultiInput&&i._bUseDialog){i._onDialogClose();}}).attachAfterClose(function(){if(i._oList){if(T&&!(i._oList instanceof T)){i._oList.destroyItems();}else{i._oList.removeSelections(true);}}}).attachAfterOpen(function(){var V=i.getValue();i._oPopupInput.setValue(V);i._triggerSuggest(V);A(i);}));i._oSuggestionPopup.addStyleClass("sapMInputSuggestionPopup");i._oSuggestionPopup.addAriaLabelledBy(g.getStaticId("sap.m","INPUT_AVALIABLE_VALUES"));i.addDependent(i._oSuggestionPopup);if(!i._bUseDialog){z(i._oSuggestionPopup,i);}if(i._oList){i._oSuggestionPopup.addContent(i._oList);}if(i.getShowTableSuggestionValueHelp()){i._addShowMoreButton();}}function x(i,E){if(i._bIsBeingDestroyed||i._oList){return;}if(!i._hasTabularSuggestions()&&!E){i._oList=new L(i.getId()+"-popup-list",{showNoData:false,mode:p.SingleSelectMaster,rememberSelections:false,itemPress:function(H){var J=H.getParameter("listItem");i.setSelectionItem(J._oItem,true);}});i._oList.addEventDelegate({onAfterRendering:i._highlightListText.bind(i)});}else{if(i._fnFilter===v._DEFAULTFILTER){i._fnFilter=v._DEFAULTFILTER_TABULAR;}if(!i._fnRowResultFilter){i._fnRowResultFilter=v._DEFAULTRESULT_TABULAR;}i._oList=i._getSuggestionsTable();if(i.getShowTableSuggestionValueHelp()){i._addShowMoreButton(E);}}if(i._oSuggestionPopup){if(i._bUseDialog){i._oSuggestionPopup.addAggregation("content",i._oList,true);var F=i._oSuggestionPopup.$("scrollCont")[0];if(F){var G=sap.ui.getCore().createRenderManager();G.renderControl(i._oList);G.flush(F);G.destroy();}}else{i._oSuggestionPopup.addContent(i._oList);}}}function y(i){if(i._oSuggestionPopup){if(i._oList instanceof T){i._oSuggestionPopup.removeAllContent();i._removeShowMoreButton();}i._oSuggestionPopup.destroy();i._oSuggestionPopup=null;}if(i._oList instanceof L){i._oList.destroy();i._oList=null;}}function z(i,E){i.open=function(){this.openBy(E,false,true);};i.oPopup.setAnimations(function($,F,O){O();},function($,F,G){G();});}function A(E){var F=E.getShowSuggestion();var G=E._oRb;E._iPopupListSelectedIndex=-1;if(!F||!E._bShouldRefreshListItems||!E.getDomRef()||(!E._bUseDialog&&!E.$().hasClass("sapMInputFocused"))){return false;}var H,J=E.getSuggestionItems(),K=E.getSuggestionRows(),M=E.getDOMValue()||"",N=E._oList,O=E.getFilterSuggests(),Q=[],U=0,V=E._oSuggestionPopup,W={ontouchstart:function($){($.originalEvent||$)._sapui_cancelAutoClose=true;}},X,i;if(E._oList){if(E._oList instanceof T){N.removeSelections(true);}else{N.destroyItems();}}if(M.length<E.getStartSuggestion()){if(!E._bUseDialog){E._iPopupListSelectedIndex=-1;this.cancelPendingSuggest();V.close();}else{if(E._hasTabularSuggestions()&&E._oList){E._oList.addStyleClass("sapMInputSuggestionTableHidden");}}E.$("SuggDescr").text("");E.$("inner").removeAttr("aria-haspopup");E.$("inner").removeAttr("aria-activedescendant");return false;}if(E._hasTabularSuggestions()){if(E._bUseDialog&&E._oList){E._oList.removeStyleClass("sapMInputSuggestionTableHidden");}for(i=0;i<K.length;i++){if(!O||E._fnFilter(M,K[i])){K[i].setVisible(true);Q.push(K[i]);}else{K[i].setVisible(false);}}E._oSuggestionTable.invalidate();}else{var Y=(J[0]instanceof c?true:false);for(i=0;i<J.length;i++){H=J[i];if(!O||E._fnFilter(M,H)){if(Y){X=new b(H.getId()+"-dli");X.setLabel(H.getText());X.setValue(H.getAdditionalText());}else{X=new S(H.getId()+"-sli");X.setTitle(H.getText());}X.setType(H.getEnabled()?s.Active:s.Inactive);X._oItem=H;X.addEventDelegate(W);Q.push(X);}}}U=Q.length;var Z="";if(U>0){if(U==1){Z=G.getText("INPUT_SUGGESTIONS_ONE_HIT");}else{Z=G.getText("INPUT_SUGGESTIONS_MORE_HITS",U);}E.$("inner").attr("aria-haspopup","true");if(!E._hasTabularSuggestions()){for(i=0;i<U;i++){N.addItem(Q[i]);}}if(!E._bUseDialog){if(E._sCloseTimer){clearTimeout(E._sCloseTimer);E._sCloseTimer=null;}if(!V.isOpen()&&!E._sOpenTimer&&(this.getValue().length>=this.getStartSuggestion())){E._sOpenTimer=setTimeout(function(){E._sOpenTimer=null;V.open();},0);}}}else{Z=G.getText("INPUT_SUGGESTIONS_NO_HIT");E.$("inner").removeAttr("aria-haspopup");E.$("inner").removeAttr("aria-activedescendant");if(!E._bUseDialog){if(V.isOpen()){E._sCloseTimer=setTimeout(function(){E._iPopupListSelectedIndex=-1;E.cancelPendingSuggest();V.close();},0);}}else{if(E._hasTabularSuggestions()&&E._oList){E._oList.addStyleClass("sapMInputSuggestionTableHidden");}}}E.$("SuggDescr").text(Z);}})();v.prototype._createHighlightedText=function(i){var w=i.innerText,x=this.getValue().toLowerCase(),y=x.length,z=w.toLowerCase(),A,E='';if(!v._wordStartsWithValue(w,x)){return o(w);}var F=z.indexOf(x);if(F>0){F=z.indexOf(' '+x)+1;}if(F>-1){E+=o(w.substring(0,F));A=w.substring(F,F+y);E+='<span class="sapMInputHighlight">'+o(A)+'</span>';E+=o(w.substring(F+y));}else{E=o(w);}return E;};v.prototype._highlightListText=function(){if(!this.getEnableSuggestionsHighlighting()){return;}var i,w,x=this._oList.$().find('.sapMDLILabel, .sapMSLITitleOnly, .sapMDLIValue');for(i=0;i<x.length;i++){w=x[i];w.innerHTML=this._createHighlightedText(w);}};v.prototype._highlightTableText=function(){if(!this.getEnableSuggestionsHighlighting()){return;}var i,w,x=this._oSuggestionTable.$().find('tbody .sapMLabel');for(i=0;i<x.length;i++){w=x[i];w.innerHTML=this._createHighlightedText(w);}};v.prototype.onfocusin=function(E){I.prototype.onfocusin.apply(this,arguments);this.$().addClass("sapMInputFocused");if(!this._bUseDialog&&this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){this.closeValueStateMessage();}if(!this._bPopupHasFocus&&!this.getStartSuggestion()&&!this.getValue()){this._triggerSuggest(this.getValue());}this._bPopupHasFocus=undefined;this._sPrevSuggValue=null;};v.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()||!this.getShowValueHelp()){return;}this.bValueHelpRequested=true;this.fireValueHelpRequest({fromSuggestions:false});E.preventDefault();E.stopPropagation();};v.prototype.onsaphide=v.prototype.onsapshow;v.prototype.onsapselect=function(E){this._fireValueHelpRequestForValueHelpOnly();};v.prototype.onfocusout=function(E){I.prototype.onfocusout.apply(this,arguments);this.$().removeClass("sapMInputFocused");this.closeValueStateMessage(this);};v.prototype._hasTabularSuggestions=function(){return!!(this.getAggregation("suggestionColumns")&&this.getAggregation("suggestionColumns").length);};v.prototype._getSuggestionsTable=function(){if(this._bIsBeingDestroyed){return;}var i=this;if(!this._oSuggestionTable){this._oSuggestionTable=new T(this.getId()+"-popup-table",{mode:p.SingleSelectMaster,showNoData:false,showSeparators:"All",width:"100%",enableBusyIndicator:false,rememberSelections:false,selectionChange:function(E){var w=E.getParameter("listItem");i.setSelectionRow(w,true);}});this._oSuggestionTable.addEventDelegate({onAfterRendering:this._highlightTableText.bind(this)});if(this._bUseDialog){this._oSuggestionTable.addStyleClass("sapMInputSuggestionTableHidden");}this._oSuggestionTable.updateItems=function(){T.prototype.updateItems.apply(this,arguments);i._refreshItemsDelayed();return this;};}return this._oSuggestionTable;};v.prototype._fireSuggestionItemSelectedEvent=function(){if(this._iPopupListSelectedIndex>=0){var i=this._oList.getItems()[this._iPopupListSelectedIndex];if(i){if(C&&i instanceof C){this.fireSuggestionItemSelected({selectedRow:i});}else{this.fireSuggestionItemSelected({selectedItem:i._oItem});}}this._iPopupListSelectedIndex=-1;}};v.prototype.clone=function(){var i=j.prototype.clone.apply(this,arguments),w;w=this.getBindingInfo("suggestionColumns");if(w){i.bindAggregation("suggestionColumns",q.extend({},w));}else{this.getSuggestionColumns().forEach(function(x){i.addSuggestionColumn(x.clone(),true);});}w=this.getBindingInfo("suggestionRows");if(w){i.bindAggregation("suggestionRows",q.extend({},w));}else{this.getSuggestionRows().forEach(function(x){i.addSuggestionRow(x.clone(),true);});}i.setRowResultFunction(this._fnRowResultFilter);return i;};v.prototype.setValue=function(V){this._iSetCount++;I.prototype.setValue.call(this,V);this._onValueUpdated(V);return this;};v.prototype.setDOMValue=function(i){this._$input.val(i);};v.prototype.getDOMValue=function(){return this._$input.val();};v.prototype.updateInputField=function(N){if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()&&this._bUseDialog){this._oPopupInput.setValue(N);this._oPopupInput._doSelect();}else{N=this._getInputValue(N);this.setDOMValue(N);this.onChange(null,null,N);}};v.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.description=((i.description||"")+" "+this.getDescription()).trim();return i;};v.prototype.preventChangeOnFocusLeave=function(E){return this.bFocusoutDueRendering||this.bValueHelpRequested;};return v;});
