/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/ValueStateSupport','sap/ui/core/library','./ProgressIndicatorRenderer',"sap/base/Log"],function(l,C,V,c,P,L){"use strict";var T=c.TextDirection;var a=c.ValueState;var b=C.extend("sap.m.ProgressIndicator",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},state:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:a.None},displayValue:{type:"string",group:"Appearance",defaultValue:null},percentValue:{type:"float",group:"Data",defaultValue:0},showValue:{type:"boolean",group:"Appearance",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit},displayOnly:{type:"boolean",group:"Behavior",defaultValue:false}},designtime:"sap/m/designtime/ProgressIndicator.designtime"}});var u=sap.ui.getCore().getConfiguration().getAnimation();b.prototype.setPercentValue=function(p){var t=this,$,f,d=this.$(),A,n;p=this.validateProperty("percentValue",p);if(!i(p)){n=p;p=p>100?100:0;L.warning(this+": percentValue ("+n+") is not correct! Setting the percentValue to "+p);}if(this.getPercentValue()!==p){f=this.getPercentValue()-p;this.setProperty("percentValue",p,true);if(!d.length){return this;}["sapMPIValueMax","sapMPIValueMin","sapMPIValueNormal","sapMPIValueGreaterHalf"].forEach(function(s){d.removeClass(s);});d.addClass(this._getCSSClassByPercentValue(p));d.addClass("sapMPIAnimate").attr("aria-valuenow",p).attr("aria-valuetext",this._getAriaValueText({fPercent:p}));A=u?Math.abs(f)*20:0;$=this.$("bar");$.stop();$.animate({"flex-basis":p+"%"},A,"linear",function(){t._setText.apply(t);t.$().removeClass("sapMPIAnimate");});}return this;};b.prototype._setText=function(){this.$().toggleClass("sapMPIValueGreaterHalf",this.getPercentValue()>50);return this;};b.prototype.setDisplayValue=function(d){this.setProperty("displayValue",d,true);var $=this.$("textLeft");var e=this.$("textRight");$.text(d);e.text(d);this.$().attr("aria-valuetext",this._getAriaValueText({sText:d}));return this;};b.prototype.setDisplayOnly=function(d){this.setProperty("displayOnly",d,true);if(this.getDomRef()){this.$().toggleClass("sapMPIDisplayOnly",d);}return this;};b.prototype._getCSSClassByPercentValue=function(p){if(p===100){return"sapMPIValueMax sapMPIValueGreaterHalf";}if(p===0){return"sapMPIValueMin";}if(p<=50){return"sapMPIValueNormal";}return"sapMPIValueNormal sapMPIValueGreaterHalf";};b.prototype._getAriaValueText=function(p){p.sText=p.sText||this.getDisplayValue();p.fPercent=p.fPercent||this.getPercentValue();p.sStateText=p.sStateText||this._getStateText();var A=p.sText||p.fPercent+"%";if(p.sStateText){A+=" "+p.sStateText;}return A;};b.prototype._getStateText=function(){return V.getAdditionalText(this.getState());};b.prototype.getAccessibilityInfo=function(){var B=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{role:"progressbar",type:B.getText("ACC_CTR_TYPE_PROGRESS"),description:B.getText("ACC_CTR_STATE_PROGRESS",[this.getPercentValue()]),focusable:this.getEnabled(),enabled:this.getEnabled()};};function i(v){return v>=0&&v<=100;}return b;});
