/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","./WizardStepRenderer","./Button","./TitlePropagationSupport","sap/base/Log"],function(l,C,W,B,T,L){"use strict";var a=C.extend("sap.m.WizardStep",{metadata:{properties:{title:{type:"string",group:"appearance",defaultValue:""},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},validated:{type:"boolean",group:"Behavior",defaultValue:true},optional:{type:"boolean",group:"Appearance",defaultValue:false}},events:{complete:{parameters:{}},activate:{parameters:{}}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},_nextButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{subsequentSteps:{type:"sap.m.WizardStep",multiple:true,singularName:"subsequentStep"},nextStep:{type:"sap.m.WizardStep",multiple:false}}}});T.call(a.prototype,"content",function(){return this.getId()+"-title";});a.prototype.init=function(){this._resourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oNextButton=new B({text:this._resourceBundle.getText("WIZARD_STEP")+2,type:"Emphasized",enabled:this.getValidated(),press:this._handleNextButtonPress.bind(this)}).addStyleClass("sapMWizardNextButton");this._oNextButton.addEventDelegate({onAfterRendering:function(){setTimeout(function(){var b=this._oNextButton,o=b.getDomRef();if(b.getEnabled()){b.addStyleClass("sapMWizardNextButtonVisible");o&&o.removeAttribute("aria-hidden");}else{b.removeStyleClass("sapMWizardNextButtonVisible");o&&o.setAttribute("aria-hidden",true);}}.bind(this),0);}},this);this.setAggregation("_nextButton",this._oNextButton);this._initTitlePropagationSupport();};a.prototype.onBeforeRendering=function(){var v=this._getWizardParent()?this._getWizardParent().getShowNextButton():true;this._oNextButton.setProperty("visible",v,true);};a.prototype._handleNextButtonPress=function(){};a.prototype.setValidated=function(v){this.setProperty("validated",v,true);var p=this._getWizardParent();if(p===null){return this;}if(v){p.validateStep(this);}else{p.invalidateStep(this);}return this;};a.prototype.setNextStep=function(v){this.setAssociation("nextStep",v,true);var p=this._getWizardParent();if(p!==null){p._checkCircularReference(this._getNextStepReference());p._updateProgressNavigator();}return this;};a.prototype.setVisible=function(v){this.setProperty("visible",v,true);L.warning("Don't use the set visible method for wizard steps. If you need to show/hide steps based on some condition - use the branching property of the Wizard instead.");return this;};a.prototype._isLeaf=function(){if(this.getNextStep()===null&&this.getSubsequentSteps().length===0){return true;}return false;};a.prototype._isBranched=function(){return this.getSubsequentSteps().length>1;};a.prototype._getNextStepReference=function(){if(this.getNextStep()!==null){return sap.ui.getCore().byId(this.getNextStep());}if(this.getSubsequentSteps().length===1){return sap.ui.getCore().byId(this.getSubsequentSteps()[0]);}return null;};a.prototype._containsSubsequentStep=function(s){return this.getSubsequentSteps().some(function(b){return b===s;});};a.prototype._getWizardParent=function(){var p=this.getParent();while(!(p instanceof sap.m.Wizard)){if(p===null){return null;}p=p.getParent();}return p;};a.prototype._markAsLast=function(){this.addStyleClass("sapMWizardLastActivatedStep");};a.prototype._unMarkAsLast=function(){this.removeStyleClass("sapMWizardLastActivatedStep");};a.prototype._activate=function(){if(this.hasStyleClass("sapMWizardStepActivated")){return;}this._markAsLast();this.addStyleClass("sapMWizardStepActivated");this.fireActivate();};a.prototype._deactivate=function(){this.removeStyleClass("sapMWizardStepActivated");};a.prototype._complete=function(){this._unMarkAsLast();this.fireComplete();};return a;});
