/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/format/NumberFormat','sap/ui/model/CompositeType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/ui/core/LocaleData',"sap/base/strings/hash","sap/ui/thirdparty/jquery"],function(N,C,F,P,V,L,h,q){"use strict";var U=C.extend("sap.ui.model.type.Unit",{constructor:function(f,c,d){C.apply(this,arguments);this.sName="Unit";this.bUseRawValues=true;this.aDynamicFormatOptionNames=d;}});U.prototype._createInstance=function(f){if(this.oFormatOptions){f=q.extend({},this.oFormatOptions,f);}return N.getUnitInstance(f);};U.prototype._getInstance=function(a,u){var f=this.createFormatOptions(a);if(u){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var o=L.getInstance(l);var s=o.getUnitFromMapping(u)||u;var m=o.getUnitFormat(s);if(m){var b=q.extend({},m);b.decimals=(f.decimals!=undefined)?f.decimals:b.decimals;b.precision=(f.precision!=undefined)?f.precision:b.precision;f.customUnits={};f.customUnits[u]=b;}}if(this.getMetadata().getClass()!==U){var M=this.getMetadata();M._mTypeInstanceCache=M._mTypeInstanceCache||{};var H=h(JSON.stringify(f)||"");var c=M._mTypeInstanceCache[H];if(!c){c=this._createInstance(f);M._mTypeInstanceCache[H]=c;}return c;}else{return this._createInstance(f);}};U.prototype._clearInstances=function(){if(this.getMetadata().getClass()!==U){var m=this.getMetadata();if(m._mTypeInstanceCache){m._mTypeInstanceCache={};}}};U.prototype.createFormatOptions=function(v){var f={};if(this.aDynamicFormatOptionNames&&v.length>=this.aDynamicFormatOptionNames.length){this.aDynamicFormatOptionNames.forEach(function(d,i){if(d){f[d]=v[i];}});}return f;};U.prototype.extractArguments=function(v){return Array.isArray(v)&&v.length>2?v.slice(2):[];};U.prototype.formatValue=function(v,i){var a=v;if(v==undefined||v==null){return null;}if(this.oInputFormat){a=this.oInputFormat.parse(v);}if(!Array.isArray(a)){throw new F("Cannot format Unit: "+v+" has the wrong format");}if(a[0]==undefined||a[0]==null){return null;}switch(this.getPrimitiveType(i)){case"string":this.aDynamicValues=this.extractArguments(a);this.oOutputFormat=this._getInstance(this.aDynamicValues,a[1]);return this.oOutputFormat.format(a);case"int":case"float":case"any":default:throw new F("Don't know how to format Unit to "+i);}};U.prototype.parseValue=function(v,i){var r,b;switch(this.getPrimitiveType(i)){case"string":this.oOutputFormat=this.oOutputFormat||this._getInstance();r=this.oOutputFormat.parse(v);if(!Array.isArray(r)){b=sap.ui.getCore().getLibraryResourceBundle();throw new P(b.getText("Unit.Invalid",[v]));}break;case"int":case"float":default:throw new P("Don't know how to parse Unit from "+i);}if(this.oInputFormat){r=this.oInputFormat.format(r);}return r;};U.prototype.validateValue=function(v){if(this.oConstraints){var b=sap.ui.getCore().getLibraryResourceBundle(),a=[],m=[],c=v,i;if(this.oInputFormat){c=this.oInputFormat.parse(v);}i=c[0];q.each(this.oConstraints,function(n,o){switch(n){case"minimum":if(i<o){a.push("minimum");m.push(b.getText("Unit.Minimum",[o]));}break;case"maximum":if(i>o){a.push("maximum");m.push(b.getText("Unit.Maximum",[o]));}break;case"decimals":var t=N._shiftDecimalPoint(i,o);if(Math.floor(t)!==t){a.push("decimals");m.push(b.getText("Unit.Decimals",[o]));}break;}});if(a.length>0){throw new V(m.join(" "),a);}}};U.prototype.setFormatOptions=function(f){this.oFormatOptions=f;this._clearInstances();this._createInputFormat();};U.prototype._handleLocalizationChange=function(){this._clearInstances();this._createInputFormat();};U.prototype._createInputFormat=function(){var s=this.oFormatOptions.source;if(s){if(q.isEmptyObject(s)){s={groupingEnabled:false,groupingSeparator:",",decimalSeparator:"."};}this.oInputFormat=N.getUnitInstance(s);}};return U;});
