/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/TimesRow','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library','sap/ui/core/format/DateFormat','sap/ui/Device','sap/ui/core/Locale','sap/ui/core/library',"./CalendarTimeIntervalRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,L,a,H,T,D,M,Y,U,l,b,c,d,e,f,g,h,i,q){"use strict";var j=e.CalendarType;var k=C.extend("sap.ui.unified.CalendarTimeInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},timesRow:{type:"sap.ui.unified.calendar.TimesRow",multiple:false,visibility:"hidden"},datesRow:{type:"sap.ui.unified.calendar.Month",multiple:false,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});k.prototype.init=function(){this._iMode=0;this._oYearFormat=b.getDateInstance({format:"y"});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new U(new Date(Date.UTC(1,0,1)));this._oMinDate.getJSDate().setUTCFullYear(1);this._oMaxDate=new U(new Date(Date.UTC(9999,11,31,23,59,59)));this._initializeHeader();this._initializeTimesRow();this._initilizeMonthPicker();this._initilizeYearPicker();this.setPickerPopup(false);this._iItemsHead=15;};k.prototype._initializeHeader=function(){var c1=new H(this.getId()+"--Head");c1.attachEvent("pressPrevious",this._handlePrevious,this);c1.attachEvent("pressNext",this._handleNext,this);this.setAggregation("header",c1);};k.prototype._initializeTimesRow=function(){var c1=new T(this.getId()+"--TimesRow");c1.attachEvent("focus",K,this);c1.attachEvent("select",J,this);c1._bNoThemeChange=true;this.setAggregation("timesRow",c1);};k.prototype._initilizeMonthPicker=function(){this.setAggregation("monthPicker",this._createMonthPicker());};k.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};k.prototype._createDatesRow=function(){var c1=new D(this.getId()+"--DatesRow",{days:18,selectedDates:[new sap.ui.unified.DateRange(this.getId()+"--Range")]});c1.attachEvent("focus",P,this);c1.attachEvent("select",O,this);c1._bNoThemeChange=true;c1.getIntervalSelection=function(){return this.getProperty("intervalSelection");};c1.getSingleSelection=function(){return this.getProperty("singleSelection");};c1.getSelectedDates=function(){return this.getAggregation("selectedDates",[]);};c1.getSpecialDates=function(){return this.getAggregation("specialDates",[]);};c1.getAriaLabelledBy=function(){return this.getAssociation("ariaLabelledBy",[]);};return c1;};k.prototype._createMonthPicker=function(){var c1=new M(this.getId()+"--MP",{columns:0,months:6});c1.attachEvent("select",Q,this);c1._bNoThemeChange=true;c1.attachEvent("pageChange",a1,this);return c1;};k.prototype._createYearPicker=function(){var c1=new Y(this.getId()+"--YP",{columns:0,years:6});c1.attachEvent("select",R,this);c1.attachEvent("pageChange",b1,this);c1._oMinDate.setYear(this._oMinDate.getUTCFullYear());c1._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());return c1;};k.prototype.exit=function(){if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent);}};k.prototype.onBeforeRendering=function(){var c1=this.getAggregation("timesRow");var d1=this._getFocusedDate();x.call(this);c1.displayDate(a._createLocalDate(d1,true));};k.prototype._getCalendarPicker=function(){var c1=this.getAggregation("calendarPicker");if(!c1){c1=new sap.ui.unified.Calendar(this.getId()+"--Cal",{});c1.setPopupMode(true);c1.attachEvent("select",N,this);c1.attachEvent("cancel",function(d1){this._oPopup.close();var e1=this.getAggregation("header").getDomRef("B1");if(e1){e1.focus();}},this);this.setAggregation("calendarPicker",c1);}return c1;};k.prototype.setStartDate=function(c1){a._checkJSDateObject(c1);if(h(this.getStartDate(),c1)){return this;}var d1=c1.getFullYear();a._checkYearInValidRange(d1);var e1=this.getMinDate();if(e1&&c1.getTime()<e1.getTime()){i.warning("startDate < minDate -> minDate as startDate set",this);c1=new Date(e1);}var f1=this.getMaxDate();if(f1&&c1.getTime()>f1.getTime()){i.warning("startDate > maxDate -> maxDate as startDate set",this);c1=new Date(f1);}this.setProperty("startDate",c1,true);var g1=this.getAggregation("timesRow");g1.setStartDate(c1);this._oUTCStartDate=new U(g1._getStartDate().getTime());x.call(this);var h1=a._createLocalDate(this._getFocusedDate(),true);if(!g1.checkDateFocusable(h1)){this._setFocusedDate(this._oUTCStartDate);g1.displayDate(c1);}return this;};k.prototype.invalidate=function(c1){if(!this._bDateRangeChanged&&(!c1||!(c1 instanceof sap.ui.unified.DateRange))){if(!c1||(!(c1 instanceof D||c1 instanceof M||c1 instanceof Y||c1 instanceof H))){C.prototype.invalidate.apply(this,arguments);}}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=setTimeout(S.bind(this),0);}};k.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var c1=this.removeAllAggregation("selectedDates");return c1;};k.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var c1=this.destroyAggregation("selectedDates");return c1;};k.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var c1=this.removeAllAggregation("specialDates");return c1;};k.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var c1=this.destroyAggregation("specialDates");return c1;};k.prototype.setIntervalMinutes=function(c1){if(c1>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%c1>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",c1,false);var d1=this.getAggregation("timesRow");var e1=a._createLocalDate(this._getFocusedDate(),true);if(!d1.checkDateFocusable(e1)){var f1=m.call(this);this._setFocusedDate(f1);d1.setDate(a._createLocalDate(f1,true));}return this;};k.prototype.setLocale=function(c1){if(this._sLocale!=c1){this._sLocale=c1;this._oLocaleData=undefined;this.invalidate();}return this;};k.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};k.prototype._getFocusedDate=function(){if(!this._oFocusedDate){o.call(this);}return this._oFocusedDate;};k.prototype._setFocusedDate=function(c1){if(!(c1 instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=new U(c1.getTime());};k.prototype.focusDate=function(c1){var d1=false;var e1=this.getAggregation("timesRow");if(!e1.checkDateFocusable(c1)){var f1=a._createUniversalUTCDate(c1,undefined,true);V.call(this,f1);d1=true;}E.call(this,c1,false);if(d1){this.fireStartDateChange();}return this;};k.prototype.displayDate=function(c1){E.call(this,c1,true);return this;};k.prototype.setItems=function(c1){this.setProperty("items",c1,true);c1=this._getItems();var d1=this.getAggregation("timesRow");d1.setItems(c1);var e1=a._createLocalDate(this._getFocusedDate(),true);if(!d1.checkDateFocusable(e1)){var f1=m.call(this);this._setFocusedDate(f1);d1.setDate(a._createLocalDate(f1,true));}if(!this.getPickerPopup()){var g1=this.getAggregation("datesRow");var h1=Math.floor(c1*1.5);if(h1>31){h1=31;}g1.setDays(h1);var i1=this.getAggregation("monthPicker");var j1=Math.floor(c1/2);if(j1>12){j1=12;}i1.setMonths(j1);var k1=this.getAggregation("yearPicker");var l1=Math.floor(c1/2);if(l1>20){l1=20;}k1.setYears(l1);}x.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};k.prototype._getItems=function(){var c1=this.getItems();if(c.system.phone&&c1>6){return 6;}else{return c1;}};k.prototype._getLocaleData=function(){if(!this._oLocaleData){var c1=this.getLocale();var d1=new d(c1);this._oLocaleData=L.getInstance(d1);}return this._oLocaleData;};k.prototype.setPickerPopup=function(c1){var d1=this.getAggregation("header"),e1,f1,g1;this.setProperty("pickerPopup",c1,true);if(e1){e1.destroy();}if(c1){d1.setVisibleButton0(false);d1.setVisibleButton1(true);d1.setVisibleButton2(false);d1.detachEvent("pressButton1",G,this);d1.attachEvent("pressButton1",G,this);if(this.getAggregation("datesRow")){this.getAggregation("datesRow").destroy();}if(this.getAggregation("monthPicker")){this.getAggregation("monthPicker").destroy();}if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}}else{d1.setVisibleButton0(true);d1.setVisibleButton1(true);d1.setVisibleButton2(true);d1.detachEvent("pressButton0",F,this);d1.attachEvent("pressButton0",F,this);d1.detachEvent("pressButton1",G,this);d1.attachEvent("pressButton1",G,this);d1.detachEvent("pressButton2",I,this);d1.attachEvent("pressButton2",I,this);if(!this.getAggregation("datesRow")){this.setAggregation("datesRow",this._createDatesRow());}if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}if(!this.getAggregation("monthPicker")){this.setAggregation("monthPicker",this._createMonthPicker());}f1=this.getAggregation("monthPicker");g1=this.getAggregation("yearPicker");f1.setColumns(0);f1.setMonths(6);g1.setColumns(0);g1.setYears(6);}return this;};k.prototype.setMinDate=function(c1){var d1,e1,f1,g1;if(h(c1,this.getMinDate())){return this;}if(!c1){a._updateUTCDate(this._oMinDate.getJSDate(),1,0,1,0,0,0,0);}else{a._checkJSDateObject(c1);this._oMinDate=a._createUniversalUTCDate(c1,undefined,true);d1=this.getAggregation("timesRow");this._oMinDate=d1._getIntervalStart(this._oMinDate);e1=this._oMinDate.getUTCFullYear();a._checkYearInValidRange(e1);if(this._oMaxDate.getTime()<this._oMinDate.getTime()){i.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=a._createUniversalUTCDate(c1,undefined,true);a._updateUTCDate(this._oMaxDate,null,this._oMaxDate.getUTCMonth()+1,0,23,59,59,0);this.setProperty("maxDate",a._createLocalDate(this._oMaxDate,true),true);}if(this._oFocusedDate){if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){i.warning("focused date < minDate -> minDate focused",this);this.focusDate(c1);}}if(this._oUTCStartDate&&this._oUTCStartDate.getTime()<this._oMinDate.getTime()){i.warning("start date < minDate -> minDate set as start date",this);_.call(this,new U(this._oMinDate.getTime()),true,true);}}this.setProperty("minDate",c1,false);if(this.getPickerPopup()){g1=this._getCalendarPicker();g1.setMinDate(c1);}else{f1=this.getAggregation("yearPicker");f1._oMinDate.setYear(this._oMinDate.getUTCFullYear());}return this;};k.prototype.setMaxDate=function(c1){var d1,e1,f1,g1,h1,i1;if(h(c1,this.getMaxDate())){return this;}if(!c1){a._updateUTCDate(this._oMaxDate.getJSDate(),9999,11,31,23,59,59,0);}else{a._checkJSDateObject(c1);this._oMaxDate=a._createUniversalUTCDate(c1,undefined,true);d1=this.getAggregation("timesRow");this._oMaxDate=d1._getIntervalStart(this._oMaxDate);this._oMaxDate.setUTCMinutes(this._oMaxDate.getUTCMinutes()+this.getIntervalMinutes());this._oMaxDate.setUTCMilliseconds(-1);e1=this._oMaxDate.getUTCFullYear();a._checkYearInValidRange(e1);if(this._oMinDate.getTime()>this._oMaxDate.getTime()){i.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=a._createUniversalUTCDate(c1,undefined,true);a._updateUTCDate(this._oMinDate,null,null,1,0,0,0,0);this.setProperty("minDate",a._createLocalDate(this._oMinDate,true),true);}if(this._oFocusedDate){if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){i.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(c1);}}if(this._oUTCStartDate){f1=new U(this._oUTCStartDate.getTime());f1.setUTCMinutes(f1.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));if(f1.getTime()>this._oMaxDate.getTime()){g1=new U(this._oMaxDate.getTime());g1.setUTCMinutes(g1.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(g1.getTime()>=this._oMinDate.getTime()){i.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,g1,true,true);}}}}this.setProperty("maxDate",c1,false);if(this.getPickerPopup()){i1=this._getCalendarPicker();i1.setMaxDate(c1);}else{h1=this.getAggregation("yearPicker");h1._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());}return this;};k.prototype.onclick=function(c1){if(c1.isMarked("delayedMouseEvent")){return;}if(c1.target.id==this.getId()+"-cancel"){this.onsapescape(c1);}};k.prototype.onmousedown=function(c1){c1.preventDefault();c1.setMark("cancelAutoClose");};k.prototype.onsapescape=function(c1){if(this.getPickerPopup()){p.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:s.call(this);break;case 2:u.call(this);break;case 3:w.call(this);break;}}};k.prototype.onsaptabnext=function(c1){var d1=this.getAggregation("header"),e1,f1,g1;if(g(this.getDomRef("content"),c1.target)){if(this.getPickerPopup()&&d1.getDomRef("B1")){d1.getDomRef("B1").focus();}else if(!this.getPickerPopup()&&d1.getDomRef("B0")){d1.getDomRef("B0").focus();}if(!this._bPoupupMode){g1=this.getAggregation("timesRow");q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){e1=this.getAggregation("monthPicker");f1=this.getAggregation("yearPicker");if(e1.getDomRef()){q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(f1.getDomRef()){q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}c1.preventDefault();}else if(c1.target.id==d1.getId()+"-B0"){if(d1.getDomRef("B1")){d1.getDomRef("B1").focus();}c1.preventDefault();}else if(!this.getPickerPopup()&&(c1.target.id==d1.getId()+"-B1")){if(d1.getDomRef("B2")){d1.getDomRef("B2").focus();}c1.preventDefault();}};k.prototype.onsaptabprevious=function(c1){var d1=this.getAggregation("header"),e1,f1,g1;if(g(this.getDomRef("content"),c1.target)){if(this._bPoupupMode){if(d1.getDomRef("B2")){d1.getDomRef("B2").focus();}c1.preventDefault();}}else if(c1.target.id==d1.getId()+"-B0"){g1=this.getAggregation("timesRow");switch(this._iMode){case 0:g1._oItemNavigation.focusItem(g1._oItemNavigation.getFocusedIndex());break;case 2:if(!this.getPickerPopup()){e1=this.getAggregation("monthPicker");e1._oItemNavigation.focusItem(e1._oItemNavigation.getFocusedIndex());}break;case 3:if(!this.getPickerPopup()){f1=this.getAggregation("yearPicker");f1._oItemNavigation.focusItem(f1._oItemNavigation.getFocusedIndex());}break;}c1.preventDefault();}else if(c1.target.id==d1.getId()+"-B2"){if(d1.getDomRef("B1")){d1.getDomRef("B1").focus();}c1.preventDefault();}else if(c1.target.id==d1.getId()+"-B1"){if(!this.getPickerPopup()){if(d1.getDomRef("B0")){d1.getDomRef("B0").focus();}}else{g1=this.getAggregation("timesRow");g1._oItemNavigation.focusItem(g1._oItemNavigation.getFocusedIndex());}c1.preventDefault();}};k.prototype.onfocusin=function(c1){if(c1.target.id==this.getId()+"-end"){var d1=this.getAggregation("header"),e1,f1,g1;if(this.getPickerPopup()&&d1.getDomRef("B1")){d1.getDomRef("B1").focus();}else if(!this.getPickerPopup()&&d1.getDomRef("B2")){d1.getDomRef("B2").focus();}if(!this._bPoupupMode){e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){f1=this.getAggregation("monthPicker");g1=this.getAggregation("yearPicker");if(f1.getDomRef()){q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(g1.getDomRef()){q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};k.prototype.onsapfocusleave=function(c1){if(!c1.relatedControlId||!g(this.getDomRef(),sap.ui.getCore().byId(c1.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var d1,e1,f1;switch(this._iMode){case 0:d1=this.getAggregation("timesRow");q(d1._oItemNavigation.getItemDomRefs()[d1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 2:if(!this.getPickerPopup()){e1=this.getAggregation("monthPicker");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 3:if(!this.getPickerPopup()){f1=this.getAggregation("yearPicker");q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};k.prototype._handlePrevious=function(c1){var d1=this._getFocusedDate(),e1,f1,g1,h1,i1,j1,k1,l1;switch(this._iMode){case 0:e1=this._getItems();f1=new U(m.call(this).getTime());g1=this.getIntervalMinutes();f1.setUTCMinutes(f1.getUTCMinutes()-e1*g1);d1.setUTCMinutes(d1.getUTCMinutes()-e1*g1);this._setFocusedDate(d1);_.call(this,f1,true);break;case 1:if(!this.getPickerPopup()){h1=this.getAggregation("datesRow");i1=a._createUniversalUTCDate(h1.getDate());j1=h1.getDays();if(i1.getUTCDate()<=j1){i1.setUTCDate(1);}else{i1.setUTCDate(i1.getUTCDate()-j1);}W.call(this,i1);}break;case 2:if(!this.getPickerPopup()){k1=this.getAggregation("monthPicker");if(k1.getMonths()<12){k1.previousPage();y.call(this);}else{d1.setUTCFullYear(d1.getUTCFullYear()-1);V.call(this,d1);this._setFocusedDate(d1);x.call(this);$.call(this,d1.getUTCFullYear(),k1);this.fireStartDateChange();}}break;case 3:if(!this.getPickerPopup()){l1=this.getAggregation("yearPicker");l1.previousPage();z.call(this);}break;}};k.prototype._handleNext=function(c1){var d1=this._getFocusedDate();switch(this._iMode){case 0:var e1=this._getItems();var f1=new U(m.call(this).getTime());var g1=this.getIntervalMinutes();f1.setUTCMinutes(f1.getUTCMinutes()+e1*g1);d1.setUTCMinutes(d1.getUTCMinutes()+e1*g1);this._setFocusedDate(d1);_.call(this,f1,true);break;case 1:if(!this.getPickerPopup()){var h1=this.getAggregation("datesRow");var i1=a._createUniversalUTCDate(h1.getDate());var j1=new U(i1.getTime());j1.setUTCDate(1);j1.setUTCMonth(j1.getUTCMonth()+1);j1.setUTCDate(0);var k1=h1.getDays();if(i1.getUTCDate()+k1>j1.getUTCDate()){i1.setUTCDate(j1.getUTCDate());}else{i1.setUTCDate(i1.getUTCDate()+k1);}W.call(this,i1);}break;case 2:if(!this.getPickerPopup()){var l1=this.getAggregation("monthPicker");if(l1.getMonths()<12){l1.nextPage();y.call(this);}else{d1.setUTCFullYear(d1.getUTCFullYear()+1);V.call(this,d1);this._setFocusedDate(d1);x.call(this);$.call(this,d1.getUTCFullYear(),l1);this.fireStartDateChange();}}break;case 3:if(!this.getPickerPopup()){var m1=this.getAggregation("yearPicker");m1.nextPage();z.call(this);}break;}};k.prototype._getShowItemHeader=function(){var c1=this.getItems();if(c1>this._iItemsHead){return true;}else{return false;}};function _(c1,d1,e1){var f1=new U(this._oMaxDate.getTime());f1.setUTCMinutes(f1.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(f1.getTime()<this._oMinDate.getTime()){f1=new U(this._oMinDate.getTime());f1.setUTCMinutes(f1.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));}if(c1.getTime()<this._oMinDate.getTime()){c1=new U(this._oMinDate.getTime());}else if(c1.getTime()>f1.getTime()){c1=f1;}var g1=this.getAggregation("timesRow");var h1=a._createLocalDate(c1,true);g1.setStartDate(h1);this._oUTCStartDate=new U(g1._getStartDate().getTime());h1=a._createLocalDate(this._oUTCStartDate,true);this.setProperty("startDate",h1,true);x.call(this);if(d1){var i1=a._createLocalDate(this._getFocusedDate(),true);if(!g1.checkDateFocusable(i1)){this._setFocusedDate(c1);g1.setDate(h1);}else{g1.setDate(i1);}}if(!e1){this.fireStartDateChange();}}function m(){if(!this._oUTCStartDate){var c1=this.getAggregation("timesRow");c1.setStartDate(a._createLocalDate(this._getFocusedDate(),true));this._oUTCStartDate=new U(c1._getStartDate().getTime());this._setFocusedDate(this._oUTCStartDate);}return this._oUTCStartDate;}function n(c1){var d1=this._getFocusedDate();var e1=this.getAggregation("timesRow");if(!c1){e1.setDate(a._createLocalDate(d1,true));}else{e1.displayDate(a._createLocalDate(d1,true));}x.call(this);}function o(){var c1=this.getSelectedDates();if(c1&&c1[0]&&c1[0].getStartDate()){this._oFocusedDate=a._createUniversalUTCDate(c1[0].getStartDate(),undefined,true);}else{var d1=new Date();this._oFocusedDate=a._createUniversalUTCDate(d1,undefined,true);}if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){this._oFocusedDate=new U(this._oMinDate.getTime());}else if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){this._oFocusedDate=new U(this._oMaxDate.getTime());}}k.prototype._showCalendarPicker=function(){var c1=a._createLocalDate(this._getFocusedDate(),true);var d1=this._getCalendarPicker();var e1=new sap.ui.unified.DateRange({startDate:c1});d1.displayDate(c1,false);d1.removeAllSelectedDates();d1.addSelectedDate(e1);d1.setMinDate(this.getMinDate());d1.setMaxDate(this.getMaxDate());X.call(this,d1);this._showOverlay();};k.prototype._showOverlay=function(){this.$("contentOver").css("display","");};k.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};function p(c1){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!c1){n.call(this);var d1=this.getAggregation("timesRow");q(d1._oItemNavigation.getItemDomRefs()[d1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function r(){if(this._iMode==3){w.call(this,true);}else if(this._iMode==2){u.call(this,true);}var c1=this._getFocusedDate();var d1=this._getItems();var e1=this.getAggregation("datesRow");var f1=e1.getSelectedDates()[0];f1.setStartDate(a._createLocalDate(c1,true));var g1=new U(c1.getTime());g1.setUTCDate(1);g1.setUTCMonth(g1.getUTCMonth()+1);g1.setUTCDate(0);var h1=g1.getUTCDate();var i1=Math.floor(d1*1.5);if(i1>h1){i1=h1;}e1.setDays(i1);if(e1.getDomRef()){e1.$().css("display","");}else{var j1=sap.ui.getCore().createRenderManager();var k1=this.$("content");j1.renderControl(e1);j1.flush(k1[0],false,true);j1.destroy();}this._showOverlay();W.call(this,c1);if(this._iMode==0){var l1=this.getAggregation("timesRow");q(l1._oItemNavigation.getItemDomRefs()[l1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=1;}function s(c1){this._iMode=0;var d1=this.getAggregation("datesRow");d1.$().css("display","none");this._hideOverlay();if(!c1){n.call(this);var e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function t(){if(this._iMode==1){s.call(this,true);}else if(this._iMode==3){w.call(this,true);}var c1=this._getFocusedDate();var d1=this.getAggregation("monthPicker");if(d1.getDomRef()){d1.$().css("display","");}else{var e1=sap.ui.getCore().createRenderManager();var f1=this.$("content");e1.renderControl(d1);e1.flush(f1[0],false,true);e1.destroy();}this._showOverlay();d1.setMonth(c1.getUTCMonth());$.call(this,c1.getUTCFullYear(),d1);if(this._iMode==0){var g1=this.getAggregation("timesRow");q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=2;y.call(this);}function u(c1){this._iMode=0;var d1=this.getAggregation("monthPicker");d1.$().css("display","none");this._hideOverlay();if(!c1){n.call(this);var e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function v(){if(this._iMode==1){s.call(this,true);}else if(this._iMode==2){u.call(this,true);}var c1=this._getFocusedDate();var d1=this.getAggregation("yearPicker");if(d1.getDomRef()){d1.$().css("display","");}else{var e1=sap.ui.getCore().createRenderManager();var f1=this.$("content");e1.renderControl(d1);e1.flush(f1[0],false,true);e1.destroy();}this._showOverlay();d1.setDate(c1.getJSDate());if(this._iMode==0){var g1=this.getAggregation("timesRow");q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}z.call(this);this._iMode=3;}function w(c1){this._iMode=0;var d1=this.getAggregation("yearPicker");d1.$().css("display","none");this._hideOverlay();if(!c1){n.call(this);var e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function x(){A.call(this);y.call(this,true);}function y(c1){var d1=new U(m.call(this).getTime());var e1=this._getItems();var f1=d1.getJSDate().getUTCFullYear();var g1=this._oMaxDate.getJSDate().getUTCFullYear();var h1=this._oMinDate.getJSDate().getUTCFullYear();var i1=d1.getJSDate().getUTCMonth();var j1=this._oMaxDate.getJSDate().getUTCMonth();var k1=this._oMinDate.getJSDate().getUTCMonth();var l1=d1.getJSDate().getUTCDate();var m1=this._oMaxDate.getJSDate().getUTCDate();var n1=this._oMinDate.getJSDate().getUTCDate();var o1=d1.getJSDate().getUTCHours();var p1=this._oMaxDate.getJSDate().getUTCHours();var q1=this._oMinDate.getJSDate().getUTCHours();var r1=d1.getJSDate().getUTCMinutes();var s1=this._oMaxDate.getJSDate().getUTCMinutes();var t1=this._oMinDate.getJSDate().getUTCMinutes();var u1=this.getAggregation("header");if(this._iMode==2&&!c1){var v1=this.getAggregation("monthPicker");var w1=v1.getMonths();var x1=v1.getStartMonth();var y1=x1+w1-1;if(x1==0||(f1==h1&&x1<=k1)){u1.setEnabledPrevious(false);}else{u1.setEnabledPrevious(true);}if(y1>10||(f1==g1&&y1>=j1)){u1.setEnabledNext(false);}else{u1.setEnabledNext(true);}return;}if((f1<h1||(f1==h1&&(!c1||(i1<k1||(i1==k1&&(l1<n1||(l1==n1&&(o1<q1||(o1==q1&&r1<=t1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){u1.setEnabledPrevious(false);}else{u1.setEnabledPrevious(true);}d1.setUTCMinutes(d1.getUTCMinutes()+(e1)*this.getIntervalMinutes()-1);f1=d1.getJSDate().getUTCFullYear();i1=d1.getJSDate().getUTCMonth();l1=d1.getJSDate().getUTCDate();o1=d1.getJSDate().getUTCHours();r1=d1.getJSDate().getUTCMinutes();if((f1>g1||(f1==g1&&(!c1||(i1>j1||(i1==j1&&(l1>m1||(l1==m1&&(o1>p1||(o1==p1&&r1>=s1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){u1.setEnabledNext(false);}else{u1.setEnabledNext(true);}}function z(){var c1=this.getAggregation("yearPicker");var d1=c1.getYears();var e1=a._createUniversalUTCDate(c1.getFirstRenderedDate());e1.setUTCFullYear(e1.getUTCFullYear()+Math.floor(d1/2));var f1=this.getAggregation("header");var g1=new U(this._oMaxDate);g1.setUTCFullYear(g1.getUTCFullYear()-Math.ceil(d1/2));g1.setUTCMonth(11,31);var h1=new U(this._oMinDate);h1.setUTCFullYear(h1.getUTCFullYear()+Math.floor(d1/2)+1);h1.setUTCMonth(0,1);if(e1.getTime()>g1.getTime()){f1.setEnabledNext(false);}else{f1.setEnabledNext(true);}if(e1.getTime()<h1.getTime()){f1.setEnabledPrevious(false);}else{f1.setEnabledPrevious(true);}}function A(){var c1=this.getAggregation("header");var d1;var e1=m.call(this);var f1;var g1=this._getLocaleData();var h1=[];var i1=[];var j1;var k1=false;var l1;var m1=j.Gregorian;var n1=false;if(g1.oLocale.sLanguage.toLowerCase()==="ja"||g1.oLocale.sLanguage.toLowerCase()==="zh"){l1=b.getDateInstance({format:"d"}).format(e1,true);}else{l1=(e1.getUTCDate()).toString();}if(this._bLongMonth||!this._bNamesLengthChecked){h1=g1.getMonthsStandAlone("wide");}else{k1=true;h1=g1.getMonthsStandAlone("abbreviated");i1=g1.getMonthsStandAlone("wide");}var o1=e1.getUTCMonth();d1=h1[o1];if(k1){j1=i1[h1[o1]];}if(!this.getPickerPopup()){c1.setTextButton0(l1);c1.setTextButton1(d1);c1.setTextButton2(this._oYearFormat.format(e1,true));}else{f1=b.getInstance({style:"long",strictParsing:true,relative:n1,calendarType:m1},g1.oLocale);j1=l1=f1.format(a._createLocalDate(e1,true));c1.setTextButton1(l1);}if(k1){c1.setAriaLabelButton1(j1);}}function B(c1,d1){var e1;var f1=false;if(c1.getTime()<this._oMinDate.getTime()){e1=this._oMinDate;f1=true;}else if(c1.getTime()>this._oMaxDate.getTime()){e1=this._oMaxDate;f1=true;}else{e1=c1;}this._setFocusedDate(e1);if(f1||d1){V.call(this,e1);n.call(this,false);this.fireStartDateChange();}}function E(c1,d1){if(c1&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=c1.getTime())){a._checkJSDateObject(c1);c1=a._createUniversalUTCDate(c1,undefined,true);var e1=c1.getUTCFullYear();a._checkYearInValidRange(e1);if(c1.getTime()<this._oMinDate.getTime()||c1.getTime()>this._oMaxDate.getTime()){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(c1);if(this.getDomRef()&&this._iMode==0){n.call(this,d1);}}}function F(c1){if(this._iMode!=1){r.call(this);}else{s.call(this);}}function G(c1){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=2){t.call(this);}else{u.call(this);}}}function I(c1){if(this._iMode!=3){v.call(this);}else{w.call(this);}}function J(c1){this.fireSelect();}function K(c1){var d1=a._createUniversalUTCDate(c1.getParameter("date"),undefined,true);var e1=c1.getParameter("notVisible");B.call(this,d1,e1);}function N(c1){var d1=c1.getSource(),e1=d1.getSelectedDates()[0].getStartDate();var f1=new U(this._getFocusedDate().getTime());var g1=a._createUniversalUTCDate(e1);f1.setUTCDate(g1.getUTCDate());f1.setUTCMonth(g1.getUTCMonth());f1.setUTCFullYear(g1.getUTCFullYear());B.call(this,f1,true);p.call(this);}function O(c1){var d1=new U(this._getFocusedDate().getTime());var e1=c1.oSource;var f1=e1.getSelectedDates()[0];var g1=a._createUniversalUTCDate(f1.getStartDate());if(!this.getPickerPopup()||g1.getUTCMonth()==d1.getUTCMonth()){d1.setUTCDate(g1.getUTCDate());d1.setUTCMonth(g1.getUTCMonth());d1.setUTCFullYear(g1.getUTCFullYear());B.call(this,d1,true);s.call(this);}}function P(c1){var d1=new U(this._getFocusedDate().getTime());var e1=a._createUniversalUTCDate(c1.getParameter("date"),undefined,true);var f1=c1.getParameter("otherMonth");if(f1&&e1.getUTCMonth()==d1.getUTCMonth()&&e1.getUTCFullYear()==d1.getUTCFullYear()){W.call(this,e1);}}function Q(c1){var d1=new U(this._getFocusedDate().getTime());var e1=this.getAggregation("monthPicker");var f1=e1.getMonth();d1.setUTCMonth(f1);if(f1!=d1.getUTCMonth()){d1.setUTCDate(0);}B.call(this,d1,true);u.call(this);}function R(c1){var d1=new U(this._getFocusedDate().getTime());var e1=this.getAggregation("yearPicker");var f1=a._createUniversalUTCDate(e1.getDate());var g1=d1.getUTCMonth();f1.setUTCMonth(d1.getUTCMonth(),d1.getUTCDate());f1.setUTCHours(d1.getUTCHours());f1.setUTCMinutes(d1.getUTCMinutes());d1=f1;if(g1!=d1.getUTCMonth()){d1.setUTCDate(0);}B.call(this,d1,true);w.call(this);}function S(){this._sInvalidateContent=undefined;var c1=this.getAggregation("timesRow");c1._bDateRangeChanged=true;c1._bInvalidateSync=true;c1.invalidate();c1._bInvalidateSync=undefined;this._bDateRangeChanged=undefined;}function V(c1){var d1=this.getAggregation("timesRow");var e1=m.call(this);var f1=d1._oItemNavigation.getFocusedIndex();e1=new U(c1.getTime());e1.setUTCMinutes(e1.getUTCMinutes()-f1*this.getIntervalMinutes());_.call(this,e1,false,true);}function W(c1){var d1=this.getAggregation("datesRow");var e1=this.getAggregation("header");if(!this.getPickerPopup()){var f1=new U(c1.getTime());f1.setUTCDate(1);f1.setUTCMonth(f1.getUTCMonth()+1);f1.setUTCDate(0);var g1=d1.getDays();var h1=new U(c1.getTime());h1.setUTCDate(1+(Math.ceil(c1.getUTCDate()/g1)-1)*g1);if(f1.getUTCDate()-h1.getUTCDate()<g1){h1.setUTCDate(f1.getUTCDate()-g1+1);}d1.setStartDate(a._createLocalDate(h1,true));var i1=h1.getJSDate().getUTCFullYear();var j1=this._oMaxDate.getJSDate().getUTCFullYear();var k1=this._oMinDate.getJSDate().getUTCFullYear();var l1=h1.getJSDate().getUTCMonth();var m1=this._oMaxDate.getJSDate().getUTCMonth();var n1=this._oMinDate.getJSDate().getUTCMonth();var o1=h1.getJSDate().getUTCDate();var p1=this._oMaxDate.getJSDate().getUTCDate();var q1=this._oMinDate.getJSDate().getUTCDate();if(o1<=1||(i1==k1&&l1==n1&&o1<=q1)){e1.setEnabledPrevious(false);}else{e1.setEnabledPrevious(true);}if((o1+g1)>=f1.getUTCDate()||(i1==j1&&l1==m1&&o1>=p1)){e1.setEnabledNext(false);}else{e1.setEnabledNext(true);}}else{e1.setEnabledPrevious(false);e1.setEnabledNext(false);}d1.setDate(a._createLocalDate(c1,true));}function X(c1){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(Z,this);this._oPopup.onsapescape=function(f1){this._oCalendar.onsapescape(f1);};}this._oPopup.setContent(c1);var d1=this.getAggregation("header");var e1=sap.ui.core.Popup.Dock;this._oPopup.open(0,e1.CenterTop,e1.CenterTop,d1,null,"flipfit",true);}function Z(c1){p.call(this);}function $(c1,d1){var e1=0;var f1=11;if(c1==this._oMinDate.getUTCFullYear()){e1=this._oMinDate.getUTCMonth();}if(c1==this._oMaxDate.getUTCFullYear()){f1=this._oMaxDate.getUTCMonth();}d1.setMinMax(e1,f1);}function a1(c1){y.call(this);}function b1(c1){z.call(this);}return k;});
