/*
 * Decompiled with CFR 0.152.
 */
package com.webjars.locator.urlprotocols;

import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.webjars.urlprotocols.UrlProtocolHandler;

public class JbossUrlProtocolHandler
implements UrlProtocolHandler {
    public boolean accepts(String protocol) {
        return "vfs".equals(protocol);
    }

    public Set<String> getAssetPaths(URL url, final Pattern filterExpr, ClassLoader ... classLoaders) {
        HashSet<String> assetPaths = new HashSet<String>();
        try {
            VirtualFile virtualFile = VFS.getChild((URI)url.toURI());
            List children = virtualFile.getChildrenRecursively(new VirtualFileFilter(){

                public boolean accepts(VirtualFile file) {
                    if (file.isDirectory()) {
                        return false;
                    }
                    int prefixIndex = file.getPathName().indexOf("META-INF/resources/webjars");
                    if (prefixIndex == -1) {
                        return false;
                    }
                    String relativePath = file.getPathName().substring(prefixIndex);
                    return file.isFile() && filterExpr.matcher(relativePath).matches();
                }
            });
            for (VirtualFile child : children) {
                assetPaths.add(child.getPathName().substring(child.getPathName().indexOf("META-INF/resources/webjars")));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return assetPaths;
    }
}

