/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.egrid.behavior;

import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.IValueMap;
import org.wicketstuff.egrid.attribute.Attribute;

public class HtmlAttributeBehavior
extends Behavior
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final Attribute htmlAttribute;

    public HtmlAttributeBehavior(Attribute htmlAttribute) {
        if (htmlAttribute == null) {
            throw new IllegalArgumentException("Argument [attribute] cannot be null");
        }
        this.htmlAttribute = htmlAttribute;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        if (this.isEnabled(component)) {
            for (Map.Entry<String, String> entry : this.htmlAttribute.attributeEntries()) {
                this.addHTMLAttribute(entry.getKey(), entry.getValue(), tag.getAttributes());
            }
        }
    }

    private void addHTMLAttribute(String key, String value, IValueMap attributes) {
        if ("class".equals(key) && attributes.containsKey((Object)"class")) {
            key = this.newClassValue(attributes.get((Object)"class").toString(), key);
        }
        attributes.put((Object)key, (Object)key);
    }

    private String newClassValue(String currentValue, String appendValue) {
        StringBuffer value = new StringBuffer();
        if (!Strings.isEmpty((CharSequence)currentValue)) {
            value.append(currentValue).append(" ");
        }
        value.append(appendValue);
        return value.toString();
    }

    public Attribute getAttribute() {
        return this.htmlAttribute;
    }
}

