/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.gmap.api;

import org.apache.wicket.util.string.Strings;
import org.wicketstuff.gmap.GMap;
import org.wicketstuff.gmap.api.GAnimation;
import org.wicketstuff.gmap.api.GIcon;
import org.wicketstuff.gmap.api.GLatLng;
import org.wicketstuff.gmap.api.GValue;
import org.wicketstuff.gmap.js.ObjectLiteral;

public class GMarkerOptions
implements GValue,
Cloneable {
    private static final long serialVersionUID = 1L;
    private boolean clickable = true;
    private final String cursor;
    private boolean draggable = false;
    private final boolean flat = false;
    private GIcon icon = null;
    private final GMap gmap;
    private String title;
    private GLatLng latLng;
    private boolean bouncy = true;
    private boolean autoPan = false;
    private GIcon shadow = null;
    private GAnimation animation = null;

    public GMarkerOptions(GMap gmap, GLatLng latLng) {
        this.cursor = null;
        this.latLng = latLng;
        this.gmap = gmap;
    }

    public GMarkerOptions(GMap gmap, GLatLng latLng, String title) {
        this(gmap, latLng, title, true);
    }

    public GMarkerOptions(GMap gmap, GLatLng latLng, String title, boolean escapeTitle) {
        this(gmap, latLng);
        this.title = title;
        if (escapeTitle) {
            this.title = ((Object)Strings.replaceAll((CharSequence)this.title, (CharSequence)"\\", (CharSequence)"\\\\")).toString();
            this.title = ((Object)Strings.replaceAll((CharSequence)this.title, (CharSequence)"\n", (CharSequence)"\\n")).toString();
            this.title = ((Object)Strings.replaceAll((CharSequence)this.title, (CharSequence)"\r", (CharSequence)"\\r")).toString();
            this.title = ((Object)Strings.replaceAll((CharSequence)this.title, (CharSequence)"\t", (CharSequence)"\\t")).toString();
            this.title = ((Object)Strings.replaceAll((CharSequence)this.title, (CharSequence)"\"", (CharSequence)"\\\"")).toString();
        }
    }

    public GMarkerOptions(GMap gmap, GLatLng latLng, String title, GIcon icon) {
        this(gmap, latLng, title);
        this.icon = icon;
    }

    public GMarkerOptions(GMap gmap, GLatLng latLng, String title, GIcon icon, boolean escapeTitle) {
        this(gmap, latLng, title, escapeTitle);
        this.icon = icon;
    }

    public GMarkerOptions(GMap gmap, GLatLng latLng, String title, GIcon icon, GIcon shadow) {
        this(gmap, latLng, title, icon, true);
        this.shadow = shadow;
    }

    @Override
    public String getJSconstructor() {
        ObjectLiteral literal = new ObjectLiteral();
        literal.set("map", this.gmap.getJsReference() + ".map");
        literal.set("position", this.latLng.getJSconstructor());
        if (!this.clickable) {
            literal.set("clickable", "false");
        }
        if (this.cursor != null) {
            literal.set("cursor", this.cursor);
        }
        if (this.draggable) {
            literal.set("draggable", "true");
        }
        if (this.icon != null) {
            literal.set("icon", this.icon.getJSconstructor());
        }
        if (this.shadow != null) {
            literal.set("shadow", this.shadow.getJSconstructor());
        }
        if (this.title != null) {
            literal.setString("title", this.title);
        }
        if (!this.bouncy) {
            literal.set("bouncy", "false");
        }
        if (this.autoPan) {
            literal.set("autoPan", "true");
        }
        if (this.animation != null) {
            literal.set("animation", this.animation.toString());
        }
        return literal.toJS();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public boolean isBouncy() {
        return this.bouncy;
    }

    public boolean isAutoPan() {
        return this.autoPan;
    }

    public GIcon getIcon() {
        return this.icon;
    }

    public GMarkerOptions clone() {
        try {
            return (GMarkerOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public GMarkerOptions clickable(boolean clickable) {
        GMarkerOptions clone = this.clone();
        clone.clickable = clickable;
        return clone;
    }

    public GMarkerOptions draggable(boolean draggable) {
        GMarkerOptions clone = this.clone();
        clone.draggable = draggable;
        return clone;
    }

    public GMarkerOptions autoPan(boolean autoPan) {
        GMarkerOptions clone = this.clone();
        clone.autoPan = autoPan;
        return clone;
    }

    public GMarkerOptions bouncy(boolean bouncy) {
        GMarkerOptions clone = this.clone();
        clone.bouncy = bouncy;
        return clone;
    }

    public String getCursor() {
        return this.cursor;
    }

    public boolean isFlat() {
        return false;
    }

    public void setLatLng(GLatLng latLng) {
        this.latLng = latLng;
    }

    public GLatLng getLatLng() {
        return this.latLng;
    }

    public GMap getGmap() {
        return this.gmap;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.autoPan ? 1231 : 1237);
        result = 31 * result + (this.bouncy ? 1231 : 1237);
        result = 31 * result + (this.clickable ? 1231 : 1237);
        result = 31 * result + (this.draggable ? 1231 : 1237);
        result = 31 * result + (this.icon == null ? 0 : this.icon.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GMarkerOptions other = (GMarkerOptions)obj;
        if (this.autoPan != other.autoPan) {
            return false;
        }
        if (this.bouncy != other.bouncy) {
            return false;
        }
        if (this.clickable != other.clickable) {
            return false;
        }
        if (this.draggable != other.draggable) {
            return false;
        }
        if (this.icon == null ? other.icon != null : !this.icon.equals(other.icon)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }

    public void setShadow(GIcon shadow) {
        this.shadow = shadow;
    }

    public GIcon getShadow() {
        return this.shadow;
    }

    public GAnimation getAnimation() {
        return this.animation;
    }

    public void setAnimation(GAnimation animation) {
        this.animation = animation;
    }
}

