/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.gmap.api;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.time.Duration;
import org.wicketstuff.gmap.GMapHeaderContributor;
import org.wicketstuff.gmap.api.GLatLng;
import org.wicketstuff.gmap.geocoder.GeocoderStatus;

public abstract class GClientGeocoder
extends AjaxEventBehavior {
    private static final long serialVersionUID = 1L;
    private final String addressFieldMarkupId;
    private final GMapHeaderContributor headerContrib;
    private final Duration timeout;

    public GClientGeocoder(String event, TextField<?> addressField) {
        this(event, addressField, Duration.milliseconds((long)500L));
    }

    public GClientGeocoder(String event, TextField<?> addressField, Duration timeout) {
        super(event);
        addressField.setOutputMarkupId(true);
        this.addressFieldMarkupId = addressField.getMarkupId();
        this.headerContrib = new GMapHeaderContributor();
        this.timeout = timeout;
    }

    public void renderHead(Component c, IHeaderResponse response) {
        super.renderHead(c, response);
        this.headerContrib.renderHead(c, response);
    }

    protected void onEvent(AjaxRequestTarget target) {
        Request request = RequestCycle.get().getRequest();
        IRequestParameters requestParameters = request.getRequestParameters();
        String status = requestParameters.getParameterValue("status").toString();
        GeocoderStatus geocoderStatus = status != null ? GeocoderStatus.valueOf(status) : null;
        String address = null;
        GLatLng coordinates = null;
        if (geocoderStatus == null) {
            StringBuilder js = new StringBuilder();
            js.append("setTimeout(function() {").append(this.getCallbackScript()).append("}, ").append(this.timeout.getMilliseconds()).append(");");
            target.appendJavaScript((CharSequence)js);
        } else {
            if (GeocoderStatus.OK.equals((Object)geocoderStatus)) {
                address = requestParameters.getParameterValue("address").toString();
                coordinates = GLatLng.parse(requestParameters.getParameterValue("coordinates").toString());
            }
            this.onGeoCode(target, geocoderStatus, address, coordinates);
        }
    }

    public abstract void onGeoCode(AjaxRequestTarget var1, GeocoderStatus var2, String var3, GLatLng var4);

    public CharSequence getCallbackScript() {
        return "Wicket.geocoder.getLatLng('" + this.getCallbackUrl() + "', '" + this.addressFieldMarkupId + "');";
    }
}

