/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.gmap.api;

import org.wicketstuff.gmap.api.GPoint;
import org.wicketstuff.gmap.api.GSize;
import org.wicketstuff.gmap.api.GValue;

public class GIcon
implements GValue,
Cloneable {
    private static final long serialVersionUID = 1714038753187423501L;
    private static final String DEFAULT_URL = "http://www.google.com/mapfiles/marker%s.png";
    private final String url;
    private GSize size = null;
    private GPoint origin = null;
    private GSize scaledSize = null;
    private GPoint anchor = null;

    public GIcon() {
        this.url = DEFAULT_URL;
    }

    public GIcon(String image) {
        this.url = image;
    }

    public GIcon(char character) {
        String letter = Character.isLetter(character) ? String.valueOf(Character.toUpperCase(character)) : "";
        this.url = String.format(DEFAULT_URL, letter);
    }

    public GIcon(String image, GSize iconSize, GPoint iconAnchor, GPoint origin, GSize scaledSize) {
        this.url = image;
        this.size = iconSize;
        this.anchor = iconAnchor;
        this.origin = origin;
        this.scaledSize = scaledSize;
    }

    public GIcon(String image, GSize iconSize, GPoint iconAnchor) {
        this.url = image;
        this.size = iconSize;
        this.anchor = iconAnchor;
    }

    public GIcon clone() {
        try {
            return (GIcon)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public String getId() {
        return "icon" + String.valueOf(System.identityHashCode(this));
    }

    @Override
    public String getJSconstructor() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(function() {\n");
        buffer.append("var icon = {\n");
        buffer.append("url: '").append(this.url).append("',\n");
        if (this.size != null) {
            buffer.append("size: ").append(this.size.getJSconstructor()).append(",\n");
        }
        if (this.anchor != null) {
            buffer.append("anchor: ").append(this.anchor.getJSconstructor()).append(",\n");
        }
        if (this.origin != null) {
            buffer.append("origin: ").append(this.origin.getJSconstructor()).append(",\n");
        }
        if (this.scaledSize != null) {
            buffer.append("scaledSize: ").append(this.scaledSize.getJSconstructor()).append(",\n");
        }
        buffer.append("}\n");
        buffer.append("return icon;\n");
        buffer.append("})()\n");
        return buffer.toString();
    }

    public GIcon setSchema(String schema) {
        String regex = "https?";
        this.url.replaceFirst("https?", schema);
        return this;
    }

    public GSize getSize() {
        return this.size;
    }

    public GIcon setSize(GSize size) {
        this.size = size;
        return this;
    }

    public GPoint getOrigin() {
        return this.origin;
    }

    public GIcon setOrigin(GPoint origin) {
        this.origin = origin;
        return this;
    }

    public GSize getScaledSize() {
        return this.scaledSize;
    }

    public GIcon setScaledSize(GSize scaledSize) {
        this.scaledSize = scaledSize;
        return this;
    }

    public GPoint getAnchor() {
        return this.anchor;
    }

    public GIcon setAnchor(GPoint anchor) {
        this.anchor = anchor;
        return this;
    }

    public String getUrl() {
        return this.url;
    }
}

