/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.gmap.api;

import java.util.ArrayList;
import java.util.List;
import org.wicketstuff.gmap.GMapMarkerClustererHeaderContributor;
import org.wicketstuff.gmap.api.GMarkerClusterStyle;
import org.wicketstuff.gmap.api.GValue;
import org.wicketstuff.gmap.js.Array;
import org.wicketstuff.gmap.js.ObjectLiteral;

public class GMarkerClusterOptions
implements GValue {
    private static final long serialVersionUID = 1L;
    private Integer gridSize = 60;
    private Integer maxZoom = 100;
    private boolean zoomOnClick = true;
    private boolean averageCenter = false;
    private Integer minimumClusterSize = 2;
    private List<GMarkerClusterStyle> styles = new ArrayList<GMarkerClusterStyle>();

    @Override
    public String getJSconstructor() {
        ObjectLiteral literal = new ObjectLiteral();
        literal.set("imagePath", "\"wicket/resource/" + GMapMarkerClustererHeaderContributor.INSTANCE.getResource().getScope().getCanonicalName() + "/m\"");
        literal.set("gridSize", this.getGridSize().toString());
        literal.set("maxZoom", this.getMaxZoom().toString());
        literal.setString("zoomOnClick", this.isZoomOnClick() ? "true" : "false");
        literal.setString("averageCenter", this.isAverageCenter() ? "true" : "false");
        literal.set("minimumClusterSize", this.getMinimumClusterSize().toString());
        if (this.getStyles().isEmpty()) {
            literal.set("styles", "[]");
        } else {
            Array array = new Array();
            for (GMarkerClusterStyle style : this.getStyles()) {
                array.add(style.getJSconstructor());
            }
            literal.set("styles", array.toJS());
        }
        return literal.toJS();
    }

    public Integer getGridSize() {
        return this.gridSize;
    }

    public GMarkerClusterOptions setGridSize(Integer gridSize) {
        this.gridSize = gridSize;
        return this;
    }

    public Integer getMaxZoom() {
        return this.maxZoom;
    }

    public GMarkerClusterOptions setMaxZoom(Integer maxZoom) {
        this.maxZoom = maxZoom;
        return this;
    }

    public boolean isZoomOnClick() {
        return this.zoomOnClick;
    }

    public GMarkerClusterOptions setZoomOnClick(boolean zoomOnClick) {
        this.zoomOnClick = zoomOnClick;
        return this;
    }

    public boolean isAverageCenter() {
        return this.averageCenter;
    }

    public GMarkerClusterOptions setAverageCenter(boolean averageCenter) {
        this.averageCenter = averageCenter;
        return this;
    }

    public Integer getMinimumClusterSize() {
        return this.minimumClusterSize;
    }

    public GMarkerClusterOptions setMinimumClusterSize(Integer minimumClusterSize) {
        this.minimumClusterSize = minimumClusterSize;
        return this;
    }

    public List<GMarkerClusterStyle> getStyles() {
        return this.styles;
    }

    public GMarkerClusterOptions setStyles(List<GMarkerClusterStyle> styles) {
        this.styles = styles;
        return this;
    }
}

