/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.gmap.api;

import org.wicketstuff.gmap.api.GValue;
import org.wicketstuff.gmap.js.Constructor;

public class GPoint
implements GValue {
    private static final long serialVersionUID = 1L;
    private final float longitude;
    private final float latitude;

    public GPoint(float longitude, float latitude) {
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public float getLatitude() {
        return this.latitude;
    }

    @Override
    public String getJSconstructor() {
        return new Constructor("google.maps.Point").add(Float.valueOf(this.longitude)).add(Float.valueOf(this.latitude)).toJS();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.latitude);
        result = 31 * result + Float.floatToIntBits(this.longitude);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GPoint other = (GPoint)obj;
        if (Float.floatToIntBits(this.latitude) != Float.floatToIntBits(other.latitude)) {
            return false;
        }
        return Float.floatToIntBits(this.longitude) == Float.floatToIntBits(other.longitude);
    }
}

