/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.gmap.api;

import java.util.StringTokenizer;
import org.wicketstuff.gmap.api.GLatLng;
import org.wicketstuff.gmap.api.GValue;
import org.wicketstuff.gmap.js.Constructor;

public class GLatLngBounds
implements GValue {
    private static final long serialVersionUID = 1L;
    private final GLatLng sw;
    private final GLatLng ne;

    public GLatLngBounds(GLatLng sw, GLatLng ne) {
        this.sw = sw;
        this.ne = ne;
    }

    public GLatLng getSW() {
        return this.sw;
    }

    public GLatLng getNE() {
        return this.ne;
    }

    public String toString() {
        return this.getJSconstructor();
    }

    @Override
    public String getJSconstructor() {
        return new Constructor("google.maps.LatLngBounds").add(this.sw.getJSconstructor()).add(this.ne.getJSconstructor()).toJS();
    }

    public int hashCode() {
        return this.sw.hashCode() ^ this.ne.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GLatLngBounds) {
            GLatLngBounds t = (GLatLngBounds)obj;
            return t.sw.equals(this.sw) && t.ne.equals(this.ne);
        }
        return false;
    }

    public static GLatLngBounds parse(String value) {
        StringTokenizer tokenizer;
        try {
            tokenizer = new StringTokenizer(value, "(, )");
        }
        catch (NullPointerException e) {
            return null;
        }
        if (tokenizer.countTokens() != 4) {
            return null;
        }
        GLatLng sw = new GLatLng(Float.valueOf(tokenizer.nextToken()).floatValue(), Float.valueOf(tokenizer.nextToken()).floatValue());
        GLatLng ne = new GLatLng(Float.valueOf(tokenizer.nextToken()).floatValue(), Float.valueOf(tokenizer.nextToken()).floatValue());
        return new GLatLngBounds(sw, ne);
    }
}

