/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.behavior.apanel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.wicketstuff.minis.behavior.apanel.FlowLayout;
import org.wicketstuff.minis.behavior.apanel.IComponentRenderer;
import org.wicketstuff.minis.behavior.apanel.ILayout;

class RenderersList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final List<IComponentRenderer<?>> DEFAULT_RENDERERS = new ArrayList();
    private final List<IComponentRenderer<?>> renderers;

    public static List<IComponentRenderer<?>> getDefaultRenderers() {
        return Collections.unmodifiableList(DEFAULT_RENDERERS);
    }

    public RenderersList(List<IComponentRenderer<?>> renderers) {
        this.renderers = renderers;
    }

    IComponentRenderer<Component> findRendererForClass(Class<? extends Component> aClass) {
        for (IComponentRenderer<Component> iComponentRenderer : this.renderers) {
            if (!iComponentRenderer.getComponentClass().isAssignableFrom(aClass)) continue;
            IComponentRenderer<Component> result = iComponentRenderer;
            return result;
        }
        throw new WicketRuntimeException("Can't find renderer for class " + aClass);
    }

    static {
        DEFAULT_RENDERERS.add(new LabelRenderer());
        DEFAULT_RENDERERS.add(new LinkRenderer());
        DEFAULT_RENDERERS.add(new ListViewRenderer());
        DEFAULT_RENDERERS.add(new RepeatingViewRenderer());
        DEFAULT_RENDERERS.add(new FormRenderer());
        DEFAULT_RENDERERS.add(new ButtonRenderer());
        DEFAULT_RENDERERS.add(new DefaultWebMarkupContainerRenderer());
        DEFAULT_RENDERERS.add(new DefaultRenderer());
    }

    public static final class RepeatingViewRenderer
    extends BaseWebMarkupContainerRenderer<RepeatingView> {
        private static final long serialVersionUID = 1L;

        @Override
        public Class<RepeatingView> getComponentClass() {
            return RepeatingView.class;
        }

        @Override
        public CharSequence getMarkup(RepeatingView component) {
            final String[] markup = new String[1];
            component.visitChildren((IVisitor)new IVisitor<Component, Void>(){

                public void component(Component component, IVisit<Void> visit) {
                    CharSequence c = RepeatingViewRenderer.this.layout.renderComponents(Collections.singletonList(component));
                    markup[0] = c.toString().replace(RepeatingViewRenderer.this.getIdAttribute(component), "%s");
                    visit.stop();
                }
            });
            if (markup[0] == null) {
                markup[0] = "<span %s></span>";
            }
            return String.format(markup[0], this.getIdAttribute((Component)component));
        }
    }

    public static final class ListViewRenderer
    extends BaseWebMarkupContainerRenderer<ListView> {
        private static final long serialVersionUID = 1L;

        @Override
        public Class<ListView> getComponentClass() {
            return ListView.class;
        }

        private CharSequence getListViewBodyMarkup(ListView listView) {
            if (listView.getList().isEmpty()) {
                return "";
            }
            ListItem listItem = (ListItem)listView.get("0");
            return this.getBodyMarkup((WebMarkupContainer)listItem);
        }

        @Override
        public CharSequence getMarkup(ListView component) {
            return String.format("<span %s>%s</span>", this.getIdAttribute((Component)component), this.getListViewBodyMarkup(component));
        }
    }

    public static final class LinkRenderer
    extends BaseWebMarkupContainerRenderer<Link> {
        private static final long serialVersionUID = 1L;

        @Override
        public Class<Link> getComponentClass() {
            return Link.class;
        }

        @Override
        public CharSequence getMarkup(Link component) {
            return String.format("<a %s>%s</a>", this.getIdAttribute((Component)component), this.getBodyMarkup((WebMarkupContainer)component));
        }
    }

    public static final class LabelRenderer
    extends BaseRenderer<Label> {
        private static final long serialVersionUID = 1L;

        @Override
        public Class<Label> getComponentClass() {
            return Label.class;
        }

        @Override
        public CharSequence getMarkup(Label component) {
            return String.format("<span %s></span>", this.getIdAttribute((Component)component));
        }
    }

    public static final class FormRenderer
    extends BaseWebMarkupContainerRenderer<Form> {
        private static final long serialVersionUID = 1L;

        @Override
        public Class<Form> getComponentClass() {
            return Form.class;
        }

        @Override
        public CharSequence getMarkup(Form component) {
            return String.format("<form %s>%s</form>", this.getIdAttribute((Component)component), this.getBodyMarkup((WebMarkupContainer)component));
        }
    }

    public static final class DefaultWebMarkupContainerRenderer
    extends BaseWebMarkupContainerRenderer<WebMarkupContainer> {
        private static final long serialVersionUID = 1L;

        @Override
        public Class<WebMarkupContainer> getComponentClass() {
            return WebMarkupContainer.class;
        }

        @Override
        public CharSequence getMarkup(WebMarkupContainer component) {
            return String.format("<span %s>%s</span>", this.getIdAttribute((Component)component), this.getBodyMarkup(component));
        }
    }

    public static final class DefaultRenderer
    extends BaseRenderer<Component> {
        private static final long serialVersionUID = 1L;

        @Override
        public Class<Component> getComponentClass() {
            return Component.class;
        }

        @Override
        public CharSequence getMarkup(Component component) {
            return String.format("<span %s></span>", this.getIdAttribute(component));
        }
    }

    public static final class ButtonRenderer
    extends BaseRenderer<Button> {
        private static final long serialVersionUID = 1L;

        @Override
        public Class<Button> getComponentClass() {
            return Button.class;
        }

        @Override
        public CharSequence getMarkup(Button component) {
            return String.format("<input type=\"submit\" %s/>", this.getIdAttribute((Component)component));
        }
    }

    public static abstract class BaseWebMarkupContainerRenderer<T extends WebMarkupContainer>
    extends BaseRenderer<T> {
        private static final long serialVersionUID = 1L;
        protected final ILayout layout;

        protected BaseWebMarkupContainerRenderer() {
            this.layout = new FlowLayout();
        }

        protected BaseWebMarkupContainerRenderer(ILayout layout) {
            this.layout = layout;
        }

        protected CharSequence getBodyMarkup(WebMarkupContainer container) {
            final ArrayList componentsToRender = new ArrayList();
            container.visitChildren((IVisitor)new IVisitor<Component, Void>(){

                public void component(Component component, IVisit<Void> visit) {
                    componentsToRender.add(component);
                    visit.dontGoDeeper();
                }
            });
            return this.layout.renderComponents(componentsToRender);
        }
    }

    public static abstract class BaseRenderer<T extends Component>
    implements IComponentRenderer<T> {
        private static final long serialVersionUID = 1L;

        protected String getIdAttribute(Component component) {
            return "wicket:id=\"" + component.getId() + "\"";
        }
    }
}

