/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.behavior.reflection;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class ReflectionBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    public static final ResourceReference REFLECTION_JS = new JavaScriptResourceReference(ReflectionBehavior.class, "reflection.js");
    private Integer reflectionOpacity = null;
    private Integer reflectionHeight = null;
    private final List<Component> components = new ArrayList<Component>();

    public ReflectionBehavior() {
    }

    public ReflectionBehavior(Integer height, Integer opacity) {
        this.setReflectionHeight(height);
        this.setReflectionOpacity(opacity);
    }

    public void bind(Component component) {
        super.bind(component);
        component.setOutputMarkupId(true);
        this.components.add(component);
    }

    public void renderHead(Component c, IHeaderResponse response) {
        super.renderHead(c, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)REFLECTION_JS));
        StringBuilder sb = new StringBuilder();
        for (Component component : this.components) {
            if (!component.isVisibleInHierarchy()) continue;
            sb.append(Javascript.show(component.getMarkupId(), this.reflectionOpacity, this.reflectionHeight));
            sb.append("\n");
        }
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)sb.toString()));
    }

    public void setReflectionHeight(Integer height) {
        this.reflectionHeight = height;
    }

    public void setReflectionOpacity(Integer opacity) {
        this.reflectionOpacity = opacity;
    }

    public static final class Javascript {
        public static CharSequence hide(String id) {
            AppendingStringBuffer sb2 = new AppendingStringBuffer();
            sb2.append("Reflection.remove(document.getElementById('");
            sb2.append(id);
            sb2.append("');");
            return sb2;
        }

        public static CharSequence show(String id, Integer opacity, Integer height) {
            AppendingStringBuffer sb2 = new AppendingStringBuffer();
            sb2.append("Reflection.add(document.getElementById('");
            sb2.append(id);
            sb2.append("'), { ");
            String komma = "";
            if (height != null) {
                sb2.append("height: ").append(height.toString()).append("/100");
                komma = ",";
            }
            if (opacity != null) {
                sb2.append(komma);
                sb2.append("opacity: ").append(opacity.toString()).append("/100");
            }
            sb2.append("});");
            return sb2;
        }

        private Javascript() {
        }
    }
}

