/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.behavior.tooltipsy;

import java.io.Serializable;
import org.apache.wicket.util.lang.Args;

public class TooltipsyOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String css = "";
    private Offset offset = new Offset();
    private String content = "";
    private TooltipsyAlignment align = TooltipsyAlignment.ELEMENT;
    private int delay = 200;
    private String tooltipsyClassName = "tooltipsy";
    private String showJavaScript = "function (e, $el) { $el.show(100); }";
    private String hideJavaScript = "function (e, $el) { $el.fadeOut(100); }";

    public TooltipsyOptions() {
    }

    public TooltipsyOptions(TooltipsyOptions options) {
        this();
        if (options != null) {
            this.setCss(options.getCss());
            this.setOffset(options.getOffset());
            this.setContent(options.getContent());
            this.setAlign(options.getAlign());
            this.setDelay(options.getDelay());
            this.setTooltipsyClassName(options.getTooltipsyClassName());
            this.setShowJavaScript(options.getShowJavaScript());
            this.setHideJavaScript(options.getHideJavaScript());
        }
    }

    public Offset getOffset() {
        return new Offset(this.offset);
    }

    public void setOffset(Offset offset) {
        Args.notNull((Object)offset, (String)"offset");
        this.offset = new Offset(offset);
    }

    public String getCss() {
        return this.css;
    }

    public void setCss(String css) {
        Args.notNull((Object)css, (String)"css");
        this.css = css;
    }

    public String getParameterString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("offset: [" + String.valueOf(this.offset.getOffsetX()) + "," + String.valueOf(this.offset.getOffsetY()) + "]");
        sb.append(",");
        sb.append("content: '" + this.content + "'");
        sb.append(",");
        sb.append("alignTo: '" + this.align.getName() + "'");
        sb.append(",");
        sb.append("delay: " + String.valueOf(this.delay));
        sb.append(",");
        sb.append("className: '" + this.tooltipsyClassName + "'");
        sb.append(",");
        sb.append("show: " + this.showJavaScript);
        sb.append(",");
        sb.append("hide: " + this.hideJavaScript);
        sb.append(",");
        sb.append("css: {");
        sb.append(this.css);
        sb.append("}");
        sb.append("}");
        return sb.toString();
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        Args.notNull((Object)content, (String)"content");
        this.content = content;
    }

    public TooltipsyAlignment getAlign() {
        return this.align;
    }

    public void setAlign(TooltipsyAlignment align) {
        Args.notNull((Object)((Object)align), (String)"align");
        this.align = align;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        Args.notNull((Object)delay, (String)"delay");
        this.delay = delay;
    }

    public String getTooltipsyClassName() {
        return this.tooltipsyClassName;
    }

    public void setTooltipsyClassName(String tooltipsyClassName) {
        Args.notNull((Object)tooltipsyClassName, (String)"tooltipsyClassName");
        this.tooltipsyClassName = tooltipsyClassName;
    }

    public String getShowJavaScript() {
        return this.showJavaScript;
    }

    public void setShowJavaScript(String showJavaScript) {
        Args.notNull((Object)showJavaScript, (String)"showJavaScript");
        this.showJavaScript = showJavaScript;
    }

    public String getHideJavaScript() {
        return this.hideJavaScript;
    }

    public void setHideJavaScript(String hideJavaScript) {
        Args.notNull((Object)hideJavaScript, (String)"hideJavaScript");
        this.hideJavaScript = hideJavaScript;
    }

    public static class TooltipsyOptionsBuilder {
        private TooltipsyOptions options = new TooltipsyOptions();

        public TooltipsyOptionsBuilder setOffset(Offset offset) {
            this.options.setOffset(offset);
            return this;
        }

        public TooltipsyOptionsBuilder setCss(String css) {
            this.options.setCss(css);
            return this;
        }

        public TooltipsyOptionsBuilder setContent(String content) {
            this.options.setContent(content);
            return this;
        }

        public TooltipsyOptionsBuilder setTooltipsyClassName(String tooltipsyClassName) {
            this.options.setTooltipsyClassName(tooltipsyClassName);
            return this;
        }

        public TooltipsyOptionsBuilder setAlign(TooltipsyAlignment align) {
            this.options.setAlign(align);
            return this;
        }

        public TooltipsyOptionsBuilder setDelay(int delay) {
            this.options.setDelay(delay);
            return this;
        }

        public TooltipsyOptionsBuilder setShowJavaScript(String showJavaScript) {
            this.options.setShowJavaScript(showJavaScript);
            return this;
        }

        public TooltipsyOptionsBuilder setHideJavaScript(String hideJavaScript) {
            this.options.setHideJavaScript(hideJavaScript);
            return this;
        }

        public TooltipsyOptions getResult() {
            return new TooltipsyOptions(this.options);
        }
    }

    public static enum TooltipsyAlignment {
        ELEMENT("element"),
        CURSOR("cursor");

        private final String name;

        private TooltipsyAlignment(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Offset {
        private int offsetX = 0;
        private int offsetY = -1;

        public Offset() {
        }

        public Offset(int offsetX, int offsetY) {
            this.offsetX = offsetX;
            this.setOffsetY(offsetY);
        }

        public Offset(Offset other) {
            this.offsetX = other.offsetX;
            this.offsetY = other.offsetY;
        }

        public int getOffsetX() {
            return this.offsetX;
        }

        public void setOffsetX(int offsetX) {
            this.offsetX = offsetX;
        }

        public int getOffsetY() {
            return this.offsetY;
        }

        public void setOffsetY(int offsetY) {
            this.offsetY = offsetY;
        }
    }
}

