/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.filter;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.response.filter.IResponseFilter;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

public class ServerHostNameAndTimeFilter
implements IResponseFilter {
    private String host;

    public ServerHostNameAndTimeFilter() throws Exception {
        this(System.getProperty("hostid"));
    }

    public ServerHostNameAndTimeFilter(String hostId) {
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            this.host = localMachine.getHostName() + "/" + localMachine.getHostAddress() + "/" + (Strings.isEmpty((String)hostId) ? "<unknown>" : hostId);
        }
        catch (UnknownHostException ex) {
            throw new WicketRuntimeException((Throwable)ex);
        }
    }

    protected void addJavaScript(AppendingStringBuffer sb) {
        sb.append("window.defaultStatus='");
        this.addMessage(sb);
        sb.append("'");
    }

    protected void addMessage(AppendingStringBuffer sb) {
        long timeTaken = System.currentTimeMillis() - RequestCycle.get().getStartTime();
        sb.append("Host: ").append(this.host).append(", handled in: ").append((Object)Duration.ofMillis(timeTaken));
    }

    public AppendingStringBuffer filter(AppendingStringBuffer responseBuffer) {
        int index = responseBuffer.indexOf("</head>");
        if (index != -1) {
            AppendingStringBuffer script = new AppendingStringBuffer(75);
            script.append("\n").append("<script type=\"text/javascript\">\n/*<![CDATA[*/\n");
            this.addJavaScript(script);
            script.append(";").append("\n/*]]>*/\n</script>\n");
            responseBuffer.insert(index, (Object)script);
        }
        return responseBuffer;
    }
}

