/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.progressbar.spring;

import java.util.ArrayList;
import java.util.List;

public class Task {
    private Runnable runnable;
    private int progress = 0;
    private boolean done = false;
    private boolean cancel = false;
    private List<Message> messages = new ArrayList<Message>();

    public Task() {
    }

    public Task(Runnable runnable) {
        this.runnable = runnable;
    }

    final Runnable getRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (Task.this.runnable != null) {
                        Task.this.runnable.run();
                    } else {
                        Task.this.run();
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
                Task.this.finish();
            }
        };
    }

    private void finish() {
        this.done = true;
        this.doFinish();
    }

    protected void run() {
    }

    protected void doFinish() {
    }

    public boolean isCancelled() {
        return this.cancel;
    }

    public void reset() {
        this.progress = 0;
        this.done = false;
        this.cancel = false;
    }

    public void cancel() {
        this.cancel = true;
    }

    public void updateProgress(int current, int total) {
        this.progress = (int)Math.ceil((double)(current + 1) / (double)total * 100.0);
    }

    public void updateProgress(int progressPercent) {
        this.progress = Math.max(this.progress, progressPercent);
    }

    public boolean isDone() {
        return this.done;
    }

    public int getProgress() {
        return this.progress;
    }

    public void info(String messageKey, Object ... arguments) {
        this.addMessage(messageKey, Message.Severity.INFO, arguments);
    }

    public void warn(String messageKey, Object ... arguments) {
        this.addMessage(messageKey, Message.Severity.WARN, arguments);
    }

    public void error(String messageKey, Object ... arguments) {
        this.addMessage(messageKey, Message.Severity.ERROR, arguments);
    }

    private void addMessage(String messageKey, Message.Severity severity, Object ... arguments) {
        this.messages.add(new Message(severity, messageKey, arguments.length == 0 ? null : arguments));
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public static class Message {
        public final Severity severity;
        public final String messageKey;
        public final Object[] arguments;

        public Message(Severity severity, String messageKey, Object[] arguments) {
            this.severity = severity;
            this.messageKey = messageKey;
            this.arguments = arguments;
        }

        public Message(Severity severity, String messageKey) {
            this(severity, messageKey, null);
        }

        public static enum Severity {
            INFO,
            WARN,
            ERROR;

        }
    }
}

