/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.progressbar;

import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.time.Duration;
import org.wicketstuff.progressbar.Progression;
import org.wicketstuff.progressbar.ProgressionModel;
import org.wicketstuff.progressbar.support.DynamicAjaxSelfUpdatingTimerBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressBar
extends Panel {
    private static final long serialVersionUID = 1L;
    private int width = 400;
    private static final ResourceReference CSS = new PackageResourceReference(ProgressBar.class, "ProgressBar.css");

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderCSSReference(CSS);
    }

    protected void onInitialize() {
        super.onInitialize();
        if (this.getParent() != null) {
            this.getParent().add(new Behavior[]{new Behavior(){
                private static final long serialVersionUID = 1L;

                public void renderHead(Component component, IHeaderResponse response) {
                    super.renderHead(component, response);
                    response.renderCSSReference(CSS);
                }
            }});
        }
    }

    public ProgressBar(String id, ProgressionModel model) {
        super(id, (IModel)model);
        this.add(new Component[]{new Label("label", this.getLabelModel(model))});
        this.add(new Component[]{new Label("message", this.getMessageModel(model))});
        this.add(new Component[]{new WebMarkupContainer("bar").add(new Behavior[]{new AttributeModifier("style", (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                ProgressionModel model = (ProgressionModel)ProgressBar.this.getDefaultModel();
                Progression progression = model.getProgression();
                return "width: " + progression.getProgress() + "%";
            }
        })})});
        this.setOutputMarkupId(true);
    }

    protected AbstractReadOnlyModel<String> getLabelModel(final ProgressionModel model) {
        return new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                Progression progression = model.getProgression();
                return progression.getProgress() + "%";
            }
        };
    }

    protected IModel<String> getMessageModel(final ProgressionModel model) {
        return new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return model.getProgression().getProgressMessage();
            }
        };
    }

    public void start(AjaxRequestTarget target) {
        this.setVisible(true);
        this.add(new Behavior[]{new DynamicAjaxSelfUpdatingTimerBehavior(Duration.ONE_SECOND){
            private static final long serialVersionUID = 1L;

            protected void onPostProcessTarget(AjaxRequestTarget target) {
                ProgressionModel model = (ProgressionModel)ProgressBar.this.getDefaultModel();
                Progression progression = model.getProgression();
                if (progression.isDone()) {
                    this.stop();
                    ProgressBar.this.onFinished(target);
                }
            }
        }});
        if (this.getParent() != null) {
            target.add(new Component[]{this.getParent()});
        } else {
            target.add(new Component[]{this});
        }
    }

    protected void onFinished(AjaxRequestTarget target) {
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

